package com.daas.nros.openapi.model.vo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 券信息vo
 *
 * @author <a href="mailto:im.leexiao@gamil.com">KitAndrew</a>
 * @since 2020年08月29日 11:43:00
 */
@Data
public class CouponVo implements Serializable {


    @io.swagger.annotations.ApiModelProperty(value = "券号", name = "couponCode", required = false, example = "")
    private String couponCode;

    @io.swagger.annotations.ApiModelProperty(value = "券名称", name = "couponName", required = false, example = "")
    private String couponName;

    @io.swagger.annotations.ApiModelProperty(value = "面额", name = "money", required = false, example = "")
    private BigDecimal money;

    @io.swagger.annotations.ApiModelProperty(value = "折扣", name = "discount", required = false, example = "")
    private BigDecimal discount;

    @io.swagger.annotations.ApiModelProperty(value = "券说明", name = "info", required = false, example = "")
    private String info;

    @io.swagger.annotations.ApiModelProperty(value = "有效期开始时间", name = "validDateStart", required = false, example = "")
    private Date validDateStart;

    @io.swagger.annotations.ApiModelProperty(value = "有效期结束时间", name = "validDateEnd", required = false, example = "")
    private Date validDateEnd;

    @io.swagger.annotations.ApiModelProperty(value = "优惠类型（1现金，2折扣，3兑换）", name = "preferentialType", required = false, example = "")
    private Byte preferentialType;
}
