package com.daas.nros.openapi.constant;

public class WebhookConstant {

    public static final String timestamp = "timestamp";
    public static final String nonce = "nonce";
    public static final String timestamp_replace = "$timestamp$";
    public static final String nonce_replace = "$nonce$";
    /**
     * 积分调整接口：
     * 100:成功
     * 101:失败，会员已注销或不存在
     * 102:失败，会员可用积分不足
     * 103:失败，会员专属门店缺失
     * 104:失败，系统错误，请联系系统管理员
     *
     * 优惠券发放接口：
     * 200:成功
     * 201:失败，会员已注销或不存在
     * 202:失败，系统错误，请联系系统管理员
     */
    public static final String INTEGRAL_SUCCESS = "100";
    public static final String INTEGRAL_ERROR_DATA_NOT_EXIST = "101";
    public static final String INTEGRAL_ERROR_INSUFFICIENT = "102";
    public static final String INTEGRAL_ERROR_STORE_NOT_EXIST = "103";
    public static final String INTEGRAL_ERROR_SYSTEM_INTERNAL_FAILED = "104";

    public static final String COUPON_SUCCESS = "200";
    public static final String COUPON_ERROR_MEMBER_NOT_EXIST = "201";
    public static final String COUPON_ERROR_SYSTEM_INTERNAL_FAILED = "202";

    /**
     * 邀约任务接口
     * 300：成功
     * 301：失败，会员归属默认导购或无导购：邀约任务下发时会员存在，但会员所属导购为默认导购或导购数据异常；
     * 302：失败，会员已注销或不存在：邀约任务下发时，会员不存在；
     * 303：失败，邀约任务已结束：邀约任务下发时，任务已结束；
     * 304：失败，系统错误，请联系系统管理员：其他异常情况；
     */
    public static final String ADD_INVITE_TASK_SUCCESS = "300";
    public static final String ADD_INVITE_TASK_DATA_NOT_MATCH = "301";
    public static final String ADD_INVITE_TASK_DATA_NOT_EXSIT = "302";
    public static final String ADD_INVITE_TASK_INVALID = "303";
    public static final String ADD_INVITE_TASK_ENDED = "304";


    public static final String TASK_INVITE_WEBHOOK_CALLBACK_TOPIC = "task_invite_webhook_callback";
    public static final String TASK_INVITE_WEBHOOK_CALLBACK_TAG = "webhook";
}
