package com.daas.nros.openapi.api;


import com.bizvane.members.facade.vo.vg.VGMemberOpenCardResponseVo;
import com.bizvane.members.facade.vo.vg.VGMemberQueryResponseVo;

import com.bizvane.utils.responseinfo.ResponseData;
import com.daas.nros.openapi.model.vo.*;
import org.springframework.web.bind.annotation.RequestBody;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;

public interface VgMembersService {

    /**
     * 校验卡是否满足
     * @param requestVO
     * @return
     * */
    ResponseData<VGMemberQueryResponseVo> memberQuery(VgMemberQueryRequestVo requestVO, HttpServletRequest request);

    /**
     * 校验卡是否满足
     * @param requestVO
     * @return
     * */
    ResponseData<VGMemberQueryResponseVo> memberQueryByAlipay(VgMemberQueryRequestVo requestVO, HttpServletRequest request);


    ResponseData<VGMemberOpenCardResponseVo> openCard(@RequestBody @Valid OpenCardRequestVo requestVo, HttpServletRequest request);


    ResponseData changeCardLevel(@RequestBody @Valid ChangeCardLevelRequestVo requestVo, HttpServletRequest request);


    ResponseData changePhone(@RequestBody @Valid ChangeMemberPhoneRequestVO requestVo, HttpServletRequest request);


    ResponseData<VGMemberInitGuideQueryResponseVO> memberInitGuideQuery(@RequestBody @Valid VGMemberInitGuideQueryRequestVO requestVo, HttpServletRequest request);

}
