/*
 * Decompiled with CFR 0.152.
 */
package com.daas.nros.connector.server.tool.httpbatchshop;

import com.alibaba.fastjson.JSON;
import com.daas.nros.connector.client.burgeon.model.req.SnyMemberCouponReq;
import com.daas.nros.connector.client.constants.Constant;
import com.daas.nros.connector.client.model.result.Result;
import com.daas.nros.connector.server.service.component.SpringComponent;
import com.daas.nros.connector.server.service.impl.burgeon.CouponServiceImpl;
import com.daas.nros.connector.server.service.impl.burgeon.CrmJointServiceImpl;
import com.daas.nros.connector.server.tool.httpbatchshop.ShopCollecter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.poi.ss.formula.functions.T;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchShopCollecter
implements ShopCollecter {
    private static Logger logger = LoggerFactory.getLogger((String)BatchShopCollecter.class.getName());
    private long sendTimer = -1L;
    private boolean isListen = true;
    private final String serverUrl;
    private final int batchNum;
    private final long batchSec;
    private final boolean interrupt;
    private final List<SnyMemberCouponReq> batchShopMsgList;
    private ExecutorService singleShopThread;
    private final String topic;

    public BatchShopCollecter(String serverUrl, int batchNum, long batchSec, String topic) {
        this(serverUrl, batchNum, batchSec, false, topic);
    }

    public BatchShopCollecter(String serverUrl, int batchNum, long batchSec, boolean interrupt, String topic) {
        this.topic = topic;
        this.serverUrl = serverUrl;
        this.interrupt = interrupt;
        this.batchNum = batchNum;
        this.batchSec = batchSec * 1000L;
        this.batchShopMsgList = new ArrayList<SnyMemberCouponReq>(this.batchNum);
        this.singleShopThread = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.init();
    }

    private void init() {
        this.singleShopThread.execute(new Runnable(){

            @Override
            public void run() {
                while (BatchShopCollecter.this.isListen) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception e1) {
                        System.out.println(e1);
                    }
                    if (BatchShopCollecter.this.sendTimer == -1L || System.currentTimeMillis() - BatchShopCollecter.this.sendTimer < BatchShopCollecter.this.batchSec) continue;
                    try {
                        BatchShopCollecter.this.upload();
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendCoupon(SnyMemberCouponReq snyMemberCouponReq) {
        List<SnyMemberCouponReq> list = this.batchShopMsgList;
        synchronized (list) {
            List couponCodeList;
            if (this.sendTimer == -1L) {
                this.sendTimer = System.currentTimeMillis();
            }
            if ((couponCodeList = this.batchShopMsgList.stream().map(SnyMemberCouponReq::getCouponId).collect(Collectors.toList())).contains(snyMemberCouponReq.getCouponId())) {
                logger.info("BatchShopCollecter couponCodeList contains couponCode:{}", (Object)snyMemberCouponReq.getCouponId());
                return true;
            }
            this.batchShopMsgList.add(snyMemberCouponReq);
            if (this.batchShopMsgList.size() >= this.batchNum) {
                this.upload();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upload() {
        List<SnyMemberCouponReq> list = this.batchShopMsgList;
        synchronized (list) {
            if (this.batchShopMsgList != null && this.batchShopMsgList.size() > 0) {
                Byte coupStatus = 0;
                try {
                    logger.info(String.format("Send shop message to topic: %s \ndata size: %s", this.topic, this.batchShopMsgList.size()));
                    CrmJointServiceImpl crmJointServiceImpl = SpringComponent.getBean(CrmJointServiceImpl.class);
                    Result<T> result = crmJointServiceImpl.snyMemberCoupon(this.batchShopMsgList);
                    logger.info("crmJointServiceImpl.snyMemberCoupon:{}", (Object)JSON.toJSONString(result));
                    if (Constant.INT_ZERO == result.getCode()) {
                        coupStatus = 1;
                    }
                }
                catch (Exception e) {
                    if (this.interrupt) {
                        this.shutdown();
                        throw new RuntimeException("Upload Data Error", e);
                    }
                    logger.error("\u6279\u91cf\u53d1\u5238\u5931\u8d25send_coupon:" + e.getMessage());
                }
                finally {
                    CouponServiceImpl couponSingleService = SpringComponent.getBean(CouponServiceImpl.class);
                    for (int i = 0; i < this.batchShopMsgList.size(); ++i) {
                        SnyMemberCouponReq snyMemberCouponReq = this.batchShopMsgList.get(i);
                        if ("JH".equals(this.batchShopMsgList.get(i).getBrandCode())) {
                            try {
                                couponSingleService.callbackSingleCoupon(snyMemberCouponReq.getCouponId(), Constant.BYTE_ONE, snyMemberCouponReq.getIfSendAgain());
                            }
                            catch (Exception e) {
                                logger.error("send_coupon\u72b6\u6001\u56de\u8c03\u5931\u8d25:{} couponCode:{}" + e.getMessage(), (Object)snyMemberCouponReq.getCouponId());
                            }
                            continue;
                        }
                        try {
                            couponSingleService.callbackSingleCoupon(snyMemberCouponReq.getCouponId(), coupStatus, snyMemberCouponReq.getIfSendAgain());
                            continue;
                        }
                        catch (Exception e) {
                            logger.error("send_coupon\u72b6\u6001\u56de\u8c03\u5931\u8d25:{} couponCode:{}" + e.getMessage(), (Object)snyMemberCouponReq.getCouponId());
                        }
                    }
                    this.batchShopMsgList.clear();
                    this.resetTimer();
                }
            }
        }
    }

    @Override
    public void flush() {
        this.upload();
    }

    @Override
    public void close() {
        this.flush();
        this.shutdown();
    }

    private void shutdown() {
        this.isListen = false;
        try {
            this.singleShopThread.shutdown();
            this.singleShopThread.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            this.singleShopThread = null;
        }
    }

    private void resetTimer() {
        this.sendTimer = -1L;
    }
}

