/*
 * Decompiled with CFR 0.152.
 */
package com.daas.nros.connector.server.tool.httpbatch;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.couponfacade.interfaces.CouponDefinitionServiceFeign;
import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.daas.nros.connector.client.api.base.CouponSingleService;
import com.daas.nros.connector.client.burgeon.model.vo.VgAddCouponCrmVO;
import com.daas.nros.connector.client.enums.StringBrandCode;
import com.daas.nros.connector.client.model.po.MbrMembersPo;
import com.daas.nros.connector.client.model.result.Result;
import com.daas.nros.connector.client.util.RestUtils;
import com.daas.nros.connector.client.weimob.model.req.param.CouponBindMemberParam;
import com.daas.nros.connector.server.config.burgeon.IposConfig;
import com.daas.nros.connector.server.service.api.weimob.SysWeimengService;
import com.daas.nros.connector.server.service.component.SpringComponent;
import com.daas.nros.connector.server.service.impl.burgeon.CouponServiceImpl;
import com.daas.nros.connector.server.tool.httpbatch.Collecter;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchCollecter
implements Collecter {
    private static Logger logger = LoggerFactory.getLogger((String)BatchCollecter.class.getName());
    private long sendTimer = -1L;
    private boolean isListen = true;
    private final String serverUrl;
    private final int batchNum;
    private final long batchSec;
    private final boolean interrupt;
    private final List<VgAddCouponCrmVO> batchMsgList;
    private ExecutorService singleThread;
    private final String topic;

    public BatchCollecter(String serverUrl, int batchNum, long batchSec, String topic) {
        this(serverUrl, batchNum, batchSec, false, topic);
    }

    public BatchCollecter(String serverUrl, int batchNum, long batchSec, boolean interrupt, String topic) {
        this.topic = topic;
        this.serverUrl = serverUrl;
        this.interrupt = interrupt;
        this.batchNum = batchNum;
        this.batchSec = batchSec * 1000L;
        this.batchMsgList = new ArrayList<VgAddCouponCrmVO>(this.batchNum);
        this.singleThread = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.init();
    }

    private void init() {
        this.singleThread.execute(new Runnable(){

            @Override
            public void run() {
                while (BatchCollecter.this.isListen) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception e1) {
                        System.out.println(e1);
                    }
                    if (BatchCollecter.this.sendTimer == -1L || System.currentTimeMillis() - BatchCollecter.this.sendTimer < BatchCollecter.this.batchSec) continue;
                    try {
                        BatchCollecter.this.upload();
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendCoupon(VgAddCouponCrmVO vgAddCouponCrmVO) {
        List<VgAddCouponCrmVO> list = this.batchMsgList;
        synchronized (list) {
            if (this.sendTimer == -1L) {
                this.sendTimer = System.currentTimeMillis();
            }
            this.batchMsgList.add(vgAddCouponCrmVO);
            if (this.batchMsgList.size() >= this.batchNum) {
                this.upload();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void upload() {
        List<VgAddCouponCrmVO> list = this.batchMsgList;
        synchronized (list) {
            if (this.batchMsgList != null && this.batchMsgList.size() > 0) {
                Byte coupStatus;
                block24: {
                    coupStatus = 0;
                    try {
                        logger.info(String.format("Send pos message to topic: %s \ndata size: %s", this.topic, this.batchMsgList.size()));
                        Map map = IposConfig.signToRequest("Burgeon.Bos.Coupon.AddCouponBatch");
                        map.put("param", this.batchMsgList);
                        String resultStr = null;
                        String url = IposConfig.url + "/rest/coupon/addCouponBatch";
                        logger.info("\u8c03\u7528:AddCouponBatch---------url:" + url);
                        String param = JSON.toJSONString((Object)map);
                        logger.info("\u8c03\u7528:AddCouponBatch---------param:" + param);
                        resultStr = RestUtils.sendRequestBuff((String)url, (String)JSON.toJSONString((Object)map), (String)"POST");
                        logger.info(String.format("\u8c03\u7528:AddCouponBatch\u8fd4\u56de\u72b6\u6001: %s \ncoupon: %s \nmessage: %s", this.topic, JSON.toJSONString(this.batchMsgList), resultStr));
                        JSONObject resultObject = JSON.parseObject((String)resultStr);
                        if (!resultObject.get((Object)"code").toString().equals("100")) break block24;
                        coupStatus = 1;
                        this.couponBindingMemberToWmBatch(this.batchMsgList);
                    }
                    catch (JsonProcessingException e) {
                        if (this.interrupt) {
                            this.shutdown();
                            throw new RuntimeException("Json Serialize Error", e);
                        }
                        logger.info(String.format("\u6279\u91cf\u53d1\u5238\u5931\u8d25send_coupon_topic: %s \ncoupon: %s \nerror: %s", this.topic, JSON.toJSONString(this.batchMsgList), e.getMessage()));
                        CouponSingleService couponSingleService = SpringComponent.getBean(CouponServiceImpl.class);
                        for (int i = 0; i < this.batchMsgList.size(); ++i) {
                            VgAddCouponCrmVO couponCrmVO = this.batchMsgList.get(i);
                            try {
                                couponSingleService.callbackSingleCoupon(couponCrmVO.getCoupNo(), coupStatus, couponCrmVO.getIfSendAgain());
                                continue;
                            }
                            catch (Exception e2) {
                                logger.info(String.format("send_coupon_topic\u72b6\u6001\u56de\u8c03\u5931\u8d25: %s couponNo: %s error: %s", this.topic, couponCrmVO.getCoupNo(), e2.getMessage()));
                            }
                        }
                        this.batchMsgList.clear();
                        this.resetTimer();
                    }
                    catch (Exception e) {
                        if (this.interrupt) {
                            this.shutdown();
                            throw new RuntimeException("Upload Data Error", e);
                        }
                        logger.info(String.format("\u6279\u91cf\u53d1\u5238\u5931\u8d25send_coupon_topic: %s coupon: %s error: %s", this.topic, JSON.toJSONString(this.batchMsgList), e.getMessage()));
                        CouponSingleService couponSingleService = SpringComponent.getBean(CouponServiceImpl.class);
                        for (int i = 0; i < this.batchMsgList.size(); ++i) {
                            VgAddCouponCrmVO couponCrmVO = this.batchMsgList.get(i);
                            try {
                                couponSingleService.callbackSingleCoupon(couponCrmVO.getCoupNo(), coupStatus, couponCrmVO.getIfSendAgain());
                                continue;
                            }
                            catch (Exception e3) {
                                logger.info(String.format("send_coupon_topic\u72b6\u6001\u56de\u8c03\u5931\u8d25: %s couponNo: %s error: %s", this.topic, couponCrmVO.getCoupNo(), e3.getMessage()));
                            }
                        }
                        this.batchMsgList.clear();
                        this.resetTimer();
                        {
                            catch (Throwable throwable) {
                                CouponSingleService couponSingleService2 = SpringComponent.getBean(CouponServiceImpl.class);
                                for (int i = 0; i < this.batchMsgList.size(); ++i) {
                                    VgAddCouponCrmVO couponCrmVO = this.batchMsgList.get(i);
                                    try {
                                        couponSingleService2.callbackSingleCoupon(couponCrmVO.getCoupNo(), coupStatus, couponCrmVO.getIfSendAgain());
                                        continue;
                                    }
                                    catch (Exception e4) {
                                        logger.info(String.format("send_coupon_topic\u72b6\u6001\u56de\u8c03\u5931\u8d25: %s couponNo: %s error: %s", this.topic, couponCrmVO.getCoupNo(), e4.getMessage()));
                                    }
                                }
                                this.batchMsgList.clear();
                                this.resetTimer();
                                throw throwable;
                            }
                        }
                    }
                }
                CouponSingleService couponSingleService = SpringComponent.getBean(CouponServiceImpl.class);
                for (int i = 0; i < this.batchMsgList.size(); ++i) {
                    VgAddCouponCrmVO couponCrmVO = this.batchMsgList.get(i);
                    try {
                        couponSingleService.callbackSingleCoupon(couponCrmVO.getCoupNo(), coupStatus, couponCrmVO.getIfSendAgain());
                        continue;
                    }
                    catch (Exception e) {
                        logger.info(String.format("send_coupon_topic\u72b6\u6001\u56de\u8c03\u5931\u8d25: %s couponNo: %s error: %s", this.topic, couponCrmVO.getCoupNo(), e.getMessage()));
                    }
                }
                this.batchMsgList.clear();
                this.resetTimer();
            }
        }
    }

    private Result<Object> couponBindingMemberToWmBatch(List<VgAddCouponCrmVO> voList) throws ParseException {
        logger.info("couponBindingMemberToWmBatch, voList:{}", (Object)JSON.toJSONString(voList));
        Result result = new Result();
        result.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
        if (CollectionUtils.isEmpty(voList)) {
            logger.info("couponBindingMemberToWmBatch, voList is NULL");
            return result;
        }
        for (VgAddCouponCrmVO vo : voList) {
            logger.info("couponBindingMemberToWmBatch, couponBindingMemberToWm,VO:{}", (Object)JSON.toJSONString((Object)vo));
            Result<Object> response = this.couponBindingMemberToWm(vo);
            logger.info("couponBindingMemberToWmBatch, couponBindingMemberToWm,response:{}", (Object)JSON.toJSONString(response));
        }
        return result;
    }

    private Result<Object> couponBindingMemberToWm(VgAddCouponCrmVO vo) throws ParseException {
        Result<Object> result = new Result<Object>();
        result.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
        logger.info("couponBindingMemberToWm,vo:{}", (Object)JSON.toJSONString((Object)vo));
        if (!this.checkCouponBindingMemberToWm(vo)) {
            result.setMessage("\u53c2\u6570\u4e0d\u5b8c\u6574");
            result.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
            return result;
        }
        CouponDefinitionPO definition = this.findCouponDefinitionByCouponCode(vo.getCoupNo());
        if (!StringBrandCode.vg.getValue().equals(vo.getBrandCode()) && !this.isExist(definition, StringBrandCode.vg.getValue())) {
            logger.info("couponBindingMemberToWm, \u5f53\u524d\u54c1\u724c\u4e0d\u662fVG,\u6240\u4ee5\u4e0d\u540c\u6b65\u5230\u5fae\u76df");
            result.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
            return result;
        }
        SysWeimengService sysWeimengService = SpringComponent.getBean(SysWeimengService.class);
        MbrMembersPo member = sysWeimengService.findMbrMemberBy(vo.getCardNo(), 3, vo.getBrandCode());
        if (member == null) {
            logger.info("couponBindingMemberToWm,member is null");
            result.setMessage("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u4f1a\u5458");
            return result;
        }
        String couponDefinitionCode = this.findCouponDefinitionCodeByCouponCode(vo.getCoupNo());
        if (StringUtils.isBlank((CharSequence)couponDefinitionCode)) {
            logger.info("couponBindingMemberToWm,couponDefinitionCode is null");
            result.setMessage("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5238\u6a21\u677f");
            return result;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        CouponBindMemberParam param = new CouponBindMemberParam();
        Long acquireTime = sdf.parse(vo.getUpdateTime()).getTime();
        Long startDate = sdf.parse(vo.getDateBegin()).getTime();
        Long endDate = sdf.parse(vo.getDateEnd()).getTime();
        param.setAcquireTime(acquireTime);
        param.setExpireStartTime(startDate);
        param.setExpireEndTime(endDate);
        param.setCouponCode(vo.getCoupNo());
        param.setMemberCode(member.getMemberCode());
        param.setCouponDefinitionCode(couponDefinitionCode);
        logger.info("couponBindingMemberToWm, couponBindMember, param:{}", (Object)JSON.toJSONString((Object)param));
        result = sysWeimengService.couponBindMember(param);
        logger.info("couponBindingMemberToWm, couponBindMember, result:{}", (Object)JSON.toJSONString(result));
        return result;
    }

    private boolean isExist(CouponDefinitionPO definition, String brandCode) {
        if (definition == null) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)definition.getApplicableBrandCodes())) {
            return false;
        }
        return definition.getApplicableBrandCodes().contains(brandCode);
    }

    public String findCouponDefinitionCodeByCouponCode(String couponCode) {
        logger.info("findCouponDefinitionCodeByCouponCode, couponCode:{}", (Object)couponCode);
        CouponDefinitionServiceFeign couponDefinitionServiceFeign = SpringComponent.getBean(CouponDefinitionServiceFeign.class);
        ResponseData responseData = couponDefinitionServiceFeign.findCouponDefinitionCodeByCouponCode(couponCode);
        logger.info("findCouponDefinitionCodeByCouponCode, responseData:{}", (Object)JSON.toJSONString((Object)responseData));
        if (responseData.getCode() == SysResponseEnum.SUCCESS.getCode()) {
            return (String)responseData.getData();
        }
        return null;
    }

    public CouponDefinitionPO findCouponDefinitionByCouponCode(String couponCode) {
        logger.info("findCouponDefinitionByCouponCode, couponCode:{}", (Object)couponCode);
        CouponDefinitionServiceFeign couponDefinitionServiceFeign = SpringComponent.getBean(CouponDefinitionServiceFeign.class);
        ResponseData responseData = couponDefinitionServiceFeign.findCouponDefinitionByCouponCode(couponCode);
        logger.info("findCouponDefinitionByCouponCode, responseData:{}", (Object)JSON.toJSONString((Object)responseData));
        if (responseData.getCode() == SysResponseEnum.SUCCESS.getCode()) {
            return (CouponDefinitionPO)responseData.getData();
        }
        return null;
    }

    private boolean checkCouponBindingMemberToWm(VgAddCouponCrmVO vo) {
        return Boolean.TRUE;
    }

    @Override
    public void flush() {
        this.upload();
    }

    @Override
    public void close() {
        this.flush();
        this.shutdown();
    }

    private void shutdown() {
        this.isListen = false;
        try {
            this.singleThread.shutdown();
            this.singleThread.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            System.out.println(e);
            this.singleThread = null;
        }
    }

    private void resetTimer() {
        this.sendTimer = -1L;
    }
}

