/*
 * Decompiled with CFR 0.152.
 */
package com.daas.nros.connector.server.service.impl.weimob;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.centerstageservice.rpc.SysBojunDataServiceRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.daas.nros.connector.client.burgeon.model.req.VidDetailReq;
import com.daas.nros.connector.client.enums.CrmWmFieldMappingTypeEnum;
import com.daas.nros.connector.client.model.po.SysCrmWmFieldMappingPO;
import com.daas.nros.connector.client.model.po.WmApiRecordPO;
import com.daas.nros.connector.client.weimob.model.req.GuiderWidReq;
import com.daas.nros.connector.client.weimob.model.req.MemberWidReq;
import com.daas.nros.connector.client.weimob.model.req.VidReq;
import com.daas.nros.connector.client.weimob.model.result.WmResultVo;
import com.daas.nros.connector.server.mapper.WmApiRecordPOMapper;
import com.daas.nros.connector.server.service.api.weimob.SysCrmWmFieldMappingService;
import com.daas.nros.connector.server.service.component.RedisCacheComponent;
import com.daas.nros.connector.server.service.component.WmSystemHttpClientComponent;
import com.daas.nros.connector.server.service.conver.WmConverFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class WmAPiComponent {
    private static final Logger log = LoggerFactory.getLogger(WmAPiComponent.class);
    public static final String SUCCESS_CODE = "0";
    @Autowired
    private WmSystemHttpClientComponent wmSystemHttpClientComponent;
    @Autowired
    private SysBojunDataServiceRpc sysBojunDataServiceRpc;
    @Autowired
    private WmApiRecordPOMapper wmApiRecordPOMapper;
    @Autowired
    private SysCrmWmFieldMappingService sysCrmWmFieldMappingService;
    @Autowired
    public RedisCacheComponent redisCacheComponent;

    public void saveApiRecord(String topic, String requestBody, String responseBody) {
        try {
            WmApiRecordPO wmApiRecordPO = new WmApiRecordPO();
            wmApiRecordPO.setCreateDate(new Date());
            wmApiRecordPO.setRequestTime(new Date());
            wmApiRecordPO.setRequestTopic(topic);
            wmApiRecordPO.setPriKey(Long.toString(System.currentTimeMillis()));
            wmApiRecordPO.setRequestMessageBody(requestBody);
            wmApiRecordPO.setResponseMessageBody(responseBody);
            this.wmApiRecordPOMapper.insertSelective(wmApiRecordPO);
        }
        catch (Exception e) {
            log.info("saveApiRecord , exception : {}", (Object)e.getMessage());
        }
    }

    public void saveApiRecord(String topic, String priKey, String requestBody, String responseBody) {
        try {
            WmApiRecordPO wmApiRecordPO = new WmApiRecordPO();
            wmApiRecordPO.setCreateDate(new Date());
            wmApiRecordPO.setRequestTime(new Date());
            wmApiRecordPO.setPriKey(priKey);
            wmApiRecordPO.setRequestTopic(topic);
            wmApiRecordPO.setRequestMessageBody(requestBody);
            wmApiRecordPO.setResponseMessageBody(responseBody);
            this.wmApiRecordPOMapper.insertSelective(wmApiRecordPO);
        }
        catch (Exception e) {
            log.info("saveApiRecord , exception : {}", (Object)e.getMessage());
        }
    }

    public void saveCrmAndWmId() {
    }

    public Long getMemberWid(String phone) throws Exception {
        MemberWidReq memberWidReq = WmConverFactory.getMemberWidReq(phone);
        log.info("getMemberWid, param:{}", (Object)memberWidReq);
        String result = this.wmSystemHttpClientComponent.doPost("/apigw/bos/v2.0/user/superwid/get", JSON.toJSONString((Object)memberWidReq));
        log.info("getMemberWid , result:{}", (Object)JSON.toJSONString((Object)result));
        WmResultVo resultVo = (WmResultVo)JSON.parseObject((String)result, WmResultVo.class);
        if (resultVo.getCode() != null && SUCCESS_CODE.equals(resultVo.getCode().getErrcode()) && resultVo.getData() != null) {
            return resultVo.getData().getLong("superWid");
        }
        throw new Exception("\u83b7\u53d6\u4f1a\u5458\u5fae\u76df\u5bf9\u63a5wid\u5931\u8d25\uff01");
    }

    public Long getMemberLevelId(String levelName, Long membershipPlanId) throws Exception {
        JSONObject jsonObj;
        JSONObject json = new JSONObject();
        json.put("membershipPlanId", (Object)membershipPlanId);
        json.put("privilegeType", (Object)"GOODS_DISCOUNT");
        String result = this.wmSystemHttpClientComponent.doPost("/apigw/weimob_crm/v2.0/membercard/level/privilege/getList", json.toJSONString());
        log.info("getMemberLevelId , result:{}", (Object)JSON.toJSONString((Object)result));
        WmResultVo resultVo = (WmResultVo)JSON.parseObject((String)result, WmResultVo.class);
        if (resultVo.getCode() != null && SUCCESS_CODE.equals(resultVo.getCode().getErrcode()) && resultVo.getData() != null && (jsonObj = resultVo.getData()).getJSONArray("levelPrivilege") != null) {
            JSONArray jsonArray = jsonObj.getJSONArray("levelPrivilege");
            Integer index = 0;
            while (index < jsonArray.size()) {
                if (levelName.equals(jsonArray.getJSONObject(index.intValue()).getString("levelName"))) {
                    return jsonArray.getJSONObject(index.intValue()).getLong("levelId");
                }
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
            }
        }
        throw new Exception("\u83b7\u53d6\u4f1a\u5458\u7b49\u7ea7wid\u5931\u8d25\uff01");
    }

    public Long getGuiderWid(String phone) throws Exception {
        GuiderWidReq guiderWidReq = WmConverFactory.getGuiderWidReq(phone);
        log.info("getGuiderWid, param:{}", (Object)guiderWidReq);
        String result = this.wmSystemHttpClientComponent.doPost("/apigw/weimob_guide/v2.0/guider/get", JSON.toJSONString((Object)guiderWidReq));
        log.info("getGuiderWid , result:{}", (Object)JSON.toJSONString((Object)result));
        WmResultVo resultVo = (WmResultVo)JSON.parseObject((String)result, WmResultVo.class);
        if (resultVo.getCode() != null && SUCCESS_CODE.equals(resultVo.getCode().getErrcode()) && resultVo.getData() != null) {
            return resultVo.getData().getLong("guiderWid");
        }
        throw new Exception("\u83b7\u53d6\u5bfc\u8d2d\u5fae\u76df\u5bf9\u63a5wid\u5931\u8d25\uff01");
    }

    public Long checkGuiderWid(String phone) {
        GuiderWidReq guiderWidReq = WmConverFactory.getGuiderWidReq(phone);
        log.info("getGuiderWid, param:{}", (Object)guiderWidReq);
        String result = this.wmSystemHttpClientComponent.doPost("/apigw/weimob_guide/v2.0/guider/get", JSON.toJSONString((Object)guiderWidReq));
        log.info("getGuiderWid , result:{}", (Object)JSON.toJSONString((Object)result));
        WmResultVo resultVo = (WmResultVo)JSON.parseObject((String)result, WmResultVo.class);
        if (resultVo.getCode() != null && SUCCESS_CODE.equals(resultVo.getCode().getErrcode()) && resultVo.getData() != null) {
            return resultVo.getData().getLong("guiderWid");
        }
        return null;
    }

    public Long getVid(Integer type) throws Exception {
        JSONObject jsonObj;
        VidReq vidReq = WmConverFactory.getVidReq(type, 1, 1);
        log.info("getVid, param:{}", (Object)vidReq);
        String result = this.wmSystemHttpClientComponent.doPost("/apigw/bos/v2.0/organization/getList", JSON.toJSONString((Object)vidReq));
        log.info("getVid , result:{}", (Object)JSON.toJSONString((Object)result));
        WmResultVo resultVo = (WmResultVo)JSON.parseObject((String)result, WmResultVo.class);
        if (resultVo.getCode() != null && SUCCESS_CODE.equals(resultVo.getCode().getErrcode()) && resultVo.getData() != null && (jsonObj = resultVo.getData()).getIntValue("totalSize") > 0 && jsonObj.getJSONArray("data") != null) {
            JSONArray jsonArray = jsonObj.getJSONArray("data");
            return jsonArray.getJSONObject(0).getLongValue("vid");
        }
        throw new Exception("\u83b7\u53d6\u5bfc\u8d2d\u5fae\u76df\u96c6\u56e2Vid\u5931\u8d25\uff01");
    }

    public Long getRegionVid(String regionCode) {
        log.info("getRegionVid,regionCode:{}", (Object)regionCode);
        if (StringUtils.isBlank((String)regionCode)) {
            return null;
        }
        Long regionVid = this.sysCrmWmFieldMappingService.findWmFieldByCrmField(regionCode, CrmWmFieldMappingTypeEnum.REGION_CODE.getCode(), Long.class);
        if (regionVid != null) {
            return regionVid;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("vidCode", regionCode);
        log.info("getRegionVid,wmURL:{}, param:{}", (Object)"/apigw/bos/v2.0/organization/detail/get", (Object)JSON.toJSONString(paramMap));
        String result = this.wmSystemHttpClientComponent.doPost("/apigw/bos/v2.0/organization/detail/get", JSON.toJSONString(paramMap));
        log.info("getRegionVid , result:{}", (Object)JSON.toJSONString((Object)result));
        WmResultVo resultVo = (WmResultVo)JSON.parseObject((String)result, WmResultVo.class);
        if (resultVo.getCode() != null && SUCCESS_CODE.equals(resultVo.getCode().getErrcode()) && resultVo.getData() != null && (regionVid = resultVo.getData().getLong("vid")) != null) {
            SysCrmWmFieldMappingPO sysCrmWmFieldMappingPO = this.sysCrmWmFieldMappingService.initSysCrmWmFieldMappingPO(regionVid.toString(), regionCode, CrmWmFieldMappingTypeEnum.REGION_CODE.getCode());
            this.sysCrmWmFieldMappingService.insertSysCrmWmFieldMapping(sysCrmWmFieldMappingPO);
        }
        return regionVid;
    }

    public Long getStoreVid(String storeCode) throws Exception {
        String vid;
        if (StringUtils.isEmpty((String)storeCode)) {
            log.info("getStoreVid, param:{}", (Object)storeCode);
        }
        if (StringUtils.isNotEmpty((String)(vid = this.sysCrmWmFieldMappingService.findWmFieldByCrmField(storeCode, CrmWmFieldMappingTypeEnum.STORE_CODE.getCode())))) {
            return Long.valueOf(vid);
        }
        VidDetailReq vidDetailReq = new VidDetailReq();
        vidDetailReq.setVidCode(storeCode);
        log.info("getStoreVid, param:{}", (Object)vidDetailReq);
        String result = this.wmSystemHttpClientComponent.doPost("/apigw/bos/v2.0/organization/detail/get", JSON.toJSONString((Object)vidDetailReq));
        log.info("getStoreVid , result:{}", (Object)JSON.toJSONString((Object)result));
        WmResultVo resultVo = (WmResultVo)JSON.parseObject((String)result, WmResultVo.class);
        if (resultVo.getCode() != null && SUCCESS_CODE.equals(resultVo.getCode().getErrcode()) && resultVo.getData() != null) {
            JSONObject jsonObj = resultVo.getData();
            Long vidLong = jsonObj.getLong("vid");
            this.addCrmAndWmFieldMapping(storeCode, vidLong);
            return vidLong;
        }
        log.info("getStoreVid, param:{}", (Object)storeCode);
        return null;
    }

    public String getGoodsId(String goodsCode) {
        if (StringUtils.isEmpty((String)goodsCode)) {
            return "";
        }
        log.info("getGoodsId, param:{}", (Object)goodsCode);
        String redisValue = (String)this.redisCacheComponent.getCacheObject("WM_GOODS_" + goodsCode);
        if (StringUtils.isNotEmpty((String)redisValue)) {
            return redisValue;
        }
        String goodsId = this.sysCrmWmFieldMappingService.findWmFieldByCrmField(goodsCode, CrmWmFieldMappingTypeEnum.GOODS_CODE.getCode());
        log.info("getGoodsId, result:{}", (Object)goodsId);
        if (StringUtils.isNotEmpty((String)goodsId)) {
            this.redisCacheComponent.setCacheObject("WM_GOODS_" + goodsCode, goodsId);
        }
        return goodsId;
    }

    private void addCrmAndWmFieldMapping(String storeCode, Long vid) {
        log.info("addCrmAndWmFieldMapping\uff1astoreCode:{}, vid:{}", (Object)storeCode, (Object)vid);
        SysCrmWmFieldMappingPO mappingPO = this.sysCrmWmFieldMappingService.initSysCrmWmFieldMappingPO(vid.toString(), storeCode, CrmWmFieldMappingTypeEnum.STORE_CODE.getCode());
        this.sysCrmWmFieldMappingService.insertSysCrmWmFieldMapping(mappingPO);
        log.info("addCrmAndWmFieldMapping\uff1aend");
    }

    @PostConstruct
    public void initWmMappingCrm() {
        this.initRegionMapping();
    }

    private void initRegionMapping() {
        log.info("initRegionMapping start--------");
        if (this.sysCrmWmFieldMappingService.isExistByMappingType(CrmWmFieldMappingTypeEnum.REGION_CODE.getCode()).booleanValue()) {
            log.info("initRegionMapping \u5df2\u7ecf\u6620\u5c04\u8fc7\u4e86----");
            return;
        }
        List<String> crmRegionCodeList = this.findCrmRegionCode();
        if (CollectionUtils.isEmpty(crmRegionCodeList)) {
            log.info("initRegionMapping crmRegionCodeList is NULL");
            return;
        }
        log.info("initRegionMapping crmRegionCodeList:{}", (Object)JSON.toJSONString(crmRegionCodeList));
        HashMap<String, Long> regionMap = new HashMap<String, Long>();
        for (int index = 1; index < 100; ++index) {
            Map<String, Long> regionMapTemp = this.selectRegionPage(index, index * 50);
            if (CollectionUtils.isEmpty(regionMapTemp)) {
                log.info("initRegionMapping regionMap is NULL");
                break;
            }
            regionMap.putAll(regionMapTemp);
            if (regionMapTemp.size() < 50) break;
        }
        log.info("initRegionMapping regionMap:{}", (Object)JSON.toJSONString(regionMap));
        for (String regionCode : crmRegionCodeList) {
            Long wmVid = (Long)regionMap.get(regionCode);
            if (wmVid == null) continue;
            SysCrmWmFieldMappingPO sysCrmWmFieldMappingPO = this.sysCrmWmFieldMappingService.initSysCrmWmFieldMappingPO(wmVid.toString(), regionCode, CrmWmFieldMappingTypeEnum.REGION_CODE.getCode());
            this.sysCrmWmFieldMappingService.insertSysCrmWmFieldMapping(sysCrmWmFieldMappingPO);
        }
    }

    private List<String> findCrmRegionCode() {
        ArrayList<String> propIdList = new ArrayList();
        log.info("findCrmRegionCode, brandCode:{}", (Object)"VG-CLUB");
        ResponseData bojunResponse = this.sysBojunDataServiceRpc.findSysBojunPropIdByBrandCode("VG-CLUB");
        if (bojunResponse.getCode() == SysResponseEnum.SUCCESS.getCode()) {
            propIdList = (List)bojunResponse.getData();
        }
        log.info("findCrmRegionCode, result:{}", (Object)JSON.toJSONString((Object)bojunResponse));
        return propIdList;
    }

    private Map<String, Long> selectRegionPage(int pageNum, int pageSize) {
        JSONObject jsonObj;
        JSONArray resultArr;
        HashMap<String, Long> resultMap = new HashMap<String, Long>();
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        param.put("isDirect", 0);
        param.put("vidType", 3);
        param.put("vidStatus", 1);
        param.put("pageSize", pageSize);
        param.put("pageNum", pageNum);
        log.info("selectRegionPage, param:{}", (Object)JSON.toJSONString(param));
        String result = this.wmSystemHttpClientComponent.doPost("/apigw/bos/v2.0/organization/getList", JSON.toJSONString(param));
        log.info("selectRegionPage , result:{}", (Object)JSON.toJSONString((Object)result));
        WmResultVo resultVo = (WmResultVo)JSON.parseObject((String)result, WmResultVo.class);
        if (resultVo.getCode() != null && SUCCESS_CODE.equals(resultVo.getCode().getErrcode()) && resultVo.getData() != null && (resultArr = (jsonObj = resultVo.getData()).getJSONArray("data")) != null) {
            for (int i = 0; i < resultArr.size(); ++i) {
                JSONObject jsonObject = resultArr.getJSONObject(i);
                String vidCode = jsonObject.getString("vidCode");
                Long vid = jsonObject.getLong("vid");
                resultMap.put(vidCode, vid);
            }
        }
        return resultMap;
    }
}

