/*
 * Decompiled with CFR 0.152.
 */
package com.daas.nros.connector.server.service.impl.weimob;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.couponfacade.interfaces.CouponDefinitionServiceFeign;
import com.bizvane.couponfacade.interfaces.CouponEntityServiceFeign;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.OrderDetailModel;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.daas.nros.connector.client.enums.CrmWmFieldMappingTypeEnum;
import com.daas.nros.connector.client.enums.StringBrandCode;
import com.daas.nros.connector.client.model.po.MbrMembersPo;
import com.daas.nros.connector.client.model.po.MbrMembersPoExample;
import com.daas.nros.connector.client.model.po.SysCrmWmFieldMappingPO;
import com.daas.nros.connector.client.model.po.SysWeiMengPO;
import com.daas.nros.connector.client.model.po.SysWeiMengPOExample;
import com.daas.nros.connector.client.model.result.Result;
import com.daas.nros.connector.client.weimob.model.req.CouponBandMemberReq;
import com.daas.nros.connector.client.weimob.model.req.CouponCancelReq;
import com.daas.nros.connector.client.weimob.model.req.CouponConsumeReq;
import com.daas.nros.connector.client.weimob.model.req.CouponCreateReq;
import com.daas.nros.connector.client.weimob.model.req.CouponTemplateReq;
import com.daas.nros.connector.client.weimob.model.req.MemberLabelAddReq;
import com.daas.nros.connector.client.weimob.model.req.MemberLabelAttrReq;
import com.daas.nros.connector.client.weimob.model.req.MemberLabelRemoveReq;
import com.daas.nros.connector.client.weimob.model.req.MemberLabelReq;
import com.daas.nros.connector.client.weimob.model.req.MemberLevelChangeReq;
import com.daas.nros.connector.client.weimob.model.req.MemberOrderCancelReq;
import com.daas.nros.connector.client.weimob.model.req.MemberOrderReq;
import com.daas.nros.connector.client.weimob.model.req.MemberOrderUpdateReq;
import com.daas.nros.connector.client.weimob.model.req.MemberReq;
import com.daas.nros.connector.client.weimob.model.req.MemberUpdateReq;
import com.daas.nros.connector.client.weimob.model.req.UpdateMemberStaffReq;
import com.daas.nros.connector.client.weimob.model.req.UpdateMemberStoreReq;
import com.daas.nros.connector.client.weimob.model.req.param.CouponBindMemberParam;
import com.daas.nros.connector.client.weimob.model.req.param.CouponCancelParam;
import com.daas.nros.connector.client.weimob.model.req.param.CouponDefinitionParam;
import com.daas.nros.connector.client.weimob.model.req.param.CouponUseParam;
import com.daas.nros.connector.client.weimob.model.req.param.CrmMemberOrderParam;
import com.daas.nros.connector.client.weimob.model.req.param.CrmMemberOrderUpdateParam;
import com.daas.nros.connector.client.weimob.model.req.param.MemberBindChannelParam;
import com.daas.nros.connector.client.weimob.model.req.param.MemberInfo;
import com.daas.nros.connector.client.weimob.model.req.param.MemberInfoModelParam;
import com.daas.nros.connector.client.weimob.model.req.param.MemberLabelAddParam;
import com.daas.nros.connector.client.weimob.model.req.param.MemberLabelAttrParam;
import com.daas.nros.connector.client.weimob.model.req.param.MemberLabelInfoParam;
import com.daas.nros.connector.client.weimob.model.req.param.MemberOrderBaseInfoParam;
import com.daas.nros.connector.client.weimob.model.req.param.MemberOrderDeliveryParam;
import com.daas.nros.connector.client.weimob.model.req.param.MemberOrderGuiderParam;
import com.daas.nros.connector.client.weimob.model.req.param.MemberOrderInfoParam;
import com.daas.nros.connector.client.weimob.model.req.param.MemberOrderItemInfoParam;
import com.daas.nros.connector.client.weimob.model.req.param.MemberOrderItemParam;
import com.daas.nros.connector.client.weimob.model.req.param.MemberOrderPayInfoParam;
import com.daas.nros.connector.client.weimob.model.req.param.MemberOrderSellerInfoParam;
import com.daas.nros.connector.client.weimob.model.req.param.MemberOrderUserInfoParam;
import com.daas.nros.connector.client.weimob.model.req.param.MerchantInfoParam;
import com.daas.nros.connector.client.weimob.model.req.param.RefundAccountParam;
import com.daas.nros.connector.client.weimob.model.req.param.RefundDetailParam;
import com.daas.nros.connector.client.weimob.model.req.param.RightsItemsParam;
import com.daas.nros.connector.client.weimob.model.req.param.WmGoodsBaseInfoParam;
import com.daas.nros.connector.client.weimob.model.req.param.WmSyncGoodsCreateParam;
import com.daas.nros.connector.client.weimob.model.result.WmMemberBaseInfoDto;
import com.daas.nros.connector.client.weimob.model.result.WmResultArrayVo;
import com.daas.nros.connector.client.weimob.model.result.WmResultVo;
import com.daas.nros.connector.server.config.weimob.WMSystemFieldConfig;
import com.daas.nros.connector.server.mapper.MbrMembersPoMapper;
import com.daas.nros.connector.server.mapper.SysWeiMengPOMapper;
import com.daas.nros.connector.server.mapper.WmApiRecordPOMapper;
import com.daas.nros.connector.server.service.api.weimob.SysCrmWmFieldMappingService;
import com.daas.nros.connector.server.service.api.weimob.SysWeimengService;
import com.daas.nros.connector.server.service.component.WmSystemHttpClientComponent;
import com.daas.nros.connector.server.service.conver.WmConverFactory;
import com.daas.nros.connector.server.service.impl.weimob.WmAPiComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SysWeimengServiceImpl
implements SysWeimengService {
    private static final Logger log = LoggerFactory.getLogger(SysWeimengServiceImpl.class);
    @Value(value="${wm.isopen:9}")
    private String isOpen;
    public static final String IS_OPEN = "9";
    @Autowired
    private WMSystemFieldConfig wmSystemFieldConfig;
    @Autowired
    private SysWeiMengPOMapper sysWeiMengPOMapper;
    @Resource
    private MbrMembersPoMapper mbrMembersPoMapper;
    @Autowired
    private WmSystemHttpClientComponent wmSystemHttpClientComponent;
    @Autowired
    private SysCrmWmFieldMappingService sysCrmWmFieldMappingService;
    @Autowired
    private CouponDefinitionServiceFeign couponDefinitionServiceFeign;
    @Autowired
    private CouponEntityServiceFeign couponEntityServiceFeign;
    @Autowired
    private WmAPiComponent wmAPiComponent;
    @Autowired
    private WmApiRecordPOMapper wmApiRecordPOMapper;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    public static final String SUCCESS_CODE = "0";
    @Value(value="${wm.membershipPlanId:800825244}")
    private Long membershipPlanId;

    @Override
    public Result<Object> addMemberInfoTowm(List<MemberInfoModelParam> memberInfoModelParams) {
        log.info("addMemberInfoTowm, start:{}", (Object)JSON.toJSONString(memberInfoModelParams));
        Result resultData = new Result();
        try {
            MemberReq memberReq = new MemberReq();
            memberReq.setImportType(Integer.valueOf(2));
            memberReq.setMembershipPlanId(this.membershipPlanId);
            ArrayList<MemberInfo> userList = new ArrayList<MemberInfo>();
            for (MemberInfoModelParam memberInfoModelParam : memberInfoModelParams) {
                Long storeId;
                MemberInfo memberInfo = new MemberInfo();
                memberInfo.setPhone(memberInfoModelParam.getPhone());
                memberInfo.setRegionCode("86");
                memberInfo.setUnionId(memberInfoModelParam.getWxUnionId());
                memberInfo.setOpenId(memberInfoModelParam.getWxOpenId());
                memberInfo.setAppId("");
                memberInfo.setAppChannel(Integer.valueOf(5));
                memberInfo.setUserName(memberInfoModelParam.getName());
                memberInfo.setGender(WmConverFactory.converGender(memberInfoModelParam.getGender()));
                if (WmConverFactory.getTimeStampFromData(memberInfoModelParam.getBirthday()) != null) {
                    memberInfo.setBirthday(WmConverFactory.getTimeStampFromData(memberInfoModelParam.getBirthday()));
                }
                memberInfo.setBelongVidName(memberInfoModelParam.getServiceStoreName());
                memberInfo.setCustomCardNo(memberInfoModelParam.getCardNo());
                memberInfo.setLevelName(memberInfoModelParam.getLevelName());
                memberInfo.setBalance(Integer.valueOf(0));
                memberInfo.setTotalBalance(Integer.valueOf(0));
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)memberInfoModelParam.getServiceGuiderPhone()) && !"13120738909".equals(memberInfoModelParam.getServiceGuiderPhone()) && this.wmAPiComponent.checkGuiderWid(memberInfoModelParam.getServiceGuiderPhone()) != null) {
                    memberInfo.setGuiderPhone(memberInfoModelParam.getServiceGuiderPhone());
                }
                if (WmConverFactory.getTimeStampFromData(memberInfoModelParam.getCreateDate()) != null) {
                    memberInfo.setBecomeMemberTime(WmConverFactory.getTimeStampFromData(memberInfoModelParam.getCreateDate()).longValue());
                }
                memberInfo.setMembershipCardChannel(Integer.valueOf(1));
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)memberInfoModelParam.getOpenCardStoreCode()) && (storeId = this.wmAPiComponent.getStoreVid(memberInfoModelParam.getOpenCardStoreCode())) != null) {
                    memberInfo.setSourceVid(storeId);
                }
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)memberInfoModelParam.getServiceStoreCode()) && (storeId = this.wmAPiComponent.getStoreVid(memberInfoModelParam.getServiceStoreCode())) != null) {
                    memberInfo.setSourceVid(storeId);
                }
                userList.add(memberInfo);
            }
            memberReq.setUserList(userList);
            log.info("addMemberInfoTowm, param:{}", (Object)JSON.toJSONString((Object)memberReq));
            String result = this.wmSystemHttpClientComponent.doPost("/apigw/weimob_crm/v2.0/customer/import", JSON.toJSONString((Object)memberReq));
            log.info("addNewMemberLaberTowm , result:{}", (Object)JSON.toJSONString((Object)result));
            WmResultVo resultVo = (WmResultVo)JSON.parseObject((String)result, WmResultVo.class);
            this.wmAPiComponent.saveApiRecord("MEMNER_ADD", JSON.toJSONString((Object)memberReq), result);
            if (resultVo.getCode() != null && SUCCESS_CODE.equals(resultVo.getCode().getErrcode())) {
                resultData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                resultData.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
                return resultData;
            }
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
            return resultData;
        }
        catch (Exception e) {
            log.info("addMemberInfoTowm , excepion :{}", (Throwable)e);
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
            return resultData;
        }
    }

    @Override
    public Result<Object> updateMemberLevelTowm(MemberInfoModelParam memberInfoModelParam) {
        log.info("updateMemberLevelToWm, start:{}", (Object)JSON.toJSONString((Object)memberInfoModelParam));
        Result resultData = new Result();
        try {
            MemberLevelChangeReq memberLevelChangeReq = WmConverFactory.getMemberLevelReq(memberInfoModelParam);
            memberLevelChangeReq.setMembershipPlanId(this.membershipPlanId);
            memberLevelChangeReq.setWid(this.wmAPiComponent.getMemberWid(memberInfoModelParam.getPhone()));
            memberLevelChangeReq.setLevelId(this.wmAPiComponent.getMemberLevelId(memberInfoModelParam.getLevelName(), this.membershipPlanId));
            log.info("updateMemberLevelToWm, param:{}", (Object)memberLevelChangeReq);
            String result = this.wmSystemHttpClientComponent.doPost("/apigw/weimob_crm/v2.0/membercard/update", JSON.toJSONString((Object)memberLevelChangeReq));
            log.info("updateMemberLevelToWm , result:{}", (Object)JSON.toJSONString((Object)result));
            this.wmAPiComponent.saveApiRecord("MEMNER_LEVEL_UPDATE", Long.toString(memberInfoModelParam.getMbrMemberId()), JSON.toJSONString((Object)memberLevelChangeReq), result);
            WmResultVo resultVo = (WmResultVo)JSON.parseObject((String)result, WmResultVo.class);
            if (resultVo.getCode() != null && SUCCESS_CODE.equals(resultVo.getCode().getErrcode())) {
                resultData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                resultData.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
                return resultData;
            }
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
            return resultData;
        }
        catch (Exception e) {
            log.info("updateMemberLevelToWm , excepion :{}", (Object)e.getMessage());
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
            return resultData;
        }
    }

    @Override
    public Result<Object> updateMemberInfoTowm(MemberInfoModelParam memberInfoModelParam) {
        log.info("updateMemberInfoTowm, start:{}", (Object)JSON.toJSONString((Object)memberInfoModelParam));
        Result resultData = new Result();
        try {
            MemberUpdateReq memberUpdateReq = WmConverFactory.getMemberUpdateReq(memberInfoModelParam);
            memberUpdateReq.setWid(this.wmAPiComponent.getMemberWid(memberInfoModelParam.getPhone()));
            log.info("updateMemberInfoTowm, param:{}", (Object)memberUpdateReq);
            String result = this.wmSystemHttpClientComponent.doPost("/apigw/weimob_crm/v2.0/customer/update", JSON.toJSONString((Object)memberUpdateReq));
            log.info("updateMemberInfoTowm , result:{}", (Object)JSON.toJSONString((Object)result));
            this.wmAPiComponent.saveApiRecord("MEMNER_INFO_UPDATE", Long.toString(memberInfoModelParam.getMbrMemberId()), JSON.toJSONString((Object)memberUpdateReq), result);
            WmResultVo resultVo = (WmResultVo)JSON.parseObject((String)result, WmResultVo.class);
            if (resultVo.getCode() != null && SUCCESS_CODE.equals(resultVo.getCode().getErrcode())) {
                resultData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                resultData.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
                return resultData;
            }
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
            return resultData;
        }
        catch (Exception e) {
            log.info("updateMemberInfoTowm , excepion :{}", (Object)e.getMessage());
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
            return resultData;
        }
    }

    @Override
    public Result<Object> updateMemberServiceTowm(MemberInfoModelParam memberInfoModelParam) {
        log.info("updateMemberServiceTowm, start:{}", (Object)JSON.toJSONString((Object)memberInfoModelParam));
        Result resultData = new Result();
        try {
            long wid = this.wmAPiComponent.getMemberWid(memberInfoModelParam.getPhone());
            long stordWid = this.wmAPiComponent.getStoreVid(memberInfoModelParam.getServiceStoreCode());
            UpdateMemberStaffReq updateMemberStaffReq = new UpdateMemberStaffReq();
            Long guiderWid = this.wmAPiComponent.checkGuiderWid(memberInfoModelParam.getServiceGuiderPhone());
            if (guiderWid != null) {
                updateMemberStaffReq.setGuiderWid(guiderWid);
            }
            updateMemberStaffReq.setGuiderVid(Long.valueOf(stordWid));
            updateMemberStaffReq.setCustomerWid(Long.valueOf(wid));
            updateMemberStaffReq.setBindSceneType(Integer.valueOf(10));
            updateMemberStaffReq.setModifyReasonType(Integer.valueOf(19));
            log.info("updateMemberServiceTowm staff , param:{}", (Object)JSON.toJSONString((Object)updateMemberStaffReq));
            String staffResult = this.wmSystemHttpClientComponent.doPost("/apigw/weimob_guide/v2.0/customer/guider/changeBind", JSON.toJSONString((Object)updateMemberStaffReq));
            log.info("updateMemberServiceTowm staff , result:{}", (Object)JSON.toJSONString((Object)staffResult));
            this.wmAPiComponent.saveApiRecord("MEMNER_INFO_UPDATE", Long.toString(memberInfoModelParam.getMbrMemberId()), JSON.toJSONString((Object)updateMemberStaffReq), staffResult);
            WmResultVo staffResultVo = (WmResultVo)JSON.parseObject((String)staffResult, WmResultVo.class);
            if (staffResultVo == null || staffResultVo.getCode() == null || !SUCCESS_CODE.equals(staffResultVo.getCode().getErrcode())) {
                resultData.setMessage(SysResponseEnum.SYSTEM_ERROR.getMessage());
                resultData.setCode(Integer.valueOf(SysResponseEnum.SYSTEM_ERROR.getCode()));
                return resultData;
            }
            UpdateMemberStoreReq updateMemberStoreReq = new UpdateMemberStoreReq();
            updateMemberStoreReq.setScene(Integer.valueOf(99));
            updateMemberStoreReq.setOrigin(Integer.valueOf(1));
            updateMemberStoreReq.setOperateWid(Integer.valueOf(0));
            updateMemberStoreReq.setReason("crm\u8c03\u6574");
            updateMemberStoreReq.setVid(Long.valueOf(stordWid));
            ArrayList<Long> widList = new ArrayList<Long>();
            widList.add(wid);
            updateMemberStoreReq.setWidList(widList);
            log.info("updateMemberServiceTowm store , param:{}", (Object)JSON.toJSONString((Object)updateMemberStoreReq));
            String storeResult = this.wmSystemHttpClientComponent.doPost("/apigw/weimob_crm/v2.0/customer/organization/bind", JSON.toJSONString((Object)updateMemberStoreReq));
            log.info("updateMemberServiceTowm store , result:{}", (Object)JSON.toJSONString((Object)storeResult));
            this.wmAPiComponent.saveApiRecord("MEMNER_INFO_UPDATE", Long.toString(memberInfoModelParam.getMbrMemberId()), JSON.toJSONString((Object)updateMemberStoreReq), storeResult);
            WmResultVo storeResultVo = (WmResultVo)JSON.parseObject((String)storeResult, WmResultVo.class);
            if (storeResultVo == null || storeResultVo.getCode() == null || !SUCCESS_CODE.equals(storeResultVo.getCode().getErrcode())) {
                resultData.setMessage(SysResponseEnum.SYSTEM_ERROR.getMessage());
                resultData.setCode(Integer.valueOf(SysResponseEnum.SYSTEM_ERROR.getCode()));
                return resultData;
            }
            resultData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            resultData.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
            return resultData;
        }
        catch (Exception e) {
            log.info("updateMemberServiceTowm , excepion :{}", (Object)e.getMessage());
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
            return resultData;
        }
    }

    @Override
    public Long findWeimengWidByPhone(String phone) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)phone)) {
            return null;
        }
        SysWeiMengPOExample example = new SysWeiMengPOExample();
        SysWeiMengPOExample.Criteria criteria = example.createCriteria();
        criteria.andPhoneEqualTo(phone).andValidEqualTo(Boolean.TRUE);
        List<SysWeiMengPO> sysWeiMengPOS = this.sysWeiMengPOMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(sysWeiMengPOS)) {
            return sysWeiMengPOS.get(0).getWid();
        }
        Long wid = this.exectorFindWmMemberBaseInfo(phone, 1);
        log.info("findWeimengWidByPhone,wid:{}", (Object)wid);
        return wid;
    }

    @Override
    public Long findWeimengWidBySysMemberCode(String memberCode) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)memberCode)) {
            return null;
        }
        MbrMembersPo member = this.findMbrMemberBy(memberCode, 2, StringBrandCode.vg.getValue());
        if (member == null) {
            log.info("exectorFindWmMemberBaseInfo \u67e5\u627e\u4e0d\u5230\u4f1a\u5458\uff0c\u5165\u53c2\u65e0\u6548");
            return null;
        }
        Long wid = this.findWeimengWidByPhone(member.getPhone());
        log.info("findWeimengWidBySysMemberCode,wid:{}", (Object)wid);
        return wid;
    }

    private Long exectorFindWmMemberBaseInfo(String keyword, int type) {
        MbrMembersPo member = this.findMbrMemberBy(keyword, type, StringBrandCode.vg.getValue());
        if (member == null) {
            log.info("exectorFindWmMemberBaseInfo \u67e5\u627e\u4e0d\u5230\u4f1a\u5458\uff0c\u5165\u53c2\u65e0\u6548");
            return null;
        }
        WmMemberBaseInfoDto wmMember = this.findWmMemberBaseInfoByPhone(member.getPhone());
        if (wmMember == null) {
            log.info("exectorFindWmMemberBaseInfo \u8c03\u7528WM \u5931\u8d25");
            return null;
        }
        Long wid = wmMember.getSuperWid();
        this.initSysWeimeng(wid, member);
        return wid;
    }

    @Override
    public MbrMembersPo findMbrMemberBy(String keyword, int type, String brandCode) {
        log.info("findMbrMemberBy,keyword:{}, type:{}, brandCode:{}", new Object[]{keyword, type, brandCode});
        Long sysCompanyId = 247L;
        ResponseData brand = this.brandServiceRpc.getBrand(sysCompanyId, brandCode);
        if (brand.getCode() == SysResponseEnum.FAILED.getCode() || brand.getData() == null) {
            log.info("findMbrMemberBy, \u83b7\u53d6\u54c1\u724c\u5931\u8d25");
            return null;
        }
        Long brandId = ((SysBrandPo)brand.getData()).getSysBrandId();
        MbrMembersPoExample membersPoExample = new MbrMembersPoExample();
        MbrMembersPoExample.Criteria criteria = membersPoExample.createCriteria();
        criteria.andSysCompanyIdEqualTo(Long.valueOf(247L)).andValidEqualTo(Boolean.TRUE);
        if (type == 1) {
            criteria.andPhoneEqualTo(keyword).andBrandIdEqualTo(Integer.valueOf(brandId.intValue()));
        } else if (type == 2) {
            criteria.andMemberCodeEqualTo(keyword);
        } else {
            criteria.andCardNoEqualTo(keyword).andBrandIdEqualTo(Integer.valueOf(brandId.intValue()));
        }
        List<MbrMembersPo> mbrMembersPos = this.mbrMembersPoMapper.selectByExample(membersPoExample);
        if (CollectionUtils.isNotEmpty(mbrMembersPos)) {
            log.info("findMbrMemberBy, result:{}", (Object)JSON.toJSONString((Object)mbrMembersPos.get(0)));
            return mbrMembersPos.get(0);
        }
        log.info("findMbrMemberBy, result:null");
        return null;
    }

    private void initSysWeimeng(Long wid, MbrMembersPo membersPo) {
        SysWeiMengPO sysWeiMengPO = new SysWeiMengPO();
        sysWeiMengPO.setWid(wid);
        sysWeiMengPO.setMbrMemberId(membersPo.getMbrMemberId());
        sysWeiMengPO.setMemberCode(membersPo.getMemberCode());
        sysWeiMengPO.setPhone(membersPo.getPhone());
        sysWeiMengPO.setValid(Boolean.TRUE);
        this.sysWeiMengPOMapper.insert(sysWeiMengPO);
    }

    @Override
    public WmMemberBaseInfoDto findWmMemberBaseInfoByPhone(String phone) {
        log.info("findWmMemberBaseInfoByPhone,phone:{}", (Object)phone);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)phone)) {
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("originalId", phone);
        hashMap.put("source", 4);
        String result = this.wmSystemHttpClientComponent.doPost("/apigw/bos/v2.0/user/superwid/get", JSON.toJSONString(hashMap));
        log.info("findWmMemberBaseInfoByPhone,result:{}", (Object)JSON.toJSONString((Object)result));
        WmResultVo resultVo = (WmResultVo)JSON.parseObject((String)result, WmResultVo.class);
        if (resultVo == null || !SUCCESS_CODE.equals(resultVo.getCode().getErrcode())) {
            log.info("getWmMemberBaseInfo error:{}", (Object)result);
            return null;
        }
        WmMemberBaseInfoDto wmMemberBaseInfoDto = (WmMemberBaseInfoDto)JSON.toJavaObject((JSON)resultVo.getData(), WmMemberBaseInfoDto.class);
        return wmMemberBaseInfoDto;
    }

    @Override
    public Result<Object> addNewMemberLabelTowm(List<MemberLabelInfoParam> memberLabelInfoParams) {
        Result resultData = new Result();
        log.info("addNewMemberLabelTowm, start:{}", (Object)JSON.toJSONString(memberLabelInfoParams));
        try {
            MemberLabelReq memberLabelReq = WmConverFactory.getMemberLabelReq(memberLabelInfoParams);
            memberLabelReq.setVid(this.wmSystemFieldConfig.getVid());
            log.info("addNewMemberLabelTowm , requet:{}", (Object)JSON.toJSONString((Object)memberLabelReq));
            String result = this.wmSystemHttpClientComponent.doPost("/apigw/weimob_cdp/v2.0/tag/insertList", JSON.toJSONString((Object)memberLabelReq));
            log.info("addNewMemberLaberTowm , result:{}", (Object)JSON.toJSONString((Object)result));
            this.wmAPiComponent.saveApiRecord("MEMBR_LABEL_ADD", JSON.toJSONString((Object)memberLabelReq), result);
            WmResultVo resultVo = (WmResultVo)JSON.parseObject((String)result, WmResultVo.class);
            if (resultVo.getCode() != null && SUCCESS_CODE.equals(resultVo.getCode().getErrcode())) {
                if (resultVo.getData() != null && resultVo.getData().get((Object)"listVo") != null) {
                    JSONObject jsonObj = resultVo.getData();
                    JSONArray jsonArray = jsonObj.getJSONArray("listVo");
                    Integer index = 0;
                    while (index < memberLabelInfoParams.size()) {
                        if (jsonArray.get(index.intValue()) != null && memberLabelInfoParams.get(index) != null) {
                            SysCrmWmFieldMappingPO sysCrmWmFieldMappingPO = new SysCrmWmFieldMappingPO();
                            sysCrmWmFieldMappingPO.setWmField(jsonArray.getJSONObject(index.intValue()).getString("tagId"));
                            sysCrmWmFieldMappingPO.setCrmField(Long.toString(memberLabelInfoParams.get(index).getMbrLabelGroupDefId()));
                            sysCrmWmFieldMappingPO.setMappingType(CrmWmFieldMappingTypeEnum.MEMBER_LABEL_GROUP_CODE.getCode());
                            this.sysCrmWmFieldMappingService.insertSysCrmWmFieldMapping(sysCrmWmFieldMappingPO);
                        }
                        Integer n = index;
                        Integer n2 = index = Integer.valueOf(index + 1);
                    }
                }
                try {
                    resultData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                    resultData.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
                    return resultData;
                }
                catch (Exception e) {
                    log.info("addNewMemberLaberTowm , excepion :{}", (Object)e.getMessage());
                }
            }
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
            return resultData;
        }
        catch (Exception e) {
            log.info("addNewMemberLaberTowm , excepion :{}", (Object)e.getMessage());
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
            return resultData;
        }
    }

    @Override
    public Result<Object> memberLabelAttrParam(List<MemberLabelAttrParam> memberLabelAttrParams) {
        Result resultData = new Result();
        log.info("memberLabelAttrParam, start:{}", (Object)JSON.toJSONString(memberLabelAttrParams));
        try {
            Long vid = this.wmSystemFieldConfig.getVid();
            for (MemberLabelAttrParam memberLabelAttrParam : memberLabelAttrParams) {
                String wmId;
                if (memberLabelAttrParam == null || memberLabelAttrParam.getMbrLabelDefId() == null || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)(wmId = this.sysCrmWmFieldMappingService.findWmFieldByCrmField(Long.toString(memberLabelAttrParam.getLabelGroupId()), CrmWmFieldMappingTypeEnum.MEMBER_LABEL_GROUP_CODE.getCode())))) continue;
                MemberLabelAttrReq memberLabelAttrReq = WmConverFactory.getMemberLabelAttrReq(memberLabelAttrParam);
                memberLabelAttrReq.setVid(vid);
                memberLabelAttrReq.setTagId(Long.valueOf(wmId));
                log.info("memberLabelAttrParam , requet:{}", (Object)JSON.toJSONString((Object)memberLabelAttrReq));
                String result = this.wmSystemHttpClientComponent.doPost("/apigw/weimob_cdp/v2.0/tag/attribute/create", JSON.toJSONString((Object)memberLabelAttrReq));
                log.info("memberLabelAttrParam , result:{}", (Object)JSON.toJSONString((Object)result));
                this.wmAPiComponent.saveApiRecord("MEMBR_LABEL_TYPE_ADD", Long.toString(memberLabelAttrParam.getMbrLabelDefId()), JSON.toJSONString((Object)memberLabelAttrReq), result);
                WmResultVo resultVo = (WmResultVo)JSON.parseObject((String)result, WmResultVo.class);
                if (resultVo == null || resultVo.getCode() == null || !SUCCESS_CODE.equals(resultVo.getCode().getErrcode())) {
                    resultData.setMessage(SysResponseEnum.FAILED.getMessage());
                    resultData.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
                    return resultData;
                }
                JSONObject jsonObj = resultVo.getData();
                if (jsonObj == null) continue;
                SysCrmWmFieldMappingPO sysCrmWmFieldMappingPO = new SysCrmWmFieldMappingPO();
                sysCrmWmFieldMappingPO.setWmField(jsonObj.getString("attrId"));
                sysCrmWmFieldMappingPO.setCrmField(Long.toString(memberLabelAttrParam.getMbrLabelDefId()));
                sysCrmWmFieldMappingPO.setMappingType(CrmWmFieldMappingTypeEnum.MEMBER_LABEL_CODE.getCode());
                this.sysCrmWmFieldMappingService.insertSysCrmWmFieldMapping(sysCrmWmFieldMappingPO);
            }
            resultData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            resultData.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
            return resultData;
        }
        catch (Exception e) {
            log.info("memberLabelAttrParam , excepion :{}", (Object)e.getMessage());
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
            return resultData;
        }
    }

    @Override
    public Result<Object> memberAddLabelBind(List<MemberInfoModelParam> memberInfoModelParams) {
        Result resultData = new Result();
        log.info("memberAddLabelBind, start:{}", (Object)JSON.toJSONString(memberInfoModelParams));
        try {
            MemberLabelAddReq memberLabelAddReq = WmConverFactory.getMemberLabelAddReq();
            memberLabelAddReq.setVid(this.wmSystemFieldConfig.getVid());
            ArrayList<Long> widList = new ArrayList<Long>();
            for (MemberInfoModelParam memberInfoModelParam : memberInfoModelParams) {
                if (memberInfoModelParam == null || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)memberInfoModelParam.getPhone())) continue;
                widList.add(this.wmAPiComponent.getMemberWid(memberInfoModelParam.getPhone()));
                ArrayList<MemberLabelAddParam> tagList = new ArrayList<MemberLabelAddParam>();
                if (!CollectionUtils.isNotEmpty((Collection)memberInfoModelParam.getTagList())) continue;
                for (MemberLabelAddParam memberLabelAddParam : memberInfoModelParam.getTagList()) {
                    if (memberLabelAddParam == null) continue;
                    MemberLabelAddParam newParam = new MemberLabelAddParam();
                    String wmId = this.sysCrmWmFieldMappingService.findWmFieldByCrmField(Long.toString(memberLabelAddParam.getTagId()), CrmWmFieldMappingTypeEnum.MEMBER_LABEL_GROUP_CODE.getCode());
                    if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)wmId)) continue;
                    newParam.setTagId(Long.valueOf(wmId));
                    ArrayList<Long> newAttrIdList = new ArrayList<Long>();
                    List attrIdList = memberLabelAddParam.getAttrIdList();
                    if (CollectionUtils.isNotEmpty((Collection)attrIdList)) {
                        for (Long attdId : attrIdList) {
                            String wmAttrId;
                            if (attdId == null || !org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)(wmAttrId = this.sysCrmWmFieldMappingService.findWmFieldByCrmField(Long.toString(attdId), CrmWmFieldMappingTypeEnum.MEMBER_LABEL_CODE.getCode())))) continue;
                            newAttrIdList.add(Long.valueOf(wmAttrId));
                        }
                    }
                    newParam.setAttrIdList(newAttrIdList);
                    tagList.add(newParam);
                }
                memberLabelAddReq.setTagList(tagList);
            }
            memberLabelAddReq.setWidList(widList);
            log.info("memberAddLabelBind , requet:{}", (Object)JSON.toJSONString((Object)memberLabelAddReq));
            String result = this.wmSystemHttpClientComponent.doPost("/apigw/weimob_cdp/v2.0/customer/tag/bind", JSON.toJSONString((Object)memberLabelAddReq));
            log.info("memberAddLabelBind , result:{}", (Object)JSON.toJSONString((Object)result));
            this.wmAPiComponent.saveApiRecord("MEMBR_BIND_LABEL_ADD", JSON.toJSONString((Object)memberLabelAddReq), result);
            WmResultVo resultVo = (WmResultVo)JSON.parseObject((String)result, WmResultVo.class);
            if (resultVo.getCode() != null && SUCCESS_CODE.equals(resultVo.getCode().getErrcode())) {
                resultData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                resultData.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
                return resultData;
            }
            resultData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            resultData.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
            return resultData;
        }
        catch (Exception e) {
            log.info("memberAddLabelBind , excepion :{}", (Object)e.getMessage());
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
            return resultData;
        }
    }

    @Override
    public Result<Object> memberRemoveLabelBind(MemberInfoModelParam memberInfoModelParam) {
        Result resultData = new Result();
        log.info("memberRemoveLabelBind, start:{}", (Object)JSON.toJSONString((Object)memberInfoModelParam));
        try {
            MemberLabelRemoveReq memberLabelRemoveReq = WmConverFactory.getMemberLabelRemoveReq(memberInfoModelParam);
            memberLabelRemoveReq.setVid(this.wmSystemFieldConfig.getVid());
            ArrayList<Long> widList = new ArrayList<Long>();
            widList.add(this.wmAPiComponent.getMemberWid(memberInfoModelParam.getPhone()));
            memberLabelRemoveReq.setWidList(widList);
            ArrayList<MemberLabelAddParam> tagList = new ArrayList<MemberLabelAddParam>();
            if (CollectionUtils.isNotEmpty((Collection)memberInfoModelParam.getTagList())) {
                for (MemberLabelAddParam memberLabelAddParam : memberInfoModelParam.getTagList()) {
                    if (memberLabelAddParam == null) continue;
                    MemberLabelAddParam newParam = new MemberLabelAddParam();
                    String wmId = this.sysCrmWmFieldMappingService.findWmFieldByCrmField(Long.toString(memberLabelAddParam.getTagId()), CrmWmFieldMappingTypeEnum.MEMBER_LABEL_GROUP_CODE.getCode());
                    if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)wmId)) continue;
                    newParam.setTagId(Long.valueOf(wmId));
                    ArrayList<Long> newAttrIdList = new ArrayList<Long>();
                    List attrIdList = memberLabelAddParam.getAttrIdList();
                    if (CollectionUtils.isNotEmpty((Collection)attrIdList)) {
                        for (Long attdId : attrIdList) {
                            String wmAttrId;
                            if (attdId == null || !org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)(wmAttrId = this.sysCrmWmFieldMappingService.findWmFieldByCrmField(Long.toString(attdId), CrmWmFieldMappingTypeEnum.MEMBER_LABEL_CODE.getCode())))) continue;
                            newAttrIdList.add(Long.valueOf(wmAttrId));
                        }
                    }
                    newParam.setAttrIdList(newAttrIdList);
                    tagList.add(newParam);
                }
                memberLabelRemoveReq.setTagList(tagList);
            }
            log.info("memberRemoveLabelBind , requet:{}", (Object)JSON.toJSONString((Object)memberLabelRemoveReq));
            String result = this.wmSystemHttpClientComponent.doPost("/apigw/weimob_cdp/v2.0/customer/tag/unbind", JSON.toJSONString((Object)memberLabelRemoveReq));
            log.info("memberRemoveLabelBind , result:{}", (Object)JSON.toJSONString((Object)result));
            this.wmAPiComponent.saveApiRecord("MEMBR_UNBIND_LABEL", Long.toString(memberInfoModelParam.getMbrMemberId()), JSON.toJSONString((Object)memberLabelRemoveReq), result);
            WmResultVo resultVo = (WmResultVo)JSON.parseObject((String)result, WmResultVo.class);
            if (resultVo.getCode() != null && SUCCESS_CODE.equals(resultVo.getCode().getErrcode())) {
                resultData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                resultData.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
                return resultData;
            }
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
            return resultData;
        }
        catch (Exception e) {
            log.info("memberRemoveLabelBind , excepion :{}", (Object)e.getMessage());
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
            return resultData;
        }
    }

    @Override
    public Result<Object> memberOrderTowm(CrmMemberOrderParam crmMemberOrderParam) {
        Result resultData = new Result();
        log.info("memberOrderTowm, start:{}", (Object)JSON.toJSONString((Object)crmMemberOrderParam));
        try {
            MemberOrderReq memberOrderReq = new MemberOrderReq();
            MemberOrderInfoParam orderInfo = new MemberOrderInfoParam();
            ArrayList associateBizList = new ArrayList();
            HashMap<String, Integer> bizMap = new HashMap<String, Integer>();
            bizMap.put("bizValue", 600101);
            associateBizList.add(bizMap);
            orderInfo.setAssociateBizList(associateBizList);
            orderInfo.setOrderBaseInfo(WmConverFactory.getOrderBaseInfo(crmMemberOrderParam));
            if (crmMemberOrderParam.getMemberInfoModel() != null) {
                MemberOrderUserInfoParam buyerInfo = WmConverFactory.getBuyInfoObj(crmMemberOrderParam.getMemberInfoModel());
                buyerInfo.setWid(this.wmAPiComponent.getMemberWid(crmMemberOrderParam.getMemberInfoModel().getPhone()));
                orderInfo.setBuyerInfo(buyerInfo);
            }
            if (crmMemberOrderParam.getSysStorePo() != null) {
                SysStorePo sysStorePo = crmMemberOrderParam.getSysStorePo();
                MemberOrderSellerInfoParam sellerInfo = new MemberOrderSellerInfoParam();
                sellerInfo.setVid(this.wmAPiComponent.getStoreVid(sysStorePo.getSysStoreOnlineCode()));
                sellerInfo.setVidName(sysStorePo.getStoreName());
                orderInfo.setSellerInfo(sellerInfo);
            }
            if (crmMemberOrderParam.getSysStaffVo() != null) {
                MemberOrderGuiderParam memberOrderGuiderParam = WmConverFactory.getMemberOrderGuiderParam(crmMemberOrderParam.getSysStaffVo());
                Long guider = this.wmAPiComponent.checkGuiderWid(crmMemberOrderParam.getSysStaffVo().getPhone());
                if (guider != null) {
                    memberOrderGuiderParam.setGuiderWid(guider);
                    orderInfo.setGuiderInfo(memberOrderGuiderParam);
                }
            }
            orderInfo.setPaymentInfo(WmConverFactory.getMemberOrderPayInfoParam(crmMemberOrderParam));
            ArrayList<MemberOrderItemParam> orderItemInfoList = new ArrayList<MemberOrderItemParam>();
            if (CollectionUtils.isNotEmpty((Collection)crmMemberOrderParam.getOrderDetailModels())) {
                List orderDetailModels = crmMemberOrderParam.getOrderDetailModels();
                for (OrderDetailModel orderDetailModel : orderDetailModels) {
                    if (orderDetailModel == null || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)orderDetailModel.getProductItemId()) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)orderDetailModel.getProductNo())) continue;
                    MemberOrderItemParam memberOrderItemParam = new MemberOrderItemParam();
                    memberOrderItemParam.setItemId(orderDetailModel.getMbrOrderDetailId());
                    memberOrderItemParam.setNum(orderDetailModel.getQuantity());
                    MemberOrderPayInfoParam paymentInfo = new MemberOrderPayInfoParam();
                    paymentInfo.setPaymentAmount(orderDetailModel.getTradeAmountDetail());
                    paymentInfo.setTotalAmount(orderDetailModel.getTagPrice());
                    paymentInfo.setShouldPaymentAmount(orderDetailModel.getTagPrice());
                    memberOrderItemParam.setPaymentInfo(paymentInfo);
                    MemberOrderItemInfoParam memberOrderItemInfoParam = WmConverFactory.getMemberOrderItemInfoParam(orderDetailModel);
                    String goodsId = this.sysCrmWmFieldMappingService.findWmFieldByCrmField(orderDetailModel.getProductNo(), CrmWmFieldMappingTypeEnum.GOODS_CODE.getCode());
                    if (org.apache.commons.lang3.StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{goodsId})) {
                        memberOrderItemInfoParam.setGoodsId(Long.valueOf(goodsId));
                    }
                    memberOrderItemParam.setGoodsInfoDto(memberOrderItemInfoParam);
                    orderItemInfoList.add(memberOrderItemParam);
                }
            }
            orderInfo.setOrderItemInfoList(orderItemInfoList);
            MemberOrderDeliveryParam memberOrderDeliveryParam = new MemberOrderDeliveryParam();
            memberOrderDeliveryParam.setDeliveryType(Integer.valueOf(5));
            orderInfo.setDeliveryInfo(memberOrderDeliveryParam);
            memberOrderReq.setOrderInfo(orderInfo);
            memberOrderReq.setOperatorWid(Long.valueOf(0L));
            memberOrderReq.setOperatorName("crm");
            log.info("memberOrderTowm , requet:{}", (Object)JSON.toJSONString((Object)memberOrderReq));
            String result = this.wmSystemHttpClientComponent.doPost("/apigw/weimob_crm/v2.0/order/import", JSON.toJSONString((Object)memberOrderReq));
            log.info("memberOrderTowm , result:{}", (Object)JSON.toJSONString((Object)result));
            this.wmAPiComponent.saveApiRecord("MEMBR_ORDER", crmMemberOrderParam.getOrderNo(), JSON.toJSONString((Object)memberOrderReq), result);
            WmResultVo resultVo = (WmResultVo)JSON.parseObject((String)result, WmResultVo.class);
            if (resultVo.getCode() != null && SUCCESS_CODE.equals(resultVo.getCode().getErrcode())) {
                JSONObject resultJSON = resultVo.getData();
                if (resultJSON != null && resultJSON.containsKey((Object)"outputInfo")) {
                    JSONObject orderResultJson = resultJSON.getJSONObject("outputInfo");
                    SysCrmWmFieldMappingPO sysCrmWmFieldMappingPO = new SysCrmWmFieldMappingPO();
                    sysCrmWmFieldMappingPO.setWmField(orderResultJson.getString("orderNo"));
                    sysCrmWmFieldMappingPO.setCrmField(crmMemberOrderParam.getOrderNo());
                    sysCrmWmFieldMappingPO.setMappingType(CrmWmFieldMappingTypeEnum.MEMBER_ORDER.getCode());
                    this.sysCrmWmFieldMappingService.insertSysCrmWmFieldMapping(sysCrmWmFieldMappingPO);
                }
                resultData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                resultData.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
                return resultData;
            }
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
            return resultData;
        }
        catch (Exception e) {
            log.info("memberOrderTowm , excepion :{}", (Object)e.getMessage());
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
            return resultData;
        }
    }

    @Override
    public Result<Object> memberOrderUpdateBiz(CrmMemberOrderUpdateParam crmMemberOrderUpdateParam) {
        Result resultData = new Result();
        log.info("memberOrderUpdateBiz, start:{}", (Object)JSON.toJSONString((Object)crmMemberOrderUpdateParam));
        try {
            MemberOrderUpdateReq memberOrderUpdateReq = new MemberOrderUpdateReq();
            MemberOrderBaseInfoParam orderBaseInfo = new MemberOrderBaseInfoParam();
            orderBaseInfo.setOutOrderNo(crmMemberOrderUpdateParam.getOrderNo());
            orderBaseInfo.setChannelType(Integer.valueOf(7));
            orderBaseInfo.setPlatformType(Integer.valueOf(2));
            memberOrderUpdateReq.setOrderBaseInfo(orderBaseInfo);
            ArrayList associateBizList = new ArrayList();
            HashMap<String, Integer> bizMap = new HashMap<String, Integer>();
            bizMap.put("bizValue", 600101);
            associateBizList.add(bizMap);
            memberOrderUpdateReq.setAssociateBizList(associateBizList);
            log.info("memberOrderUpdateBiz , requet:{}", (Object)JSON.toJSONString((Object)memberOrderUpdateReq));
            String result = this.wmSystemHttpClientComponent.doPost("/apigw/weimob_crm/v2.0/order/update", JSON.toJSONString((Object)memberOrderUpdateReq));
            log.info("memberOrderUpdateBiz , result:{}", (Object)JSON.toJSONString((Object)result));
            this.wmAPiComponent.saveApiRecord("MEMBR_ORDER_UPDATE", crmMemberOrderUpdateParam.getOrderNo(), JSON.toJSONString((Object)memberOrderUpdateReq), result);
            resultData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            resultData.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
            return resultData;
        }
        catch (Exception e) {
            log.info("memberOrderUpdateBiz , excepion :{}", (Object)e.getMessage());
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
            return resultData;
        }
    }

    @Override
    public Result<Object> memberOrderCancelTowm(CrmMemberOrderParam crmMemberOrderParam) {
        Result resultData = new Result();
        log.info("memberOrderCancelTowm, start:{}", (Object)JSON.toJSONString((Object)crmMemberOrderParam));
        try {
            MemberOrderCancelReq memberOrderCancelReq = new MemberOrderCancelReq();
            MerchantInfoParam merchantInfo = new MerchantInfoParam();
            merchantInfo.setVid(this.wmAPiComponent.getStoreVid(crmMemberOrderParam.getStoreOnlineCode()));
            memberOrderCancelReq.setMerchantInfo(merchantInfo);
            if (crmMemberOrderParam.getMemberInfoModel() != null) {
                MemberInfoModel memberInfoModel = crmMemberOrderParam.getMemberInfoModel();
                MemberOrderUserInfoParam buyerInfo = WmConverFactory.getBuyInfoObj(crmMemberOrderParam.getMemberInfoModel());
                buyerInfo.setWid(this.wmAPiComponent.getMemberWid(memberInfoModel.getPhone()));
                memberOrderCancelReq.setBuyerInfo(buyerInfo);
            }
            memberOrderCancelReq.setRightsOrder(WmConverFactory.getRightsOrderParam(crmMemberOrderParam));
            RefundAccountParam refundAccountParam = new RefundAccountParam();
            refundAccountParam.setRefundMethodId(Integer.valueOf(1));
            memberOrderCancelReq.setRefundAccount(refundAccountParam);
            if (crmMemberOrderParam.getPayMoney() != null) {
                RefundDetailParam refundDetail = new RefundDetailParam();
                refundDetail.setApplyAmount(crmMemberOrderParam.getPayMoney().intValue() < 0 ? crmMemberOrderParam.getPayMoney().negate() : crmMemberOrderParam.getPayMoney());
                refundDetail.setRefundAmount(crmMemberOrderParam.getPayMoney().intValue() < 0 ? crmMemberOrderParam.getPayMoney().negate() : crmMemberOrderParam.getPayMoney());
                memberOrderCancelReq.setRefundDetail(refundDetail);
            }
            ArrayList<RightsItemsParam> rightsItems = new ArrayList<RightsItemsParam>();
            if (CollectionUtils.isNotEmpty((Collection)crmMemberOrderParam.getOrderDetailModels())) {
                List orderDetailModels = crmMemberOrderParam.getOrderDetailModels();
                for (OrderDetailModel orderDetailModel : orderDetailModels) {
                    String goodsId;
                    if (orderDetailModel == null || orderDetailModel.getMbrOrderDetailId() == null) continue;
                    RightsItemsParam rightsItemsParam = WmConverFactory.getRightsItemsParam(orderDetailModel, crmMemberOrderParam);
                    if (crmMemberOrderParam.getSysStaffVo() != null) {
                        Long guiderWid = this.wmAPiComponent.checkGuiderWid(crmMemberOrderParam.getSysStaffVo().getPhone());
                        if (guiderWid != null) {
                            rightsItemsParam.setGuiderWid(guiderWid);
                        }
                        rightsItemsParam.setGuiderPhone(crmMemberOrderParam.getSysStaffVo().getPhone());
                        rightsItemsParam.setGuiderName(crmMemberOrderParam.getSysStaffVo().getStaffCode());
                        rightsItemsParam.setOutGuiderNo(crmMemberOrderParam.getSysStaffVo().getStaffCode());
                    }
                    if (org.apache.commons.lang3.StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{goodsId = this.sysCrmWmFieldMappingService.findWmFieldByCrmField(orderDetailModel.getProductItemId(), CrmWmFieldMappingTypeEnum.GOODS_CODE.getCode())})) {
                        rightsItemsParam.setGoodsId(Long.valueOf(goodsId));
                    }
                    rightsItems.add(rightsItemsParam);
                }
            }
            memberOrderCancelReq.setRightsItems(rightsItems);
            memberOrderCancelReq.setOriginOrder(WmConverFactory.getOriginOrderParam(crmMemberOrderParam));
            ArrayList associateBizList = new ArrayList();
            HashMap<String, Integer> bizMap = new HashMap<String, Integer>();
            bizMap.put("bizValue", 600101);
            associateBizList.add(bizMap);
            memberOrderCancelReq.setAssociateBizList(associateBizList);
            log.info("memberOrderCancelTowm , requet:{}", (Object)JSON.toJSONString((Object)memberOrderCancelReq));
            String result = this.wmSystemHttpClientComponent.doPost("/apigw/weimob_crm/v2.0/rights/import", JSON.toJSONString((Object)memberOrderCancelReq));
            log.info("memberOrderCancelTowm , result:{}", (Object)JSON.toJSONString((Object)result));
            this.wmAPiComponent.saveApiRecord("MEMBR_CANCEL_ORDER", crmMemberOrderParam.getOrderNo(), JSON.toJSONString((Object)memberOrderCancelReq), result);
            WmResultVo resultVo = (WmResultVo)JSON.parseObject((String)result, WmResultVo.class);
            if (resultVo.getCode() != null && SUCCESS_CODE.equals(resultVo.getCode().getErrcode())) {
                JSONObject resultJSON = resultVo.getData();
                if (resultJSON != null && resultJSON.containsKey((Object)"rightsOrderNo")) {
                    SysCrmWmFieldMappingPO sysCrmWmFieldMappingPO = new SysCrmWmFieldMappingPO();
                    sysCrmWmFieldMappingPO.setWmField(resultJSON.getString("rightsOrderNo"));
                    sysCrmWmFieldMappingPO.setCrmField(crmMemberOrderParam.getOrderNo());
                    sysCrmWmFieldMappingPO.setMappingType(CrmWmFieldMappingTypeEnum.MEMBER_ORDER.getCode());
                    this.sysCrmWmFieldMappingService.insertSysCrmWmFieldMapping(sysCrmWmFieldMappingPO);
                }
                resultData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                resultData.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
                return resultData;
            }
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
            return resultData;
        }
        catch (Exception e) {
            log.info("memberOrderCancelTowm , excepion :{}", (Object)e.getMessage());
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
            return resultData;
        }
    }

    @Override
    public Result<Object> couponDefineTowm(CouponDefinitionParam param) {
        Result resultData = new Result();
        log.info("couponDefineTowm,param:{}", (Object)JSON.toJSONString((Object)param));
        try {
            this.packingCouponDefinitionParam(param);
            Result checkResult = this.checkCouponDefineTowm(param);
            log.info("checkCouponDefineTowm, checkResult:{}", (Object)JSON.toJSONString((Object)checkResult));
            if (checkResult.getCode().intValue() != SysResponseEnum.SUCCESS.getCode()) {
                log.info("couponDefineTowm,check error! param:{}", (Object)JSON.toJSONString((Object)param));
                resultData.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
                return resultData;
            }
            CouponTemplateReq couponTemplateReq = WmConverFactory.caseToCouponTemplateReq(param);
            log.info("couponDefineTowm,couponTemplateReq:{}", (Object)JSON.toJSONString((Object)couponTemplateReq));
            String templateResultStr = this.wmSystemHttpClientComponent.doPost("/apigw/weimob_crm/v2.0/coupon/template/basic/create", JSON.toJSONString((Object)couponTemplateReq));
            log.info("couponDefineTowm,templateResultStr:{}", (Object)templateResultStr);
            this.wmAPiComponent.saveApiRecord("COUPON_BASIC_DEFINE", JSON.toJSONString((Object)couponTemplateReq), templateResultStr);
            WmResultVo resultVo = (WmResultVo)JSON.parseObject((String)templateResultStr, WmResultVo.class);
            Long basicTemplateId = null;
            if (resultVo != null && SUCCESS_CODE.equals(resultVo.getCode().getErrcode())) {
                basicTemplateId = resultVo.getData().getLong("basicCouponTemplateId");
                param.setBasicCouponTemplateIdList(Arrays.asList(basicTemplateId));
                CouponCreateReq couponCreateReq = WmConverFactory.caseToCouponCreateReq(param);
                log.info("couponDefineTowm,couponCreateReq:{}", (Object)JSON.toJSONString((Object)couponCreateReq));
                String couponResultStr = this.wmSystemHttpClientComponent.doPost("/apigw/weimob_crm/v2.0/coupon/template/create", JSON.toJSONString((Object)couponCreateReq));
                log.info("couponDefineTowm,couponResultStr:{}", (Object)couponResultStr);
                this.wmAPiComponent.saveApiRecord("COUPON_DEFINE", JSON.toJSONString((Object)couponCreateReq), couponResultStr);
                WmResultVo couponResultVo = (WmResultVo)JSON.parseObject((String)couponResultStr, WmResultVo.class);
                if (resultVo != null && SUCCESS_CODE.equals(couponResultVo.getCode().getErrcode())) {
                    resultData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                    resultData.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
                    JSONArray couponTemplateIds = couponResultVo.getData().getJSONArray("couponTemplateIds");
                    String couponTemplateId = couponTemplateIds.get(0).toString();
                    this.addCouponDefinitionMapping(param.getCouponDefinitionCode(), couponTemplateId);
                    return resultData;
                }
            }
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
        }
        catch (Exception e) {
            log.info("couponDefineTowm error:{}", (Object)e.getMessage());
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
        }
        return resultData;
    }

    private void asyncCouponDefinitionToWmErrorForRecord(Long couponDefinitionId) {
        log.info("asyncCouponDefinitionToWmErrorForRecord,couponDefinitionId:{}", (Object)couponDefinitionId);
        if (couponDefinitionId == null) {
            log.info("asyncCouponDefinitionToWmErrorForRecord,couponDefinitionId is NULL,error");
            return;
        }
        ResponseData responseData = this.couponDefinitionServiceFeign.addCouponDefinitionToWmErrorForRecode(couponDefinitionId);
        log.info("asyncCouponDefinitionToWmErrorForRecord,responseData\uff1a{}", (Object)JSON.toJSONString((Object)responseData));
    }

    private void asyncCouponEntityToWmErrorForRecord(String couponCode) {
        log.info("asyncCouponDefinitionToWmErrorForRecord,asyncCouponEntityToWmErrorForRecord,couponCode:{}", (Object)couponCode);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)couponCode)) {
            log.info("asyncCouponDefinitionToWmErrorForRecord, couponCode is NULL error");
            return;
        }
        ResponseData responseData = this.couponEntityServiceFeign.addCouponEntityToWmErrorForRecode(couponCode);
        log.info("asyncCouponDefinitionToWmErrorForRecord,responseData\uff1a{}", (Object)JSON.toJSONString((Object)responseData));
    }

    private Result checkCouponDefineTowm(CouponDefinitionParam param) {
        log.info("checkCouponDefineTowm,param:{}", (Object)JSON.toJSONString((Object)param));
        Result result = new Result();
        result.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
        if (param.getApplianceStoreType() != 1 && CollectionUtils.isEmpty((Collection)param.getWmStoreIdList())) {
            result.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
            result.setMessage("\u9002\u7528\u95e8\u5e97\u627e\u4e0d\u5230\u6620\u5c04");
            return result;
        }
        if (param.getApplianceCommodityType() == 2 && CollectionUtils.isEmpty((Collection)param.getGoodsIdList())) {
            result.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
            result.setMessage("\u9002\u7528\u5546\u54c1\u627e\u4e0d\u5230\u6620\u5c04");
            return result;
        }
        return result;
    }

    @Override
    public Result<Object> syncWmCreateGoodsMsg(WmSyncGoodsCreateParam param) {
        Result result = new Result();
        result.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
        log.info("syncWmCreateGoodsMsg, param:{}", (Object)JSON.toJSONString((Object)param));
        String goodsId = JSON.parseObject((String)param.getMsgBody()).getString("goodsId");
        try {
            WmGoodsBaseInfoParam wmGoodsBaseInfoParam = WmConverFactory.getWmGoodsBaseInfoParam(goodsId, this.wmSystemFieldConfig.getVid());
            log.info("syncWmCreateGoodsMsg, url:{}, param:{}", (Object)"/apigw/weimob_shop/v2.0/goods/getListById", (Object)JSON.toJSONString((Object)wmGoodsBaseInfoParam));
            String resultStr = this.wmSystemHttpClientComponent.doPost("/apigw/weimob_shop/v2.0/goods/getListById", JSON.toJSONString((Object)wmGoodsBaseInfoParam));
            log.info("syncWmCreateGoodsMsg , resultStr:{}", (Object)JSON.toJSONString((Object)resultStr));
            this.wmAPiComponent.saveApiRecord("SYNC_GOODS", goodsId, JSON.toJSONString((Object)wmGoodsBaseInfoParam), resultStr);
            WmResultArrayVo goodsResult = (WmResultArrayVo)JSON.parseObject((String)resultStr, WmResultArrayVo.class);
            String outerGoodsCode = "";
            if (null != goodsResult && SUCCESS_CODE.equals(goodsResult.getCode().getErrcode())) {
                JSONArray goodsResultData = goodsResult.getData();
                JSONObject jsonObject = goodsResultData.getJSONObject(0);
                outerGoodsCode = jsonObject.getString("outerGoodsCode");
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)outerGoodsCode)) {
                result.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
                SysCrmWmFieldMappingPO sysCrmWmFieldMappingPO = this.sysCrmWmFieldMappingService.initSysCrmWmFieldMappingPO(goodsId, outerGoodsCode, CrmWmFieldMappingTypeEnum.GOODS_CODE.getCode());
                this.sysCrmWmFieldMappingService.insertSysCrmWmFieldMapping(sysCrmWmFieldMappingPO);
            }
        }
        catch (Exception e) {
            result.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
            result.setMessage(e.getMessage());
        }
        return result;
    }

    @Override
    public Result<Object> memberBindChannel(List<MemberBindChannelParam> params) {
        Result resultData = new Result();
        resultData.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
        log.info("SysWeimengServiceImpl#memberBindChannel,params:{}", (Object)JSON.toJSONString(params));
        for (MemberBindChannelParam param : params) {
            if (!this.buildMemberBindChannelParam(param)) {
                log.info("SysWeimengServiceImpl#memberBindChannel continue");
                continue;
            }
            try {
                log.info("memberBindChannel,param:{}", (Object)JSON.toJSONString((Object)param));
                String couponBindResult = this.wmSystemHttpClientComponent.doPost("/apigw/bos/v2.0/user/channel/bind", JSON.toJSONString((Object)param));
                log.info("memberBindChannel,result:{}", (Object)couponBindResult);
                this.wmAPiComponent.saveApiRecord("MEMBER_BIND_CHANNEL", JSON.toJSONString((Object)param), couponBindResult);
            }
            catch (Exception e) {
                log.info("SysWeimengServiceImpl#memberBindChannel,error:{}", (Object)e.getMessage());
            }
        }
        return resultData;
    }

    private boolean buildMemberBindChannelParam(MemberBindChannelParam param) {
        if (param == null || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)param.getPhone()) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)param.getAppId()) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)param.getOriginalId()) || null == param.getSource()) {
            log.info("SysWeimengServiceImpl#buildMemberBindChannelParam,param is null");
            return false;
        }
        Long wid = this.findWeimengWidByPhone(param.getPhone());
        if (wid == null) {
            log.info("SysWeimengServiceImpl#buildMemberBindChannelParam,phone:{} wid is null", (Object)param.getPhone());
            return false;
        }
        param.setWid(wid);
        return true;
    }

    private void packingCouponDefinitionParam(CouponDefinitionParam param) {
        Long belongVid = this.wmSystemFieldConfig.getVid();
        log.info("packingCouponDefinitionParam,getVid:{}", (Object)belongVid);
        param.setBelongVid(belongVid);
        if (param.getApplianceStoreType() != 1) {
            if (param.getApplianceStoreType() == 2) {
                param.setWmStoreIdList(this.buildStoreId(param.getStoreWhitelist()));
            } else {
                param.setWmStoreIdList(this.buildRegionId(param.getStoreWhitelist()));
            }
        }
        if (param.getApplianceCommodityType() == 2) {
            this.cleanGoodsProductCodeFrefix(param);
            param.setGoodsIdList(this.buildGoodsIds(param.getCommodityWhitelist()));
        }
    }

    private void cleanGoodsProductCodeFrefix(CouponDefinitionParam vo) {
        log.info("cleanGoodsProductCodeFrefix, param vo:{}", (Object)JSON.toJSONString((Object)vo));
        ArrayList<String> codeList = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)vo.getCommodityWhitelist())) {
            List<String> productCodes = Arrays.asList(vo.getCommodityWhitelist().split(","));
            for (String productCode : productCodes) {
                codeList.add(this.cleanFrefix(productCode));
            }
        }
        if (CollectionUtils.isNotEmpty(codeList)) {
            String whiteList = StringUtils.join(codeList, (String)",");
            vo.setCommodityWhitelist(whiteList);
        }
        log.info("cleanGoodsProductCodeFrefix, result vo:{}", (Object)JSON.toJSONString((Object)vo));
    }

    private String cleanFrefix(String productCode) {
        String VG_FREFIX = "VG-CLUB_";
        String TN_FREFIX = "TN-CLUB_";
        String TT_FREFIX = "TT-CLUB_";
        String TZ_FREFIX = "TZ-CLUB_";
        String YJ_FREFIX = "YJ-CLUB_";
        if (productCode.startsWith(VG_FREFIX) || productCode.startsWith(TN_FREFIX) || productCode.startsWith(TT_FREFIX) || productCode.startsWith(TZ_FREFIX) || productCode.startsWith(YJ_FREFIX)) {
            return productCode.substring(8, productCode.length());
        }
        return "";
    }

    private List<Long> buildGoodsIds(String commodityWhitelist) {
        String[] split;
        log.info("buildGoodsIds, commodityWhitelist:{}", (Object)commodityWhitelist);
        ArrayList<Long> goodsIds = new ArrayList<Long>();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)commodityWhitelist)) {
            return goodsIds;
        }
        for (String goodsCode : split = commodityWhitelist.split(",")) {
            String goodsId = this.wmAPiComponent.getGoodsId(goodsCode);
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)goodsId)) continue;
            goodsIds.add(Long.valueOf(goodsId));
        }
        log.info("buildGoodsIds, result:{}", (Object)JSON.toJSONString(goodsIds));
        return goodsIds;
    }

    private List<Long> buildStoreId(String storeCodeStr) {
        ArrayList<Long> storeIds = new ArrayList<Long>();
        String[] split = storeCodeStr.split(",");
        if (split.length <= 0) {
            return storeIds;
        }
        for (String storeCode : split) {
            Long storeId = null;
            try {
                storeId = this.wmAPiComponent.getStoreVid(storeCode);
                if (null == storeId) continue;
                storeIds.add(storeId);
            }
            catch (Exception e) {
                log.info("getStoreVid error,e:{}", (Object)e.getMessage());
            }
        }
        return storeIds;
    }

    private List<Long> buildRegionId(String storeCodeStr) {
        ArrayList<Long> regionIds = new ArrayList<Long>();
        String[] split = storeCodeStr.split(",");
        if (split.length <= 0) {
            return regionIds;
        }
        for (String regionCode : split) {
            Long regionId = null;
            try {
                regionId = this.wmAPiComponent.getRegionVid(regionCode);
                if (null == regionId) continue;
                regionIds.add(regionId);
            }
            catch (Exception e) {
                log.info("buildRegionId error,e:{}", (Object)e.getMessage());
            }
        }
        return regionIds;
    }

    private void addCouponDefinitionMapping(String crmField, String wmField) {
        log.info("addCouponDefinitionMapping, crmField:{}, wmField:{}", (Object)crmField, (Object)wmField);
        SysCrmWmFieldMappingPO sysCrmWmFieldMappingPO = this.sysCrmWmFieldMappingService.initSysCrmWmFieldMappingPO(wmField, crmField, CrmWmFieldMappingTypeEnum.COUPON_CODE.getCode());
        this.sysCrmWmFieldMappingService.insertSysCrmWmFieldMapping(sysCrmWmFieldMappingPO);
    }

    @Override
    public Result<Object> unuseCouponTowm(CouponCancelParam param) {
        Result resultData = new Result();
        resultData.setMessage(SysResponseEnum.FAILED.getMessage());
        resultData.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
        log.info("unuseCouponTowm,param:{}", (Object)JSON.toJSONString((Object)param));
        this.packingCouponCancelParam(param);
        try {
            CouponCancelReq couponCancelReq = WmConverFactory.caseToCouponCancelReq(param);
            log.info("unuseCouponTowm,couponCancelReq:{}", (Object)JSON.toJSONString((Object)couponCancelReq));
            String couponCancelResult = this.wmSystemHttpClientComponent.doPost("/apigw/weimob_crm/v2.0/coupon/cancel", JSON.toJSONString((Object)couponCancelReq));
            log.info("unuseCouponTowm,couponCancelResult:{}", (Object)couponCancelResult);
            this.wmAPiComponent.saveApiRecord("COUPON_CANCEL", JSON.toJSONString((Object)couponCancelReq), couponCancelResult);
            WmResultVo resultVo = (WmResultVo)JSON.parseObject((String)couponCancelResult, WmResultVo.class);
            if (resultVo != null && SUCCESS_CODE.equals(resultVo.getCode().getErrcode()) && resultVo.getData().getBoolean("result").booleanValue()) {
                resultData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                resultData.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
            }
        }
        catch (Exception e) {
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
        }
        log.info("unuseCouponTowm, resultData:{}", (Object)JSON.toJSONString((Object)resultData));
        return resultData;
    }

    private void packingCouponCancelParam(CouponCancelParam param) {
        int vidType = 1;
        Long vid = this.wmSystemFieldConfig.getVid();
        Long wid = this.findWeimengWidBySysMemberCode(param.getMemberCode());
        param.setWid(wid);
        param.setVid(vid);
        param.setType(Integer.valueOf(vidType));
        param.getOperateCoupons().forEach(coupon -> coupon.setCouponTemplateId(this.sysCrmWmFieldMappingService.findWmFieldByCrmField(coupon.getCouponDefinitionCode(), CrmWmFieldMappingTypeEnum.COUPON_CODE.getCode(), Long.class)));
    }

    @Override
    public Result<Object> useCouponEntityTowm(CouponUseParam param) {
        Result resultData = new Result();
        log.info("useCouponEntityTowm,param:{}", (Object)JSON.toJSONString((Object)param));
        if (IS_OPEN.equals(this.isOpen)) {
            log.info("IS_OPEN:{}, close!", (Object)this.isOpen);
            resultData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            resultData.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
            return resultData;
        }
        resultData.setMessage(SysResponseEnum.FAILED.getMessage());
        resultData.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
        this.packingCouponUseParam(param);
        if (param.getWid() == null) {
            log.info("useCouponEntityTowm wid is not found!");
            resultData.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
            return resultData;
        }
        try {
            CouponConsumeReq couponConsumeReq = WmConverFactory.caseToCouponConsumeReq(param);
            log.info("useCouponEntityTowm,couponConsumeReq:{}", (Object)JSON.toJSONString((Object)couponConsumeReq));
            String couponConsumeResult = this.wmSystemHttpClientComponent.doPost("/apigw/weimob_crm/v2.0/coupon/consume", JSON.toJSONString((Object)couponConsumeReq));
            log.info("useCouponEntityTowm,couponConsumeResult:{}", (Object)couponConsumeResult);
            this.wmAPiComponent.saveApiRecord("COUPON_CONSUMER", JSON.toJSONString((Object)couponConsumeReq), couponConsumeResult);
            WmResultVo resultVo = (WmResultVo)JSON.parseObject((String)couponConsumeResult, WmResultVo.class);
            if (resultVo != null && SUCCESS_CODE.equals(resultVo.getCode().getErrcode()) && resultVo.getData().getBoolean("result").booleanValue()) {
                resultData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                resultData.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
            }
        }
        catch (Exception e) {
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
        }
        log.info("useCouponEntityTowm,resultData:{}", (Object)JSON.toJSONString((Object)resultData));
        return resultData;
    }

    private void packingCouponUseParam(CouponUseParam param) {
        Long wid = this.findWeimengWidBySysMemberCode(param.getMemberCode());
        Long vid = this.wmSystemFieldConfig.getVid();
        param.setWid(wid);
        param.setVid(vid);
        param.getOperateCoupons().forEach(coupon -> {
            Long wmCounponDefinitionId = this.sysCrmWmFieldMappingService.findWmFieldByCrmField(coupon.getCouponDefinitionCode(), CrmWmFieldMappingTypeEnum.COUPON_CODE.getCode(), Long.class);
            coupon.setCouponTemplateId(wmCounponDefinitionId);
        });
    }

    @Override
    public Result<Object> couponBindMember(CouponBindMemberParam param) {
        Result resultData = new Result();
        log.info("couponBindMember,param:{}", (Object)JSON.toJSONString((Object)param));
        if (IS_OPEN.equals(this.isOpen)) {
            log.info("IS_OPEN:{}, close!", (Object)this.isOpen);
            resultData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            resultData.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
            return resultData;
        }
        this.packingCouponBindMemberParam(param);
        if (param.getWid() == null) {
            log.info("useCouponEntityTowm wid is not found!");
            resultData.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
            return resultData;
        }
        try {
            CouponBandMemberReq couponBandMemberReq = WmConverFactory.caseToCouponBindingMemberReq(param);
            log.info("couponBindMember,couponBandMemberReq:{}", (Object)JSON.toJSONString((Object)couponBandMemberReq));
            String couponBindResult = this.wmSystemHttpClientComponent.doPost("/apigw/weimob_crm/v2.0/coupon/customer/sync", JSON.toJSONString((Object)couponBandMemberReq));
            log.info("couponBindMember,couponBindResult:{}", (Object)couponBindResult);
            this.wmAPiComponent.saveApiRecord("COUPON_BINDING_MEMBER", JSON.toJSONString((Object)couponBandMemberReq), couponBindResult);
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
            WmResultVo resultVo = (WmResultVo)JSON.parseObject((String)couponBindResult, WmResultVo.class);
            if (resultVo != null && SUCCESS_CODE.equals(resultVo.getCode().getErrcode()) && resultVo.getData().getBoolean("result").booleanValue()) {
                resultData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                resultData.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
            }
        }
        catch (Exception e) {
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
        }
        log.info("couponBindMember, resultData:{}", (Object)JSON.toJSONString((Object)resultData));
        if (resultData.getCode().intValue() != SysResponseEnum.SUCCESS.getCode()) {
            // empty if block
        }
        return resultData;
    }

    private void packingCouponBindMemberParam(CouponBindMemberParam param) {
        Long wid = this.findWeimengWidBySysMemberCode(param.getMemberCode());
        Long couponTemplateId = this.sysCrmWmFieldMappingService.findWmFieldByCrmField(param.getCouponDefinitionCode(), CrmWmFieldMappingTypeEnum.COUPON_CODE.getCode(), Long.class);
        param.setVid(this.wmSystemFieldConfig.getVid());
        param.setWid(wid);
        param.setCouponTemplateId(couponTemplateId);
    }
}

