/*
 * Decompiled with CFR 0.152.
 */
package com.daas.nros.connector.server.service.impl.weimob;

import com.alibaba.fastjson.JSON;
import com.daas.nros.connector.client.model.po.SysCrmWmFieldMappingPO;
import com.daas.nros.connector.client.model.po.SysCrmWmFieldMappingPOExample;
import com.daas.nros.connector.server.mapper.SysCrmWmFieldMappingPOMapper;
import com.daas.nros.connector.server.service.api.weimob.SysCrmWmFieldMappingService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thymeleaf.util.StringUtils;

@Service
public class SysCrmWmFieldMappingServiceImpl
implements SysCrmWmFieldMappingService {
    private static final Logger log = LoggerFactory.getLogger(SysCrmWmFieldMappingServiceImpl.class);
    @Resource
    private SysCrmWmFieldMappingPOMapper sysCrmWmFieldMappingPOMapper;

    @Override
    public Boolean insertSysCrmWmFieldMapping(SysCrmWmFieldMappingPO entity) {
        log.info("insertSysCrmWmFieldMapping,entity:{}", (Object)JSON.toJSONString((Object)entity));
        if (!this.checkInsertSysCrmWmFieldMapping(entity)) {
            log.info("insertSysCrmWmFieldMapping entity is null, error");
            return false;
        }
        String oldFidld = this.findWmFieldByCrmField(entity.getCrmField(), entity.getMappingType());
        if (!StringUtils.isEmpty((String)oldFidld)) {
            log.info("insertSysCrmWmFieldMapping entity is exist, error");
            return false;
        }
        entity.setValid(Boolean.TRUE);
        this.sysCrmWmFieldMappingPOMapper.insertSelective(entity);
        return Boolean.TRUE;
    }

    @Override
    public SysCrmWmFieldMappingPO initSysCrmWmFieldMappingPO(String wmField, String crmField, int mappingType) {
        SysCrmWmFieldMappingPO mapping = new SysCrmWmFieldMappingPO();
        mapping.setWmField(wmField);
        mapping.setCrmField(crmField);
        mapping.setMappingType(Integer.valueOf(mappingType));
        mapping.setValid(Boolean.TRUE);
        return mapping;
    }

    @Override
    public Boolean isExistByMappingType(int mappingType) {
        SysCrmWmFieldMappingPOExample example = new SysCrmWmFieldMappingPOExample();
        SysCrmWmFieldMappingPOExample.Criteria criteria = example.createCriteria();
        criteria.andMappingTypeEqualTo(Integer.valueOf(mappingType)).andValidEqualTo(Boolean.TRUE);
        List<SysCrmWmFieldMappingPO> sysCrmWmFieldMappingPOS = this.sysCrmWmFieldMappingPOMapper.selectByExample(example);
        return CollectionUtils.isNotEmpty(sysCrmWmFieldMappingPOS);
    }

    private boolean checkInsertSysCrmWmFieldMapping(SysCrmWmFieldMappingPO entity) {
        return entity != null && !StringUtils.isEmpty((String)entity.getCrmField()) && !StringUtils.isEmpty((String)entity.getWmField()) && null != entity.getMappingType();
    }

    @Override
    public String findWmFieldByCrmField(String crmField, int type) {
        return this.findWmFieldByCrmFieldForStr(crmField, type);
    }

    @Override
    public Long findWmFieldByCrmField(String crmField, int type, Class<Long> targetClass) {
        String wmField = this.findWmFieldByCrmFieldForStr(crmField, type);
        if (StringUtils.isEmpty((String)wmField)) {
            return null;
        }
        return Long.valueOf(wmField);
    }

    @Override
    public Long findWmFieldByCrmFieldForLong(String crmField, int type) {
        String wmField = this.findWmFieldByCrmFieldForStr(crmField, type);
        if (StringUtils.isEmpty((String)wmField)) {
            return null;
        }
        return Long.valueOf(wmField);
    }

    private String findWmFieldByCrmFieldForStr(String crmField, int type) {
        log.info("findWmFieldByCrmField,crmField:{}, type:{}, targetClass:{}", (Object)crmField, (Object)type);
        SysCrmWmFieldMappingPOExample example = new SysCrmWmFieldMappingPOExample();
        SysCrmWmFieldMappingPOExample.Criteria criteria = example.createCriteria();
        criteria.andCrmFieldEqualTo(crmField).andMappingTypeEqualTo(Integer.valueOf(type)).andValidEqualTo(Boolean.TRUE);
        List<SysCrmWmFieldMappingPO> sysCrmWmFieldMappingPOS = this.sysCrmWmFieldMappingPOMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(sysCrmWmFieldMappingPOS)) {
            log.info("findWmFieldByCrmField, not find wm field");
            return null;
        }
        SysCrmWmFieldMappingPO mappingPO = sysCrmWmFieldMappingPOS.get(0);
        log.info("findWmFieldByCrmField, mappingPO:{}", (Object)JSON.toJSONString((Object)mappingPO));
        String wmField = mappingPO.getWmField();
        log.info("findWmFieldByCrmField, result:{}", (Object)wmField);
        return wmField;
    }
}

