/*
 * Decompiled with CFR 0.152.
 */
package com.daas.nros.connector.server.service.impl.burgeon;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.bizvane.couponfacade.interfaces.CouponDefinitionServiceFeign;
import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.daas.nros.connector.client.api.base.CouponSingleService;
import com.daas.nros.connector.client.burgeon.model.vo.VgAddCouponCrmVO;
import com.daas.nros.connector.client.burgeon.model.vo.VgAddCouponDefinitionVo;
import com.daas.nros.connector.client.burgeon.model.vo.VgAddGiveCouponVo;
import com.daas.nros.connector.client.burgeon.model.vo.VgCancelCouponVo;
import com.daas.nros.connector.client.burgeon.model.vo.VgUseCouponVo;
import com.daas.nros.connector.client.enums.ConnectorResponseEnum;
import com.daas.nros.connector.client.enums.StringBrandCode;
import com.daas.nros.connector.client.model.po.MbrMembersPo;
import com.daas.nros.connector.client.model.result.Result;
import com.daas.nros.connector.client.util.HttpClientUtil;
import com.daas.nros.connector.client.util.RestUtils;
import com.daas.nros.connector.client.weimob.model.req.param.CouponBindMemberParam;
import com.daas.nros.connector.client.weimob.model.vo.VgAddCouponDefinitionRe;
import com.daas.nros.connector.client.weimob.model.vo.VgAddGiveCouponVoRe;
import com.daas.nros.connector.client.weimob.model.vo.VgCancelCouponVoRe;
import com.daas.nros.connector.client.weimob.model.vo.VgUseCouponVoRe;
import com.daas.nros.connector.client.weimob.rpc.WmConnectServiceFeign;
import com.daas.nros.connector.server.config.burgeon.IposConfig;
import com.daas.nros.connector.server.service.api.burgeon.VgCouponService;
import com.daas.nros.connector.server.service.api.weimob.SysWeimengService;
import com.daas.nros.connector.server.service.conver.DataConver;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="vgCoupon")
public class VgCouponServiceImpl
implements VgCouponService {
    private static Logger logger = LoggerFactory.getLogger((String)VgCouponServiceImpl.class.getName());
    @Autowired
    private CouponSingleService couponSingleService;
    @Autowired
    private VgCouponService vgCouponService;
    @Autowired
    private CouponDefinitionServiceFeign couponDefinitionServiceFeign;
    @Autowired
    private WmConnectServiceFeign wmConnectServiceFeign;
    @Autowired
    private SysWeimengService sysWeimengService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<JSONObject> sendCoupon(VgAddCouponCrmVO vgAddCouponCrmVO) {
        Result result = new Result();
        Byte coupStatus = 0;
        try {
            Map map = IposConfig.signToRequest("Burgeon.Bos.Coupon.AddCoupon");
            map.put("param", vgAddCouponCrmVO);
            String resultStr = null;
            String url = IposConfig.url + "/rest/coupon/addCoupon";
            String param = JSON.toJSONString((Object)map);
            logger.info("jh_third_interface sendCoupon param : {} , url :{}", (Object)param, (Object)url);
            resultStr = RestUtils.sendRequestBuff((String)url, (String)param, (String)"POST");
            JSONObject resultObject = JSON.parseObject((String)resultStr);
            if (resultObject.get((Object)"code").toString().equals("100")) {
                result.setCode(Integer.valueOf(ConnectorResponseEnum.SUCCESS.getCode()));
                result.setData((Object)resultObject);
                coupStatus = 1;
                logger.info("sendCoupon, couponBindingMemberToWm, vo:{}", (Object)JSON.toJSONString((Object)vgAddCouponCrmVO));
                Result<Object> wmResult = this.couponBindingMemberToWm(vgAddCouponCrmVO);
                logger.info("sendCoupon, couponBindingMemberToWm, result:{}", (Object)JSON.toJSONString(wmResult));
            } else {
                result.setCode(Integer.valueOf(ConnectorResponseEnum.FAILED.getCode()));
                result.setData((Object)resultObject);
            }
        }
        catch (Exception e) {
            logger.error("jh_third_interface sendCoupon error : {}", (Object)e.getMessage());
            result.setCode(Integer.valueOf(ConnectorResponseEnum.FAILED.getCode()));
            result.setMessage(e.getMessage());
        }
        finally {
            try {
                this.couponSingleService.callbackSingleCoupon(vgAddCouponCrmVO.getCoupNo(), coupStatus, vgAddCouponCrmVO.getIfSendAgain());
            }
            catch (Exception e) {
                logger.error("jh_third_interface sendCoupon \u72b6\u6001\u56de\u8c03\u5931\u8d25: {}", (Object)e.getMessage());
            }
        }
        return result;
    }

    @Override
    public Result<JSONObject> sendCouponBatch(JSONObject jsonObject) {
        Map map = IposConfig.signToRequest("Burgeon.Bos.Coupon.AddCoupon");
        map.put("param", jsonObject);
        Result result = new Result();
        String resultStr = null;
        try {
            String url = IposConfig.url + "/rest/coupon/addCoupon";
            logger.info("jh_third_interface sendCouponBatch url:" + url);
            resultStr = RestUtils.sendRequestBuff((String)url, (String)JSON.toJSONString((Object)map), (String)"POST");
            return DataConver.resultObj(result, resultStr);
        }
        catch (Exception e) {
            logger.error("jh_third_interface sendCouponBatch \u53d1\u6279\u91cf\u5238\u5931\u8d25 :" + e.getMessage());
            result.setCode(Integer.valueOf(ConnectorResponseEnum.FAILED.getCode()));
            result.setMessage(e.getMessage());
            return result;
        }
    }

    @Override
    public Result<JSONObject> addCouponGrp(JSONObject jsonObject, String tag) {
        Map map = IposConfig.signToRequest("Burgeon.Bos.Coupon.addCouponGrp");
        VgAddCouponDefinitionVo vgAddCouponDefinition = (VgAddCouponDefinitionVo)JSON.parseObject((String)JSON.toJSONString((Object)jsonObject), (TypeReference)new TypeReference<VgAddCouponDefinitionVo>(){}, (Feature[])new Feature[0]);
        VgAddCouponDefinitionRe vgAddCouponDefinitionRe = DataConver.mqCouponDeToCrmVo(vgAddCouponDefinition, tag);
        vgAddCouponDefinitionRe.setChangeType("A");
        map.put("param", vgAddCouponDefinitionRe);
        Result result = new Result();
        String resultStr = null;
        try {
            String url = IposConfig.url + "/rest/coupon/addCouponGrp";
            String param = JSON.toJSONString((Object)map);
            logger.info("jh_third_interface addCouponGrp---------param :{} ,url :{}", (Object)param, (Object)url);
            resultStr = HttpClientUtil.doPost((String)url, (String)param);
            return DataConver.resultObj(result, resultStr);
        }
        catch (Exception e) {
            logger.error("jh_third_interface addCouponGrp \u53d1\u5238\u89c4\u5219\u5931\u8d25 :{} ,data:{}", (Object)e.getMessage(), (Object)jsonObject);
            result.setCode(Integer.valueOf(ConnectorResponseEnum.FAILED.getCode()));
            result.setMessage(e.getMessage());
            return result;
        }
    }

    @Override
    public Result<JSONObject> invalidCouponGrp(JSONObject jsonObject, String tag) {
        Map map = IposConfig.signToRequest("Burgeon.Bos.Coupon.addCouponGrp");
        VgAddCouponDefinitionVo vgAddCouponDefinition = (VgAddCouponDefinitionVo)JSON.parseObject((String)JSON.toJSONString((Object)jsonObject), (TypeReference)new TypeReference<VgAddCouponDefinitionVo>(){}, (Feature[])new Feature[0]);
        VgAddCouponDefinitionRe vgAddCouponDefinitionRe = DataConver.mqCouponDeToCrmVo(vgAddCouponDefinition, tag);
        vgAddCouponDefinitionRe.setChangeType("D");
        map.put("param", vgAddCouponDefinitionRe);
        Result result = new Result();
        String resultStr = null;
        try {
            String url = IposConfig.url + "/rest/coupon/addCouponGrp";
            String param = JSON.toJSONString((Object)map);
            logger.info("jh_third_interface invalidCouponGrp---------param :{} ,url :{}", (Object)param, (Object)url);
            resultStr = RestUtils.sendRequestBuff((String)url, (String)param, (String)"POST");
            return DataConver.resultObj(result, resultStr);
        }
        catch (Exception e) {
            logger.error("jh_third_interface invalidCouponGrp \u4f5c\u5e9f\u53d1\u5238\u89c4\u5219\u5931\u8d25 :{} ,data:{}", (Object)e.getMessage(), (Object)jsonObject);
            result.setCode(Integer.valueOf(ConnectorResponseEnum.FAILED.getCode()));
            result.setMessage(e.getMessage());
            return result;
        }
    }

    @Override
    public Result<JSONObject> modifyCouponGrp(JSONObject jsonObject, String tag) {
        Map map = IposConfig.signToRequest("Burgeon.Bos.Coupon.addCouponGrp");
        VgAddCouponDefinitionVo vgAddCouponDefinition = (VgAddCouponDefinitionVo)JSON.parseObject((String)JSON.toJSONString((Object)jsonObject), (TypeReference)new TypeReference<VgAddCouponDefinitionVo>(){}, (Feature[])new Feature[0]);
        VgAddCouponDefinitionRe vgAddCouponDefinitionRe = DataConver.mqCouponDeToCrmVo(vgAddCouponDefinition, tag);
        vgAddCouponDefinitionRe.setChangeType("M");
        map.put("param", vgAddCouponDefinitionRe);
        Result result = new Result();
        String resultStr = null;
        try {
            String url = IposConfig.url + "/rest/coupon/addCouponGrp";
            String param = JSON.toJSONString((Object)map);
            logger.info("jh_third_interface modifyCouponGrp---------param :{} ,url :{}", (Object)param, (Object)url);
            resultStr = RestUtils.sendRequestBuff((String)url, (String)param, (String)"POST");
            return DataConver.resultObj(result, resultStr);
        }
        catch (Exception e) {
            logger.error("jh_third_interface modifyCouponGrp \u4fee\u6539\u53d1\u5238\u89c4\u5219\u5546\u54c1\u5931\u8d25 :{} ,data:{}", (Object)e.getMessage(), (Object)jsonObject);
            result.setCode(Integer.valueOf(ConnectorResponseEnum.FAILED.getCode()));
            result.setMessage(e.getMessage());
            return result;
        }
    }

    @Override
    public Result<JSONObject> giveCoupon(JSONObject jsonObject) {
        VgAddGiveCouponVo vgAddGiveCouponVo = (VgAddGiveCouponVo)JSON.parseObject((String)JSON.toJSONString((Object)jsonObject), (TypeReference)new TypeReference<VgAddGiveCouponVo>(){}, (Feature[])new Feature[0]);
        VgAddGiveCouponVoRe vgAddGiveCouponVoRe = DataConver.giveCouponToCrm(vgAddGiveCouponVo);
        Map map = IposConfig.signToRequest("Burgeon.Bos.Coupon.GiveCoupon");
        map.put("param", vgAddGiveCouponVoRe);
        Result result = new Result();
        String resultStr = null;
        try {
            String url = IposConfig.url + "/rest/coupon/giveCoupon";
            String param = JSON.toJSONString((Object)map);
            logger.info("jh_third_interface giveCoupon---------param :{} ,url :{}" + param, (Object)url);
            resultStr = RestUtils.sendRequestBuff((String)url, (String)param, (String)"POST");
            return DataConver.resultObj(result, resultStr);
        }
        catch (Exception e) {
            logger.error("jh_third_interface giveCoupon \u8f6c\u8d60\u5238\u5931\u8d25 :{} , data :{}", (Object)e.getMessage(), (Object)jsonObject);
            result.setCode(Integer.valueOf(ConnectorResponseEnum.FAILED.getCode()));
            result.setMessage(e.getMessage());
            return result;
        }
    }

    @Override
    public Result<JSONObject> cancelCouponBatch(JSONObject jsonObject, String club) {
        VgCancelCouponVo vgCancelCouponVo = (VgCancelCouponVo)JSON.parseObject((String)JSON.toJSONString((Object)jsonObject), (TypeReference)new TypeReference<VgCancelCouponVo>(){}, (Feature[])new Feature[0]);
        VgCancelCouponVoRe vgAddGiveCouponVoRe = DataConver.cancelCouponToCrm(vgCancelCouponVo, vgCancelCouponVo.getBrandCode());
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)vgAddGiveCouponVoRe);
        Map map = IposConfig.signToRequest("Burgeon.Bos.Coupon.CancelCouponBatch");
        map.put("param", jsonArray);
        Result result = new Result();
        String resultStr = null;
        try {
            String url = IposConfig.url + "/rest/coupon/cancelCouponBatch";
            String param = JSON.toJSONString((Object)map);
            logger.info("jh_third_interface cancelCouponBatch---------param :{}, url :{}", (Object)param, (Object)url);
            resultStr = RestUtils.sendRequestBuff((String)url, (String)param, (String)"POST");
            return DataConver.resultObj(result, resultStr);
        }
        catch (Exception e) {
            logger.error("jh_third_interface cancelCouponBatch \u5238\u4f5c\u5e9f\u5931\u8d25 :{} ,data :{}", (Object)e.getMessage(), (Object)jsonObject);
            result.setCode(Integer.valueOf(ConnectorResponseEnum.FAILED.getCode()));
            result.setMessage(e.getMessage());
            return result;
        }
    }

    @Override
    public Result<JSONObject> useCoupon(JSONObject jsonObject, String tag) {
        VgUseCouponVo vgUseCouponVo = (VgUseCouponVo)JSON.parseObject((String)JSON.toJSONString((Object)jsonObject), (TypeReference)new TypeReference<VgUseCouponVo>(){}, (Feature[])new Feature[0]);
        VgUseCouponVoRe vgUseCouponVoRe = DataConver.useCouponToCrm(vgUseCouponVo, vgUseCouponVo.getBrandCode());
        Map map = IposConfig.signToRequest("Burgeon.Bos.Coupon.UseCoupon");
        map.put("param", vgUseCouponVoRe);
        Result result = new Result();
        String resultStr = null;
        try {
            String url = IposConfig.url + "/rest/coupon/useCoupon";
            String param = JSON.toJSONString((Object)map);
            logger.info("jh_third_interface useCoupon---------param :{} ,url :{}", (Object)param, (Object)url);
            resultStr = RestUtils.sendRequestBuff((String)url, (String)param, (String)"POST");
            return DataConver.resultObj(result, resultStr);
        }
        catch (Exception e) {
            logger.error("toJSONString useCoupon \u5238\u6838\u9500\u5931\u8d25 :{}, data :{}", (Object)e.getMessage(), (Object)jsonObject);
            result.setCode(Integer.valueOf(ConnectorResponseEnum.FAILED.getCode()));
            result.setMessage(e.getMessage());
            return result;
        }
    }

    private Result<Object> couponBindingMemberToWm(VgAddCouponCrmVO vo) throws ParseException {
        Result<Object> result = new Result<Object>();
        result.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
        logger.info("couponBindingMemberToWm,vo:{}", (Object)JSON.toJSONString((Object)vo));
        if (!this.checkCouponBindingMemberToWm(vo)) {
            result.setMessage("\u53c2\u6570\u4e0d\u5b8c\u6574");
            result.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
            return result;
        }
        CouponDefinitionPO definition = this.findCouponDefinitionByCouponCode(vo.getCoupNo());
        if (!StringBrandCode.vg.getValue().equals(vo.getBrandCode()) && !this.isExist(definition, StringBrandCode.vg.getValue())) {
            logger.info("couponBindingMemberToWm, \u5f53\u524d\u54c1\u724c\u4e0d\u662fVG,\u6240\u4ee5\u4e0d\u540c\u6b65\u5230\u5fae\u76df");
            result.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
            return result;
        }
        MbrMembersPo member = this.sysWeimengService.findMbrMemberBy(vo.getCardNo(), 3, vo.getBrandCode());
        if (member == null) {
            logger.info("couponBindingMemberToWm,member is null");
            result.setMessage("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u4f1a\u5458");
            return result;
        }
        String couponDefinitionCode = this.findCouponDefinitionCodeByCouponCode(vo.getCoupNo());
        if (StringUtils.isBlank((CharSequence)couponDefinitionCode)) {
            logger.info("couponBindingMemberToWm,couponDefinitionCode is null");
            result.setMessage("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5238\u6a21\u677f");
            return result;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        CouponBindMemberParam param = new CouponBindMemberParam();
        Long acquireTime = sdf.parse(vo.getUpdateTime()).getTime();
        Long startDate = sdf.parse(vo.getDateBegin()).getTime();
        Long endDate = sdf.parse(vo.getDateEnd()).getTime();
        param.setAcquireTime(acquireTime);
        param.setExpireStartTime(startDate);
        param.setExpireEndTime(endDate);
        param.setCouponCode(vo.getCoupNo());
        param.setMemberCode(member.getMemberCode());
        param.setCouponDefinitionCode(couponDefinitionCode);
        logger.info("couponBindingMemberToWm, couponBindMember, param:{}", (Object)JSON.toJSONString((Object)param));
        result = this.sysWeimengService.couponBindMember(param);
        logger.info("couponBindingMemberToWm, couponBindMember, result:{}", (Object)JSON.toJSONString(result));
        return result;
    }

    private boolean isExist(CouponDefinitionPO definition, String brandCode) {
        if (definition == null) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)definition.getApplicableBrandCodes())) {
            return false;
        }
        return definition.getApplicableBrandCodes().contains(brandCode);
    }

    public CouponDefinitionPO findCouponDefinitionPOByCouponDefId(Long couponDefId) {
        logger.info("findCouponDefinitionPOByCouponDefId, couponDefId:{}", (Object)couponDefId);
        ResponseData responseData = this.couponDefinitionServiceFeign.findCouponDefinitionPOByCouponDefId(couponDefId);
        logger.info("findCouponDefinitionPOByCouponDefId, responseData:{}", (Object)JSON.toJSONString((Object)responseData));
        if (responseData.getCode() == SysResponseEnum.SUCCESS.getCode()) {
            return (CouponDefinitionPO)responseData.getData();
        }
        return null;
    }

    public String findCouponDefinitionCodeByCouponCode(String couponCode) {
        logger.info("findCouponDefinitionCodeByCouponCode, couponCode:{}", (Object)couponCode);
        ResponseData responseData = this.couponDefinitionServiceFeign.findCouponDefinitionCodeByCouponCode(couponCode);
        logger.info("findCouponDefinitionCodeByCouponCode, responseData:{}", (Object)JSON.toJSONString((Object)responseData));
        if (responseData.getCode() == SysResponseEnum.SUCCESS.getCode()) {
            return (String)responseData.getData();
        }
        return null;
    }

    public CouponDefinitionPO findCouponDefinitionByCouponCode(String couponCode) {
        logger.info("findCouponDefinitionByCouponCode, couponCode:{}", (Object)couponCode);
        ResponseData responseData = this.couponDefinitionServiceFeign.findCouponDefinitionByCouponCode(couponCode);
        logger.info("findCouponDefinitionByCouponCode, responseData:{}", (Object)JSON.toJSONString((Object)responseData));
        if (responseData.getCode() == SysResponseEnum.SUCCESS.getCode()) {
            return (CouponDefinitionPO)responseData.getData();
        }
        return null;
    }

    private boolean checkCouponBindingMemberToWm(VgAddCouponCrmVO vo) {
        return Boolean.TRUE;
    }
}

