/*
 * Decompiled with CFR 0.152.
 */
package com.daas.nros.connector.server.service.impl.burgeon;

import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.daas.nros.connector.client.weimob.model.vo.VGSerialNumberVo;
import com.daas.nros.connector.server.mapper.VGSerialNumberMapper;
import com.daas.nros.connector.server.service.api.burgeon.VGSerialNumberRecordService;
import com.daas.nros.connector.server.service.api.burgeon.VGSerialNumberService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class VGSerialNumberServiceImpl
implements VGSerialNumberService {
    private static final Logger log = LoggerFactory.getLogger(VGSerialNumberServiceImpl.class);
    private final String VG_OPENCARD_SERIAL_NUMBER_CONSTANTS = "VG_CARD_";
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Resource
    private VGSerialNumberMapper vgSerialNumberMapper;
    @Autowired
    private VGSerialNumberRecordService vgSerialNumberRecordService;

    @Override
    public String getRedisNo(String prefix) {
        String yyHHmm = this.vgSerialNumberMapper.getDate();
        if (StringUtils.isEmpty((Object)yyHHmm) || yyHHmm.length() != 6) {
            throw new RuntimeException("\u83b7\u53d6db\u65f6\u95f4\u5931\u8d25!");
        }
        String redisKey = "VG_CARD_" + yyHHmm;
        Long currentSerialNumber = this.redisTemplateService.incr(redisKey, -1184567296L) + 1L;
        log.info("\u5f53\u524d\u751f\u6210redis\u6d41\u6c34\u53f7\u4e3a:{}", (Object)currentSerialNumber);
        String thisCardNo = prefix + yyHHmm + String.format("%06d", currentSerialNumber);
        return thisCardNo;
    }

    @Override
    public String getRedisNoAndSaveSerialNumberRecord(VGSerialNumberVo vgSerialNumberVo) {
        String prefix = vgSerialNumberVo.getPrefix();
        String redisNo = this.getRedisNo(prefix);
        int rows = this.vgSerialNumberRecordService.insertRecord(vgSerialNumberVo, redisNo);
        return redisNo;
    }
}

