/*
 * Decompiled with CFR 0.152.
 */
package com.daas.nros.connector.server.service.impl.burgeon;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.daas.nros.connector.client.api.ConnectConfigService;
import com.daas.nros.connector.client.model.po.ConnectConfig;
import com.daas.nros.connector.client.model.po.MbrLevelDefPo;
import com.daas.nros.connector.client.model.po.MbrMembersPo;
import com.daas.nros.connector.client.model.po.MbrMembersPoExample;
import com.daas.nros.connector.client.model.po.SysBrandPo;
import com.daas.nros.connector.client.model.po.SysBrandPoExample;
import com.daas.nros.connector.client.model.result.Result;
import com.daas.nros.connector.client.model.vo.MemberInfoQueryRequestVO;
import com.daas.nros.connector.client.model.vo.MemberInfoQueryResponseVO;
import com.daas.nros.connector.client.model.vo.MemberInfoUpdateRequestVO;
import com.daas.nros.connector.client.model.vo.MemberModifyGradeRequestVO;
import com.daas.nros.connector.client.model.vo.MemberOpenCardRequestVO;
import com.daas.nros.connector.client.model.vo.MemberOpenCardResponseVO;
import com.daas.nros.connector.client.model.vo.MemberPhoneUpdateRequestVO;
import com.daas.nros.connector.client.util.DateUtil;
import com.daas.nros.connector.client.util.RestUtils;
import com.daas.nros.connector.client.weimob.model.vo.OfflineMemberLevelRequestVo;
import com.daas.nros.connector.client.weimob.model.vo.OfflineMemberRequestVo;
import com.daas.nros.connector.server.config.burgeon.CrmJointVConfig;
import com.daas.nros.connector.server.config.burgeon.IposConfig;
import com.daas.nros.connector.server.mapper.MbrLevelDefPoMapper;
import com.daas.nros.connector.server.mapper.MbrMembersPoMapper;
import com.daas.nros.connector.server.mapper.SysBrandPoMapper;
import com.daas.nros.connector.server.service.api.burgeon.MemberService;
import com.daas.nros.connector.server.service.impl.burgeon.BasicServiceImpl;
import com.daas.nros.connector.server.service.impl.burgeon.JHMallServiceComponent;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="member")
public class JHMemberServiceImpl
extends BasicServiceImpl
implements MemberService {
    private static Logger logger = LoggerFactory.getLogger((String)JHMemberServiceImpl.class.getName());
    @Autowired
    private ConnectConfigService connectConfigService;
    @Autowired
    private JHMallServiceComponent jhMallServiceComponent;
    @Resource
    private MbrMembersPoMapper mbrMembersPoMapper;
    @Resource
    private SysBrandPoMapper sysBrandPoMapper;
    @Resource
    private MbrLevelDefPoMapper mbrLevelDefPoMapper;

    @Override
    public Result<MemberOpenCardResponseVO> loginandopencard(MemberOpenCardRequestVO requestVO) {
        Result returnResult = new Result();
        MemberOpenCardResponseVO memberOpenCardResponseVO = new MemberOpenCardResponseVO();
        try {
            String offlineBrandCode = requestVO.getOfflineBrandCode();
            Long brandId = requestVO.getBrandId();
            ConnectConfig connectConfig = this.connectConfigService.queryByOnlineBrandId(brandId);
            if (connectConfig == null || StringUtils.isBlank((CharSequence)connectConfig.getOfflineBrandCode())) {
                logger.error("jh_third_interface loginAndOpenCard getBrandCode error : {}", (Object)JSONObject.toJSONString((Object)requestVO));
                returnResult.setCode(Integer.valueOf(SysResponseEnum.MODEL_FAILED_VALIDATION.getCode()));
                returnResult.setMessage("\u83b7\u53d6brandCode\u5931\u8d25...");
                returnResult.setData((Object)memberOpenCardResponseVO);
                return returnResult;
            }
            offlineBrandCode = connectConfig.getOfflineBrandCode();
            requestVO.setOfflineBrandCode(offlineBrandCode);
            memberOpenCardResponseVO.setOfflineCardNo(requestVO.getCardNo());
            memberOpenCardResponseVO.setErpId(requestVO.getCardNo());
            memberOpenCardResponseVO.setBrandId(brandId);
            memberOpenCardResponseVO.setSessionTokenId(requestVO.getSessionTokenId());
            memberOpenCardResponseVO.setOfflineBrandCode(offlineBrandCode);
            if (this.isJHBrandRequest(offlineBrandCode)) {
                return this.getMemberOpenCardResponseVOResultMall(requestVO, (Result<MemberOpenCardResponseVO>)returnResult, memberOpenCardResponseVO);
            }
            if (StringUtils.isBlank((CharSequence)requestVO.getCardNo())) {
                logger.error("jh_third_interface loginAndOpenCard cardNo empty : {}", (Object)JSONObject.toJSONString((Object)requestVO));
                returnResult.setCode(Integer.valueOf(SysResponseEnum.MODEL_FAILED_VALIDATION.getCode()));
                returnResult.setMessage("\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                return returnResult;
            }
            if (JHMemberServiceImpl.checkBrandCodeIsTWUnder(requestVO.getOfflineBrandCode())) {
                logger.info("jh_third_interface loginAndOpenCard \u4f1a\u5458\u65b0\u589e\uff0c\u53ea\u9700\u8981\u65b0\u589eTW\u7684\uff0c\u4e0d\u9700\u8981\u540c\u6b65TT-TN-TZ\u7684 : {}", (Object)JSONObject.toJSONString((Object)requestVO));
                returnResult.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
                returnResult.setMessage("\u4f1a\u5458\u65b0\u589e\uff0c\u53ea\u9700\u8981\u65b0\u589eTW\u7684\uff0c\u4e0d\u9700\u8981\u540c\u6b65TT-TN-TZ\u7684");
                returnResult.setData((Object)memberOpenCardResponseVO);
                memberOpenCardResponseVO.setType(Integer.valueOf(3));
                return returnResult;
            }
            if (this.isMallBrandRequest(offlineBrandCode)) {
                try {
                    Result<MemberOpenCardResponseVO> loginandopencard = this.jhMallServiceComponent.loginandopencard(requestVO, memberOpenCardResponseVO);
                    logger.info("jh_third_interface loginAndOpenCard mall\u4f1a\u5458\u65b0\u589e: {}", (Object)JSONObject.toJSONString(loginandopencard));
                    if (loginandopencard.getCode().equals(SysResponseEnum.SUCCESS.getCode())) {
                        return loginandopencard;
                    }
                }
                catch (Exception e) {
                    logger.info("jhMallServiceComponent.loginandopencard error:{}", (Throwable)e);
                }
                return this.getMemberOpenCardResponseVOResultMall(requestVO, (Result<MemberOpenCardResponseVO>)returnResult, memberOpenCardResponseVO);
            }
            Map map = IposConfig.signToRequest("Burgeon.Bos.Vip.VipAdd");
            if (MapUtils.isEmpty((Map)map)) {
                logger.error("jh_third_interface loginAndOpenCard sign error : {}", (Object)JSONObject.toJSONString((Object)map));
                returnResult.setCode(Integer.valueOf(SysResponseEnum.MODEL_FAILED_VALIDATION.getCode()));
                returnResult.setMessage(SysResponseEnum.MODEL_FAILED_VALIDATION.getMessage());
                return returnResult;
            }
            OfflineMemberRequestVo offlineMemberRequestVo = OfflineMemberRequestVo.builder().brandCode(requestVO.getOfflineBrandCode()).cardNo(requestVO.getCardNo()).levelCode(requestVO.getLevelCode()).storeCode(requestVO.getOpenStoreCode()).guideCode(requestVO.getOpenGuideCode()).serviceStoreCode(requestVO.getServiceStoreCode()).serviceGuideCode(requestVO.getServiceGuideCode()).openCardTime(DateUtil.transformDateToStandard((String)requestVO.getOpenCardTime())).validDate(this.transformDateToInt(requestVO.getEffectiveTime())).name(requestVO.getName()).mobile(requestVO.getPhone()).sex(this.transformSex(requestVO.getGender())).birthday(this.transformDateToInt(requestVO.getBirthday())).valid("Y").build();
            map.put("param", JSON.toJSON((Object)offlineMemberRequestVo));
            String mapParams = JSONObject.toJSONString((Object)map);
            logger.info("jh_third_interface vipAdd start mapParams : {}", (Object)mapParams);
            String httpResult = RestUtils.sendRequestBuff((String)(IposConfig.url + "/rest/vip/vipAdd"), (String)mapParams, (String)"POST");
            logger.info("jh_third_interface vipAdd end httpResult : {}", (Object)httpResult);
            JSONObject jsonObjectHttpResult = JSON.parseObject((String)httpResult);
            Integer returnCode = Integer.valueOf(jsonObjectHttpResult.getOrDefault((Object)"code", (Object)SysResponseEnum.FAILED.getCode()).toString());
            returnResult.setCode(Integer.valueOf(returnCode == 100 ? SysResponseEnum.SUCCESS.getCode() : returnCode.intValue()));
            returnResult.setMessage(jsonObjectHttpResult.getOrDefault((Object)"message", (Object)SysResponseEnum.FAILED.getMessage()).toString());
            if (returnCode == 100) {
                if (jsonObjectHttpResult.getJSONObject("data") != null && jsonObjectHttpResult.getJSONObject("data").getOrDefault((Object)"subCode", (Object)"").equals("110")) {
                    memberOpenCardResponseVO.setType(Integer.valueOf(1));
                } else {
                    memberOpenCardResponseVO.setType(Integer.valueOf(2));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("jh_third_interface vipAdd error : {}", (Object)e.getMessage());
            returnResult.setCode(Integer.valueOf(SysResponseEnum.SYSTEM_ERROR.getCode()));
            returnResult.setMessage(e.getMessage());
        }
        returnResult.setData((Object)memberOpenCardResponseVO);
        logger.info("jh_third_interface loginAndOpenCard \u8fd4\u56de\u7ed3\u679c : {}", (Object)JSONObject.toJSONString((Object)returnResult));
        return returnResult;
    }

    private Result<MemberOpenCardResponseVO> getMemberOpenCardResponseVOResultMall(MemberOpenCardRequestVO requestVO, Result<MemberOpenCardResponseVO> returnResult, MemberOpenCardResponseVO memberOpenCardResponseVO) {
        logger.info("jh_third_interface loginAndOpenCard \u96c6\u56e2\u5361\u4e0d\u9700\u8981\u540c\u6b65\u7ebf\u4e0b\u548cMall : {}", (Object)JSONObject.toJSONString((Object)requestVO));
        returnResult.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
        returnResult.setMessage("\u96c6\u56e2\u5361\u7684\u4f1a\u5458\u65b0\u589e\u4e0d\u9700\u8981\u540c\u6b65\u7ebf\u4e0b\u548cMall");
        memberOpenCardResponseVO.setType(Integer.valueOf(3));
        returnResult.setData((Object)memberOpenCardResponseVO);
        return returnResult;
    }

    @Override
    public Result updateuserinfo(MemberInfoUpdateRequestVO requestVO, String logType) {
        Result returnResult = new Result();
        try {
            String offlineBrandCode = requestVO.getOfflineBrandCode();
            Long brandId = requestVO.getBrandId();
            ConnectConfig connectConfig = this.connectConfigService.queryByOnlineBrandId(brandId);
            if (connectConfig == null || StringUtils.isBlank((CharSequence)connectConfig.getOfflineBrandCode())) {
                logger.error("jh_third_interface vipModify getBrandCode type:{} , error : {}", (Object)logType, (Object)JSONObject.toJSONString((Object)requestVO));
                returnResult.setCode(Integer.valueOf(SysResponseEnum.MODEL_FAILED_VALIDATION.getCode()));
                returnResult.setMessage("\u83b7\u53d6brandCode\u5931\u8d25...");
                return returnResult;
            }
            offlineBrandCode = connectConfig.getOfflineBrandCode();
            requestVO.setOfflineBrandCode(offlineBrandCode);
            if (StringUtils.isBlank((CharSequence)requestVO.getOfflineCardNo())) {
                logger.error("jh_third_interface vipModify cardNo type:{} , empty : {}", (Object)logType, (Object)JSONObject.toJSONString((Object)requestVO));
                returnResult.setCode(Integer.valueOf(SysResponseEnum.MODEL_FAILED_VALIDATION.getCode()));
                returnResult.setMessage("\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                return returnResult;
            }
            if (this.isMallBrandRequest(requestVO.getOfflineBrandCode())) {
                logger.warn("jh_third_interface vipModify type:{} , \u96c6\u56e2\u5361\u4f1a\u5458\u4fe1\u606f\u4fee\u6539\u4e0d\u9700\u8981\u540c\u6b65\u7ebf\u4e0b\u548cMall : {}", (Object)logType, (Object)JSONObject.toJSONString((Object)requestVO));
                returnResult.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
                returnResult.setMessage("\u96c6\u56e2\u5361\u7684\u4f1a\u5458\u4fe1\u606f\u4fee\u6539\u4e0d\u9700\u8981\u540c\u6b65\u5230\u7ebf\u4e0b\u548cMall");
                return returnResult;
            }
            if (this.isJHBrandRequest(requestVO.getOfflineBrandCode())) {
                logger.info("jh_third_interface#vipModify#syncall");
                SysBrandPoExample sysBrandPoExample = new SysBrandPoExample();
                sysBrandPoExample.createCriteria().andValidEqualTo(Boolean.TRUE).andSysBrandIdEqualTo(brandId);
                List<SysBrandPo> sysBrandPos = this.sysBrandPoMapper.selectByExample(sysBrandPoExample);
                SysBrandPo sysBrandPo = sysBrandPos.get(0);
                SysBrandPoExample allBrandExample = new SysBrandPoExample();
                allBrandExample.createCriteria().andValidEqualTo(Boolean.TRUE).andSysCompanyIdEqualTo(sysBrandPo.getSysCompanyId()).andBrandCodeNotEqualTo("JH").andBrandCodeNotEqualTo("MALL-CLUB");
                List<SysBrandPo> allOfflineBrand = this.sysBrandPoMapper.selectByExample(allBrandExample);
                for (SysBrandPo offlineBrand : allOfflineBrand) {
                    MbrMembersPoExample mbrMembersPoExample = new MbrMembersPoExample();
                    mbrMembersPoExample.createCriteria().andValidEqualTo(Boolean.TRUE).andPhoneEqualTo(requestVO.getPhone()).andBrandIdEqualTo(Integer.valueOf(offlineBrand.getSysBrandId().intValue()));
                    List<MbrMembersPo> mbrMembersPos = this.mbrMembersPoMapper.selectByExample(mbrMembersPoExample);
                    MbrMembersPo mbrMembersPo = new MbrMembersPo();
                    String gender = "";
                    if (CollectionUtils.isEmpty(mbrMembersPos)) {
                        logger.info("jh_third_interface#\u6839\u636e\u54c1\u724cid\u548c\u624b\u673a\u53f7\u672a\u67e5\u8be2\u5230\u4f1a\u5458\u4fe1\u606f\uff01");
                    } else {
                        mbrMembersPo = mbrMembersPos.get(0);
                        if (mbrMembersPo != null) {
                            gender = mbrMembersPo.getGender() != null ? mbrMembersPo.getGender() : "";
                        } else {
                            logger.info("jh_third_interface#\u6839\u636e\u54c1\u724cid\u548c\u624b\u673a\u53f7\u672a\u67e5\u8be2\u5230\u4f1a\u5458\u4fe1\u606f,mbrMembersPo\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u6027\u522b\u672a\u77e5\uff01");
                        }
                    }
                    gender = gender.equals("1") || gender.equals(1) ? "0" : (gender.equals("2") || gender.equals(2) ? "1" : null);
                    logger.info("jh_third_interface#\u4f1a\u5458\u4fe1\u606f\u4fee\u6539\u63a5\u53e3#\u6839\u636e\u54c1\u724cid\u548c\u624b\u673a\u53f7\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f\u540e,gender\u8f6c\u6362\u540e\u4e3a:{}", (Object)gender);
                    MbrLevelDefPo mbrLevelDefPo = this.mbrLevelDefPoMapper.selectByPrimaryKey(mbrMembersPo.getLevelId());
                    MemberInfoUpdateRequestVO memberInfoUpdateRequestVO = new MemberInfoUpdateRequestVO();
                    memberInfoUpdateRequestVO.setOfflineBrandCode(offlineBrand.getBrandCode());
                    memberInfoUpdateRequestVO.setOfflineCardNo(mbrMembersPo.getOfflineCardNo());
                    memberInfoUpdateRequestVO.setLevelCode(mbrLevelDefPo.getOfflineLevelCode());
                    memberInfoUpdateRequestVO.setOpenStoreCode(mbrMembersPo.getOpenCardStoreCode());
                    memberInfoUpdateRequestVO.setOpenGuideCode(mbrMembersPo.getOpenCardGuideCode());
                    memberInfoUpdateRequestVO.setServiceStoreCode(mbrMembersPo.getServiceStoreCode());
                    memberInfoUpdateRequestVO.setServiceGuideCode(mbrMembersPo.getServiceGuideCode());
                    memberInfoUpdateRequestVO.setName(mbrMembersPo.getName());
                    memberInfoUpdateRequestVO.setPhone(mbrMembersPo.getPhone());
                    memberInfoUpdateRequestVO.setGender(gender);
                    memberInfoUpdateRequestVO.setBirthday(DateUtil.dateFormatDate((Date)mbrMembersPo.getBirthday()));
                    this.requestVipModify(memberInfoUpdateRequestVO, logType);
                }
                return returnResult;
            }
            MbrMembersPoExample mbrMembersPoExample = new MbrMembersPoExample();
            mbrMembersPoExample.createCriteria().andValidEqualTo(Boolean.TRUE).andPhoneEqualTo(requestVO.getPhone()).andBrandIdEqualTo(Integer.valueOf(requestVO.getBrandId().intValue()));
            List<MbrMembersPo> mbrMembersPos = this.mbrMembersPoMapper.selectByExample(mbrMembersPoExample);
            String gender = "";
            if (CollectionUtils.isEmpty(mbrMembersPos)) {
                logger.info("jh_third_interface#\u6839\u636e\u54c1\u724cid\u548c\u624b\u673a\u53f7\u672a\u67e5\u8be2\u5230\u4f1a\u5458\u4fe1\u606f");
            } else {
                MbrMembersPo mbrMembersPo = mbrMembersPos.get(0);
                if (mbrMembersPo != null) {
                    gender = mbrMembersPo.getGender() != null ? mbrMembersPo.getGender() : "";
                } else {
                    logger.info("jh_third_interface#\u6839\u636e\u54c1\u724cid\u548c\u624b\u673a\u53f7\u672a\u67e5\u8be2\u5230\u4f1a\u5458\u4fe1\u606f,mbrMembersPo\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u6027\u522b\u672a\u77e5");
                }
            }
            gender = gender.equals("1") || gender.equals(1) ? "0" : (gender.equals("2") || gender.equals(2) ? "1" : null);
            logger.info("jh_third_interface#\u4f1a\u5458\u4fe1\u606f\u4fee\u6539#\u6839\u636e\u54c1\u724cid\u548c\u624b\u673a\u53f7\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f\u540e,gender\u8f6c\u6362\u4e3a:{}", (Object)gender);
            requestVO.setGender(gender);
            return this.requestVipModify(requestVO, logType);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("jh_third_interface vipModify type:{} , error : {}", (Object)logType, (Object)e.getMessage());
            returnResult.setCode(Integer.valueOf(SysResponseEnum.SYSTEM_ERROR.getCode()));
            returnResult.setMessage(e.getMessage());
            return returnResult;
        }
    }

    private Result<String> requestVipModify(MemberInfoUpdateRequestVO requestVO, String logType) throws Exception {
        logger.info("jh_third_interface#requestVipModify#requestVO:{},logType:{}", (Object)JSON.toJSONString((Object)requestVO), (Object)logType);
        Result returnResult = new Result();
        Map map = IposConfig.signToRequest("Burgeon.Bos.Vip.VipModify");
        if (MapUtils.isEmpty((Map)map)) {
            logger.error("jh_third_interface vipModify sign type:{} , error : {}", (Object)logType, (Object)JSONObject.toJSONString((Object)map));
            returnResult.setCode(Integer.valueOf(SysResponseEnum.MODEL_FAILED_VALIDATION.getCode()));
            returnResult.setMessage(SysResponseEnum.MODEL_FAILED_VALIDATION.getMessage());
            return returnResult;
        }
        OfflineMemberRequestVo offlineMemberRequestVo = OfflineMemberRequestVo.builder().brandCode(requestVO.getOfflineBrandCode()).cardNo(requestVO.getOfflineCardNo()).levelCode(requestVO.getLevelCode()).storeCode(requestVO.getOpenStoreCode()).guideCode(requestVO.getOpenGuideCode()).serviceStoreCode(requestVO.getServiceStoreCode()).serviceGuideCode(requestVO.getServiceGuideCode()).openCardTime("").validDate(null).name(requestVO.getName()).mobile(requestVO.getPhone()).sex(this.transformSex(requestVO.getGender())).birthday(this.transformDateToInt(requestVO.getBirthday())).valid("Y").build();
        String sendToOfflineBrandCode = offlineMemberRequestVo.getBrandCode();
        map.put("param", JSON.toJSON((Object)offlineMemberRequestVo));
        String mapParams = JSONObject.toJSONString((Object)map);
        logger.info("jh_third_interface vipModify start type:{} , mapParams : {}, sendToOfflineBrandCode :{}", new Object[]{logType, mapParams, sendToOfflineBrandCode});
        String httpResult = RestUtils.sendRequestBuff((String)(IposConfig.url + "/rest/vip/vipModify"), (String)mapParams, (String)"POST");
        logger.info("jh_third_interface vipModify end type:{} , httpResult : {} ,sendToOfflineBrandCode :{}", new Object[]{logType, httpResult, sendToOfflineBrandCode});
        JSONObject jsonObjectHttpResult = JSON.parseObject((String)httpResult);
        Integer returnCode = Integer.valueOf(jsonObjectHttpResult.getOrDefault((Object)"code", (Object)SysResponseEnum.FAILED.getCode()).toString());
        returnResult.setCode(Integer.valueOf(returnCode == 100 ? SysResponseEnum.SUCCESS.getCode() : returnCode.intValue()));
        returnResult.setMessage(jsonObjectHttpResult.getOrDefault((Object)"message", (Object)SysResponseEnum.FAILED.getMessage()).toString());
        return returnResult;
    }

    @Override
    public Result modifymembergrade(MemberModifyGradeRequestVO requestVO) {
        Result returnResult = new Result();
        try {
            String offlineBrandCode = requestVO.getOfflineBrandCode();
            Long brandId = requestVO.getBrandId();
            ConnectConfig connectConfig = this.connectConfigService.queryByOnlineBrandId(brandId);
            if (connectConfig == null || StringUtils.isBlank((CharSequence)connectConfig.getOfflineBrandCode())) {
                logger.error("jh_third_interface levelChange getBrandCode error : {}", (Object)JSONObject.toJSONString((Object)requestVO));
                returnResult.setCode(Integer.valueOf(SysResponseEnum.MODEL_FAILED_VALIDATION.getCode()));
                returnResult.setMessage("\u83b7\u53d6brandCode\u5931\u8d25...");
                return returnResult;
            }
            offlineBrandCode = connectConfig.getOfflineBrandCode();
            requestVO.setOfflineBrandCode(offlineBrandCode);
            if (this.isJHBrandRequest(requestVO.getOfflineBrandCode()) || this.isMallBrandRequest(requestVO.getOfflineBrandCode())) {
                logger.info("jh_third_interface levelChange \u96c6\u56e2\u5361\u7b49\u7ea7\u53d8\u66f4\u4e0d\u9700\u8981\u540c\u6b65\u7ebf\u4e0b\u548cMall : {}", (Object)JSONObject.toJSONString((Object)requestVO));
                returnResult.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
                returnResult.setMessage("\u96c6\u56e2\u5361\u7684\u7b49\u7ea7\u53d8\u66f4\u4e0d\u9700\u8981\u540c\u6b65\u7ebf\u4e0b\u548cMall");
                return returnResult;
            }
            if (StringUtils.isBlank((CharSequence)requestVO.getOfflineCardNo())) {
                logger.error("jh_third_interface levelChange cardNo empty : {}", (Object)JSONObject.toJSONString((Object)requestVO));
                returnResult.setCode(Integer.valueOf(SysResponseEnum.MODEL_FAILED_VALIDATION.getCode()));
                returnResult.setMessage("\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                return returnResult;
            }
            Map map = IposConfig.signToRequest("Burgeon.Bos.Vip.LevelChange");
            if (MapUtils.isEmpty((Map)map)) {
                logger.error("jh_third_interface levelChange sign error : {}", (Object)JSONObject.toJSONString((Object)map));
                returnResult.setCode(Integer.valueOf(SysResponseEnum.MODEL_FAILED_VALIDATION.getCode()));
                returnResult.setMessage(SysResponseEnum.MODEL_FAILED_VALIDATION.getMessage());
                return returnResult;
            }
            if (JHMemberServiceImpl.checkBrandCodeIsTWUnder(requestVO.getOfflineBrandCode())) {
                logger.info("jh_third_interface levelChange \u4e0d\u9700\u8981\u53d1\u9001TW-CLUB\u4ee5\u5916\u7684\u5361\u7b49\u7ea7\u53d8\u66f4\u5230\u7ebf\u4e0bPOS : {}", (Object)JSONObject.toJSONString((Object)requestVO));
                returnResult.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
                returnResult.setMessage("\u4e0d\u9700\u8981\u53d1\u9001TW-CLUB\u4ee5\u5916\u7684\u5361\u7b49\u7ea7\u53d8\u66f4\u5230\u7ebf\u4e0bPOS");
                return returnResult;
            }
            OfflineMemberLevelRequestVo offlineMemberLevelRequestVo = OfflineMemberLevelRequestVo.builder().brandCode(requestVO.getOfflineBrandCode()).cardNo(requestVO.getOfflineCardNo()).levelCodeBegin(requestVO.getOldLevelCode()).levelCodeEnd(requestVO.getNewLevelCode()).changeTime(DateUtil.transformDateToStandard((String)requestVO.getModifiedTime())).build();
            map.put("param", JSON.toJSON((Object)offlineMemberLevelRequestVo));
            String mapParams = JSONObject.toJSONString((Object)map);
            logger.info("jh_third_interface levelChange start postData : {}", (Object)mapParams, (Object)mapParams);
            String httpResult = RestUtils.sendRequestBuff((String)(IposConfig.url + "/rest/vip/levelChange"), (String)mapParams, (String)"POST");
            logger.info("jh_third_interface levelChange end httpResult : {}", (Object)httpResult);
            JSONObject jsonObjectHttpResult = JSON.parseObject((String)httpResult);
            Integer returnCode = Integer.valueOf(jsonObjectHttpResult.getOrDefault((Object)"code", (Object)SysResponseEnum.FAILED.getCode()).toString());
            returnResult.setCode(Integer.valueOf(returnCode == 100 ? SysResponseEnum.SUCCESS.getCode() : returnCode.intValue()));
            returnResult.setMessage(jsonObjectHttpResult.getOrDefault((Object)"message", (Object)SysResponseEnum.FAILED.getMessage()).toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("jh_third_interface levelChange error : {}", (Object)e.getMessage());
            returnResult.setCode(Integer.valueOf(SysResponseEnum.SYSTEM_ERROR.getCode()));
            returnResult.setMessage(e.getMessage());
        }
        return returnResult;
    }

    @Override
    public Result<MemberInfoQueryResponseVO> querymemberinfo(MemberInfoQueryRequestVO requestVO) {
        Result returnResult = new Result();
        returnResult.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
        returnResult.setMessage(SysResponseEnum.SUCCESS.getMessage());
        MemberInfoQueryResponseVO memberInfoQueryResponseVO = new MemberInfoQueryResponseVO();
        return returnResult;
    }

    @Override
    public Result modifymemberphone(MemberPhoneUpdateRequestVO requestVO) {
        Result result = new Result();
        try {
            String cardNo;
            if (requestVO.getNewMobile().equals(requestVO.getOldMobile())) {
                result.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
                result.setMessage("\u4fee\u6539\u7684\u624b\u673a\u53f7\u524d\u540e\u4e0d\u80fd\u4e00\u81f4");
                return result;
            }
            String erpId = requestVO.getErpId();
            String string = cardNo = StringUtils.isBlank((CharSequence)requestVO.getCardNo()) ? erpId : requestVO.getCardNo();
            if (StringUtils.isBlank((CharSequence)cardNo)) {
                result.setCode(Integer.valueOf(SysResponseEnum.FAILED.getCode()));
                result.setMessage("cardNo\u548cerpId\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
                return result;
            }
            requestVO.setCardNo(cardNo);
            requestVO.setAppKey(CrmJointVConfig.appKey);
            requestVO.setAppSecret(CrmJointVConfig.appSecret);
            String req = JSONObject.toJSONString((Object)requestVO);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("Content-type", "application/json;charset=utf-8");
            logger.info("jh_third_interface modifymemberphone start req : {} url :{}", (Object)req, (Object)(CrmJointVConfig.urlPrefix + CrmJointVConfig.memberRights));
            result.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
            result.setMessage(SysResponseEnum.SUCCESS.getMessage());
            result.setData((Object)JSON.toJSONString((Object)requestVO));
        }
        catch (Exception e) {
            logger.error("crm_joint_interface snyMemberRights error : {}", (Object)e.getMessage());
            result.setCode(Integer.valueOf(SysResponseEnum.SYSTEM_ERROR.getCode()));
            result.setMessage("\u4fee\u6539\u624b\u673a\u53f7\u5931\u8d25 : " + e.getMessage());
        }
        return result;
    }
}

