/*
 * Decompiled with CFR 0.152.
 */
package com.daas.nros.connector.server.service.impl.burgeon;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.daas.nros.connector.client.model.result.Result;
import com.daas.nros.connector.client.model.vo.IntegralAdjustRequestVO;
import com.daas.nros.connector.client.model.vo.IntegralAdjustResponseVO;
import com.daas.nros.connector.client.util.DateUtil;
import com.daas.nros.connector.client.util.MD5Util;
import com.daas.nros.connector.client.util.RestUtils;
import com.daas.nros.connector.client.weimob.model.vo.OfflineIntegralRequestVo;
import com.daas.nros.connector.server.config.burgeon.IposConfig;
import com.daas.nros.connector.server.service.api.burgeon.IntegralRecordService;
import com.daas.nros.connector.server.service.impl.burgeon.BasicServiceImpl;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="integral")
public class JHIntegralRecordServiceImpl
extends BasicServiceImpl
implements IntegralRecordService {
    private static Logger logger = LoggerFactory.getLogger((String)JHIntegralRecordServiceImpl.class.getName());
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    private HashMap<Long, String> brandHashMap = new HashMap();

    @Override
    public Result<IntegralAdjustResponseVO> adjustintegral(IntegralAdjustRequestVO requestVO) {
        Result returnResult = new Result();
        try {
            Map map = IposConfig.signToRequest("Burgeon.Bos.Vip.IntegralChange");
            if (MapUtils.isEmpty((Map)map)) {
                logger.error("jh_third_interface integralChange sign error : {}", (Object)JSONObject.toJSONString((Object)map));
                returnResult.setCode(Integer.valueOf(SysResponseEnum.NULLPOINTEREXCEPTION.getCode()));
                returnResult.setMessage(SysResponseEnum.NULLPOINTEREXCEPTION.getMessage());
                return returnResult;
            }
            String brandCode = this.getCompanyBrandCodeByBrandId(requestVO.getBrandId());
            if (StringUtils.isBlank((CharSequence)brandCode)) {
                logger.error("jh_third_interface integralChange \u83b7\u53d6brandCode\u5f02\u5e38 : {}", (Object)JSONObject.toJSONString((Object)requestVO));
                returnResult.setCode(Integer.valueOf(SysResponseEnum.OPERATE_FAILED_DATA_NOT_EXISTS.getCode()));
                returnResult.setMessage("\u901a\u8fc7brandId\u67e5\u8be2brandCode\u5931\u8d25");
                return returnResult;
            }
            IntegralAdjustResponseVO defaultIntegralAdjustResponseVO = new IntegralAdjustResponseVO();
            defaultIntegralAdjustResponseVO.setOfflineBrandCode(brandCode);
            defaultIntegralAdjustResponseVO.setIntegralAdjustId(MD5Util.getMd5((String)requestVO.getSerialNumber()));
            defaultIntegralAdjustResponseVO.setChangeIntegral(requestVO.getChangeIntegral());
            defaultIntegralAdjustResponseVO.setDocNo(requestVO.getOrderBillNo());
            if (this.isJHBrandRequest(brandCode) && StringUtils.isBlank((CharSequence)requestVO.getFirstEnterClubCode())) {
                returnResult.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
                returnResult.setMessage("\u96c6\u56e2\u4ff1\u4e50\u90e8\u7684\u6d41\u6c34 && \u7b2c\u4e00\u6b21\u5165\u4f1a\u7684code\u4e3a\u7a7a\u4e0d\u9700\u8981\u540c\u6b65\u7ebf\u4e0b\u7684\u4e0d\u9700\u8981");
                returnResult.setData((Object)defaultIntegralAdjustResponseVO);
                logger.error("jh_third_interface integralChange \u4f1a\u5458\u672a\u5165\u4f1a\u4e14\u662f\u96c6\u56e2\u7684\u6d41\u6c34\u7684\u4e0d\u9700\u8981 requestVO : {} , result: {} ", (Object)JSONObject.toJSONString((Object)requestVO), (Object)JSONObject.toJSONString((Object)returnResult));
                return returnResult;
            }
            if (this.isMallBrandRequest(brandCode) && StringUtils.isBlank((CharSequence)requestVO.getFirstEnterClubCode())) {
                returnResult.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
                returnResult.setMessage("\u5546\u57ce\u4ff1\u4e50\u90e8\u7684\u6d41\u6c34 && \u7b2c\u4e00\u6b21\u5165\u4f1a\u7684code\u4e3a\u7a7a\u4e0d\u9700\u8981\u540c\u6b65\u7ebf\u4e0b\u7684\u4e0d\u9700\u8981");
                returnResult.setData((Object)defaultIntegralAdjustResponseVO);
                logger.error("jh_third_interface integralChange \u4f1a\u5458\u672a\u5165\u4f1a\u7ebf\u4e0b\u4ff1\u4e50\u90e8\u4e14\u662f\u5546\u57ce\u7684\u6d41\u6c34\u7684\u4e0d\u9700\u8981 requestVO : {} , result: {} ", (Object)JSONObject.toJSONString((Object)requestVO), (Object)JSONObject.toJSONString((Object)returnResult));
                return returnResult;
            }
            String storeCode = requestVO.getShopCode();
            if (StringUtils.isBlank((CharSequence)storeCode)) {
                storeCode = requestVO.getStoreCode();
            }
            OfflineIntegralRequestVo offlineIntegralRequestVo = OfflineIntegralRequestVo.builder().brandCode(brandCode).cardNo(requestVO.getOfflineCardNo()).serialNumber(requestVO.getSerialNumber()).integral(requestVO.getChangeIntegral()).changeTime(DateUtil.transformDateToStandard((String)requestVO.getAddTime())).orderNo(requestVO.getOrderBillNo()).source(StringUtils.isBlank((CharSequence)requestVO.getSource()) ? "6" : requestVO.getSource()).storeCode(storeCode).changeRemark(requestVO.getBusinessType()).build();
            String sendToOfflineBrandCode = offlineIntegralRequestVo.getBrandCode();
            map.put("param", JSON.toJSON((Object)offlineIntegralRequestVo));
            String mapParams = JSONObject.toJSONString((Object)map);
            logger.info("jh_third_interface integralChange start mapParams : {} , sendBrandCode :{}", (Object)mapParams, (Object)sendToOfflineBrandCode);
            String httpResult = RestUtils.sendRequestBuff((String)(IposConfig.url + "/rest/vip/integralChange"), (String)mapParams, (String)"POST");
            logger.info("jh_third_interface integralChange end httpResult : {} , sendBrandCode :{}", (Object)httpResult, (Object)sendToOfflineBrandCode);
            JSONObject jsonObjectHttpResult = JSON.parseObject((String)httpResult);
            Integer returnCode = Integer.valueOf(jsonObjectHttpResult.getOrDefault((Object)"code", (Object)SysResponseEnum.FAILED.getCode()).toString());
            returnResult.setCode(Integer.valueOf(returnCode == 100 ? SysResponseEnum.SUCCESS.getCode() : returnCode.intValue()));
            returnResult.setMessage(jsonObjectHttpResult.getOrDefault((Object)"message", (Object)SysResponseEnum.FAILED.getMessage()).toString());
            returnResult.setData((Object)defaultIntegralAdjustResponseVO);
        }
        catch (Exception e) {
            logger.error("jh_third_interface integralChange error : {}", (Object)e.getMessage());
            returnResult.setCode(Integer.valueOf(SysResponseEnum.SYSTEM_ERROR.getCode()));
            returnResult.setMessage(e.getMessage());
        }
        logger.info("jh_third_interface integralChange returnResult : {}", (Object)JSONObject.toJSONString((Object)returnResult));
        return returnResult;
    }

    private String getCompanyBrandCodeByBrandId(Long brandId) {
        try {
            String brandCode = this.brandHashMap.getOrDefault(brandId, "");
            if (StringUtils.isNotBlank((CharSequence)brandCode)) {
                return brandCode;
            }
            ResponseData responseData = this.brandServiceRpc.getBrandByID(brandId);
            if (responseData.getCode() == SysResponseEnum.SUCCESS.getCode() && responseData.getData() != null) {
                brandCode = ((SysBrandPo)responseData.getData()).getBrandCode();
                this.brandHashMap.put(brandId, brandCode);
                return brandCode;
            }
        }
        catch (Exception e) {
            logger.info("jh_third_interface getCompanyBrandCodeByBrandId error : {} , brandId :{}", (Object)e.getMessage(), (Object)brandId);
        }
        return null;
    }
}

