/*
 * Decompiled with CFR 0.152.
 */
package com.daas.nros.connector.server.service.impl.burgeon;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.exception.BizException;
import com.daas.nros.connector.client.burgeon.model.req.SnyCouponInfoReq;
import com.daas.nros.connector.client.burgeon.model.req.SnyCouponStatusReq;
import com.daas.nros.connector.client.burgeon.model.req.SnyCouponTransferReq;
import com.daas.nros.connector.client.burgeon.model.req.SnyMemberCouponReq;
import com.daas.nros.connector.client.burgeon.model.req.SnyMemberRightsReq;
import com.daas.nros.connector.client.burgeon.model.req.VgMemberCouponVo;
import com.daas.nros.connector.client.burgeon.model.vo.VgAddCouponDefinitionVo;
import com.daas.nros.connector.client.burgeon.model.vo.VgAddGiveCouponVo;
import com.daas.nros.connector.client.burgeon.model.vo.VgCancelCouponVo;
import com.daas.nros.connector.client.constants.Constant;
import com.daas.nros.connector.client.enums.ConnectorResponseEnum;
import com.daas.nros.connector.client.model.po.ConnectRequestLogPOWithBLOBs;
import com.daas.nros.connector.client.model.result.Result;
import com.daas.nros.connector.client.util.HttpClientUtil;
import com.daas.nros.connector.server.config.burgeon.CrmJointVConfig;
import com.daas.nros.connector.server.mapper.ConnectRequestLogPOMapper;
import com.daas.nros.connector.server.service.api.burgeon.CrmJointService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import jodd.exception.ExceptionUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.formula.functions.T;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CrmJointServiceImpl
implements CrmJointService {
    private static final Logger log = LoggerFactory.getLogger(CrmJointServiceImpl.class);
    private static ThreadLocal<ConnectRequestLogPOWithBLOBs> logThread = new ThreadLocal();
    @Resource
    private ConnectRequestLogPOMapper connectRequestLogPOMapper;

    @Override
    public void init() {
        ConnectRequestLogPOWithBLOBs connectRequestLogPO = new ConnectRequestLogPOWithBLOBs();
        connectRequestLogPO.setTrace(MDC.get((String)"traceId"));
        logThread.set(connectRequestLogPO);
    }

    @Override
    public void remove() {
        ConnectRequestLogPOWithBLOBs connectRequestLogPO = logThread.get();
        if (connectRequestLogPO != null) {
            connectRequestLogPO.setThirdEndTime(new Date());
            connectRequestLogPO.setCreateDate(new Date());
            this.connectRequestLogPOMapper.insertSelective(connectRequestLogPO);
            logThread.remove();
        }
    }

    public Result<T> snyCouponInfo(VgAddCouponDefinitionVo vgAddCouponDefinitionVo) {
        log.info("CrmJointServiceImpl#snyCouponInfo#vgAddCouponDefinitionVo: {}", (Object)JSON.toJSONString((Object)vgAddCouponDefinitionVo));
        ConnectRequestLogPOWithBLOBs connectRequestLogPOWithBLOBs = logThread.get();
        connectRequestLogPOWithBLOBs.setMethodName("snyCouponInfo");
        connectRequestLogPOWithBLOBs.setBrandCode(vgAddCouponDefinitionVo.getBrandCode());
        Result result = new Result();
        List<String> commodityWhiteList = this.stringToList(vgAddCouponDefinitionVo.getCommodityWhitelist());
        List<String> storeWhiteList = this.stringToList(vgAddCouponDefinitionVo.getStoreWhitelist());
        if (CollectionUtils.isEmpty(storeWhiteList)) {
            log.error("storeWhiteList is empty");
            result.setCode(Integer.valueOf(ConnectorResponseEnum.FAILED.getCode()));
            result.setMessage("storeWhiteList \u4e0d\u80fd\u4e3a\u7a7a");
            return result;
        }
        SnyCouponInfoReq couponInfoReq = SnyCouponInfoReq.builder().activityId(vgAddCouponDefinitionVo.getCouponDefinitionCode()).activityName(vgAddCouponDefinitionVo.getCouponName()).validType(Integer.valueOf(vgAddCouponDefinitionVo.getValidType().byteValue())).validStartAt(vgAddCouponDefinitionVo.getValidDateStart() != null ? String.valueOf(vgAddCouponDefinitionVo.getValidDateStart().getTime()) : null).validEndAt(vgAddCouponDefinitionVo.getValidDateEnd() != null ? String.valueOf(vgAddCouponDefinitionVo.getValidDateEnd().getTime()) : null).validDay(vgAddCouponDefinitionVo.getValidDay()).level(vgAddCouponDefinitionVo.getLevel()).condition(Long.valueOf(vgAddCouponDefinitionVo.getMinConsume().multiply(Constant.BIG_DECIMAL_ONE_HUNDRED).longValue())).discountType(Integer.valueOf(Integer.valueOf(vgAddCouponDefinitionVo.getPreferentialType().byteValue()) == 1 ? 2 : 1)).discountTarget(Constant.INT_ONE).quantity(Integer.valueOf(999999999)).limitQuantity(Integer.valueOf(999999999)).shopId("MALL-CLUB").status(Constant.INT_ONE).shopCodeList(storeWhiteList).itemCodeList(commodityWhiteList).appKey(CrmJointVConfig.appKey).appSecret(CrmJointVConfig.appSecret).build();
        if (Constant.INT_ONE.equals(couponInfoReq.getDiscountType())) {
            couponInfoReq.setDiscountValue(Long.valueOf(vgAddCouponDefinitionVo.getDiscount().multiply(Constant.BIG_DECIMAL_TEN).longValue()));
        } else {
            couponInfoReq.setDiscountValue(Long.valueOf(vgAddCouponDefinitionVo.getMoney().multiply(Constant.BIG_DECIMAL_ONE_HUNDRED).longValue()));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Content-type", "application/json;charset=utf-8");
        try {
            String req = JSONObject.toJSONString((Object)couponInfoReq);
            log.info("TOPIC_COUPON_DEFINITION mall-club\u54c1\u724c\u5238\u5b9a\u4e49 snyCouponInfo start req : {} url:{}", (Object)req, (Object)(CrmJointVConfig.urlPrefix + CrmJointVConfig.snyCouponInfo));
            connectRequestLogPOWithBLOBs.setThirdUrl(CrmJointVConfig.urlPrefix + CrmJointVConfig.snyCouponInfo);
            connectRequestLogPOWithBLOBs.setThirdHeader(JSON.toJSONString(map));
            connectRequestLogPOWithBLOBs.setThirdParam(req);
            connectRequestLogPOWithBLOBs.setThirdStartTime(new Date());
            String httpResult = HttpClientUtil.dopost((String)(CrmJointVConfig.urlPrefix + CrmJointVConfig.snyCouponInfo), (String)req, map);
            log.info("TOPIC_COUPON_DEFINITION mall-club\u54c1\u724c\u5238\u5b9a\u4e49 snyCouponInfo end httpResult : {}", (Object)httpResult);
            connectRequestLogPOWithBLOBs.setThirdEndTime(new Date());
            connectRequestLogPOWithBLOBs.setThirdResult(httpResult);
            this.convertToJsonObject((Result<T>)result, httpResult);
        }
        catch (BizException e) {
            connectRequestLogPOWithBLOBs.setThirdException(ExceptionUtil.exceptionStackTraceToString((Throwable)e));
            log.info("BizException:{}", (Throwable)e);
            result.setCode(Integer.valueOf(e.getCode()));
            result.setMessage(e.getMessage());
        }
        catch (Exception e) {
            connectRequestLogPOWithBLOBs.setThirdException(ExceptionUtil.exceptionStackTraceToString((Throwable)e));
            log.error("TOPIC_COUPON_DEFINITION mall-club\u54c1\u724c\u5238\u5b9a\u4e49 snyCouponInfo error : {}", (Throwable)e);
            result.setCode(Integer.valueOf(ConnectorResponseEnum.FAILED.getCode()));
            result.setMessage(e.getMessage());
        }
        return result;
    }

    public Result<T> modifyCouponInfo(VgAddCouponDefinitionVo vgAddCouponDefinitionVo) {
        ConnectRequestLogPOWithBLOBs connectRequestLogPOWithBLOBs = logThread.get();
        connectRequestLogPOWithBLOBs.setMethodName("modifyCouponInfo");
        connectRequestLogPOWithBLOBs.setBrandCode(vgAddCouponDefinitionVo.getBrandCode());
        log.info("CrmJointServiceImpl#modifyCouponInfo#vgAddCouponDefinitionVo: {}", (Object)JSON.toJSONString((Object)vgAddCouponDefinitionVo));
        Result result = new Result();
        List<String> itemCodeList = this.stringToList(vgAddCouponDefinitionVo.getCommodityWhitelist(), new ArrayList<String>());
        SnyCouponInfoReq couponInfoReq = SnyCouponInfoReq.builder().activityId(vgAddCouponDefinitionVo.getCouponDefinitionCode()).itemCodeList(itemCodeList).appKey(CrmJointVConfig.appKey).appSecret(CrmJointVConfig.appSecret).build();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Content-type", "application/json;charset=utf-8");
        try {
            String req = JSONObject.toJSONString((Object)couponInfoReq);
            log.info("TOPIC_COUPON_DEFINITION mall-club\u54c1\u724c\u5238\u5b9a\u4e49\u66f4\u65b0 modifyCouponInfo start req : {} url:{}", (Object)req, (Object)(CrmJointVConfig.urlPrefix + CrmJointVConfig.couponUpdate));
            connectRequestLogPOWithBLOBs.setThirdUrl(CrmJointVConfig.urlPrefix + CrmJointVConfig.snyCouponInfo);
            connectRequestLogPOWithBLOBs.setThirdHeader(JSON.toJSONString(map));
            connectRequestLogPOWithBLOBs.setThirdParam(req);
            connectRequestLogPOWithBLOBs.setThirdStartTime(new Date());
            String httpResult = HttpClientUtil.dopost((String)(CrmJointVConfig.urlPrefix + CrmJointVConfig.couponUpdate), (String)req, map);
            connectRequestLogPOWithBLOBs.setThirdEndTime(new Date());
            connectRequestLogPOWithBLOBs.setThirdResult(httpResult);
            log.info("TOPIC_COUPON_DEFINITION mall-club\u54c1\u724c\u5238\u5b9a\u4e49\u66f4\u65b0 modifyCouponInfo end httpResult : {}", (Object)httpResult);
            this.convertToJsonObject((Result<T>)result, httpResult);
        }
        catch (BizException e) {
            connectRequestLogPOWithBLOBs.setThirdException(ExceptionUtil.exceptionStackTraceToString((Throwable)e));
            log.info("BizException:{}", (Throwable)e);
            result.setCode(Integer.valueOf(e.getCode()));
            result.setMessage(e.getMessage());
        }
        catch (Exception e) {
            connectRequestLogPOWithBLOBs.setThirdException(ExceptionUtil.exceptionStackTraceToString((Throwable)e));
            log.error("TOPIC_COUPON_DEFINITION mall-club\u54c1\u724c\u5238\u5b9a\u4e49\u66f4\u65b0 modifyCouponInfo error : {}", (Throwable)e);
            result.setCode(Integer.valueOf(ConnectorResponseEnum.FAILED.getCode()));
            result.setMessage(e.getMessage());
        }
        return result;
    }

    private List<String> stringToList(String str, List<String> defaultValue) {
        if (StringUtils.isBlank((String)str)) {
            return defaultValue;
        }
        return Arrays.asList(str.split(","));
    }

    private List<String> stringToList(String str) {
        return this.stringToList(str, null);
    }

    public String trimStr(String charStr) {
        int st;
        int len = charStr.length();
        char[] val = charStr.toCharArray();
        for (st = 0; st < len && val[st] <= ','; ++st) {
        }
        while (st < len && val[len - 1] <= ',') {
            --len;
        }
        return st > 0 || len < charStr.length() ? charStr.substring(st, len) : charStr;
    }

    public Result<T> snyMemberCoupon(List<SnyMemberCouponReq> couponReqList) {
        Result result = new Result();
        try {
            VgMemberCouponVo baseReq = VgMemberCouponVo.builder().appKey(CrmJointVConfig.appKey).appSecret(CrmJointVConfig.appSecret).couponList(couponReqList).build();
            ArrayList<String> couponCodeList = new ArrayList<String>();
            for (SnyMemberCouponReq snyMemberCouponReq : couponReqList) {
                couponCodeList.add(snyMemberCouponReq.getCouponId());
            }
            String req = JSONObject.toJSONString((Object)baseReq);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("Content-type", "application/json;charset=utf-8");
            log.info("TOPIC_COUPON_SEND mall-club\u54c1\u724c\u53d1\u5238 snyMemberCoupon start req : {} url:{}", (Object)req, (Object)(CrmJointVConfig.urlPrefix + CrmJointVConfig.snyMemberCoupon));
            String httpResult = HttpClientUtil.dopost((String)(CrmJointVConfig.urlPrefix + CrmJointVConfig.snyMemberCoupon), (String)req, map);
            log.info("TOPIC_COUPON_SEND mall-club\u54c1\u724c\u53d1\u5238 snyMemberCoupon end httpResult : {} couponCodeList :{}", (Object)httpResult, couponCodeList);
            this.convertToJsonObjectCoupon((Result<T>)result, httpResult);
        }
        catch (Exception e) {
            log.error("TOPIC_COUPON_SEND mall-club\u54c1\u724c\u53d1\u5238 snyMemberCoupon error : {} couponCodeList :{}", (Object)e.getMessage(), couponReqList);
            result.setCode(Integer.valueOf(ConnectorResponseEnum.FAILED.getCode()));
            result.setMessage(e.getMessage());
        }
        return result;
    }

    public Result<T> snyCouponStatus(VgCancelCouponVo vgCancelCouponVo) {
        Result result = new Result();
        SnyCouponStatusReq statusReq = SnyCouponStatusReq.builder().couponId(vgCancelCouponVo.getCouponCode()).status(Constant.INT_MINUS_TWO).updateAt(vgCancelCouponVo.getModifiedDate() != null ? String.valueOf(vgCancelCouponVo.getModifiedDate().getTime()) : null).build();
        return this.couponStatus((Result<T>)result, statusReq);
    }

    @Override
    public Result snyCouponCancel(VgCancelCouponVo vgCancelCouponVo) {
        Result result = new Result();
        SnyCouponStatusReq statusReq = SnyCouponStatusReq.builder().couponId(vgCancelCouponVo.getCouponCode()).status(Constant.INT_ONE).updateAt(vgCancelCouponVo.getModifiedDate() != null ? String.valueOf(vgCancelCouponVo.getModifiedDate().getTime()) : null).build();
        return this.couponStatus((Result<T>)result, statusReq);
    }

    private Result couponStatus(Result<T> result, SnyCouponStatusReq statusReq) {
        try {
            statusReq.setAppKey(CrmJointVConfig.appKey);
            statusReq.setAppSecret(CrmJointVConfig.appSecret);
            String req = JSONObject.toJSONString((Object)statusReq);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("Content-type", "application/json;charset=utf-8");
            log.info("TOPIC_COUPON_VERIFICATION/TOPIC_COUPON_CANCEL snyCouponStatus start req : {} url:{}", (Object)req, (Object)(CrmJointVConfig.urlPrefix + CrmJointVConfig.snyCouponStatus));
            String httpResult = HttpClientUtil.dopost((String)(CrmJointVConfig.urlPrefix + CrmJointVConfig.snyCouponStatus), (String)req, map);
            log.info("TOPIC_COUPON_VERIFICATION/TOPIC_COUPON_CANCEL snyCouponStatus end httpResult : {}", (Object)httpResult);
            this.convertToJsonObject(result, httpResult);
        }
        catch (Exception e) {
            log.error("TOPIC_COUPON_VERIFICATION/TOPIC_COUPON_CANCEL snyCouponStatus error : {}", (Object)e.getMessage());
            result.setCode(Integer.valueOf(ConnectorResponseEnum.FAILED.getCode()));
            result.setMessage(e.getMessage());
        }
        return result;
    }

    @Override
    public Result snyCouponTransfer(VgAddGiveCouponVo vgAddGiveCouponVo) {
        Result result = new Result();
        try {
            SnyCouponTransferReq build = SnyCouponTransferReq.builder().couponId(vgAddGiveCouponVo.getCouponCode()).donorMobile(vgAddGiveCouponVo.getTransferMemberPhone()).receiverMobile(vgAddGiveCouponVo.getMemberPhone()).appKey(CrmJointVConfig.appKey).appSecret(CrmJointVConfig.appSecret).build();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("Content-type", "application/json;charset=utf-8");
            String req = JSONObject.toJSONString((Object)build);
            log.info("coupon_to_offline_give_coupon_entity_topic snyCouponTransfer start req : {} url :{} ", (Object)req, (Object)(CrmJointVConfig.urlPrefix + CrmJointVConfig.couponTransfer));
            String httpResult = HttpClientUtil.dopost((String)(CrmJointVConfig.urlPrefix + CrmJointVConfig.couponTransfer), (String)req, map);
            log.info("coupon_to_offline_give_coupon_entity_topic snyCouponTransfer end httpResult : {}", (Object)httpResult);
            this.convertToJsonObject((Result<T>)result, httpResult);
        }
        catch (Exception e) {
            log.error("coupon_to_offline_give_coupon_entity_topic snyCouponTransfer error : {}", (Object)e.getMessage());
            result.setCode(Integer.valueOf(ConnectorResponseEnum.FAILED.getCode()));
            result.setMessage(e.getMessage());
        }
        return result;
    }

    @Override
    public Result snyMemberRights(SnyMemberRightsReq snyMemberRightsReq) {
        Result result = new Result();
        try {
            snyMemberRightsReq.setAppKey(CrmJointVConfig.appKey);
            snyMemberRightsReq.setAppSecret(CrmJointVConfig.appSecret);
            String req = JSONObject.toJSONString((Object)snyMemberRightsReq);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("Content-type", "application/json;charset=utf-8");
            log.info("CrmJointServiceImpl snyMemberRights start req : {} url :{}", (Object)req, (Object)(CrmJointVConfig.urlPrefix + CrmJointVConfig.memberRights));
            String httpResult = HttpClientUtil.dopost((String)(CrmJointVConfig.urlPrefix + CrmJointVConfig.memberRights), (String)req, map);
            log.info("CrmJointServiceImpl snyMemberRights end httpResult : {}", (Object)httpResult);
            this.convertToJsonObject((Result<T>)result, httpResult);
        }
        catch (Exception e) {
            log.error("CrmJointServiceImpl snyMemberRights error : {}", (Object)e.getMessage());
            result.setCode(Integer.valueOf(ConnectorResponseEnum.FAILED.getCode()));
            result.setMessage(e.getMessage());
        }
        return result;
    }

    public void convertToJsonObject(Result<T> result, String httpResult) {
        try {
            JSONObject jsonObject = JSON.parseObject((String)httpResult);
            if (jsonObject != null) {
                result.setMessage(String.valueOf(JSON.parseObject((String)String.valueOf(JSON.parseObject((String)String.valueOf(jsonObject.get((Object)"data"))).get((Object)"result"))).get((Object)"returnMessage")));
                if ("000000".equals(String.valueOf(JSON.parseObject((String)String.valueOf(JSON.parseObject((String)String.valueOf(jsonObject.get((Object)"data"))).get((Object)"result"))).get((Object)"returnCode")))) {
                    result.setCode(Integer.valueOf(ConnectorResponseEnum.SUCCESS.getCode()));
                } else {
                    result.setCode(Integer.valueOf(ConnectorResponseEnum.FAILED.getCode()));
                }
            } else {
                result.setCode(Integer.valueOf(ConnectorResponseEnum.FAILED.getCode()));
            }
        }
        catch (Exception e) {
            log.info("convertToJsonObject:{}", (Throwable)e);
            throw new BizException(SysResponseEnum.SYSTEM_ERROR.getCode(), SysResponseEnum.SYSTEM_ERROR.getMessage());
        }
    }

    public void convertToJsonObjectCoupon(Result<T> result, String httpResult) {
        JSONObject jsonObject = JSON.parseObject((String)httpResult);
        if (jsonObject != null) {
            result.setMessage(String.valueOf(JSON.parseObject((String)String.valueOf(JSON.parseObject((String)String.valueOf(jsonObject.get((Object)"data"))).get((Object)"result"))).get((Object)"returnMessage")));
            String resultCode = String.valueOf(JSON.parseObject((String)String.valueOf(JSON.parseObject((String)String.valueOf(jsonObject.get((Object)"data"))).get((Object)"result"))).get((Object)"returnCode"));
            if ("000000".equals(resultCode)) {
                result.setCode(Integer.valueOf(ConnectorResponseEnum.SUCCESS.getCode()));
            } else if ("400001".equals(resultCode)) {
                result.setCode(Integer.valueOf(ConnectorResponseEnum.SUCCESS.getCode()));
            } else {
                result.setCode(Integer.valueOf(ConnectorResponseEnum.FAILED.getCode()));
            }
        } else {
            result.setCode(Integer.valueOf(ConnectorResponseEnum.FAILED.getCode()));
        }
    }
}

