/*
 * Decompiled with CFR 0.152.
 */
package com.daas.nros.connector.server.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.daas.nros.connector.client.api.ConnectConfigService;
import com.daas.nros.connector.client.constants.SystemConstant;
import com.daas.nros.connector.client.enums.ConnectorResponseEnum;
import com.daas.nros.connector.client.model.po.ConnectConfig;
import com.daas.nros.connector.client.model.po.ConnectConfigBean;
import com.daas.nros.connector.client.model.po.ConnectConfigBeanExample;
import com.daas.nros.connector.client.model.po.ConnectConfigExample;
import com.daas.nros.connector.client.model.po.ConnectMethod;
import com.daas.nros.connector.client.model.po.ConnectMethodConfig;
import com.daas.nros.connector.client.model.po.ConnectMethodConfigExample;
import com.daas.nros.connector.client.model.po.ConnectMethodExample;
import com.daas.nros.connector.client.model.result.Result;
import com.daas.nros.connector.client.model.vo.ConnectConfigVO;
import com.daas.nros.connector.server.mapper.ConnectConfigBeanMapper;
import com.daas.nros.connector.server.mapper.ConnectConfigMapper;
import com.daas.nros.connector.server.mapper.ConnectMethodConfigMapper;
import com.daas.nros.connector.server.mapper.ConnectMethodMapper;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConnectConfigServiceImpl
implements ConnectConfigService {
    private static Logger logger = LoggerFactory.getLogger((String)ConnectConfigServiceImpl.class.getName());
    private static final String BEAN_NAME = "baseBurgeon";
    private static final String CREATE_USER_NAME = "System";
    private static final Integer CREATE_USER_ID = 999;
    private static final String MODIFIED_USER_NAME = "System";
    private static final Integer MODIFIED_USER_ID = 999;
    @Autowired
    private RedisTemplateServiceImpl<Object, ConnectConfig> connectConfigRedisTemplateService;
    private static final HashMap<String, ConnectConfig> CONNECT_CONFIG_HASH_MAP = new HashMap();
    @Autowired
    private ConnectConfigMapper connectConfigMapper;
    @Autowired
    private ConnectConfigBeanMapper connectConfigBeanMapper;
    @Autowired
    private ConnectMethodMapper connectMethodMapper;
    @Autowired
    private ConnectMethodConfigMapper connectMethodConfigMapper;
    private static final String SCRIPT_PREFIX = "wx$";

    public static final HashMap<String, ConnectConfig> getConnectConfigHashMap() {
        return (HashMap)CONNECT_CONFIG_HASH_MAP.clone();
    }

    public void refreshRedisAll() {
        logger.info("execute method refreshRedisAll from Class ConnectConfigServiceImpl");
        ConnectConfigExample connectConfigExample = new ConnectConfigExample();
        connectConfigExample.createCriteria().andValidEqualTo(SystemConstant.VALID);
        List<ConnectConfig> connectConfigList = this.connectConfigMapper.selectByExample(connectConfigExample);
        CONNECT_CONFIG_HASH_MAP.clear();
        for (ConnectConfig connectConfig : connectConfigList) {
            Long onlineBrandId = connectConfig.getOnlineBrandId();
            String appid = connectConfig.getAppid();
            CONNECT_CONFIG_HASH_MAP.put(appid, connectConfig);
            this.connectConfigRedisTemplateService.hashPushHashMap((Object)"brand", (Object)onlineBrandId, (Object)connectConfig);
        }
    }

    public ConnectConfig queryByOnlineBrandId(Long onlineBrandId) {
        ConnectConfig connectConfigRedis = (ConnectConfig)this.connectConfigRedisTemplateService.stringGetStringByKey((Object)("brand" + onlineBrandId));
        logger.info("jh_third_interface queryByOnlineBrandId connectConfigRedis data:{} , onlineBrandId:{}", (Object)JSONObject.toJSONString((Object)connectConfigRedis), (Object)onlineBrandId);
        if (connectConfigRedis != null) {
            return connectConfigRedis;
        }
        ConnectConfigExample connectConfigExample = new ConnectConfigExample();
        connectConfigExample.createCriteria().andOnlineBrandIdEqualTo(onlineBrandId).andValidEqualTo(SystemConstant.VALID);
        logger.info("jh_third_interface queryByOnlineBrandId selectByExample data:{} , onlineBrandId:{}", (Object)JSONObject.toJSONString((Object)connectConfigExample), (Object)onlineBrandId);
        List<ConnectConfig> connectConfigList = this.connectConfigMapper.selectByExample(connectConfigExample);
        if (CollectionUtils.isEmpty(connectConfigList)) {
            return null;
        }
        ConnectConfig connectConfig = connectConfigList.get(0);
        logger.info("jh_third_interface queryByOnlineBrandId connectConfig data:{} , onlineBrandId:{}", (Object)JSONObject.toJSONString((Object)connectConfig), (Object)onlineBrandId);
        this.connectConfigRedisTemplateService.stringSetString((Object)("brand" + onlineBrandId), (Object)connectConfig);
        return connectConfig;
    }

    public Result addConnectConfig(ConnectConfigVO requestVO) {
        Result result = new Result();
        Long onlineBrandId = requestVO.getOnlineBrandId();
        ConnectConfig connectConfig = this.queryByOnlineBrandId(onlineBrandId);
        if (connectConfig != null) {
            result.setCode(Integer.valueOf(ConnectorResponseEnum.FAILED.getCode()));
            result.setMessage("\u8be5\u54c1\u724c\u5df2\u5b58\u5728,\u65e0\u6cd5\u65b0\u589e!!!");
            return result;
        }
        ConnectConfig connectConfigInsert = this.insertConnectConfig(requestVO);
        this.insertConnectConfigBean(connectConfigInsert);
        List<ConnectMethod> connectMethodList = this.selectAllConnectMethod();
        for (int i = 0; CollectionUtils.isNotEmpty(connectMethodList) && i < connectMethodList.size(); ++i) {
            ConnectMethod connectMethod = connectMethodList.get(i);
            ConnectMethodConfig connectMethodConfig = new ConnectMethodConfig();
            connectMethodConfig.setConnectConfigId(connectConfigInsert.getConnectConfigId());
            connectMethodConfig.setConnectMethodId(connectMethod.getConnectMethodId());
            connectMethodConfig.setOnlineBrandId(connectConfigInsert.getOnlineBrandId());
            String methodName = connectMethod.getMethodName();
            connectMethodConfig.setMethodName(methodName);
            connectMethodConfig.setMethodUrl(connectMethod.getMethodUrl());
            connectMethodConfig.setOfflineScriptName(SCRIPT_PREFIX + methodName);
            if ("addorder".equalsIgnoreCase(methodName)) {
                connectMethodConfig.setIsSendErp(Boolean.FALSE);
            } else {
                connectMethodConfig.setIsSendErp(Boolean.TRUE);
            }
            connectMethodConfig.setValid(Boolean.TRUE);
            connectMethodConfig.setCreateUserId(CREATE_USER_ID);
            connectMethodConfig.setCreateUserName("System");
            connectMethodConfig.setModifiedUserId(MODIFIED_USER_ID);
            connectMethodConfig.setModifiedUserName("System");
            this.connectMethodConfigMapper.insertSelective(connectMethodConfig);
        }
        result.setCode(Integer.valueOf(ConnectorResponseEnum.SUCCESS.getCode()));
        result.setMessage(ConnectorResponseEnum.SUCCESS.getMessage());
        return result;
    }

    public Result updateConnectConfig(ConnectConfigVO requestVO) {
        Result result = new Result();
        Long onlineBrandId = requestVO.getOnlineBrandId();
        ConnectConfig connectConfig = this.queryByOnlineBrandId(onlineBrandId);
        if (connectConfig == null) {
            result.setCode(Integer.valueOf(ConnectorResponseEnum.FAILED.getCode()));
            result.setMessage("\u8be5\u54c1\u724c\u4e0d\u5b58\u5728,\u65e0\u6cd5\u66f4\u65b0!!!");
            return result;
        }
        Integer connectConfigId = connectConfig.getConnectConfigId();
        ConnectConfig connectConfigUpdate = new ConnectConfig();
        connectConfigUpdate.setConnectConfigId(connectConfigId);
        connectConfigUpdate.setOnlineBrandId(requestVO.getOnlineBrandId());
        connectConfigUpdate.setOfflineBrandCode(requestVO.getOfflineBrandCode());
        connectConfigUpdate.setBrandName(requestVO.getBrandName());
        connectConfigUpdate.setDomain(requestVO.getDomain());
        connectConfigUpdate.setValidDayNumber(requestVO.getValidDayNumber());
        connectConfigUpdate.setOfflineCompanyCode(requestVO.getOfflineCompanyCode());
        this.connectConfigMapper.updateByPrimaryKeySelective(connectConfigUpdate);
        result.setCode(Integer.valueOf(ConnectorResponseEnum.SUCCESS.getCode()));
        result.setMessage(ConnectorResponseEnum.SUCCESS.getMessage());
        return result;
    }

    public List<ConnectConfig> getAllConnectConfigList() {
        ConnectConfigExample connectConfigExample = new ConnectConfigExample();
        connectConfigExample.createCriteria().andValidEqualTo(Boolean.TRUE);
        List<ConnectConfig> connectConfigs = this.connectConfigMapper.selectByExample(connectConfigExample);
        return connectConfigs;
    }

    private void deleteConnectMethodConfigByConnectConfigId(Integer connectConfigId) {
        ConnectMethodConfigExample connectMethodConfigExample = new ConnectMethodConfigExample();
        connectMethodConfigExample.createCriteria().andValidEqualTo(Boolean.TRUE).andConnectConfigIdEqualTo(connectConfigId);
        this.connectMethodConfigMapper.deleteByExample(connectMethodConfigExample);
    }

    private void deleteConnectConfigBeanByConnectConfigId(Integer connectConfigId) {
        ConnectConfigBeanExample connectConfigBeanExample = new ConnectConfigBeanExample();
        connectConfigBeanExample.createCriteria().andValidEqualTo(Boolean.TRUE).andConnectConfigIdEqualTo(connectConfigId);
        this.connectConfigBeanMapper.deleteByExample(connectConfigBeanExample);
    }

    private List<ConnectMethod> selectAllConnectMethod() {
        ConnectMethodExample connectMethodExample = new ConnectMethodExample();
        connectMethodExample.createCriteria().andValidEqualTo(Boolean.TRUE);
        List<ConnectMethod> connectMethodList = this.connectMethodMapper.selectByExample(connectMethodExample);
        return connectMethodList;
    }

    private ConnectConfigBean insertConnectConfigBean(ConnectConfig connectConfigInsert) {
        ConnectConfigBean connectConfigBean = new ConnectConfigBean();
        connectConfigBean.setConnectConfigId(connectConfigInsert.getConnectConfigId());
        connectConfigBean.setOnlineBrandId(connectConfigInsert.getOnlineBrandId());
        connectConfigBean.setBeanName(BEAN_NAME);
        connectConfigBean.setValid(Boolean.TRUE);
        connectConfigBean.setCreateUserId(CREATE_USER_ID);
        connectConfigBean.setCreateUserName("System");
        connectConfigBean.setModifiedUserId(MODIFIED_USER_ID);
        connectConfigBean.setModifiedUserName("System");
        this.connectConfigBeanMapper.insertSelective(connectConfigBean);
        return connectConfigBean;
    }

    private ConnectConfig insertConnectConfig(ConnectConfigVO requestVO) {
        ConnectConfig connectConfigInsert = new ConnectConfig();
        connectConfigInsert.setOnlineBrandId(requestVO.getOnlineBrandId());
        connectConfigInsert.setOfflineBrandCode(requestVO.getOfflineBrandCode());
        connectConfigInsert.setBrandName(requestVO.getBrandName());
        connectConfigInsert.setDomain(requestVO.getDomain());
        connectConfigInsert.setValidDayNumber(requestVO.getValidDayNumber());
        connectConfigInsert.setOfflineCompanyCode(requestVO.getOfflineCompanyCode());
        connectConfigInsert.setValid(Boolean.TRUE);
        connectConfigInsert.setCreateUserId(CREATE_USER_ID);
        connectConfigInsert.setCreateUserName("System");
        connectConfigInsert.setModifiedUserId(MODIFIED_USER_ID);
        connectConfigInsert.setModifiedUserName("System");
        this.connectConfigMapper.insertSelective(connectConfigInsert);
        return connectConfigInsert;
    }
}

