/*
 * Decompiled with CFR 0.152.
 */
package com.daas.nros.connector.server.service.conver;

import com.bizvane.centerstageservice.models.vo.StaffVo;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.MemberLabelModel;
import com.bizvane.members.facade.models.OrderDetailModel;
import com.bizvane.utils.commonutils.DateUtils;
import com.daas.nros.connector.client.util.DateUtil;
import com.daas.nros.connector.client.weimob.constant.WmSystemConstant;
import com.daas.nros.connector.client.weimob.model.req.CouponBandMemberReq;
import com.daas.nros.connector.client.weimob.model.req.CouponCancelReq;
import com.daas.nros.connector.client.weimob.model.req.CouponConsumeReq;
import com.daas.nros.connector.client.weimob.model.req.CouponCreateReq;
import com.daas.nros.connector.client.weimob.model.req.CouponTemplateReq;
import com.daas.nros.connector.client.weimob.model.req.GuiderWidReq;
import com.daas.nros.connector.client.weimob.model.req.MemberLabelAddReq;
import com.daas.nros.connector.client.weimob.model.req.MemberLabelAttrReq;
import com.daas.nros.connector.client.weimob.model.req.MemberLabelRemoveReq;
import com.daas.nros.connector.client.weimob.model.req.MemberLabelReq;
import com.daas.nros.connector.client.weimob.model.req.MemberLevelChangeReq;
import com.daas.nros.connector.client.weimob.model.req.MemberReq;
import com.daas.nros.connector.client.weimob.model.req.MemberUpdateReq;
import com.daas.nros.connector.client.weimob.model.req.MemberWidReq;
import com.daas.nros.connector.client.weimob.model.req.VidReq;
import com.daas.nros.connector.client.weimob.model.req.param.CouponBindMemberParam;
import com.daas.nros.connector.client.weimob.model.req.param.CouponCancelParam;
import com.daas.nros.connector.client.weimob.model.req.param.CouponDefinitionParam;
import com.daas.nros.connector.client.weimob.model.req.param.CouponUseParam;
import com.daas.nros.connector.client.weimob.model.req.param.CrmMemberOrderParam;
import com.daas.nros.connector.client.weimob.model.req.param.MemberInfo;
import com.daas.nros.connector.client.weimob.model.req.param.MemberInfoModelParam;
import com.daas.nros.connector.client.weimob.model.req.param.MemberLabelAttrParam;
import com.daas.nros.connector.client.weimob.model.req.param.MemberLabelInfoParam;
import com.daas.nros.connector.client.weimob.model.req.param.MemberOrderBaseInfoParam;
import com.daas.nros.connector.client.weimob.model.req.param.MemberOrderCancelInfo;
import com.daas.nros.connector.client.weimob.model.req.param.MemberOrderDiscountParam;
import com.daas.nros.connector.client.weimob.model.req.param.MemberOrderGuiderParam;
import com.daas.nros.connector.client.weimob.model.req.param.MemberOrderItemInfoParam;
import com.daas.nros.connector.client.weimob.model.req.param.MemberOrderPayInfoParam;
import com.daas.nros.connector.client.weimob.model.req.param.MemberOrderUserInfoParam;
import com.daas.nros.connector.client.weimob.model.req.param.OpenCreateTagRequest;
import com.daas.nros.connector.client.weimob.model.req.param.OriginOrderParam;
import com.daas.nros.connector.client.weimob.model.req.param.RefundDetailParam;
import com.daas.nros.connector.client.weimob.model.req.param.RightsAssetsParam;
import com.daas.nros.connector.client.weimob.model.req.param.RightsItemsParam;
import com.daas.nros.connector.client.weimob.model.req.param.RightsOrderParam;
import com.daas.nros.connector.client.weimob.model.req.param.TagAttrRequest;
import com.daas.nros.connector.client.weimob.model.req.param.WmGoodsBaseInfoParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class WmConverFactory {
    private static final Logger log = LoggerFactory.getLogger(WmConverFactory.class);

    public static MemberReq getMemberReq(List<MemberInfoModelParam> memberInfoModelParams) {
        MemberReq memberReq = new MemberReq();
        memberReq.setImportType(Integer.valueOf(2));
        ArrayList<MemberInfo> userList = new ArrayList<MemberInfo>();
        for (MemberInfoModelParam memberInfoModelParam : memberInfoModelParams) {
            MemberInfo memberInfo = new MemberInfo();
            memberInfo.setPhone(memberInfoModelParam.getPhone());
            memberInfo.setRegionCode("86");
            memberInfo.setUnionId(memberInfoModelParam.getWxUnionId());
            memberInfo.setOpenId(memberInfoModelParam.getWxOpenId());
            memberInfo.setAppId("");
            memberInfo.setAppChannel(Integer.valueOf(5));
            memberInfo.setUserName(memberInfoModelParam.getName());
            memberInfo.setGender(WmConverFactory.converGender(memberInfoModelParam.getGender()));
            memberInfo.setBirthday(WmConverFactory.getTimeSecondFromData(memberInfoModelParam.getBirthday()));
            memberInfo.setIdentityCardNum(memberInfoModelParam.getIdCard());
            memberInfo.setEducation(null);
            memberInfo.setIncome(null);
            memberInfo.setIndustry(null);
            memberInfo.setHobby(null);
            memberInfo.setProvince(memberInfoModelParam.getProvince());
            memberInfo.setCity(memberInfoModelParam.getCity());
            memberInfo.setArea(null);
            memberInfo.setAddress(memberInfoModelParam.getAddress());
            memberInfo.setBelongVidName(memberInfoModelParam.getServiceGuiderName());
            memberInfo.setBelongVid(memberInfoModelParam.getServiceStoreId());
            memberInfo.setCustomCardNo(memberInfoModelParam.getCardNo());
            memberInfo.setLevelName(memberInfoModelParam.getLevelName());
            memberInfo.setGrowth(Integer.valueOf(0));
            memberInfo.setBalance(Integer.valueOf(0));
            memberInfo.setTotalBalance(Integer.valueOf(0));
            memberInfo.setTag(memberInfoModelParam.getMemberTags());
            memberInfo.setGuiderPhone(memberInfoModelParam.getServiceGuiderPhone());
            memberInfo.setSourceVid(memberInfoModelParam.getOpenCardStoreId());
            memberInfo.setBecomeMemberTime(WmConverFactory.getTimeSecondFromData(memberInfoModelParam.getCreateDate()).longValue());
            memberInfo.setMembershipCardChannel(Integer.valueOf(1));
            userList.add(memberInfo);
        }
        memberReq.setUserList(userList);
        return memberReq;
    }

    public static Integer converGender(String gender) {
        if (StringUtils.isEmpty((Object)gender)) {
            return 0;
        }
        if ("1".equals(gender)) {
            return 2;
        }
        if ("2".equals(gender)) {
            return 1;
        }
        if ("3".equals(gender)) {
            return 0;
        }
        return 0;
    }

    public static Long getTimeStampFromData(Date date) {
        if (date == null) {
            return null;
        }
        return date.getTime();
    }

    public static Long getTimeSecondFromData(Date date) {
        if (date == null) {
            return null;
        }
        return date.getTime();
    }

    private static long getTimeStampFromData(String dateTims) {
        if (StringUtils.isEmpty((Object)dateTims)) {
            return new Date().getTime();
        }
        if (!DateUtil.isValidDate((String)dateTims)) {
            return new Date().getTime();
        }
        Date date = DateUtils.StringFormatTime((String)dateTims);
        return date.getTime();
    }

    public static MemberLevelChangeReq getMemberLevelReq(MemberInfoModelParam memberInfoModelParam) {
        MemberLevelChangeReq memberLevelChangeReq = new MemberLevelChangeReq();
        memberLevelChangeReq.setDelayType(Long.valueOf(1L));
        memberLevelChangeReq.setUpdateType(Integer.valueOf(3));
        memberLevelChangeReq.setOperatorWId(Long.valueOf(0L));
        memberLevelChangeReq.setChannelType(Integer.valueOf(971));
        memberLevelChangeReq.setReason("\u4f1a\u5458\u7b49\u7ea7\u53d8\u66f4");
        memberLevelChangeReq.setOperatorName("crm");
        memberLevelChangeReq.setNewCustomCardNo(memberInfoModelParam.getCardNo());
        memberLevelChangeReq.setOldCustomCardNo(memberInfoModelParam.getCardNo());
        return memberLevelChangeReq;
    }

    public static MemberUpdateReq getMemberUpdateReq(MemberInfoModelParam memberInfoModelParam) {
        MemberUpdateReq memberUpdateReq = new MemberUpdateReq();
        memberUpdateReq.setVid(memberInfoModelParam.getServiceStoreCode());
        memberUpdateReq.setName(memberInfoModelParam.getName());
        memberUpdateReq.setGender(WmConverFactory.converGender(memberInfoModelParam.getGender()));
        memberUpdateReq.setBirthday(WmConverFactory.getTimeSecondFromData(memberInfoModelParam.getBirthday()));
        if (StringUtils.isEmpty((Object)memberInfoModelParam.getIdCard())) {
            memberUpdateReq.setIdentityCardNum(memberInfoModelParam.getIdCard());
        }
        if (StringUtils.isEmpty((Object)memberInfoModelParam.getEmail())) {
            memberUpdateReq.setEmail(memberInfoModelParam.getEmail());
        }
        memberUpdateReq.setProvince(memberInfoModelParam.getProvince());
        memberUpdateReq.setCity(memberInfoModelParam.getCity());
        memberUpdateReq.setAddress(memberInfoModelParam.getAddress());
        return memberUpdateReq;
    }

    public static MemberLabelReq getMemberLabelReq(List<MemberLabelInfoParam> memberLabelInfoParams) {
        MemberLabelReq memberLabelReq = new MemberLabelReq();
        memberLabelReq.setVidType(Integer.valueOf(1));
        memberLabelReq.setOperationSource(Integer.valueOf(2));
        ArrayList<OpenCreateTagRequest> openCreateTagRequestList = new ArrayList<OpenCreateTagRequest>();
        for (MemberLabelInfoParam memberLabelInfoParam : memberLabelInfoParams) {
            OpenCreateTagRequest openCreateTagRequest = new OpenCreateTagRequest();
            openCreateTagRequest.setSource(Integer.valueOf(0));
            openCreateTagRequest.setTagType(Integer.valueOf(1));
            openCreateTagRequest.setIsAddAtt(Boolean.TRUE);
            openCreateTagRequest.setIsCheckQwUpdate(Boolean.FALSE);
            openCreateTagRequest.setCheckTagNameExist(Boolean.TRUE);
            openCreateTagRequest.setTagGroupId(memberLabelInfoParam.getMbrLabelGroupDefId());
            openCreateTagRequest.setTagName(memberLabelInfoParam.getLabelTypeName());
            ArrayList<TagAttrRequest> tagAttrRequestList = new ArrayList<TagAttrRequest>();
            if (!CollectionUtils.isEmpty((Collection)memberLabelInfoParam.getMemberLabelModels())) {
                for (MemberLabelModel memberLabelModel : memberLabelInfoParam.getMemberLabelModels()) {
                    if (memberLabelModel == null) continue;
                    TagAttrRequest tagAttrRequest = new TagAttrRequest();
                    tagAttrRequest.setAttrId(memberLabelModel.getMbrLabelDefId());
                    tagAttrRequest.setAttrName(memberLabelModel.getLabelName());
                    tagAttrRequestList.add(tagAttrRequest);
                }
            }
            openCreateTagRequest.setTagAttrRequestList(tagAttrRequestList);
            openCreateTagRequestList.add(openCreateTagRequest);
        }
        memberLabelReq.setOpenCreateTagRequestList(openCreateTagRequestList);
        return memberLabelReq;
    }

    public static MemberLabelAttrReq getMemberLabelAttrReq(MemberLabelAttrParam memberLabelAttrParam) {
        MemberLabelAttrReq memberLabelAttrReq = new MemberLabelAttrReq();
        memberLabelAttrReq.setAttrName(memberLabelAttrParam.getLabelName());
        memberLabelAttrReq.setVidType(Integer.valueOf(1));
        memberLabelAttrReq.setOperationSource(Integer.valueOf(2));
        return memberLabelAttrReq;
    }

    public static MemberLabelAddReq getMemberLabelAddReq() {
        MemberLabelAddReq memberLabelAddReq = new MemberLabelAddReq();
        memberLabelAddReq.setVidType(Integer.valueOf(1));
        memberLabelAddReq.setNeedCheckExist(Boolean.TRUE);
        return memberLabelAddReq;
    }

    public static MemberLabelRemoveReq getMemberLabelRemoveReq(MemberInfoModelParam memberInfoModelParam) {
        MemberLabelRemoveReq memberLabelRemoveReq = new MemberLabelRemoveReq();
        memberLabelRemoveReq.setVidType(Integer.valueOf(1));
        return memberLabelRemoveReq;
    }

    public static CouponTemplateReq caseToCouponTemplateReq(CouponDefinitionParam param) {
        CouponTemplateReq couponTemplateReq = new CouponTemplateReq();
        couponTemplateReq.buildCouponTemplateBaseInfo(param);
        couponTemplateReq.buildCouponTemplateReduceRule(param);
        couponTemplateReq.buildCouponTemplateSendRule(param);
        couponTemplateReq.buildCouponTemplateUseRule(param);
        couponTemplateReq.buildCouponTemplateOtherSetting(param);
        couponTemplateReq.buildCouponTemplateCreateInfo(param);
        return couponTemplateReq;
    }

    public static CouponCreateReq caseToCouponCreateReq(CouponDefinitionParam param) {
        CouponCreateReq couponCreateReq = new CouponCreateReq();
        couponCreateReq.buildCouponBaseInfo(param);
        couponCreateReq.buildCouponSetting(param);
        couponCreateReq.buildCouponSendRule(param);
        couponCreateReq.buildCouponUseRule(param);
        couponCreateReq.buildCouponOtherSetting(param);
        couponCreateReq.buildCouponCreateInfo(param);
        return couponCreateReq;
    }

    public static CouponBandMemberReq caseToCouponBindingMemberReq(CouponBindMemberParam param) {
        CouponBandMemberReq couponBandMemberReq = new CouponBandMemberReq();
        couponBandMemberReq.setAcquireTime(param.getAcquireTime());
        couponBandMemberReq.setCouponTemplateId(param.getCouponTemplateId());
        couponBandMemberReq.setCode(param.getCouponCode());
        couponBandMemberReq.setWid(param.getWid());
        couponBandMemberReq.setExpireStartTime(param.getExpireStartTime());
        couponBandMemberReq.setExpireEndTime(param.getExpireEndTime());
        couponBandMemberReq.setVid(param.getVid());
        return couponBandMemberReq;
    }

    public static CouponCancelReq caseToCouponCancelReq(CouponCancelParam param) {
        int vidType = 1;
        int type = 2;
        CouponCancelReq couponCancelReq = new CouponCancelReq();
        couponCancelReq.setWid(param.getWid());
        couponCancelReq.setVidType(Integer.valueOf(vidType));
        couponCancelReq.setVid(param.getVid());
        couponCancelReq.setType(Integer.valueOf(type));
        couponCancelReq.buildCouponOperate(param);
        return couponCancelReq;
    }

    public static CouponConsumeReq caseToCouponConsumeReq(CouponUseParam param) {
        Long operator = WmSystemConstant.WM_STSTEM_OPERATOR_ID;
        Integer useResourceType = 2;
        Integer useScene = 7;
        Integer vidType = 1;
        BigDecimal orderAmount = new BigDecimal("0");
        CouponConsumeReq couponConsumeReq = new CouponConsumeReq();
        couponConsumeReq.setOrderAmount(orderAmount);
        couponConsumeReq.setOperator(operator);
        couponConsumeReq.setUseResourceType(useResourceType);
        couponConsumeReq.setUseScene(useScene);
        couponConsumeReq.setWid(param.getWid());
        couponConsumeReq.setVid(param.getVid());
        couponConsumeReq.setVidType(vidType);
        couponConsumeReq.buildCouponUseParam(param);
        return couponConsumeReq;
    }

    public static VidReq getVidReq(Integer type, Integer pageNum, Integer pageSize) {
        VidReq vidReq = new VidReq();
        vidReq.setVidType(type);
        vidReq.setPageSize(pageSize);
        vidReq.setPageNum(pageNum);
        return vidReq;
    }

    public static MemberWidReq getMemberWidReq(String phone) {
        MemberWidReq memberWidReq = new MemberWidReq();
        memberWidReq.setSource(Integer.valueOf(4));
        memberWidReq.setAppId("");
        memberWidReq.setOriginalId(phone);
        return memberWidReq;
    }

    public static GuiderWidReq getGuiderWidReq(String phone) {
        GuiderWidReq guiderWidReq = new GuiderWidReq();
        guiderWidReq.setJobNumber(phone);
        guiderWidReq.setNeedGuiderPicUrl(Integer.valueOf(0));
        guiderWidReq.setGuiderPhone(phone);
        return guiderWidReq;
    }

    public static MemberOrderBaseInfoParam getOrderBaseInfo(CrmMemberOrderParam crmMemberOrderParam) {
        MemberOrderBaseInfoParam orderBaseInfo = new MemberOrderBaseInfoParam();
        orderBaseInfo.setOutOrderNo(crmMemberOrderParam.getOrderNo());
        orderBaseInfo.setOutOriginalOrderNo(crmMemberOrderParam.getOrderNo());
        orderBaseInfo.setOrderType(Integer.valueOf(1));
        orderBaseInfo.setStatus(Integer.valueOf(8));
        orderBaseInfo.setPaymentType(Integer.valueOf(crmMemberOrderParam.getOrderNo().contains("O_mall") ? 2 : 1));
        orderBaseInfo.setChannelType(Integer.valueOf(7));
        if (WmConverFactory.getTimeSecondFromData(crmMemberOrderParam.getPlaceOrderTime()) != null) {
            orderBaseInfo.setOrderTime(Long.toString(WmConverFactory.getTimeSecondFromData(crmMemberOrderParam.getPlaceOrderTime())));
        }
        if (WmConverFactory.getTimeSecondFromData(crmMemberOrderParam.getPayTime()) != null) {
            orderBaseInfo.setFinishPaymentTime(Long.toString(WmConverFactory.getTimeSecondFromData(crmMemberOrderParam.getPayTime())));
        }
        orderBaseInfo.setDelete(Integer.valueOf(2));
        orderBaseInfo.setSaleChannelType(Integer.valueOf(crmMemberOrderParam.getOrderFrom() == 4 ? 10001 : 10002));
        orderBaseInfo.setBizSourceType(Integer.valueOf(1));
        orderBaseInfo.setPayStatus(Integer.valueOf(2));
        orderBaseInfo.setRemark(crmMemberOrderParam.getRemark());
        orderBaseInfo.setPlatformType(Integer.valueOf(2));
        return orderBaseInfo;
    }

    public static MemberOrderUserInfoParam getBuyInfoObj(MemberInfoModel memberInfoModel) {
        MemberOrderUserInfoParam buyerInfo = new MemberOrderUserInfoParam();
        buyerInfo.setBuyerName(memberInfoModel.getName());
        buyerInfo.setBuyerPhone(memberInfoModel.getPhone());
        buyerInfo.setOutCardNo(memberInfoModel.getCardNo());
        return buyerInfo;
    }

    public static MemberOrderGuiderParam getMemberOrderGuiderParam(StaffVo staffVo) {
        MemberOrderGuiderParam memberOrderGuiderParam = new MemberOrderGuiderParam();
        memberOrderGuiderParam.setGuiderName(staffVo.getStaffName());
        memberOrderGuiderParam.setGuiderNo(staffVo.getStaffCode());
        memberOrderGuiderParam.setOutGuiderNo(staffVo.getStaffCode());
        memberOrderGuiderParam.setGuiderPhone(staffVo.getPhone());
        return memberOrderGuiderParam;
    }

    public static MemberOrderPayInfoParam getMemberOrderPayInfoParam(CrmMemberOrderParam crmMemberOrderParam) {
        MemberOrderPayInfoParam paymentInfo = new MemberOrderPayInfoParam();
        paymentInfo.setPaymentAmount(crmMemberOrderParam.getPayMoney());
        paymentInfo.setTotalAmount(crmMemberOrderParam.getPayMoney());
        paymentInfo.setShouldPaymentAmount(crmMemberOrderParam.getPayMoney());
        return paymentInfo;
    }

    public static MemberOrderDiscountParam getMemberOrderDiscountParam() {
        MemberOrderDiscountParam memberOrderDiscountParam = new MemberOrderDiscountParam();
        return memberOrderDiscountParam;
    }

    public static MemberOrderCancelInfo getMemberOrderCancelInfo() {
        MemberOrderCancelInfo memberOrderCancelInfo = new MemberOrderCancelInfo();
        return memberOrderCancelInfo;
    }

    public static MemberOrderItemInfoParam getMemberOrderItemInfoParam(OrderDetailModel orderDetailModel) {
        MemberOrderItemInfoParam memberOrderItemInfoParam = new MemberOrderItemInfoParam();
        memberOrderItemInfoParam.setGoodsType(Integer.valueOf(1));
        memberOrderItemInfoParam.setSubGoodsType(Integer.valueOf(101));
        memberOrderItemInfoParam.setGoodsTitle(orderDetailModel.getProductName());
        memberOrderItemInfoParam.setSkuAttrInfo(orderDetailModel.getSpecification());
        memberOrderItemInfoParam.setImageUrl(orderDetailModel.getSkuImg());
        memberOrderItemInfoParam.setSalePrice(orderDetailModel.getTradeAmountDetail());
        memberOrderItemInfoParam.setOutSkuId(orderDetailModel.getSku());
        memberOrderItemInfoParam.setSkuName(orderDetailModel.getSku());
        memberOrderItemInfoParam.setMarketPrice(orderDetailModel.getTagPrice());
        memberOrderItemInfoParam.setDeductStockType(Integer.valueOf(1));
        return memberOrderItemInfoParam;
    }

    public static OriginOrderParam getOriginOrderParam(CrmMemberOrderParam crmMemberOrderParam) {
        OriginOrderParam originOrder = new OriginOrderParam();
        if (!StringUtils.isEmpty((Object)crmMemberOrderParam.getOriginalOrderNo())) {
            originOrder.setOutOrderNo(crmMemberOrderParam.getOriginalOrderNo());
            originOrder.setOutOriginalOrderNo(crmMemberOrderParam.getOriginalOrderNo());
        }
        return originOrder;
    }

    public static RightsOrderParam getRightsOrderParam(CrmMemberOrderParam crmMemberOrderParam) {
        RightsOrderParam rightsOrder = new RightsOrderParam();
        rightsOrder.setRightsType(Integer.valueOf(1));
        rightsOrder.setChannelType(Integer.valueOf(7));
        rightsOrder.setRightsStatus(Integer.valueOf(6));
        rightsOrder.setRightsCauseType(Integer.valueOf(1));
        rightsOrder.setRefundType(Integer.valueOf(crmMemberOrderParam.getOrderFrom() != null && crmMemberOrderParam.getOrderFrom() == 4 ? 2 : 1));
        rightsOrder.setOutRightsNo(crmMemberOrderParam.getOrderNo());
        rightsOrder.setRemark(crmMemberOrderParam.getRemark());
        rightsOrder.setReason(crmMemberOrderParam.getRemark());
        if (WmConverFactory.getTimeSecondFromData(crmMemberOrderParam.getPlaceOrderTime()) != null) {
            rightsOrder.setCreateTime(WmConverFactory.getTimeSecondFromData(crmMemberOrderParam.getPlaceOrderTime()));
        }
        if (WmConverFactory.getTimeSecondFromData(crmMemberOrderParam.getPlaceOrderTime()) != null) {
            rightsOrder.setFinishTime(WmConverFactory.getTimeSecondFromData(crmMemberOrderParam.getPlaceOrderTime()));
        }
        if (WmConverFactory.getTimeSecondFromData(crmMemberOrderParam.getPlaceOrderTime()) != null) {
            rightsOrder.setAgreeTime(WmConverFactory.getTimeSecondFromData(crmMemberOrderParam.getPlaceOrderTime()));
        }
        rightsOrder.setPlatformType(Integer.valueOf(2));
        rightsOrder.setRefundMethod(Integer.valueOf(1));
        return rightsOrder;
    }

    public static RightsItemsParam getRightsItemsParam(OrderDetailModel orderDetailModel, CrmMemberOrderParam crmMemberOrderParam) {
        RightsItemsParam rightsItemsParam = new RightsItemsParam();
        rightsItemsParam.setOutRightsItemId(Long.toString(orderDetailModel.getMbrOrderDetailId()));
        rightsItemsParam.setOrderItemId(crmMemberOrderParam.getMbrOrderId());
        rightsItemsParam.setGoodsTitle(orderDetailModel.getProductName());
        rightsItemsParam.setOutGoodsId(orderDetailModel.getProductItemId());
        rightsItemsParam.setOutSkuId(orderDetailModel.getSku());
        rightsItemsParam.setSkuName(orderDetailModel.getSpecification());
        if (orderDetailModel.getQuantity() != null) {
            rightsItemsParam.setApplyNum(Integer.valueOf(Math.abs(orderDetailModel.getQuantity())));
        }
        rightsItemsParam.setMarketPrice(orderDetailModel.getTagPrice());
        if (orderDetailModel.getTradeAmountDetail() != null) {
            rightsItemsParam.setSalePrice(orderDetailModel.getTradeAmountDetail().intValue() < 0 ? orderDetailModel.getTradeAmountDetail().negate() : orderDetailModel.getTradeAmountDetail());
            rightsItemsParam.setPayAmount(orderDetailModel.getTradeAmountDetail().intValue() < 0 ? orderDetailModel.getTradeAmountDetail().negate() : orderDetailModel.getTradeAmountDetail());
        }
        ArrayList<RightsAssetsParam> rightsAssets = new ArrayList<RightsAssetsParam>();
        RightsAssetsParam rightsAssetsParam = new RightsAssetsParam();
        rightsAssetsParam.setAssetType(Integer.valueOf(1));
        rightsAssetsParam.setAssetsTarget(Integer.valueOf(1));
        if (orderDetailModel.getTradeAmountDetail() != null) {
            RefundDetailParam refundDetail = new RefundDetailParam();
            refundDetail.setApplyAmount(orderDetailModel.getTradeAmountDetail().intValue() < 0 ? orderDetailModel.getTradeAmountDetail().negate() : orderDetailModel.getTradeAmountDetail());
            refundDetail.setRefundAmount(orderDetailModel.getTradeAmountDetail().intValue() < 0 ? orderDetailModel.getTradeAmountDetail().negate() : orderDetailModel.getTradeAmountDetail());
            if (Math.abs(orderDetailModel.getQuantity()) > 1) {
                refundDetail.setApplyAmount(orderDetailModel.getTradeAmountDetail().intValue() < 0 ? orderDetailModel.getTradeAmountDetail().negate().multiply(new BigDecimal(Math.abs(orderDetailModel.getQuantity()))) : orderDetailModel.getTradeAmountDetail().multiply(new BigDecimal(Math.abs(orderDetailModel.getQuantity()))));
                refundDetail.setRefundAmount(orderDetailModel.getTradeAmountDetail().intValue() < 0 ? orderDetailModel.getTradeAmountDetail().negate().multiply(new BigDecimal(Math.abs(orderDetailModel.getQuantity()))) : orderDetailModel.getTradeAmountDetail().multiply(new BigDecimal(Math.abs(orderDetailModel.getQuantity()))));
            }
            rightsItemsParam.setRefundDetail(refundDetail);
            rightsAssetsParam.setAssetAmount(orderDetailModel.getTradeAmountDetail().intValue() < 0 ? orderDetailModel.getTradeAmountDetail().negate() : orderDetailModel.getTradeAmountDetail());
        }
        rightsAssets.add(rightsAssetsParam);
        rightsItemsParam.setRightsAssets(rightsAssets);
        return rightsItemsParam;
    }

    public static WmGoodsBaseInfoParam getWmGoodsBaseInfoParam(String goodsId, Long vid) {
        WmGoodsBaseInfoParam wmGoodsBaseInfoParam = new WmGoodsBaseInfoParam();
        wmGoodsBaseInfoParam.setGoodsIdList(Arrays.asList(Long.valueOf(goodsId)));
        WmGoodsBaseInfoParam.BasicInfo basicInfo = new WmGoodsBaseInfoParam.BasicInfo();
        basicInfo.setVid(vid);
        wmGoodsBaseInfoParam.setBasicInfo(basicInfo);
        return wmGoodsBaseInfoParam;
    }
}

