/*
 * Decompiled with CFR 0.152.
 */
package com.daas.nros.connector.server.service.component;

import com.alibaba.fastjson.JSON;
import com.daas.nros.connector.client.util.HttpClientUtil;
import com.daas.nros.connector.client.weimob.constant.WmSystemConstant;
import com.daas.nros.connector.client.weimob.model.vo.WmSystemTokenVo;
import com.daas.nros.connector.server.config.weimob.WMSystemConfig;
import com.daas.nros.connector.server.service.component.RedisCacheComponent;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WmSystemTokenUtils {
    private static final Logger log = LoggerFactory.getLogger(WmSystemTokenUtils.class);
    @Autowired
    private RedisCacheComponent redisCacheComponent;
    @Autowired
    private WMSystemConfig wmSystemConfig;

    public String getWmSystemToken() {
        WmSystemTokenVo wmSystemTokenByRedis = this.getWmSystemTokenByRedis();
        return wmSystemTokenByRedis.getAccess_token();
    }

    private WmSystemTokenVo getWmSystemTokenByRedis() {
        WmSystemTokenVo tokenVo;
        log.info("getWmSystemTokenByRedis,1. \u5c1d\u8bd5\u4eceredis\u4e2d\u83b7\u53d6");
        Object wmSystemTokenVo = this.redisCacheComponent.getCacheObject("wm_system_token_redis_key");
        if (wmSystemTokenVo != null && null != (tokenVo = (WmSystemTokenVo)JSON.parseObject((String)wmSystemTokenVo.toString(), WmSystemTokenVo.class))) {
            return tokenVo;
        }
        log.info("getWmSystemTokenByRedis,2. \u7f13\u5b58\u4e2d\u6ca1\u6709token, \u5c31\u5237\u65b0token");
        return this.refreshToken();
    }

    private WmSystemTokenVo refreshToken() {
        WmSystemTokenVo tokenVo = this.findWmSystemToken();
        if (tokenVo == null || StringUtils.isBlank((String)tokenVo.getAccess_token())) {
            log.info("\u83b7\u53d6\u5fae\u76dftoken\u5931\u8d25");
            throw new RuntimeException("\u83b7\u53d6\u5fae\u76dftoken\u5931\u8d25");
        }
        this.redisCacheComponent.setCacheObject("wm_system_token_redis_key", JSON.toJSONString((Object)tokenVo), this.getExpirseTime(tokenVo), TimeUnit.SECONDS);
        return tokenVo;
    }

    private Long getExpirseTime(WmSystemTokenVo tokenVo) {
        if (null != tokenVo.getExpires_in()) {
            return tokenVo.getExpires_in();
        }
        return WmSystemConstant.DEFAULT_WM_SYSTEM_TOKEN_REDIS_TIMEOUT;
    }

    private WmSystemTokenVo findWmSystemToken() {
        WmSystemTokenVo wmSystemTokenVo = null;
        String url = this.packingWmSystemInterface("/fuwu/b/oauth2/token");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("grant_type", this.wmSystemConfig.getGrantType());
        headers.put("client_id", this.wmSystemConfig.getClientId());
        headers.put("client_secret", this.wmSystemConfig.getClientSecret());
        url = url + "?grant_type=" + this.wmSystemConfig.getGrantType() + "&client_id=" + this.wmSystemConfig.getClientId() + "&client_secret=" + this.wmSystemConfig.getClientSecret();
        log.info("findWmSystemToken,url{},headers:{}", (Object)url, (Object)JSON.toJSONString(headers));
        String response = HttpClientUtil.doPost((String)url, null);
        log.info("findWmSystemToken,response:{}", (Object)response);
        if (StringUtils.isNotBlank((String)response)) {
            wmSystemTokenVo = (WmSystemTokenVo)JSON.parseObject((String)response, WmSystemTokenVo.class);
        }
        return wmSystemTokenVo;
    }

    public String packingWmSystemInterface(String url) {
        return this.wmSystemConfig.getWmSystemDNS() + url;
    }
}

