/*
 * Decompiled with CFR 0.152.
 */
package com.daas.nros.connector.server.middleware.mq.producer;

import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.SendResult;
import com.aliyun.openservices.ons.api.exception.ONSClientException;
import com.bizvane.utils.responseinfo.ResponseData;
import com.daas.nros.connector.server.middleware.mq.producer.RocketMQProducerService;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.message.MessageQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RocketMQProducerServiceImpl
implements RocketMQProducerService {
    @Autowired
    private RocketMQTemplate rocketMQTemplate;
    private static final Logger logger = LoggerFactory.getLogger(RocketMQProducerServiceImpl.class);

    @Override
    public ResponseData<String> sendMessage(Producer producer, String topic, String tag, byte[] messageBody) {
        logger.info("RocketMQProducerServiceImpl.sendMessage:topic:" + topic + ">tag:" + tag);
        if (StringUtils.isBlank((CharSequence)topic) || StringUtils.isBlank((CharSequence)tag)) {
            logger.error("RocketMQProducerServiceImpl.sendMessage:topic\u3001tag\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ResponseData result = new ResponseData();
        Message message = new Message(topic, tag, messageBody);
        try {
            SendResult sendResult = producer.send(message);
            String messageId = sendResult.getMessageId();
            result.setData((Object)messageId);
            logger.info("RocketMQProducerServiceImpl.sendMessage\u6d88\u606f\u53d1\u9001\u5b8c\u6210\uff0cmsgId\uff1a" + messageId);
        }
        catch (ONSClientException e) {
            logger.info("RocketMQProducerServiceImpl.sendMessage\uff1a" + e.getMessage());
        }
        return result;
    }

    @Override
    public org.apache.rocketmq.client.producer.SendResult sendMessage(String topic, String tag, Object messageBody, long sysBrandId) {
        logger.info("sendMessage:{},{},{},{}", new Object[]{topic, tag, JSONObject.toJSONString((Object)messageBody), sysBrandId});
        return this.rocketMQTemplate.send(new Destination(topic, tag, null), messageBody, (mqs, msg, arg) -> {
            int value = arg.hashCode();
            if (value < 0) {
                value = Math.abs(value);
            }
            int i = value % mqs.size();
            return (MessageQueue)mqs.get(i);
        }, String.valueOf(sysBrandId));
    }
}

