/*
 * Decompiled with CFR 0.152.
 */
package com.daas.nros.connector.server.middleware.mq.listener;

import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.Producer;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class ApplicationInitListener
implements ApplicationListener<ApplicationReadyEvent> {
    private static Logger logger = LoggerFactory.getLogger((String)ApplicationInitListener.class.getName());
    private static final String BOOLEAN_TRUE = "true";
    private static final String LOCAL_ONSADDR = "NAMESRV_ADDR";
    @Value(value="${rocketmq.onsaddr}")
    private String onsaddr;
    @Value(value="${rocketmq.accessKey}")
    private String accessKey;
    @Value(value="${rocketmq.secretKey}")
    private String secretKey;
    @Value(value="${rocketmq.memberInfoRequestConsumerId}")
    private String memberInfoRequestConsumerId;
    @Value(value="${rocketmq.topic}")
    public String topic;
    @Value(value="${rocketmq.memberInfoRequestTag}")
    public String memberInfoRequestTag;
    @Value(value="${rocketmq.producerId}")
    private String producerId;
    @Value(value="${rocketmq.isLocal}")
    private String isLocal;
    @Value(value="${rocketmq.localAddress}")
    private String localAddress;
    private static Producer producer;
    private static Consumer consumer;

    private void initMemberInfoMq() {
        logger.info("\u6d88\u8d39\u8005\u542f\u52a8");
        Properties properties = this.loadMqRequest();
        properties.put("ConsumerId", this.memberInfoRequestConsumerId);
        consumer = ONSFactory.createConsumer((Properties)properties);
        consumer.start();
    }

    private void initProducer() {
        logger.info("\u751f\u4ea7\u8005\u542f\u52a8");
        Properties properties = this.loadMqRequest();
        properties.put("ProducerId", this.producerId);
        producer = ONSFactory.createProducer((Properties)properties);
        producer.start();
    }

    public Properties loadMqRequest() {
        Properties properties = new Properties();
        properties.put("AccessKey", this.accessKey);
        properties.put("SecretKey", this.secretKey);
        if (BOOLEAN_TRUE.equalsIgnoreCase(this.isLocal)) {
            logger.info("\u52a0\u8f7d\u672c\u5730roketmq\u914d\u7f6e:{}", (Object)this.localAddress);
            properties.put(LOCAL_ONSADDR, this.localAddress);
        } else {
            logger.info("\u52a0\u8f7daliyun roketmq\u914d\u7f6e:{}", (Object)this.onsaddr);
            properties.put("ONSAddr", this.onsaddr);
        }
        return properties;
    }

    public void onApplicationEvent(ApplicationReadyEvent applicationReadyEvent) {
        this.startMq();
    }

    public void startMq() {
        this.initMemberInfoMq();
        this.initProducer();
        logger.info("rabbitMq \u542f\u52a8\u6210\u529f");
    }

    public void shutdownMq() {
        if (producer != null) {
            producer.shutdown();
            logger.info("\u751f\u4ea7\u8005\u5173\u95ed");
        }
        if (consumer != null) {
            consumer.shutdown();
            logger.info("\u6d88\u8d39\u8005\u5173\u95ed");
        }
        logger.info("rabbitMq \u5173\u95ed\u6210\u529f");
    }

    public static Producer getProducer() {
        return producer;
    }

    public static Consumer getConsumer() {
        return consumer;
    }
}

