/*
 * Decompiled with CFR 0.152.
 */
package com.daas.nros.connector.server.middleware.mq.consumer;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.bizvane.couponfacade.interfaces.CouponDefinitionServiceFeign;
import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.daas.nros.connector.client.burgeon.model.vo.VgUseCouponVo;
import com.daas.nros.connector.client.enums.StringBrandCode;
import com.daas.nros.connector.client.model.po.MbrMembersPo;
import com.daas.nros.connector.client.model.result.Result;
import com.daas.nros.connector.client.weimob.model.req.param.CouponUseParam;
import com.daas.nros.connector.client.weimob.rpc.WmConnectServiceFeign;
import com.daas.nros.connector.server.service.api.burgeon.VgCouponService;
import com.daas.nros.connector.server.service.api.weimob.SysWeimengService;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@RocketMQMessageListener(topic="TOPIC_COUPON_VERIFICATION", tags={"VG_CLUB", "YJ_CLUB", "TW_CLUB"})
public class UseCouponBatchListerner
implements RocketMQListener<JSONObject> {
    private static final Logger log = LoggerFactory.getLogger(UseCouponBatchListerner.class);
    @Autowired
    private VgCouponService vgCouponService;
    @Autowired
    private SysWeimengService sysWeimengService;
    @Autowired
    private CouponDefinitionServiceFeign couponDefinitionServiceFeign;
    @Autowired
    private WmConnectServiceFeign wmConnectServiceFeign;

    public void onMessage(ConsumerMessage<JSONObject> consumerMessage) {
        log.info("use_couponListerner topic:{} on message body : {}", (Object)"TOPIC_COUPON_VERIFICATION", consumerMessage.getMessage());
        JSONObject body = (JSONObject)consumerMessage.getMessage();
        String tag = consumerMessage.getTags();
        String club = tag.replace("_", "-");
        Result<JSONObject> result = this.vgCouponService.useCoupon(body, club);
        log.info("use_coupon" + JSON.toJSONString(result));
        log.info("syncCouponConsumerToWM, club:{}, body:{}", (Object)club, (Object)body);
        Result syncWMResult = this.syncCouponConsumerToWM(body, club);
        log.info("syncCouponConsumerToWM, syncWMResult:{}", (Object)JSON.toJSONString((Object)syncWMResult));
    }

    private Result syncCouponConsumerToWM(JSONObject body, String club) {
        Result<Object> result = new Result<Object>();
        VgUseCouponVo vgUseCouponVo = (VgUseCouponVo)JSON.parseObject((String)JSON.toJSONString((Object)body), (TypeReference)new TypeReference<VgUseCouponVo>(){}, (Feature[])new Feature[0]);
        result.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
        log.info("syncCouponConsumerToWM, club:{}, body:{}", (Object)club, (Object)JSON.toJSONString((Object)body));
        CouponDefinitionPO definition = this.findCouponDefinitionByCouponCode(vgUseCouponVo.getCouponCode());
        if (!StringBrandCode.vg.getValue().equals(club) && !this.isExist(definition, StringBrandCode.vg.getValue())) {
            log.info("syncCouponConsumerToWM \u6838\u9500\u7c7b\u578b\u4e0d\u662fVG,end.");
            result.setMessage("syncCouponConsumerToWM \u6838\u9500\u7c7b\u578b\u4e0d\u662fVG,end.");
            result.setCode(Integer.valueOf(SysResponseEnum.SUCCESS.getCode()));
            return result;
        }
        CouponUseParam couponUseParam = this.convertCouponUseParam(vgUseCouponVo);
        if (null == couponUseParam) {
            log.info("syncCouponConsumerToWM convertCouponUseParam \u53c2\u6570\u8f6c\u6362\u5931\u8d25");
            result.setMessage("syncCouponConsumerToWM convertCouponUseParam \u53c2\u6570\u8f6c\u6362\u5931\u8d25");
            return result;
        }
        result = this.sysWeimengService.useCouponEntityTowm(couponUseParam);
        return result;
    }

    public CouponDefinitionPO findCouponDefinitionByCouponCode(String couponCode) {
        log.info("findCouponDefinitionByCouponCode, couponCode:{}", (Object)couponCode);
        ResponseData responseData = this.couponDefinitionServiceFeign.findCouponDefinitionByCouponCode(couponCode);
        log.info("findCouponDefinitionByCouponCode, responseData:{}", (Object)JSON.toJSONString((Object)responseData));
        if (responseData.getCode() == SysResponseEnum.SUCCESS.getCode()) {
            return (CouponDefinitionPO)responseData.getData();
        }
        return null;
    }

    private boolean isExist(CouponDefinitionPO definition, String brandCode) {
        if (definition == null) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)definition.getApplicableBrandCodes())) {
            return false;
        }
        return definition.getApplicableBrandCodes().contains(brandCode);
    }

    private CouponUseParam convertCouponUseParam(VgUseCouponVo vgUseCouponVo) {
        log.info("convertCouponUseParam, vgUseCouponVo:{}", (Object)JSON.toJSONString((Object)vgUseCouponVo));
        CouponUseParam couponUseParam = new CouponUseParam();
        MbrMembersPo mbrMemberBy = this.sysWeimengService.findMbrMemberBy(vgUseCouponVo.getUseMemberCardNo(), 3, StringBrandCode.vg.getValue());
        if (mbrMemberBy == null) {
            return null;
        }
        String couponDefinitionCode = this.findCouponDefinitionCodeByCouponCode(vgUseCouponVo.getCouponCode());
        if (StringUtils.isBlank((CharSequence)couponDefinitionCode)) {
            return null;
        }
        couponUseParam.setMemberCode(mbrMemberBy.getMemberCode());
        CouponUseParam.OperateCoupon operateCoupon = new CouponUseParam.OperateCoupon();
        operateCoupon.setCode(vgUseCouponVo.getCouponCode());
        operateCoupon.setCouponDefinitionCode(couponDefinitionCode);
        couponUseParam.setOperateCoupons(Arrays.asList(operateCoupon));
        log.info("convertCouponUseParam, result:{}", (Object)JSON.toJSONString((Object)couponUseParam));
        return couponUseParam;
    }

    private String findCouponDefinitionCodeByCouponCode(String couponCode) {
        log.info("findCouponDefinitionCodeByCouponCode, couponCode:{}", (Object)couponCode);
        ResponseData responseData = this.couponDefinitionServiceFeign.findCouponDefinitionCodeByCouponCode(couponCode);
        log.info("findCouponDefinitionCodeByCouponCode, responseData:{}", (Object)JSON.toJSONString((Object)responseData));
        if (responseData.getCode() == SysResponseEnum.SUCCESS.getCode()) {
            return (String)responseData.getData();
        }
        return "";
    }
}

