/*
 * Decompiled with CFR 0.152.
 */
package com.daas.nros.connector.server.middleware.mq.consumer;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.daas.nros.connector.client.burgeon.model.vo.VgAddGiveCouponVo;
import com.daas.nros.connector.client.model.result.Result;
import com.daas.nros.connector.server.service.api.burgeon.CrmJointService;
import com.daas.nros.connector.server.service.api.burgeon.VgCouponService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@RocketMQMessageListener(topic="coupon_to_offline_give_coupon_entity_topic", tags={"give"})
public class GiveCouponShopListener
implements RocketMQListener<JSONObject> {
    private static final Logger log = LoggerFactory.getLogger(GiveCouponShopListener.class);
    @Autowired
    private CrmJointService crmJointService;
    @Autowired
    private VgCouponService vgCouponService;
    private static Byte couponOfflineChannel = 1;
    private static Byte couponAllChannel = 2;

    public void onMessage(ConsumerMessage<JSONObject> consumerMessage) {
        log.info("GiveCouponShopListener topic:{} on message body : {}", (Object)"coupon_to_offline_give_coupon_entity_topic", consumerMessage.getMessage());
        JSONObject body = (JSONObject)consumerMessage.getMessage();
        VgAddGiveCouponVo vgCancelCouponVo = (VgAddGiveCouponVo)JSON.parseObject((String)JSON.toJSONString((Object)body), (TypeReference)new TypeReference<VgAddGiveCouponVo>(){}, (Feature[])new Feature[0]);
        Result offlineResult = null;
        Result<JSONObject> posResult = null;
        if (couponOfflineChannel.equals(vgCancelCouponVo.getUseChannel())) {
            posResult = this.vgCouponService.giveCoupon(body);
        } else if (couponAllChannel.equals(vgCancelCouponVo.getUseChannel())) {
            offlineResult = this.crmJointService.snyCouponTransfer(vgCancelCouponVo);
            posResult = this.vgCouponService.giveCoupon(body);
        } else {
            log.info("\u975e\u7ebf\u4e0b\u5238\u6216\u5168\u6e20\u9053\u5238\uff0c\u4e0d\u5904\u7406");
        }
        log.info("coupon_to_offline_give_coupon_entity_topic,offlineResult:{}", (Object)JSON.toJSONString(offlineResult));
        log.info("coupon_to_offline_give_coupon_entity_topic,posResult:{}", (Object)JSON.toJSONString(posResult));
    }
}

