package com.daas.nros.connector.server.tool.httpbatchshop;

import com.daas.nros.connector.client.burgeon.model.req.SnyMemberCouponReq;
import com.daas.nros.connector.client.exception.AnalysysShopException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShopHttpSendBatch {

	private static Logger logger = LoggerFactory.getLogger(ShopHttpSendBatch.class.getName());

	private final ShopCollecter collecter;

	/**
	 * 构造方法
	 * @param collecter 消息收集器
	 */
	public ShopHttpSendBatch(ShopCollecter collecter){
		this.collecter = collecter;
	}

	/**
	 * 立即发送所有收集的信息到服务器
	 */
	public void flush() {
	    this.collecter.flush();
	}
	
	public void shutdown() {
	    this.collecter.close();
	}
	

	/**
	 * 发券数据
	 * @throws AnalysysShopException 自定义异常
	 */
	public void track(SnyMemberCouponReq snyMemberCouponReq) throws AnalysysShopException {
		upload(snyMemberCouponReq);
	}
	/**
	 * 上传数据
	 * @param snyMemberCouponReq 券数据
	 * @throws AnalysysShopException 自定义异常
	 */
	private void upload(SnyMemberCouponReq snyMemberCouponReq){
		boolean ret = this.collecter.sendCoupon(snyMemberCouponReq);
		if(ret){
			logger.info(String.format("%s success.", ret));
		}
	}
}
