package com.daas.nros.connector.server.tool.httpbatchshop;

import com.alibaba.fastjson.JSON;

import com.daas.nros.connector.client.burgeon.model.req.SnyMemberCouponReq;
import com.daas.nros.connector.client.constants.Constant;
import com.daas.nros.connector.client.model.result.Result;
import com.daas.nros.connector.server.service.component.SpringComponent;
import com.daas.nros.connector.server.service.impl.burgeon.CouponServiceImpl;
import com.daas.nros.connector.server.service.impl.burgeon.CrmJointServiceImpl;
import org.apache.poi.ss.formula.functions.T;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class BatchShopCollecter implements ShopCollecter {

	private static Logger logger = LoggerFactory.getLogger(BatchShopCollecter.class.getName());

	private long sendTimer = -1;

	private boolean isListen = true;

	private final String serverUrl;

	private final int batchNum;

	private final long batchSec;

	private final boolean interrupt;

	private final List<SnyMemberCouponReq> batchShopMsgList;

	private ExecutorService singleShopThread;

	private final String topic;

	/**
	 * 构造方法
	 * @param serverUrl 数据接收服务地址
	 * @param batchNum 批量发送数量
	 * @param batchSec 批量发送等待时间(秒)
	 */
	public BatchShopCollecter(String serverUrl, int batchNum, long batchSec, String topic ){
		this(serverUrl, batchNum, batchSec, false,topic);
	}

	/**
	 * 构造方法
	 * @param serverUrl 数据接收服务地址
	 * @param batchNum 批量发送数量
	 * @param batchSec 批量发送等待时间(秒)
	 * @param interrupt 是否中断程序
	 */
	public BatchShopCollecter(String serverUrl, int batchNum, long batchSec, boolean interrupt, String topic ){
		this.topic=topic;
		this.serverUrl = serverUrl;
		this.interrupt = interrupt;
		this.batchNum = batchNum;
		this.batchSec = batchSec * 1000;
		this.batchShopMsgList = new ArrayList<SnyMemberCouponReq>(this.batchNum);
		this.singleShopThread = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
		init();
	}

	private void init(){
		this.singleShopThread.execute(new Runnable() {
			@Override
			public void run() {
				while(isListen){
					try { Thread.sleep(1000); } catch (Exception e1) {System.out.println(e1);}
					if (sendTimer != -1 && (System.currentTimeMillis() - sendTimer >= batchSec)) {
						try {
							upload();
						} catch (Exception e) {}
					}
				}
			}
		});
	}

	@Override
	public boolean sendCoupon(SnyMemberCouponReq snyMemberCouponReq) {
		synchronized (batchShopMsgList) {
			if(sendTimer == -1){
				sendTimer = System.currentTimeMillis();
			}
			List<String> couponCodeList = batchShopMsgList.stream().map(SnyMemberCouponReq::getCouponId).collect(Collectors.toList());
			if(couponCodeList.contains(snyMemberCouponReq.getCouponId())){
				logger.info("BatchShopCollecter couponCodeList contains couponCode:{}",snyMemberCouponReq.getCouponId());
				return true;
			}
			batchShopMsgList.add(snyMemberCouponReq);
			if (batchShopMsgList.size() >= batchNum) {
				upload();
			}
		}
		return true;
	}
	@Override
	public void upload() {
		synchronized (batchShopMsgList) {
			if(batchShopMsgList != null && batchShopMsgList.size() > 0){
				Byte coupStatus = 0;
				try {
					logger.info(String.format("Send shop message to topic: %s \ndata size: %s", topic, batchShopMsgList.size()));
					CrmJointServiceImpl crmJointServiceImpl = SpringComponent.getBean(CrmJointServiceImpl.class);
					Result<T> result = crmJointServiceImpl.snyMemberCoupon(batchShopMsgList);
					logger.info("crmJointServiceImpl.snyMemberCoupon:{}", JSON.toJSONString(result));

					if(Constant.INT_ZERO == result.getCode()){
						coupStatus = 1;
					}
				}  catch (Exception e) {
					if(interrupt){
						shutdown();
						throw new RuntimeException("Upload Data Error", e);
					} else {
						logger.error("批量发券失败send_coupon:"+e.getMessage());
					}
				} finally {
					CouponServiceImpl couponSingleService = SpringComponent.getBean(CouponServiceImpl.class);
					for(int i = 0; i< batchShopMsgList.size(); i++){
						SnyMemberCouponReq snyMemberCouponReq = batchShopMsgList.get(i);
						// JH 品牌默认回调发券成功
						if(Constant.JH_CLUB.equals(batchShopMsgList.get(i).getBrandCode())) {
							try {
								couponSingleService.callbackSingleCoupon(snyMemberCouponReq.getCouponId(),Constant.BYTE_ONE,snyMemberCouponReq.getIfSendAgain());
							}catch (Exception e){
								logger.error("send_coupon状态回调失败:{} couponCode:{}"+e.getMessage(),snyMemberCouponReq.getCouponId());
							}
						} else {
							try {
								couponSingleService.callbackSingleCoupon(snyMemberCouponReq.getCouponId(),coupStatus,snyMemberCouponReq.getIfSendAgain());
							}catch (Exception e){
								logger.error("send_coupon状态回调失败:{} couponCode:{}"+e.getMessage(),snyMemberCouponReq.getCouponId());
							}
						}
					}
					batchShopMsgList.clear();
					resetTimer();
				}
			}
		}
	}
	
	@Override
	public void flush() {
		upload();
	}
	
	@Override
	public void close() {
		flush();
		shutdown();
	}
	
	private void shutdown(){
		this.isListen = false;
		try {
			this.singleShopThread.shutdown();
			this.singleShopThread.awaitTermination(5, TimeUnit.SECONDS);
		} catch (Exception e) {
			this.singleShopThread = null;
		}
	}
	
	private void resetTimer(){
		this.sendTimer = -1;
	}
}
