package com.daas.nros.connector.server.tool.httpbatch;

import com.daas.nros.connector.client.burgeon.model.vo.VgAddCouponCrmVO;
import com.daas.nros.connector.client.exception.AnalysysException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


public class HttpSendBatch {

    private static Logger logger = LoggerFactory.getLogger(HttpSendBatch.class.getName());

    private final Collecter collecter;

    /**
     * 构造方法
     *
     * @param collecter 消息收集器
     */
    public HttpSendBatch(Collecter collecter) {
        this.collecter = collecter;
    }

    /**
     * 立即发送所有收集的信息到服务器
     */
    public void flush() {
        this.collecter.flush();
    }

    public void shutdown() {
        this.collecter.close();
    }


    /**
     * 发券数据
     *
     * @throws AnalysysException 自定义异常
     */
    public void track(VgAddCouponCrmVO vgAddCouponCrmVO) throws AnalysysException {
        upload(vgAddCouponCrmVO);
    }

    /**
     * 上传数据
     *
     * @param vgAddCouponCrmVO 券数据
     * @throws AnalysysException 自定义异常
     */
    private void upload(VgAddCouponCrmVO vgAddCouponCrmVO) {
        boolean ret = this.collecter.sendCoupon(vgAddCouponCrmVO);
        if (ret) {
            logger.info(String.format("%s success.", ret));
        }
    }
}
