package com.daas.nros.connector.server.service.impl.weimob;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONArray;
import com.bizvane.centerstageservice.rpc.SysBojunDataServiceRpc;

import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.daas.nros.connector.client.burgeon.model.req.VidDetailReq;
import com.daas.nros.connector.client.constants.Constant;
import com.daas.nros.connector.server.mapper.WmApiRecordPOMapper;
import com.daas.nros.connector.client.enums.CrmWmFieldMappingTypeEnum;
import com.daas.nros.connector.client.model.po.SysCrmWmFieldMappingPO;
import com.daas.nros.connector.client.model.po.WmApiRecordPO;
import com.daas.nros.connector.server.service.component.RedisCacheComponent;
import com.daas.nros.connector.server.service.component.WmSystemHttpClientComponent;
import com.daas.nros.connector.server.service.conver.WmConverFactory;
import com.daas.nros.connector.server.service.api.weimob.SysCrmWmFieldMappingService;
import com.daas.nros.connector.client.weimob.constant.WmSystemConstant;
import com.daas.nros.connector.client.weimob.model.req.GuiderWidReq;
import com.daas.nros.connector.client.weimob.model.req.MemberWidReq;
import com.daas.nros.connector.client.weimob.model.req.VidReq;
import com.daas.nros.connector.client.weimob.model.result.WmResultVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.PostConstruct;
import java.util.*;

/**
 * 调用微盟接口API地址
 * @anthor shifeng
 * @version 1.0.1
 * 2022-11-27 16:47:08
 */
@Slf4j
@Component
public class WmAPiComponent {

    // 返回成功标识符
    public static final String SUCCESS_CODE = "0";

    @Autowired
    private WmSystemHttpClientComponent wmSystemHttpClientComponent;

    @Autowired
    private SysBojunDataServiceRpc sysBojunDataServiceRpc;

    //log
    @Autowired
    private WmApiRecordPOMapper wmApiRecordPOMapper;

    @Autowired
    private SysCrmWmFieldMappingService sysCrmWmFieldMappingService;

    @Autowired
    public RedisCacheComponent redisCacheComponent;

    /**
     *记录api请求
     * @anthor shifeng
     * @param  topic 业务 topic
     * @param  requestBody 请求报文
     * @param  responseBody  返回报文
     * @return void
     * 2022-12-1 14:16:48
     */
    public void saveApiRecord(String topic, String requestBody, String responseBody) {
        try {
            WmApiRecordPO wmApiRecordPO = new WmApiRecordPO();
            wmApiRecordPO.setCreateDate(new Date());
            wmApiRecordPO.setRequestTime(new Date());
            wmApiRecordPO.setRequestTopic(topic);
            wmApiRecordPO.setPriKey(Long.toString(System.currentTimeMillis()));
            wmApiRecordPO.setRequestMessageBody(requestBody);
            wmApiRecordPO.setResponseMessageBody(responseBody);
            wmApiRecordPOMapper.insertSelective(wmApiRecordPO);
        } catch (Exception e) {
            log.info("saveApiRecord , exception : {}", e.getMessage());
        }
    }


    /**
     *记录api请求
     * @anthor shifeng
     * @param  topic 业务 topic
     * @param  requestBody 请求报文
     * @param  responseBody  返回报文
     * @return void
     * 2022-12-1 14:16:48
     */
    public void saveApiRecord(String topic, String priKey, String requestBody, String responseBody) {
        try {
            WmApiRecordPO wmApiRecordPO = new WmApiRecordPO();
            wmApiRecordPO.setCreateDate(new Date());
            wmApiRecordPO.setRequestTime(new Date());
            wmApiRecordPO.setPriKey(priKey);
            wmApiRecordPO.setRequestTopic(topic);
            wmApiRecordPO.setRequestMessageBody(requestBody);
            wmApiRecordPO.setResponseMessageBody(responseBody);
            wmApiRecordPOMapper.insertSelective(wmApiRecordPO);
        } catch (Exception e) {
            log.info("saveApiRecord , exception : {}", e.getMessage());
        }
    }

    /**
     * crm系统和微盟id映射关系表保存
     * @anthor shifeng
     * @retutrn
     * 2022-12-1 14:17:39
     */
    public void saveCrmAndWmId() {

    }

    /**
     * 获取会员的wid
     * @param phone 手机号码的
     * @return Long
     * @throws Exception
     * 2022-12-1 15:11:42
     */
    public Long getMemberWid(String phone) throws Exception {
        MemberWidReq memberWidReq = WmConverFactory.getMemberWidReq(phone);
        log.info("getMemberWid, param:{}", memberWidReq);
        String result = wmSystemHttpClientComponent.doPost(WmSystemConstant.MEMBER_WID, JSON.toJSONString(memberWidReq));
        log.info("getMemberWid , result:{}", JSON.toJSONString(result));
        WmResultVo resultVo = JSON.parseObject(result, WmResultVo.class);
        if (resultVo.getCode() != null && SUCCESS_CODE.equals(resultVo.getCode().getErrcode()) && resultVo.getData() != null) {
            return resultVo.getData().getLong("superWid");
        }
        throw new Exception("获取会员微盟对接wid失败！");
    }

    /**
     * 获取会员等级ID
     * @param levelName
     * @param membershipPlanId
     * @return Long
     */
    public Long getMemberLevelId(String levelName, Long membershipPlanId) throws Exception {
        JSONObject json = new JSONObject();
        json.put("membershipPlanId", membershipPlanId);
        json.put("privilegeType", "GOODS_DISCOUNT");
        String result = wmSystemHttpClientComponent.doPost(WmSystemConstant.MEMBER_LEVEL, json.toJSONString());
        log.info("getMemberLevelId , result:{}", JSON.toJSONString(result));
        WmResultVo resultVo = JSON.parseObject(result, WmResultVo.class);
        if (resultVo.getCode() != null && SUCCESS_CODE.equals(resultVo.getCode().getErrcode()) && resultVo.getData() != null) {
            JSONObject jsonObj = resultVo.getData();
            if (jsonObj.getJSONArray("levelPrivilege") != null) {
                JSONArray jsonArray = jsonObj.getJSONArray("levelPrivilege");
                for (Integer index = 0; index < jsonArray.size(); index ++ ) {
                    if (levelName.equals(jsonArray.getJSONObject(index).getString("levelName"))) {
                        return jsonArray.getJSONObject(index).getLong("levelId");
                    }
                }
            }
        }
        throw new Exception("获取会员等级wid失败！");
    }


    /**
     * 获取会员的wid
     * @param phone 手机号码的
     * @return Long
     * @throws Exception
     * 2022-12-1 15:11:42
     */
    public Long getGuiderWid(String phone) throws Exception {
        GuiderWidReq guiderWidReq = WmConverFactory.getGuiderWidReq(phone);
        log.info("getGuiderWid, param:{}", guiderWidReq);
        String result = wmSystemHttpClientComponent.doPost(WmSystemConstant.GUIDER_WID, JSON.toJSONString(guiderWidReq));
        log.info("getGuiderWid , result:{}", JSON.toJSONString(result));
        WmResultVo resultVo = JSON.parseObject(result, WmResultVo.class);
        if (resultVo.getCode() != null && SUCCESS_CODE.equals(resultVo.getCode().getErrcode()) && resultVo.getData() != null) {
            return resultVo.getData().getLong("guiderWid");
        }
        throw new Exception("获取导购微盟对接wid失败！");
    }

    /**
     * 获取会员的wid
     * @param phone 手机号码的
     * @return Long
     * @throws Exception
     * 2022-12-1 15:11:42
     */
    public Long checkGuiderWid(String phone){
        GuiderWidReq guiderWidReq = WmConverFactory.getGuiderWidReq(phone);
        log.info("getGuiderWid, param:{}", guiderWidReq);
        String result = wmSystemHttpClientComponent.doPost(WmSystemConstant.GUIDER_WID, JSON.toJSONString(guiderWidReq));
        log.info("getGuiderWid , result:{}", JSON.toJSONString(result));
        WmResultVo resultVo = JSON.parseObject(result, WmResultVo.class);
        if (resultVo.getCode() != null && SUCCESS_CODE.equals(resultVo.getCode().getErrcode()) && resultVo.getData() != null) {
            return resultVo.getData().getLong("guiderWid");
        }
        return null;
    }


    /**
     * @param type
     * @return Long
     * 2022-12-1 20:16:29
     */
    public Long getVid(Integer type) throws Exception{
        VidReq vidReq = WmConverFactory.getVidReq(type, 1, 1);
        log.info("getVid, param:{}", vidReq);
        String result = wmSystemHttpClientComponent.doPost(WmSystemConstant.ORG_QUERY_WID, JSON.toJSONString(vidReq));
        log.info("getVid , result:{}", JSON.toJSONString(result));
        WmResultVo resultVo = JSON.parseObject(result, WmResultVo.class);
        if (resultVo.getCode() != null && SUCCESS_CODE.equals(resultVo.getCode().getErrcode()) && resultVo.getData() != null) {
            JSONObject jsonObj = resultVo.getData();
            if (jsonObj.getIntValue("totalSize") > 0 && jsonObj.getJSONArray("data") != null) {
                JSONArray jsonArray = jsonObj.getJSONArray("data");
                return jsonArray.getJSONObject(0).getLongValue("vid");
            }
        }
        throw new Exception("获取导购微盟集团Vid失败！");
    }

    /**
     * 获取区域的vid
     * @param regionCode 区域code, 也就是伯俊属性id
     * @return Long
     * @throws Exception
     * 2022-12-1 15:11:42
     */
    public Long getRegionVid(String regionCode){
        log.info("getRegionVid,regionCode:{}", regionCode);
        // 1. 判断入参
        if (StringUtils.isBlank(regionCode)){
            return null;
        }
        // 2. 尝试从映射表获取
        Long regionVid = sysCrmWmFieldMappingService.findWmFieldByCrmField(regionCode, CrmWmFieldMappingTypeEnum.REGION_CODE.getCode(), Long.class);
        if (regionVid != null){
            return regionVid;
        }
        // 3. 调用微盟接口获取
        Map<String, String> paramMap = new HashMap<>();
        paramMap.put("vidCode", regionCode);
        log.info("getRegionVid,wmURL:{}, param:{}", WmSystemConstant.REGION_SEARCH_BY_CODE, JSON.toJSONString(paramMap));
        String result = wmSystemHttpClientComponent.doPost(WmSystemConstant.REGION_SEARCH_BY_CODE, JSON.toJSONString(paramMap));
        log.info("getRegionVid , result:{}", JSON.toJSONString(result));
        WmResultVo resultVo = JSON.parseObject(result, WmResultVo.class);
        if (resultVo.getCode() != null && SUCCESS_CODE.equals(resultVo.getCode().getErrcode()) && resultVo.getData() != null) {
            regionVid = resultVo.getData().getLong("vid");
            if (regionVid != null){
                // 添加映射表
                SysCrmWmFieldMappingPO sysCrmWmFieldMappingPO = sysCrmWmFieldMappingService.initSysCrmWmFieldMappingPO(regionVid.toString(), regionCode, CrmWmFieldMappingTypeEnum.REGION_CODE.getCode());
                sysCrmWmFieldMappingService.insertSysCrmWmFieldMapping(sysCrmWmFieldMappingPO);
            }
        }
        return regionVid;

    }

    /**
     * 通过门店code查询id
     * @param storeCode
     * @return Long
     * 2022-12-1 20:16:29
     */
    public Long getStoreVid(String storeCode) throws Exception{
        if (StringUtils.isEmpty(storeCode)) {
            log.info("getStoreVid, param:{}", storeCode);
        }
        // 尝试从映射表中取值
        String vid = sysCrmWmFieldMappingService.findWmFieldByCrmField(storeCode, CrmWmFieldMappingTypeEnum.STORE_CODE.getCode());
        if (StringUtils.isNotEmpty(vid)){
            return Long.valueOf(vid);
        }
        VidDetailReq vidDetailReq = new VidDetailReq();
        vidDetailReq.setVidCode(storeCode);
        log.info("getStoreVid, param:{}", vidDetailReq);
        String result = wmSystemHttpClientComponent.doPost(WmSystemConstant.ORG_DETAIL_QUERY_WID, JSON.toJSONString(vidDetailReq));
        log.info("getStoreVid , result:{}", JSON.toJSONString(result));
        WmResultVo resultVo = JSON.parseObject(result, WmResultVo.class);
        if (resultVo.getCode() != null && SUCCESS_CODE.equals(resultVo.getCode().getErrcode()) && resultVo.getData() != null) {
            JSONObject jsonObj = resultVo.getData();
            Long vidLong = jsonObj.getLong("vid");
            addCrmAndWmFieldMapping(storeCode, vidLong);
            return vidLong;
        }
        log.info("getStoreVid, param:{}", storeCode);
        return null;
    }

    /**
     * 获取商品id
     * @param goodsCode
     * @return
     * @throws Exception
     */
    public String getGoodsId(String goodsCode){
        if (StringUtils.isEmpty(goodsCode)) {
            return "";
        }
        // 尝试从映射表中取值
        log.info("getGoodsId, param:{}", goodsCode);
        String redisValue = redisCacheComponent.getCacheObject("WM_GOODS_" + goodsCode);
        if (StringUtils.isNotEmpty(redisValue)) {
            return redisValue;
        }
        String goodsId = sysCrmWmFieldMappingService.findWmFieldByCrmField(goodsCode, CrmWmFieldMappingTypeEnum.GOODS_CODE.getCode());
        log.info("getGoodsId, result:{}", goodsId);
        if (StringUtils.isNotEmpty(goodsId)) {
            redisCacheComponent.setCacheObject("WM_GOODS_" + goodsCode, goodsId);
        }
        return goodsId;
    }

    /**
     * 添加CRM与微盟字段映射
     * @param storeCode
     * @param vid
     */
    private void addCrmAndWmFieldMapping(String storeCode, Long vid){
        log.info("addCrmAndWmFieldMapping：storeCode:{}, vid:{}", storeCode, vid);
        SysCrmWmFieldMappingPO mappingPO = sysCrmWmFieldMappingService.initSysCrmWmFieldMappingPO(vid.toString(), storeCode, CrmWmFieldMappingTypeEnum.STORE_CODE.getCode());
        sysCrmWmFieldMappingService.insertSysCrmWmFieldMapping(mappingPO);
        log.info("addCrmAndWmFieldMapping：end");
    }

    /**
     * 项目启动时映射
     */
    @PostConstruct
    public void initWmMappingCrm(){
        // 项目启动映射 区域关系
        initRegionMapping();
    }

    /**
     * 初始化区域映射
     */
    private void initRegionMapping(){
        log.info("initRegionMapping start--------");
        // 1。 查询是否已有映射数据，只有在没有映射过的时候，才会进行映射
        if (sysCrmWmFieldMappingService.isExistByMappingType(CrmWmFieldMappingTypeEnum.REGION_CODE.getCode())){
            log.info("initRegionMapping 已经映射过了----");
            return;
        }

        // 2. 查询伯俊品牌id为 bojun_brand_id(VG-CLUB)的伯俊code
        List<String> crmRegionCodeList = findCrmRegionCode();
        if (CollectionUtils.isEmpty(crmRegionCodeList)){
            log.info("initRegionMapping crmRegionCodeList is NULL");
            return;
        }
        log.info("initRegionMapping crmRegionCodeList:{}", JSON.toJSONString(crmRegionCodeList));

        // 3. 调用微盟全量查询区域接口
        Map<String, Long> regionMap = new HashMap<>();
        for (int index = 1; index < 100; index++) {
            Map<String, Long> regionMapTemp = selectRegionPage(index, index * 50);
            if (CollectionUtils.isEmpty(regionMapTemp)){
                log.info("initRegionMapping regionMap is NULL");
                break;
            }
            regionMap.putAll(regionMapTemp);
            if (regionMapTemp.size() < 50){
                break;
            }
        }
        log.info("initRegionMapping regionMap:{}", JSON.toJSONString(regionMap));
        // 添加映射关系到数据库
        for (String regionCode : crmRegionCodeList) {
            Long wmVid = regionMap.get(regionCode);
            if (wmVid == null){
                continue;
            }
            SysCrmWmFieldMappingPO sysCrmWmFieldMappingPO = sysCrmWmFieldMappingService.initSysCrmWmFieldMappingPO(wmVid.toString(), regionCode, CrmWmFieldMappingTypeEnum.REGION_CODE.getCode());
            sysCrmWmFieldMappingService.insertSysCrmWmFieldMapping(sysCrmWmFieldMappingPO);
        }
    }

    /**
     * 查询crm区域code
     * @return
     */
    private List<String> findCrmRegionCode(){
        List<String> propIdList = new ArrayList<>();
        log.info("findCrmRegionCode, brandCode:{}", Constant.VG_CLUB);
        ResponseData<List<String>> bojunResponse = sysBojunDataServiceRpc.findSysBojunPropIdByBrandCode(Constant.VG_CLUB);
        if (bojunResponse.getCode() == SysResponseEnum.SUCCESS.getCode()){
            propIdList = bojunResponse.getData();
        }
        log.info("findCrmRegionCode, result:{}", JSON.toJSONString(bojunResponse));
        return propIdList;
    }

    /**
     * 查询微盟区域id
     * @return
     */
    private Map<String, Long> selectRegionPage(int pageNum, int pageSize){
        Map<String, Long> resultMap = new HashMap<>();
        Map<String, Integer> param = new HashMap<>();
        param.put("isDirect", 0);
        param.put("vidType", 3);
        param.put("vidStatus", 1);
        param.put("pageSize", pageSize);
        param.put("pageNum", pageNum);
        log.info("selectRegionPage, param:{}", JSON.toJSONString(param));
        String result = wmSystemHttpClientComponent.doPost(WmSystemConstant.REGION_PAGE_SEARCH, JSON.toJSONString(param));
        log.info("selectRegionPage , result:{}", JSON.toJSONString(result));
        WmResultVo resultVo = JSON.parseObject(result, WmResultVo.class);
        if (resultVo.getCode() != null && SUCCESS_CODE.equals(resultVo.getCode().getErrcode()) && resultVo.getData() != null) {
            JSONObject jsonObj = resultVo.getData();
            JSONArray resultArr = jsonObj.getJSONArray("data");
            if (resultArr != null){
                for (int i = 0; i < resultArr.size(); i++) {
                    JSONObject jsonObject = resultArr.getJSONObject(i);
                    String vidCode = jsonObject.getString("vidCode");
                    Long vid = jsonObject.getLong("vid");
                    resultMap.put(vidCode, vid);
                }
            }
        }
        return resultMap;
    }

}
