package com.daas.nros.connector.server.service.impl.weimob;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.couponfacade.interfaces.CouponDefinitionServiceFeign;
import com.bizvane.couponfacade.interfaces.CouponEntityServiceFeign;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.OrderDetailModel;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.daas.nros.connector.server.config.weimob.WMSystemFieldConfig;
import com.daas.nros.connector.server.mapper.MbrMembersPoMapper;
import com.daas.nros.connector.server.mapper.SysWeiMengPOMapper;
import com.daas.nros.connector.server.mapper.WmApiRecordPOMapper;
import com.daas.nros.connector.client.enums.CrmWmFieldMappingTypeEnum;
import com.daas.nros.connector.client.enums.StringBrandCode;
import com.daas.nros.connector.client.model.po.*;
import com.daas.nros.connector.client.model.result.Result;
import com.daas.nros.connector.server.service.component.WmSystemHttpClientComponent;
import com.daas.nros.connector.server.service.conver.WmConverFactory;
import com.daas.nros.connector.server.service.api.weimob.SysCrmWmFieldMappingService;
import com.daas.nros.connector.server.service.api.weimob.SysWeimengService;
import com.daas.nros.connector.client.weimob.constant.WmSystemConstant;
import com.daas.nros.connector.client.weimob.constant.WmTopicConstant;
import com.daas.nros.connector.client.weimob.model.req.*;
import com.daas.nros.connector.client.weimob.model.req.param.*;
import com.daas.nros.connector.client.weimob.model.result.WmMemberBaseInfoDto;
import com.daas.nros.connector.client.weimob.model.result.WmResultArrayVo;
import com.daas.nros.connector.client.weimob.model.result.WmResultVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;


/**
 *  微盟对接CRM ，会员wid转换
 */
@Slf4j
@Service
public class SysWeimengServiceImpl implements SysWeimengService {

    @Value("${wm.isopen:9}")
    private String isOpen;

    public static final String IS_OPEN = "9";

    @Autowired
    private WMSystemFieldConfig wmSystemFieldConfig;

    @Autowired
    private SysWeiMengPOMapper sysWeiMengPOMapper;

    @Resource
    private MbrMembersPoMapper mbrMembersPoMapper;

    @Autowired
    private WmSystemHttpClientComponent wmSystemHttpClientComponent;

    @Autowired
    private SysCrmWmFieldMappingService sysCrmWmFieldMappingService;

    @Autowired
    private CouponDefinitionServiceFeign couponDefinitionServiceFeign;

    @Autowired
    private CouponEntityServiceFeign couponEntityServiceFeign;

    // 组件
    @Autowired
    private WmAPiComponent wmAPiComponent;

    @Autowired
    private WmApiRecordPOMapper wmApiRecordPOMapper;

    @Autowired
    private BrandServiceRpc brandServiceRpc;

    // 返回成功标识符
    public static final String SUCCESS_CODE = "0";


    // 客户端身份标识
    @Value("${wm.membershipPlanId:800825244}")
    private Long membershipPlanId;

    /**
     * 会员新增接口
     * @param  memberInfoModelParams
     * @return Result
     * 2022-12-1 14:08:23
     */
    @Override
    public Result<Object> addMemberInfoTowm(List<MemberInfoModelParam> memberInfoModelParams) {
        log.info("addMemberInfoTowm, start:{}", JSON.toJSONString(memberInfoModelParams));
        Result<Object> resultData = new Result<>();
        try {
            // 参数转换
            MemberReq memberReq = new MemberReq();
            memberReq.setImportType(2);
            memberReq.setMembershipPlanId(membershipPlanId);
            List<MemberInfo> userList = new ArrayList<>();
            for (MemberInfoModelParam memberInfoModelParam : memberInfoModelParams) {
                MemberInfo memberInfo = new MemberInfo();
                memberInfo.setPhone(memberInfoModelParam.getPhone());
                memberInfo.setRegionCode("86");
                memberInfo.setUnionId(memberInfoModelParam.getWxUnionId());
                memberInfo.setOpenId(memberInfoModelParam.getWxOpenId());
                memberInfo.setAppId("");
                memberInfo.setAppChannel(5);
                memberInfo.setUserName(memberInfoModelParam.getName());
                memberInfo.setGender(WmConverFactory.converGender(memberInfoModelParam.getGender()));
                if (WmConverFactory.getTimeStampFromData(memberInfoModelParam.getBirthday()) != null) {
                    memberInfo.setBirthday(WmConverFactory.getTimeStampFromData(memberInfoModelParam.getBirthday()));
                }
                memberInfo.setBelongVidName(memberInfoModelParam.getServiceStoreName());
                memberInfo.setCustomCardNo(memberInfoModelParam.getCardNo());
                memberInfo.setLevelName(memberInfoModelParam.getLevelName());
                memberInfo.setBalance(0);
                memberInfo.setTotalBalance(0);
                if (StringUtils.isNotEmpty(memberInfoModelParam.getServiceGuiderPhone())) {
                    if (!"13120738909".equals(memberInfoModelParam.getServiceGuiderPhone())) {
                        // 获取一下vid 不存在不存
                        if (wmAPiComponent.checkGuiderWid(memberInfoModelParam.getServiceGuiderPhone()) != null) {
                            memberInfo.setGuiderPhone(memberInfoModelParam.getServiceGuiderPhone());
                        }
                    }
                }
                if (WmConverFactory.getTimeStampFromData(memberInfoModelParam.getCreateDate()) != null) {
                    memberInfo.setBecomeMemberTime(WmConverFactory.getTimeStampFromData(memberInfoModelParam.getCreateDate()));
                }
                memberInfo.setMembershipCardChannel(1);
                // 开卡门店
                if (StringUtils.isNotEmpty(memberInfoModelParam.getOpenCardStoreCode())) {
                    Long storeId = wmAPiComponent.getStoreVid(memberInfoModelParam.getOpenCardStoreCode());
                    if (storeId != null) {
                        memberInfo.setSourceVid(storeId);
                    }
                }
                // 导购门店
                if (StringUtils.isNotEmpty(memberInfoModelParam.getServiceStoreCode())) {
                    Long storeId = wmAPiComponent.getStoreVid(memberInfoModelParam.getServiceStoreCode());
                    if (storeId != null) {
                        memberInfo.setSourceVid(storeId);
                    }
                }
                userList.add(memberInfo);
            }
            memberReq.setUserList(userList);
            log.info("addMemberInfoTowm, param:{}", JSON.toJSONString(memberReq));
            String result = wmSystemHttpClientComponent.doPost(WmSystemConstant.MEMBER_INSERT, JSON.toJSONString(memberReq));
            log.info("addNewMemberLaberTowm , result:{}", JSON.toJSONString(result));
            WmResultVo resultVo = JSON.parseObject(result, WmResultVo.class);
            // 记录下请求日志
            wmAPiComponent.saveApiRecord(WmTopicConstant.MEMNER_ADD ,JSON.toJSONString(memberReq), result);
            if (resultVo.getCode() != null && SUCCESS_CODE.equals(resultVo.getCode().getErrcode())) {
                resultData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                resultData.setCode(SysResponseEnum.SUCCESS.getCode());
                return resultData;
            }
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(SysResponseEnum.FAILED.getCode());
            return resultData;
        } catch (Exception e) {
            log.info("addMemberInfoTowm , excepion :{}",e );
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(SysResponseEnum.FAILED.getCode());
            return resultData;
        }
    }

    /**
     * 更新会员等级信息接口
     * @param memberInfoModelParam
     * @return Result
     * 2022-12-1 14:46:48
     */
    @Override
    public Result<Object> updateMemberLevelTowm(MemberInfoModelParam memberInfoModelParam) {
        log.info("updateMemberLevelToWm, start:{}", JSON.toJSONString(memberInfoModelParam));
        Result<Object> resultData = new Result<>();
        try {
            // 参数转换
            MemberLevelChangeReq memberLevelChangeReq = WmConverFactory.getMemberLevelReq(memberInfoModelParam);
            memberLevelChangeReq.setMembershipPlanId(membershipPlanId);
            memberLevelChangeReq.setWid(wmAPiComponent.getMemberWid(memberInfoModelParam.getPhone()));
            memberLevelChangeReq.setLevelId(wmAPiComponent.getMemberLevelId(memberInfoModelParam.getLevelName(), membershipPlanId));
            log.info("updateMemberLevelToWm, param:{}", memberLevelChangeReq);
            String result = wmSystemHttpClientComponent.doPost(WmSystemConstant.UPDATE_MEMBER_LEVEL, JSON.toJSONString(memberLevelChangeReq));
            log.info("updateMemberLevelToWm , result:{}", JSON.toJSONString(result));
            // 记录下请求日志
            wmAPiComponent.saveApiRecord(WmTopicConstant.MEMNER_LEVEL_UPDATE, Long.toString(memberInfoModelParam.getMbrMemberId()), JSON.toJSONString(memberLevelChangeReq), result);
            // 结果处理
            WmResultVo resultVo = JSON.parseObject(result, WmResultVo.class);
            if (resultVo.getCode() != null && SUCCESS_CODE.equals(resultVo.getCode().getErrcode())) {
                resultData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                resultData.setCode(SysResponseEnum.SUCCESS.getCode());
                return resultData;
            }
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(SysResponseEnum.FAILED.getCode());
            return resultData;
        } catch (Exception e) {
            log.info("updateMemberLevelToWm , excepion :{}",e.getMessage());
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(SysResponseEnum.FAILED.getCode());
            return resultData;
        }
    }

    /**
     * 更新会员基本信息接口
     * @param memberInfoModelParam
     * @return Result
     * 2022-12-1 14:46:48
     */
    @Override
    public Result<Object> updateMemberInfoTowm(MemberInfoModelParam memberInfoModelParam) {
        log.info("updateMemberInfoTowm, start:{}", JSON.toJSONString(memberInfoModelParam));
        Result<Object> resultData = new Result<>();
        try {
            // 参数转换
            MemberUpdateReq memberUpdateReq = WmConverFactory.getMemberUpdateReq(memberInfoModelParam);
            memberUpdateReq.setWid(wmAPiComponent.getMemberWid(memberInfoModelParam.getPhone()));
            log.info("updateMemberInfoTowm, param:{}", memberUpdateReq);
            String result = wmSystemHttpClientComponent.doPost(WmSystemConstant.MEMBER_UPDATE, JSON.toJSONString(memberUpdateReq));
            log.info("updateMemberInfoTowm , result:{}", JSON.toJSONString(result));
            // 记录下请求日志
            wmAPiComponent.saveApiRecord(WmTopicConstant.MEMNER_INFO_UPDATE, Long.toString(memberInfoModelParam.getMbrMemberId()), JSON.toJSONString(memberUpdateReq), result);
            // 结果处理
            WmResultVo resultVo = JSON.parseObject(result, WmResultVo.class);
            if (resultVo.getCode() != null && SUCCESS_CODE.equals(resultVo.getCode().getErrcode())) {
                resultData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                resultData.setCode(SysResponseEnum.SUCCESS.getCode());
                return resultData;
            }
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(SysResponseEnum.FAILED.getCode());
            return resultData;
        } catch (Exception e){
            log.info("updateMemberInfoTowm , excepion :{}",e.getMessage());
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(SysResponseEnum.FAILED.getCode());
            return resultData;
        }
    }

    /**
     * 更新会员服务门店和导购信息接口
     * @param memberInfoModelParam
     * @return Result
     * 2022-12-1 14:46:48
     */
    @Override
    public Result<Object> updateMemberServiceTowm(MemberInfoModelParam memberInfoModelParam) {
        log.info("updateMemberServiceTowm, start:{}", JSON.toJSONString(memberInfoModelParam));
        Result<Object> resultData = new Result<>();
        try {
            long wid = wmAPiComponent.getMemberWid(memberInfoModelParam.getPhone());
            long stordWid = wmAPiComponent.getStoreVid(memberInfoModelParam.getServiceStoreCode());
            // 更新会员门店信息
            UpdateMemberStaffReq updateMemberStaffReq = new UpdateMemberStaffReq();
            Long guiderWid = wmAPiComponent.checkGuiderWid(memberInfoModelParam.getServiceGuiderPhone());
            if (guiderWid != null) {
                updateMemberStaffReq.setGuiderWid(guiderWid);
            }
            updateMemberStaffReq.setGuiderVid(stordWid);
            updateMemberStaffReq.setCustomerWid(wid);
            updateMemberStaffReq.setBindSceneType(10);
            updateMemberStaffReq.setModifyReasonType(19);
            log.info("updateMemberServiceTowm staff , param:{}", JSON.toJSONString(updateMemberStaffReq));
            String staffResult = wmSystemHttpClientComponent.doPost(WmSystemConstant.MEMBER_STAFF_UPDATE, JSON.toJSONString(updateMemberStaffReq));
            log.info("updateMemberServiceTowm staff , result:{}", JSON.toJSONString(staffResult));
            // 记录下请求日志
            wmAPiComponent.saveApiRecord(WmTopicConstant.MEMNER_INFO_UPDATE, Long.toString(memberInfoModelParam.getMbrMemberId()), JSON.toJSONString(updateMemberStaffReq), staffResult);
            WmResultVo staffResultVo = JSON.parseObject(staffResult, WmResultVo.class);
            if (staffResultVo == null || staffResultVo.getCode() == null || !SUCCESS_CODE.equals(staffResultVo.getCode().getErrcode())) {
                resultData.setMessage(SysResponseEnum.SYSTEM_ERROR.getMessage());
                resultData.setCode(SysResponseEnum.SYSTEM_ERROR.getCode());
                return resultData;
            }
            // 更新门店信息
            UpdateMemberStoreReq updateMemberStoreReq = new UpdateMemberStoreReq();
            updateMemberStoreReq.setScene(99);
            updateMemberStoreReq.setOrigin(1);
            updateMemberStoreReq.setOperateWid(0);
            updateMemberStoreReq.setReason("crm调整");
            updateMemberStoreReq.setVid(stordWid);
            List<Long> widList = new ArrayList<>();
            widList.add(wid);
            updateMemberStoreReq.setWidList(widList);
            log.info("updateMemberServiceTowm store , param:{}", JSON.toJSONString(updateMemberStoreReq));
            String storeResult = wmSystemHttpClientComponent.doPost(WmSystemConstant.MEMBER_STORE_UPDATE, JSON.toJSONString(updateMemberStoreReq));
            log.info("updateMemberServiceTowm store , result:{}", JSON.toJSONString(storeResult));
            // 记录下请求日志
            wmAPiComponent.saveApiRecord(WmTopicConstant.MEMNER_INFO_UPDATE, Long.toString(memberInfoModelParam.getMbrMemberId()), JSON.toJSONString(updateMemberStoreReq), storeResult);
            WmResultVo storeResultVo = JSON.parseObject(storeResult, WmResultVo.class);
            if (storeResultVo == null || storeResultVo.getCode() == null || !SUCCESS_CODE.equals(storeResultVo.getCode().getErrcode())) {
                resultData.setMessage(SysResponseEnum.SYSTEM_ERROR.getMessage());
                resultData.setCode(SysResponseEnum.SYSTEM_ERROR.getCode());
                return resultData;
            }
            resultData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            resultData.setCode(SysResponseEnum.SUCCESS.getCode());
            return resultData;
        } catch (Exception e) {
            log.info("updateMemberServiceTowm , excepion :{}",e.getMessage());
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(SysResponseEnum.FAILED.getCode());
            return resultData;
        }
    }

    @Override
    public Long findWeimengWidByPhone(String phone) {
        if (StringUtils.isBlank(phone)){
            return null;
        }
        SysWeiMengPOExample example = new SysWeiMengPOExample();
        SysWeiMengPOExample.Criteria criteria = example.createCriteria();
        criteria.andPhoneEqualTo(phone).andValidEqualTo(Boolean.TRUE);
        List<SysWeiMengPO> sysWeiMengPOS = sysWeiMengPOMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(sysWeiMengPOS)){
            return sysWeiMengPOS.get(0).getWid();
        }
        // 调用微盟接口，根据手机号查询
        Long wid = exectorFindWmMemberBaseInfo( phone, 1);
        log.info("findWeimengWidByPhone,wid:{}", wid);
        return wid;
    }


    @Override
    public Long findWeimengWidBySysMemberCode(String memberCode) {
        if (StringUtils.isBlank(memberCode)){
            return null;
        }
        MbrMembersPo member = findMbrMemberBy(memberCode, 2, StringBrandCode.vg.getValue());
        if (member == null){
            log.info("exectorFindWmMemberBaseInfo 查找不到会员，入参无效");
            return null;
        }

        // 调用微盟接口，根据手机号查询
        Long wid = findWeimengWidByPhone(member.getPhone());
        log.info("findWeimengWidBySysMemberCode,wid:{}", wid);
        return wid;
    }

    /**
     * 执行查找微盟wid
     * @param keyword
     * @param type
     * @return
     */
    private Long exectorFindWmMemberBaseInfo(String keyword, int type){
        MbrMembersPo member = findMbrMemberBy(keyword, type, StringBrandCode.vg.getValue());
        if (member == null){
            log.info("exectorFindWmMemberBaseInfo 查找不到会员，入参无效");
            return null;
        }
        WmMemberBaseInfoDto wmMember = findWmMemberBaseInfoByPhone(member.getPhone());
        if (wmMember == null){
            log.info("exectorFindWmMemberBaseInfo 调用WM 失败");
            return null;
        }
        Long wid = wmMember.getSuperWid();
        // 初始化数据到库
        initSysWeimeng(wid, member);
        return wid;
    }

    /**
     * 查找CRM VG 品牌下的会员信息
     * @param type 1: 手机号， 2：会员code，3. 会员卡号
     * @param keyword
     * @return
     */
    @Override
    public MbrMembersPo findMbrMemberBy(String keyword, int type, String brandCode){
        log.info("findMbrMemberBy,keyword:{}, type:{}, brandCode:{}", keyword, type, brandCode);
        Long sysCompanyId = 247L;
        ResponseData<SysBrandPo> brand = brandServiceRpc.getBrand(sysCompanyId, brandCode);
        if (brand.getCode() == SysResponseEnum.FAILED.getCode() || brand.getData() == null) {
            log.info("findMbrMemberBy, 获取品牌失败");
            return null;
        }
        Long brandId = brand.getData().getSysBrandId();
        MbrMembersPoExample membersPoExample = new MbrMembersPoExample();
        MbrMembersPoExample.Criteria criteria = membersPoExample.createCriteria();
        criteria.andSysCompanyIdEqualTo(247L).andValidEqualTo(Boolean.TRUE);
        if (type == 1){
            criteria.andPhoneEqualTo(keyword).andBrandIdEqualTo(brandId.intValue());
        }else if (type == 2){
            criteria.andMemberCodeEqualTo(keyword);
        } else{
            criteria.andCardNoEqualTo(keyword).andBrandIdEqualTo(brandId.intValue());
        }
        List<MbrMembersPo> mbrMembersPos = mbrMembersPoMapper.selectByExample(membersPoExample);
        if (CollectionUtils.isNotEmpty(mbrMembersPos)){
            log.info("findMbrMemberBy, result:{}", JSON.toJSONString(mbrMembersPos.get(0)));
            return mbrMembersPos.get(0);
        }
        log.info("findMbrMemberBy, result:null");
        return null;
    }

    /**
     *
     * @param wid
     * @param membersPo
     */
    private void initSysWeimeng(Long wid, MbrMembersPo membersPo){
        SysWeiMengPO sysWeiMengPO = new SysWeiMengPO();
        sysWeiMengPO.setWid(wid);
        sysWeiMengPO.setMbrMemberId(membersPo.getMbrMemberId());
        sysWeiMengPO.setMemberCode(membersPo.getMemberCode());
        sysWeiMengPO.setPhone(membersPo.getPhone());
        sysWeiMengPO.setValid(Boolean.TRUE);
        sysWeiMengPOMapper.insert(sysWeiMengPO);
    }

    /**
     * 根据手机号查找微盟会员基本信息
     * @param phone
     * @return
     */
    @Override
    public WmMemberBaseInfoDto findWmMemberBaseInfoByPhone(String phone) {
        log.info("findWmMemberBaseInfoByPhone,phone:{}", phone);
        if (StringUtils.isBlank(phone)){
            return null;
        }
        Map<String, Object> hashMap = new HashMap<>();
        hashMap.put("originalId", phone);
        hashMap.put("source", 4);
        String result = wmSystemHttpClientComponent.doPost(WmSystemConstant.GET_WM_MEMBER_BASE_INFO, JSON.toJSONString(hashMap));
        log.info("findWmMemberBaseInfoByPhone,result:{}", JSON.toJSONString(result));
        WmResultVo resultVo = JSON.parseObject(result, WmResultVo.class);
        if (resultVo == null || !WmSystemConstant.WM_RESULT_SUCCESS_STATUS.equals(resultVo.getCode().getErrcode())){
            log.info("getWmMemberBaseInfo error:{}", result);
            return null;
        }
        WmMemberBaseInfoDto wmMemberBaseInfoDto = JSON.toJavaObject(resultVo.getData(), WmMemberBaseInfoDto.class);
        return wmMemberBaseInfoDto;
    }

    /**
     * 同步会员标签新增
     * @anthor shifeng
     * @version 1.0.1
     * 2022-12-1 11:44:08
     */
    @Override
    public Result<Object> addNewMemberLabelTowm(List<MemberLabelInfoParam> memberLabelInfoParams) {
        Result<Object> resultData = new Result<>();
        log.info("addNewMemberLabelTowm, start:{}", JSON.toJSONString(memberLabelInfoParams));
        try {
            MemberLabelReq memberLabelReq = WmConverFactory.getMemberLabelReq(memberLabelInfoParams);
            memberLabelReq.setVid(wmSystemFieldConfig.getVid());
            log.info("addNewMemberLabelTowm , requet:{}", JSON.toJSONString(memberLabelReq));
            String result = wmSystemHttpClientComponent.doPost(WmSystemConstant.MEMBER_LABEL_INSERT, JSON.toJSONString(memberLabelReq));
            log.info("addNewMemberLaberTowm , result:{}", JSON.toJSONString(result));
            // 记录下请求日志
            wmAPiComponent.saveApiRecord(WmTopicConstant.MEMBR_LABEL_ADD, JSON.toJSONString(memberLabelReq), result);
            WmResultVo resultVo = JSON.parseObject(result, WmResultVo.class);
            // 记录下请求日志
            if (resultVo.getCode() != null && SUCCESS_CODE.equals(resultVo.getCode().getErrcode())) {
                // 解析结果
                if (resultVo.getData() != null && resultVo.getData().get("listVo") != null) {
                    JSONObject jsonObj = resultVo.getData();
                    JSONArray jsonArray = jsonObj.getJSONArray("listVo");
                    for (Integer index = 0; index < memberLabelInfoParams.size() ; index++) {
                        if (jsonArray.get(index) != null && memberLabelInfoParams.get(index) != null) {
                            SysCrmWmFieldMappingPO sysCrmWmFieldMappingPO = new SysCrmWmFieldMappingPO();
                            sysCrmWmFieldMappingPO.setWmField(jsonArray.getJSONObject(index).getString("tagId"));
                            sysCrmWmFieldMappingPO.setCrmField(Long.toString(memberLabelInfoParams.get(index).getMbrLabelGroupDefId()));
                            sysCrmWmFieldMappingPO.setMappingType(CrmWmFieldMappingTypeEnum.MEMBER_LABEL_GROUP_CODE.getCode());
                            sysCrmWmFieldMappingService.insertSysCrmWmFieldMapping(sysCrmWmFieldMappingPO);
                        }
                    }
                }
                try {
                    resultData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                    resultData.setCode(SysResponseEnum.SUCCESS.getCode());
                    return resultData;
                } catch (Exception e) {
                    log.info("addNewMemberLaberTowm , excepion :{}",e.getMessage());
                }
            }
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(SysResponseEnum.FAILED.getCode());
            return resultData;
        } catch (Exception e) {
            log.info("addNewMemberLaberTowm , excepion :{}",e.getMessage());
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(SysResponseEnum.FAILED.getCode());
            return resultData;
        }
    }

    /**
     * 同步会员属性
     * @anthor shifeng
     * @version 1.0.1
     * 2022-12-1 11:44:08
     */
    @Override
    public Result<Object> memberLabelAttrParam(List<MemberLabelAttrParam> memberLabelAttrParams) {
        Result<Object> resultData = new Result<>();
        log.info("memberLabelAttrParam, start:{}", JSON.toJSONString(memberLabelAttrParams));
        try  {
            Long vid = wmSystemFieldConfig.getVid();
            for (MemberLabelAttrParam memberLabelAttrParam : memberLabelAttrParams) {
                if (memberLabelAttrParam == null || memberLabelAttrParam.getMbrLabelDefId() == null) {
                    continue;
                }
                String wmId = sysCrmWmFieldMappingService.findWmFieldByCrmField(Long.toString(memberLabelAttrParam.getLabelGroupId()), CrmWmFieldMappingTypeEnum.MEMBER_LABEL_GROUP_CODE.getCode());
                if (StringUtils.isEmpty(wmId)) {
                    continue;
                }
                // 参数转换
                MemberLabelAttrReq memberLabelAttrReq = WmConverFactory.getMemberLabelAttrReq(memberLabelAttrParam);
                memberLabelAttrReq.setVid(vid);
                memberLabelAttrReq.setTagId(Long.valueOf(wmId));
                log.info("memberLabelAttrParam , requet:{}", JSON.toJSONString(memberLabelAttrReq));
                String result = wmSystemHttpClientComponent.doPost(WmSystemConstant.MEMBER_LABEL_ATTR_INSERT, JSON.toJSONString(memberLabelAttrReq));
                log.info("memberLabelAttrParam , result:{}", JSON.toJSONString(result));
                // 记录下请求日志
                wmAPiComponent.saveApiRecord(WmTopicConstant.MEMBR_LABEL_TYPE_ADD, Long.toString(memberLabelAttrParam.getMbrLabelDefId()), JSON.toJSONString(memberLabelAttrReq), result);
                WmResultVo resultVo = JSON.parseObject(result, WmResultVo.class);
                // 记录下请求日志
                if (resultVo == null || resultVo.getCode() == null || !SUCCESS_CODE.equals(resultVo.getCode().getErrcode())) {
                    resultData.setMessage(SysResponseEnum.FAILED.getMessage());
                    resultData.setCode(SysResponseEnum.FAILED.getCode());
                    return resultData;
                }
                JSONObject jsonObj = resultVo.getData();
                if (jsonObj != null) {
                    // 处理id映射
                    SysCrmWmFieldMappingPO sysCrmWmFieldMappingPO = new SysCrmWmFieldMappingPO();
                    sysCrmWmFieldMappingPO.setWmField(jsonObj.getString("attrId"));
                    sysCrmWmFieldMappingPO.setCrmField(Long.toString(memberLabelAttrParam.getMbrLabelDefId()));
                    sysCrmWmFieldMappingPO.setMappingType(CrmWmFieldMappingTypeEnum.MEMBER_LABEL_CODE.getCode());
                    sysCrmWmFieldMappingService.insertSysCrmWmFieldMapping(sysCrmWmFieldMappingPO);
                }
            }
            resultData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            resultData.setCode(SysResponseEnum.SUCCESS.getCode());
            return resultData;
        } catch (Exception e) {
            log.info("memberLabelAttrParam , excepion :{}", e.getMessage());
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(SysResponseEnum.FAILED.getCode());
            return resultData;
        }
    }

    /**
     * 同步会员标签新增
     * @anthor shifeng
     * @version 1.0.1
     * 2022-12-1 11:44:08
     */
    @Override
    public Result<Object> memberAddLabelBind(List<MemberInfoModelParam> memberInfoModelParams) {
        Result resultData = new Result<>();
        log.info("memberAddLabelBind, start:{}", JSON.toJSONString(memberInfoModelParams));
        try {
            MemberLabelAddReq memberLabelAddReq = WmConverFactory.getMemberLabelAddReq();
            memberLabelAddReq.setVid(wmSystemFieldConfig.getVid());
            // 获取人员信息集合
            List<Long> widList = new ArrayList<>();
            for (MemberInfoModelParam memberInfoModelParam : memberInfoModelParams) {
                if (memberInfoModelParam == null || StringUtils.isEmpty(memberInfoModelParam.getPhone())) {
                    continue;
                }
                widList.add(wmAPiComponent.getMemberWid(memberInfoModelParam.getPhone()));
                // 数据转换一下
                List<MemberLabelAddParam> tagList = new ArrayList<>();
                if (CollectionUtils.isNotEmpty(memberInfoModelParam.getTagList())) {
                    for (MemberLabelAddParam memberLabelAddParam : memberInfoModelParam.getTagList()) {
                        if (memberLabelAddParam == null) {
                            continue;
                        }
                        MemberLabelAddParam newParam = new MemberLabelAddParam();
                        String wmId = sysCrmWmFieldMappingService.findWmFieldByCrmField(Long.toString(memberLabelAddParam.getTagId()), CrmWmFieldMappingTypeEnum.MEMBER_LABEL_GROUP_CODE.getCode());
                        if (StringUtils.isEmpty(wmId)) {
                            continue;
                        }
                        newParam.setTagId(Long.valueOf(wmId));
                        List<Long> newAttrIdList = new ArrayList<>();
                        List<Long> attrIdList = memberLabelAddParam.getAttrIdList();
                        if(CollectionUtils.isNotEmpty(attrIdList)) {
                            for (Long attdId : attrIdList ) {
                                if (attdId != null) {
                                    String wmAttrId = sysCrmWmFieldMappingService.findWmFieldByCrmField(Long.toString(attdId), CrmWmFieldMappingTypeEnum.MEMBER_LABEL_CODE.getCode());
                                    if (StringUtils.isNotEmpty(wmAttrId)) {
                                        newAttrIdList.add(Long.valueOf(wmAttrId));
                                    }
                                }
                            }
                        }
                        newParam.setAttrIdList(newAttrIdList);
                        tagList.add(newParam);
                    }
                    memberLabelAddReq.setTagList(tagList);
                }
            }
            memberLabelAddReq.setWidList(widList);
            log.info("memberAddLabelBind , requet:{}", JSON.toJSONString(memberLabelAddReq));
            String result = wmSystemHttpClientComponent.doPost(WmSystemConstant.MEMBER_ADD_LABEL, JSON.toJSONString(memberLabelAddReq));
            log.info("memberAddLabelBind , result:{}", JSON.toJSONString(result));
            // 记录下请求日志
            wmAPiComponent.saveApiRecord(WmTopicConstant.MEMBR_BIND_LABEL_ADD, JSON.toJSONString(memberLabelAddReq), result);
            WmResultVo resultVo = JSON.parseObject(result, WmResultVo.class);
            // 记录下请求日志
            if (resultVo.getCode() != null && SUCCESS_CODE.equals(resultVo.getCode().getErrcode())) {
                resultData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                resultData.setCode(SysResponseEnum.SUCCESS.getCode());
                return resultData;
            }
            resultData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            resultData.setCode(SysResponseEnum.SUCCESS.getCode());
            return resultData;
        } catch (Exception e) {
            log.info("memberAddLabelBind , excepion :{}",e.getMessage());
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(SysResponseEnum.FAILED.getCode());
            return resultData;
        }
    }

    /**
     * 同步会员标签解绑
     * @anthor shifeng
     * @param  memberInfoModelParam
     * @version 1.0.1
     * 2022-12-1 11:44:08
     */
    @Override
    public Result<Object> memberRemoveLabelBind(MemberInfoModelParam memberInfoModelParam) {
        Result resultData = new Result<>();
        log.info("memberRemoveLabelBind, start:{}", JSON.toJSONString(memberInfoModelParam));
        try {
            MemberLabelRemoveReq memberLabelRemoveReq = WmConverFactory.getMemberLabelRemoveReq(memberInfoModelParam);
            // 设置动态数据
            memberLabelRemoveReq.setVid(wmSystemFieldConfig.getVid());
            List<Long> widList = new ArrayList<>();
            widList.add(wmAPiComponent.getMemberWid(memberInfoModelParam.getPhone()));
            memberLabelRemoveReq.setWidList(widList);
            List<MemberLabelAddParam> tagList = new ArrayList<>();
            // 数据转换一下
            if (CollectionUtils.isNotEmpty(memberInfoModelParam.getTagList())) {
                for (MemberLabelAddParam memberLabelAddParam : memberInfoModelParam.getTagList()) {
                    if (memberLabelAddParam == null) {
                        continue;
                    }
                    MemberLabelAddParam newParam = new MemberLabelAddParam();
                    String wmId = sysCrmWmFieldMappingService.findWmFieldByCrmField(Long.toString(memberLabelAddParam.getTagId()), CrmWmFieldMappingTypeEnum.MEMBER_LABEL_GROUP_CODE.getCode());
                    if (StringUtils.isEmpty(wmId)) {
                        continue;
                    }
                    newParam.setTagId(Long.valueOf(wmId));
                    List<Long> newAttrIdList = new ArrayList<>();
                    List<Long> attrIdList = memberLabelAddParam.getAttrIdList();
                    if(CollectionUtils.isNotEmpty(attrIdList)) {
                        for (Long attdId : attrIdList ) {
                            if (attdId != null) {
                                String wmAttrId = sysCrmWmFieldMappingService.findWmFieldByCrmField(Long.toString(attdId), CrmWmFieldMappingTypeEnum.MEMBER_LABEL_CODE.getCode());
                                if (StringUtils.isNotEmpty(wmAttrId)) {
                                    newAttrIdList.add(Long.valueOf(wmAttrId));
                                }
                            }
                        }
                    }
                    newParam.setAttrIdList(newAttrIdList);
                    tagList.add(newParam);
                }
                memberLabelRemoveReq.setTagList(tagList);
            }
            log.info("memberRemoveLabelBind , requet:{}", JSON.toJSONString(memberLabelRemoveReq));
            String result = wmSystemHttpClientComponent.doPost(WmSystemConstant.MEMBER_REMOVE_LABEL, JSON.toJSONString(memberLabelRemoveReq));
            log.info("memberRemoveLabelBind , result:{}", JSON.toJSONString(result));
            // 记录下请求日志
            wmAPiComponent.saveApiRecord(WmTopicConstant.MEMBR_UNBIND_LABEL, Long.toString(memberInfoModelParam.getMbrMemberId()), JSON.toJSONString(memberLabelRemoveReq), result);
            WmResultVo resultVo = JSON.parseObject(result, WmResultVo.class);
            // 记录下请求日志
            if (resultVo.getCode() != null && SUCCESS_CODE.equals(resultVo.getCode().getErrcode())) {
                resultData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                resultData.setCode(SysResponseEnum.SUCCESS.getCode());
                return resultData;
            }
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(SysResponseEnum.FAILED.getCode());
            return resultData;
        } catch (Exception e) {
            log.info("memberRemoveLabelBind , excepion :{}",e.getMessage());
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(SysResponseEnum.FAILED.getCode());
            return resultData;
        }
    }

    /**
     * 会员订单积分同步
     * @anthor shifeng
     * @return Result
     * 2022-12-2 14:56:44
     */
    @Override
    public Result<Object> memberOrderTowm(CrmMemberOrderParam crmMemberOrderParam) {
        Result resultData = new Result<>();
        log.info("memberOrderTowm, start:{}", JSON.toJSONString(crmMemberOrderParam));
        try {
            MemberOrderReq memberOrderReq = new MemberOrderReq();
            //订单信息
            MemberOrderInfoParam orderInfo = new MemberOrderInfoParam();
            //下游业务参数
            List<Map<String,Object>> associateBizList = new ArrayList<>();
            Map<String,Object> bizMap = new HashMap<>();
            bizMap.put("bizValue", 600101);
            associateBizList.add(bizMap);
            orderInfo.setAssociateBizList(associateBizList);
            //订单基本信息
            orderInfo.setOrderBaseInfo(WmConverFactory.getOrderBaseInfo(crmMemberOrderParam));
            // 买家信息
            if (crmMemberOrderParam.getMemberInfoModel() != null) {
                MemberOrderUserInfoParam buyerInfo = WmConverFactory.getBuyInfoObj(crmMemberOrderParam.getMemberInfoModel());
                //否 客户编号，与客户⼿机号、线下卡号必传⼀个（若⽆wid和⼿机号，会⽣成匿名wid）
                buyerInfo.setWid(wmAPiComponent.getMemberWid(crmMemberOrderParam.getMemberInfoModel().getPhone()));
                orderInfo.setBuyerInfo(buyerInfo);
            }
            // 卖家信息
            if (crmMemberOrderParam.getSysStorePo() != null) {
                SysStorePo sysStorePo = crmMemberOrderParam.getSysStorePo();
                MemberOrderSellerInfoParam sellerInfo = new MemberOrderSellerInfoParam();
                sellerInfo.setVid(wmAPiComponent.getStoreVid(sysStorePo.getSysStoreOnlineCode()));
                sellerInfo.setVidName(sysStorePo.getStoreName());
                orderInfo.setSellerInfo(sellerInfo);
            }
            // 导购信息
            if(crmMemberOrderParam.getSysStaffVo() != null) {
                MemberOrderGuiderParam memberOrderGuiderParam = WmConverFactory.getMemberOrderGuiderParam(crmMemberOrderParam.getSysStaffVo());
                //售导购wid（导购⼿机号或导购wid⾄少⼆选⼀必填）
                Long guider = wmAPiComponent.checkGuiderWid(crmMemberOrderParam.getSysStaffVo().getPhone());
                if (guider != null) {
                    memberOrderGuiderParam.setGuiderWid(guider);
                    orderInfo.setGuiderInfo(memberOrderGuiderParam);
                }
            }
            // 支付信息
            orderInfo.setPaymentInfo(WmConverFactory.getMemberOrderPayInfoParam(crmMemberOrderParam));
            // 订单明细
            List<MemberOrderItemParam> orderItemInfoList = new ArrayList<>();
            if (CollectionUtils.isNotEmpty(crmMemberOrderParam.getOrderDetailModels())) {
                List<OrderDetailModel> orderDetailModels = crmMemberOrderParam.getOrderDetailModels();
                for (OrderDetailModel orderDetailModel : orderDetailModels) {
                    if (orderDetailModel == null || StringUtils.isEmpty(orderDetailModel.getProductItemId()) || StringUtils.isEmpty(orderDetailModel.getProductNo())) {
                        continue;
                    }
                    MemberOrderItemParam memberOrderItemParam = new MemberOrderItemParam();
                    //外部订单项ID（⾏号）
                    memberOrderItemParam.setItemId(orderDetailModel.getMbrOrderDetailId());
                    memberOrderItemParam.setNum(orderDetailModel.getQuantity());
                    //商品项金额信息
                    MemberOrderPayInfoParam paymentInfo = new MemberOrderPayInfoParam();
                    //订单实付
                    paymentInfo.setPaymentAmount(orderDetailModel.getTradeAmountDetail());
                    //订单总⾦额
                    paymentInfo.setTotalAmount(orderDetailModel.getTagPrice());
                    //订单应付⾦额
                    paymentInfo.setShouldPaymentAmount(orderDetailModel.getTagPrice());
                    memberOrderItemParam.setPaymentInfo(paymentInfo);
                    //商品信息
                    MemberOrderItemInfoParam memberOrderItemInfoParam = WmConverFactory.getMemberOrderItemInfoParam(orderDetailModel);
                    // 商品ID 获取下映射表的数据
                    String goodsId = sysCrmWmFieldMappingService.findWmFieldByCrmField(orderDetailModel.getProductNo(), CrmWmFieldMappingTypeEnum.GOODS_CODE.getCode());
                    if (StringUtils.isNoneEmpty(goodsId)) {
                        memberOrderItemInfoParam.setGoodsId(Long.valueOf(goodsId));
                    }
                    memberOrderItemParam.setGoodsInfoDto(memberOrderItemInfoParam);
                    orderItemInfoList.add(memberOrderItemParam);
                }
            }
            orderInfo.setOrderItemInfoList(orderItemInfoList);
            // pos 配送 下游 crm选中不存在 传空对象
            MemberOrderDeliveryParam memberOrderDeliveryParam = new MemberOrderDeliveryParam();
            memberOrderDeliveryParam.setDeliveryType(5);
            orderInfo.setDeliveryInfo(memberOrderDeliveryParam);
            //订单详情信息
            memberOrderReq.setOrderInfo(orderInfo);
            memberOrderReq.setOperatorWid(0L);
            memberOrderReq.setOperatorName("crm");

            log.info("memberOrderTowm , requet:{}", JSON.toJSONString(memberOrderReq));
            String result = wmSystemHttpClientComponent.doPost(WmSystemConstant.IMPORT_ORDER, JSON.toJSONString(memberOrderReq));
            log.info("memberOrderTowm , result:{}", JSON.toJSONString(result));
            // 记录下请求日志
            wmAPiComponent.saveApiRecord(WmTopicConstant.MEMBR_ORDER, crmMemberOrderParam.getOrderNo(), JSON.toJSONString(memberOrderReq), result);
            WmResultVo resultVo = JSON.parseObject(result, WmResultVo.class);
            if (resultVo.getCode() != null && SUCCESS_CODE.equals(resultVo.getCode().getErrcode())) {
                // 保存绑定关系
                JSONObject resultJSON = resultVo.getData();
                if (resultJSON != null && resultJSON.containsKey("outputInfo")) {
                    JSONObject orderResultJson = resultJSON.getJSONObject("outputInfo");
                    SysCrmWmFieldMappingPO sysCrmWmFieldMappingPO = new SysCrmWmFieldMappingPO();
                    sysCrmWmFieldMappingPO.setWmField(orderResultJson.getString("orderNo"));
                    sysCrmWmFieldMappingPO.setCrmField(crmMemberOrderParam.getOrderNo());
                    sysCrmWmFieldMappingPO.setMappingType(CrmWmFieldMappingTypeEnum.MEMBER_ORDER.getCode());
                    sysCrmWmFieldMappingService.insertSysCrmWmFieldMapping(sysCrmWmFieldMappingPO);
                }
                resultData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                resultData.setCode(SysResponseEnum.SUCCESS.getCode());
                return resultData;
            }
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(SysResponseEnum.FAILED.getCode());
            return resultData;
        } catch (Exception e) {
            log.info("memberOrderTowm , excepion :{}",e.getMessage());
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(SysResponseEnum.FAILED.getCode());
            return resultData;
        }
    }

    /**
     * 会员订单积分同步
     * @anthor shifeng
     * @return Result
     * 2022-12-2 14:56:44
     */
    @Override
    public Result<Object> memberOrderUpdateBiz(CrmMemberOrderUpdateParam crmMemberOrderUpdateParam) {
        Result resultData = new Result<>();
        log.info("memberOrderUpdateBiz, start:{}", JSON.toJSONString(crmMemberOrderUpdateParam));
        try {
            MemberOrderUpdateReq memberOrderUpdateReq = new MemberOrderUpdateReq();
            MemberOrderBaseInfoParam orderBaseInfo = new MemberOrderBaseInfoParam();
            orderBaseInfo.setOutOrderNo(crmMemberOrderUpdateParam.getOrderNo());
            orderBaseInfo.setChannelType(7);
            orderBaseInfo.setPlatformType(2);
            memberOrderUpdateReq.setOrderBaseInfo(orderBaseInfo);
            List<Map<String,Object>> associateBizList = new ArrayList<>();
            Map<String, Object> bizMap = new HashMap<>();
            bizMap.put("bizValue", 600101);
            associateBizList.add(bizMap);
            memberOrderUpdateReq.setAssociateBizList(associateBizList);
            log.info("memberOrderUpdateBiz , requet:{}", JSON.toJSONString(memberOrderUpdateReq));
            String result = wmSystemHttpClientComponent.doPost(WmSystemConstant.UPDATE_ORDER, JSON.toJSONString(memberOrderUpdateReq));
            log.info("memberOrderUpdateBiz , result:{}", JSON.toJSONString(result));
            // 记录下请求日志
            wmAPiComponent.saveApiRecord(WmTopicConstant.MEMBR_ORDER_UPDATE, crmMemberOrderUpdateParam.getOrderNo(), JSON.toJSONString(memberOrderUpdateReq), result);
            resultData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            resultData.setCode(SysResponseEnum.SUCCESS.getCode());
            return resultData;
        } catch (Exception e) {
            log.info("memberOrderUpdateBiz , excepion :{}",e.getMessage());
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(SysResponseEnum.FAILED.getCode());
            return resultData;
        }
    }

    /**
     * 会员订单积分同步
     * @anthor shifeng
     * @return Result
     * 2022-12-2 14:56:44
     */
    @Override
    public Result<Object> memberOrderCancelTowm(CrmMemberOrderParam crmMemberOrderParam) {
        Result resultData = new Result<>();
        log.info("memberOrderCancelTowm, start:{}", JSON.toJSONString(crmMemberOrderParam));
        try  {
            MemberOrderCancelReq memberOrderCancelReq = new MemberOrderCancelReq();
            //商家信息
            MerchantInfoParam merchantInfo = new MerchantInfoParam();
            //售后单发⽣的组织节点ID。组织的唯⼀标识，是创建组织时⾃动⽣成
            merchantInfo.setVid(wmAPiComponent.getStoreVid(crmMemberOrderParam.getStoreOnlineCode()));
            memberOrderCancelReq.setMerchantInfo(merchantInfo);
            // 买家信息
            if (crmMemberOrderParam.getMemberInfoModel() != null) {
                MemberInfoModel memberInfoModel = crmMemberOrderParam.getMemberInfoModel();
                MemberOrderUserInfoParam buyerInfo = WmConverFactory.getBuyInfoObj(crmMemberOrderParam.getMemberInfoModel());
                //否 客户编号，与客户⼿机号、线下卡号必传⼀个（若⽆wid和⼿机号，会⽣成匿名wid）
                buyerInfo.setWid(wmAPiComponent.getMemberWid(memberInfoModel.getPhone()));
                memberOrderCancelReq.setBuyerInfo(buyerInfo);
            }
            //基本信息
            memberOrderCancelReq.setRightsOrder(WmConverFactory.getRightsOrderParam(crmMemberOrderParam));
            //退款账户信息
            RefundAccountParam refundAccountParam = new RefundAccountParam();
            refundAccountParam.setRefundMethodId(1);
            memberOrderCancelReq.setRefundAccount(refundAccountParam);
            //退款⾦额信息
            if (crmMemberOrderParam.getPayMoney() != null) {
                RefundDetailParam refundDetail = new RefundDetailParam();
                //申请退款总⾦额，单位元，保留⼩时点后两位，不能为负
                refundDetail.setApplyAmount(crmMemberOrderParam.getPayMoney().intValue() < 0 ? crmMemberOrderParam.getPayMoney().negate() : crmMemberOrderParam.getPayMoney());
                //订单级的实退商品的销售⾦额（货款+运费），单位元，保留⼩时点后
                refundDetail.setRefundAmount(crmMemberOrderParam.getPayMoney().intValue() < 0 ? crmMemberOrderParam.getPayMoney().negate() : crmMemberOrderParam.getPayMoney());
                memberOrderCancelReq.setRefundDetail(refundDetail);
            }
            //商品项信息
            List<RightsItemsParam> rightsItems = new ArrayList<>();
            if (CollectionUtils.isNotEmpty(crmMemberOrderParam.getOrderDetailModels())) {
                List<OrderDetailModel> orderDetailModels = crmMemberOrderParam.getOrderDetailModels();
                for (OrderDetailModel orderDetailModel : orderDetailModels) {
                    if (orderDetailModel == null || orderDetailModel.getMbrOrderDetailId() == null) {
                        continue;
                    }
                    // 构建对象
                    RightsItemsParam rightsItemsParam = WmConverFactory.getRightsItemsParam(orderDetailModel, crmMemberOrderParam);
                    // 导购信息
                    if (crmMemberOrderParam.getSysStaffVo() != null) {
                        //销售导购编号
                        Long guiderWid = wmAPiComponent.checkGuiderWid(crmMemberOrderParam.getSysStaffVo().getPhone());
                        if (guiderWid != null) {
                            rightsItemsParam.setGuiderWid(guiderWid);
                        }
                        //销售导购手机号码
                        rightsItemsParam.setGuiderPhone(crmMemberOrderParam.getSysStaffVo().getPhone());
                        //销售导购名称
                        rightsItemsParam.setGuiderName(crmMemberOrderParam.getSysStaffVo().getStaffCode());
                        //外部导购编号
                        rightsItemsParam.setOutGuiderNo(crmMemberOrderParam.getSysStaffVo().getStaffCode());
                    }
                    String goodsId = sysCrmWmFieldMappingService.findWmFieldByCrmField(orderDetailModel.getProductItemId(), CrmWmFieldMappingTypeEnum.GOODS_CODE.getCode());
                    if (StringUtils.isNoneEmpty(goodsId)) {
                        rightsItemsParam.setGoodsId(Long.valueOf(goodsId));
                    }
                    //商品资产项信息
                    rightsItems.add(rightsItemsParam);
                }
            }
            memberOrderCancelReq.setRightsItems(rightsItems);
            //原订单信息
            memberOrderCancelReq.setOriginOrder(WmConverFactory.getOriginOrderParam(crmMemberOrderParam));
            // 下游业务感知
            List<Map<String,Object>> associateBizList = new ArrayList<>();
            Map<String,Object> bizMap = new HashMap<>();
            bizMap.put("bizValue", 600101);
            associateBizList.add(bizMap);
            memberOrderCancelReq.setAssociateBizList(associateBizList);
            log.info("memberOrderCancelTowm , requet:{}", JSON.toJSONString(memberOrderCancelReq));
            String result = wmSystemHttpClientComponent.doPost(WmSystemConstant.IMPORT_CANCEL_ORDER, JSON.toJSONString(memberOrderCancelReq));
            log.info("memberOrderCancelTowm , result:{}", JSON.toJSONString(result));
            // 记录下请求日志
            wmAPiComponent.saveApiRecord(WmTopicConstant.MEMBR_CANCEL_ORDER, crmMemberOrderParam.getOrderNo(), JSON.toJSONString(memberOrderCancelReq), result);
            WmResultVo resultVo = JSON.parseObject(result, WmResultVo.class);
            if (resultVo.getCode() != null && SUCCESS_CODE.equals(resultVo.getCode().getErrcode())) {
                // 保存绑定关系
                JSONObject resultJSON = resultVo.getData();
                if (resultJSON != null && resultJSON.containsKey("rightsOrderNo")) {
                    SysCrmWmFieldMappingPO sysCrmWmFieldMappingPO = new SysCrmWmFieldMappingPO();
                    sysCrmWmFieldMappingPO.setWmField(resultJSON.getString("rightsOrderNo"));
                    sysCrmWmFieldMappingPO.setCrmField(crmMemberOrderParam.getOrderNo());
                    sysCrmWmFieldMappingPO.setMappingType(CrmWmFieldMappingTypeEnum.MEMBER_ORDER.getCode());
                    sysCrmWmFieldMappingService.insertSysCrmWmFieldMapping(sysCrmWmFieldMappingPO);
                }
                resultData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                resultData.setCode(SysResponseEnum.SUCCESS.getCode());
                return resultData;
            }
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(SysResponseEnum.FAILED.getCode());
            return resultData;
        } catch (Exception e) {
            log.info("memberOrderCancelTowm , excepion :{}",e.getMessage());
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(SysResponseEnum.FAILED.getCode());
            return resultData;
        }
    }

    /**
     * 优惠券定义同步
     * @param param
     * @return
     */
    @Override
    public Result<Object> couponDefineTowm(CouponDefinitionParam param) {
        Result resultData = new Result<>();
        log.info("couponDefineTowm,param:{}", JSON.toJSONString(param));
        try{
            // 2. 封装参数
            packingCouponDefinitionParam(param);
            // 校验入参，适用门店和适用商品是否符合要求
            Result checkResult = checkCouponDefineTowm(param);
            log.info("checkCouponDefineTowm, checkResult:{}", JSON.toJSONString(checkResult));
            if (checkResult.getCode() != SysResponseEnum.SUCCESS.getCode()){
                log.info("couponDefineTowm,check error! param:{}", JSON.toJSONString(param));
                resultData.setCode(SysResponseEnum.SUCCESS.getCode());
                return resultData;
            }
            CouponTemplateReq couponTemplateReq = WmConverFactory.caseToCouponTemplateReq(param);
            log.info("couponDefineTowm,couponTemplateReq:{}", JSON.toJSONString(couponTemplateReq));
            // 校验入参，
            // 3. 同步卷模板
            String templateResultStr = wmSystemHttpClientComponent.doPost(WmSystemConstant.CREATE_COUPON_BASIC_TEMPLATE, JSON.toJSONString(couponTemplateReq));
            log.info("couponDefineTowm,templateResultStr:{}", templateResultStr);
            // 记录下请求日志
            wmAPiComponent.saveApiRecord(WmTopicConstant.COUPON_BASIC_DEFINE, JSON.toJSONString(couponTemplateReq), templateResultStr);
            WmResultVo resultVo = JSON.parseObject(templateResultStr, WmResultVo.class);
            Long basicTemplateId = null;
            if (resultVo != null && WmSystemConstant.SUCCESS_CODE.equals(resultVo.getCode().getErrcode())){
                basicTemplateId = resultVo.getData().getLong("basicCouponTemplateId");

                param.setBasicCouponTemplateIdList(Arrays.asList(basicTemplateId));
                // 4. 同步卷
                CouponCreateReq couponCreateReq = WmConverFactory.caseToCouponCreateReq(param);
                log.info("couponDefineTowm,couponCreateReq:{}", JSON.toJSONString(couponCreateReq));
                String couponResultStr = wmSystemHttpClientComponent.doPost(WmSystemConstant.CREATE_COUPON_TEMPLATE, JSON.toJSONString(couponCreateReq));
                log.info("couponDefineTowm,couponResultStr:{}",couponResultStr);
                // 记录下请求日志
                wmAPiComponent.saveApiRecord(WmTopicConstant.COUPON_DEFINE, JSON.toJSONString(couponCreateReq), couponResultStr);

                WmResultVo couponResultVo = JSON.parseObject(couponResultStr, WmResultVo.class);
                if (resultVo != null && WmSystemConstant.SUCCESS_CODE.equals(couponResultVo.getCode().getErrcode())){
                    // 同步成功
                    resultData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                    resultData.setCode(SysResponseEnum.SUCCESS.getCode());
                    JSONArray couponTemplateIds = couponResultVo.getData().getJSONArray("couponTemplateIds");
                    String couponTemplateId = couponTemplateIds.get(0).toString();
                    // 添加映射表
                    addCouponDefinitionMapping(param.getCouponDefinitionCode(), couponTemplateId);
                    return resultData;
                }
            }
            // 同步微盟优惠券失败，记录日志
//            asyncCouponDefinitionToWmErrorForRecord(param.getCouponDefinitionId());
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(SysResponseEnum.FAILED.getCode());
        }catch (Exception e){
            log.info("couponDefineTowm error:{}", e.getMessage());
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(SysResponseEnum.FAILED.getCode());
        }
        return resultData;
    }

    /**
     * 优惠券模版同步微盟失败记录详情
     * @param couponDefinitionId
     */
    private void asyncCouponDefinitionToWmErrorForRecord(Long couponDefinitionId){
        log.info("asyncCouponDefinitionToWmErrorForRecord,couponDefinitionId:{}", couponDefinitionId);
        if (couponDefinitionId == null){
            log.info("asyncCouponDefinitionToWmErrorForRecord,couponDefinitionId is NULL,error");
            return;
        }
        ResponseData responseData = couponDefinitionServiceFeign.addCouponDefinitionToWmErrorForRecode(couponDefinitionId);
        log.info("asyncCouponDefinitionToWmErrorForRecord,responseData：{}", JSON.toJSONString(responseData));
    }

    /**
     * 优惠券绑定会员同步微盟失败记录详情
     * @param couponCode
     */
    private void asyncCouponEntityToWmErrorForRecord(String couponCode){
        log.info("asyncCouponDefinitionToWmErrorForRecord,asyncCouponEntityToWmErrorForRecord,couponCode:{}", couponCode);
        if (StringUtils.isBlank(couponCode)){
            log.info("asyncCouponDefinitionToWmErrorForRecord, couponCode is NULL error");
            return;
        }
        // 根据券号 进行记录失败数据
        ResponseData responseData = couponEntityServiceFeign.addCouponEntityToWmErrorForRecode(couponCode);
         log.info("asyncCouponDefinitionToWmErrorForRecord,responseData：{}", JSON.toJSONString(responseData));
    }

    /**
     * 校验同步微盟数据
     * 1. 校验适用门店类型如果为部分适用，则部分适用门店列表不能位空
     * 2. 校验适用商品类型如果为部分适用，则部分适用商品列表不能为空
     * @param param
     * @return
     */
    private Result checkCouponDefineTowm(CouponDefinitionParam param){
        log.info("checkCouponDefineTowm,param:{}", JSON.toJSONString(param));
        Result<Object> result = new Result<>();
        result.setCode(SysResponseEnum.SUCCESS.getCode());
        if (param.getApplianceStoreType() != 1){
            if (CollectionUtils.isEmpty(param.getWmStoreIdList())){
                result.setCode(SysResponseEnum.FAILED.getCode());
                result.setMessage("适用门店找不到映射");
                return result;
            }
        }
        if (param.getApplianceCommodityType() == 2){
            if (CollectionUtils.isEmpty(param.getGoodsIdList())){
                result.setCode(SysResponseEnum.FAILED.getCode());
                result.setMessage("适用商品找不到映射");
                return result;
            }
        }
        return result;
    }

    /**
     * 微盟创建商品信息同步
     * @param param
     * @return
     */
    @Override
    public Result<Object> syncWmCreateGoodsMsg(WmSyncGoodsCreateParam param) {
        Result<Object> result = new Result<>();
        result.setCode(SysResponseEnum.FAILED.getCode());
        log.info("syncWmCreateGoodsMsg, param:{}", JSON.toJSONString(param));
        String goodsId = JSON.parseObject(param.getMsgBody()).getString("goodsId");
        // 根据微盟商品id 查询对应的商品编码
        try {
            WmGoodsBaseInfoParam wmGoodsBaseInfoParam = WmConverFactory.getWmGoodsBaseInfoParam(goodsId, wmSystemFieldConfig.getVid());
            log.info("syncWmCreateGoodsMsg, url:{}, param:{}", WmSystemConstant.FIND_GOODS_BY_ID, JSON.toJSONString(wmGoodsBaseInfoParam));
            String resultStr = wmSystemHttpClientComponent.doPost(WmSystemConstant.FIND_GOODS_BY_ID, JSON.toJSONString(wmGoodsBaseInfoParam));
            log.info("syncWmCreateGoodsMsg , resultStr:{}", JSON.toJSONString(resultStr));
            // 记录下请求日志
            wmAPiComponent.saveApiRecord(WmTopicConstant.SYNC_GOODS, goodsId, JSON.toJSONString(wmGoodsBaseInfoParam), resultStr);
            WmResultArrayVo goodsResult = JSON.parseObject(resultStr, WmResultArrayVo.class);
            String outerGoodsCode = "";
            if (null != goodsResult && WmSystemConstant.SUCCESS_CODE.equals(goodsResult.getCode().getErrcode())){
                JSONArray goodsResultData = goodsResult.getData();
                JSONObject jsonObject = goodsResultData.getJSONObject(0);
                outerGoodsCode = jsonObject.getString("outerGoodsCode");
            }
            if (StringUtils.isNotBlank(outerGoodsCode)){
                result.setCode(SysResponseEnum.SUCCESS.getCode());
                // 添加到映射表中
                SysCrmWmFieldMappingPO sysCrmWmFieldMappingPO = sysCrmWmFieldMappingService.initSysCrmWmFieldMappingPO(goodsId, outerGoodsCode, CrmWmFieldMappingTypeEnum.GOODS_CODE.getCode());
                sysCrmWmFieldMappingService.insertSysCrmWmFieldMapping(sysCrmWmFieldMappingPO);
            }
        }catch (Exception e){
            result.setCode(SysResponseEnum.FAILED.getCode());
            result.setMessage(e.getMessage());
        }
        return result;
    }


    /**
     * 会员绑定渠道推送微盟
     * @param params
     * @return
     */
    @Override
    public Result<Object> memberBindChannel(List<MemberBindChannelParam> params) {
        Result resultData = new Result<>();
        resultData.setCode(SysResponseEnum.SUCCESS.getCode());
        log.info("SysWeimengServiceImpl#memberBindChannel,params:{}", JSON.toJSONString(params));
        for (MemberBindChannelParam param : params) {
            // 1. 校验入参
            if (!buildMemberBindChannelParam(param)){
                log.info("SysWeimengServiceImpl#memberBindChannel continue");
                continue;
            }
            // 2. 推送微盟
            try {
                log.info("memberBindChannel,param:{}", JSON.toJSONString(param));
                // 3. 同步卷模板
                String couponBindResult = wmSystemHttpClientComponent.doPost(WmSystemConstant.member_bind_channel, JSON.toJSONString(param));
                log.info("memberBindChannel,result:{}", couponBindResult);
                // 记录下请求日志
                wmAPiComponent.saveApiRecord(WmTopicConstant.MEMBER_BIND_CHANNEL, JSON.toJSONString(param), couponBindResult);
            }catch (Exception e){
                log.info("SysWeimengServiceImpl#memberBindChannel,error:{}", e.getMessage());
            }
        }
        return resultData;
    }

    /**
     * 校验并构建用户wid
     * @param param
     */
    private boolean buildMemberBindChannelParam(MemberBindChannelParam param){
        // 1. 校验入参
        if (param == null || StringUtils.isBlank(param.getPhone())
                || StringUtils.isBlank(param.getAppId())
                || StringUtils.isBlank(param.getOriginalId())
                || null == param.getSource()){
            log.info("SysWeimengServiceImpl#buildMemberBindChannelParam,param is null");
            return false;
        }
        Long wid = findWeimengWidByPhone(param.getPhone());
        if (wid == null){
            log.info("SysWeimengServiceImpl#buildMemberBindChannelParam,phone:{} wid is null", param.getPhone());
            return false;
        }
        param.setWid(wid);
        return true;
    }

    /**
     * 封装 券定义入参
     * @param param
     */
    private void packingCouponDefinitionParam(CouponDefinitionParam param){
        // 券归属 vid, 获取配置默认值
        Long belongVid = wmSystemFieldConfig.getVid();
        log.info("packingCouponDefinitionParam,getVid:{}", belongVid);
        param.setBelongVid(belongVid);
        if (param.getApplianceStoreType() != 1){
            // 部分门店
            if (param.getApplianceStoreType() == 2){
                param.setWmStoreIdList(buildStoreId(param.getStoreWhitelist()));
            }else {
                param.setWmStoreIdList(buildRegionId(param.getStoreWhitelist()));
            }
        }

        // 部分商品适用
        if (param.getApplianceCommodityType() == 2){
            // 取出商品前缀
            cleanGoodsProductCodeFrefix(param);
            param.setGoodsIdList(buildGoodsIds(param.getCommodityWhitelist()));
        }
    }

    /**
     * 去除前缀
     * @param vo
     */
    private void cleanGoodsProductCodeFrefix(CouponDefinitionParam vo){
        log.info("cleanGoodsProductCodeFrefix, param vo:{}", JSON.toJSONString(vo));
        List<String> codeList = new ArrayList<>();
        if (org.apache.commons.lang.StringUtils.isNotBlank(vo.getCommodityWhitelist())){
            List<String> productCodes = Arrays.asList(vo.getCommodityWhitelist().split(","));
            for (String productCode : productCodes) {
                codeList.add(cleanFrefix(productCode));
            }
        }
        if (CollectionUtils.isNotEmpty(codeList)){
            String whiteList = org.apache.commons.lang.StringUtils.join(codeList, ",");
            vo.setCommodityWhitelist(whiteList);
        }
        log.info("cleanGoodsProductCodeFrefix, result vo:{}", JSON.toJSONString(vo));
    }

    private String cleanFrefix(String productCode){
        String VG_FREFIX = "VG-CLUB_";
        String TN_FREFIX = "TN-CLUB_";
        String TT_FREFIX = "TT-CLUB_";
        String TZ_FREFIX = "TZ-CLUB_";
        String YJ_FREFIX = "YJ-CLUB_";

        if (productCode.startsWith(VG_FREFIX)
                || productCode.startsWith(TN_FREFIX)
                || productCode.startsWith(TT_FREFIX)
                || productCode.startsWith(TZ_FREFIX)
                || productCode.startsWith(YJ_FREFIX)){
            return productCode.substring(8, productCode.length());
        }
        return "";
    }

    /**
     * 根据适用商品列表查询对应的微盟id
     * @param commodityWhitelist
     * @return
     */
    private List<Long> buildGoodsIds(String commodityWhitelist){
        log.info("buildGoodsIds, commodityWhitelist:{}", commodityWhitelist);
        List<Long> goodsIds = new ArrayList<>();
        if (StringUtils.isBlank(commodityWhitelist)){
            return goodsIds;
        }
        String[] split = commodityWhitelist.split(",");
        for (String goodsCode : split) {
            String goodsId = wmAPiComponent.getGoodsId(goodsCode);
            if (StringUtils.isNotBlank(goodsId)){
                goodsIds.add(Long.valueOf(goodsId));
            }
        }
        log.info("buildGoodsIds, result:{}", JSON.toJSONString(goodsIds));
        return goodsIds;
    }

    /**
     * 转换成微盟放storeId
     * @param storeCodeStr
     * @return
     */
    private List<Long> buildStoreId(String storeCodeStr){
        List<Long> storeIds = new ArrayList<>();
        String[] split = storeCodeStr.split(",");
        if (split.length <= 0){
            return storeIds;
        }
        for (String storeCode : split) {
            Long storeId = null;
            try {
                storeId = wmAPiComponent.getStoreVid(storeCode);
                if (null != storeId){
                    storeIds.add(storeId);
                }
            } catch (Exception e) {
                log.info("getStoreVid error,e:{}", e.getMessage());
            }
        }
        return storeIds;
    }

    /**
     * 转化微盟 区域id
     * @param storeCodeStr
     * @return
     */
    private List<Long> buildRegionId(String storeCodeStr){
        List<Long> regionIds = new ArrayList<>();
        String[] split = storeCodeStr.split(",");
        if (split.length <= 0){
            return regionIds;
        }
        for (String regionCode : split) {
            Long regionId = null;
            try {
                regionId = wmAPiComponent.getRegionVid(regionCode);
                if (null != regionId){
                    regionIds.add(regionId);
                }
            } catch (Exception e) {
                log.info("buildRegionId error,e:{}", e.getMessage());
            }
        }
        return regionIds;
    }

    /**
     * 添加券模板字段映射
     * @param crmField
     * @param wmField
     */
    private void addCouponDefinitionMapping(String crmField, String wmField){
        log.info("addCouponDefinitionMapping, crmField:{}, wmField:{}", crmField, wmField);
        SysCrmWmFieldMappingPO sysCrmWmFieldMappingPO = sysCrmWmFieldMappingService.initSysCrmWmFieldMappingPO(wmField, crmField, CrmWmFieldMappingTypeEnum.COUPON_CODE.getCode());
        sysCrmWmFieldMappingService.insertSysCrmWmFieldMapping(sysCrmWmFieldMappingPO);
    }


    /**
     * 优惠券作废
     * @param param
     * @return
     */
    @Override
    public Result<Object> unuseCouponTowm(CouponCancelParam param) {
        Result resultData = new Result<>();
        resultData.setMessage(SysResponseEnum.FAILED.getMessage());
        resultData.setCode(SysResponseEnum.FAILED.getCode());
        log.info("unuseCouponTowm,param:{}", JSON.toJSONString(param));
        packingCouponCancelParam(param);
        try{
            // 2. 封装参数
            CouponCancelReq couponCancelReq = WmConverFactory.caseToCouponCancelReq(param);
            log.info("unuseCouponTowm,couponCancelReq:{}", JSON.toJSONString(couponCancelReq));
            // 3. 同步卷模板
            String couponCancelResult = wmSystemHttpClientComponent.doPost(WmSystemConstant.COUPON_CANCEL, JSON.toJSONString(couponCancelReq));
            log.info("unuseCouponTowm,couponCancelResult:{}", couponCancelResult);
            // 记录下请求日志
            wmAPiComponent.saveApiRecord(WmTopicConstant.COUPON_CANCEL, JSON.toJSONString(couponCancelReq), couponCancelResult);
            WmResultVo resultVo = JSON.parseObject(couponCancelResult, WmResultVo.class);
            if (resultVo != null && WmSystemConstant.SUCCESS_CODE.equals(resultVo.getCode().getErrcode())){
                if (resultVo.getData().getBoolean("result")){
                    // 同步成功
                    resultData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                    resultData.setCode(SysResponseEnum.SUCCESS.getCode());
                }
            }
        }catch (Exception e){
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(SysResponseEnum.FAILED.getCode());
        }
        log.info("unuseCouponTowm, resultData:{}", JSON.toJSONString(resultData));
        return resultData;
    }

    /**
     * 封装券作废入参
     * @param param
     */
    private void packingCouponCancelParam(CouponCancelParam param){
        // 组织架构节点类型。类型包括：1-集团；2-品牌；3-区域；4部门；5-商场；6-楼层；10-门店；11-网点；100-自提点。固定值 1
        int vidType = 1;
        // 获取配置vid
        Long vid = wmSystemFieldConfig.getVid();
        // 根据会员编号查询微盟wid
        Long wid = this.findWeimengWidBySysMemberCode(param.getMemberCode());
        param.setWid(wid);
        param.setVid(vid);
        param.setType(vidType);
        // 封装券模板id
        param.getOperateCoupons().forEach(coupon -> {
            coupon.setCouponTemplateId(sysCrmWmFieldMappingService.findWmFieldByCrmField(coupon.getCouponDefinitionCode(), CrmWmFieldMappingTypeEnum.COUPON_CODE.getCode(), Long.class));
        });
    }

    /**
     * 优惠券使用
     * @param param
     * @return
     */
    @Override
    public Result<Object> useCouponEntityTowm(CouponUseParam param) {
        Result resultData = new Result<>();
        log.info("useCouponEntityTowm,param:{}", JSON.toJSONString(param));
        if (IS_OPEN.equals(isOpen)) {
            log.info("IS_OPEN:{}, close!", isOpen);
            resultData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            resultData.setCode(SysResponseEnum.SUCCESS.getCode());
            return resultData;
        }
        resultData.setMessage(SysResponseEnum.FAILED.getMessage());
        resultData.setCode(SysResponseEnum.FAILED.getCode());
        packingCouponUseParam(param);
        // 判断券规则wid是否为空，如果为空，直接返回
        if (param.getWid() == null){
            log.info("useCouponEntityTowm wid is not found!");
            resultData.setCode(SysResponseEnum.SUCCESS.getCode());
            return resultData;
        }
        try{
            // 2. 封装参数
            CouponConsumeReq couponConsumeReq = WmConverFactory.caseToCouponConsumeReq(param);
            log.info("useCouponEntityTowm,couponConsumeReq:{}", JSON.toJSONString(couponConsumeReq));
            // 3. 同步卷模板
            String couponConsumeResult = wmSystemHttpClientComponent.doPost(WmSystemConstant.COUPON_USE, JSON.toJSONString(couponConsumeReq));
            log.info("useCouponEntityTowm,couponConsumeResult:{}", couponConsumeResult);
            // 记录下请求日志
            wmAPiComponent.saveApiRecord(WmTopicConstant.COUPON_CONSUMER, JSON.toJSONString(couponConsumeReq), couponConsumeResult);

            WmResultVo resultVo = JSON.parseObject(couponConsumeResult, WmResultVo.class);
            if (resultVo != null && WmSystemConstant.SUCCESS_CODE.equals(resultVo.getCode().getErrcode())){
                if (resultVo.getData().getBoolean("result")){
                    // 同步成功
                    resultData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                    resultData.setCode(SysResponseEnum.SUCCESS.getCode());
                }
            }
        }catch (Exception e){
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(SysResponseEnum.FAILED.getCode());
        }
        log.info("useCouponEntityTowm,resultData:{}", JSON.toJSONString(resultData));
        return resultData;
    }



    /**
     * 封装核销优惠券入参
     * @param param
     */
    private void packingCouponUseParam(CouponUseParam param){

        // 查询wid
        Long wid = findWeimengWidBySysMemberCode(param.getMemberCode());
        // 获取配置vid
        Long vid = wmSystemFieldConfig.getVid();
        param.setWid(wid);
        param.setVid(vid);
        param.getOperateCoupons().forEach(coupon -> {
            Long wmCounponDefinitionId = sysCrmWmFieldMappingService.findWmFieldByCrmField(coupon.getCouponDefinitionCode(), CrmWmFieldMappingTypeEnum.COUPON_CODE.getCode(), Long.class);
            coupon.setCouponTemplateId(wmCounponDefinitionId);
        });
    }

    /**
     * 会员领劵
     * @param param
     * @return
     */
    @Override
    public Result<Object> couponBindMember(CouponBindMemberParam param) {
        Result resultData = new Result<>();
        log.info("couponBindMember,param:{}", JSON.toJSONString(param));
        if (IS_OPEN.equals(isOpen)) {
            log.info("IS_OPEN:{}, close!", isOpen);
            resultData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            resultData.setCode(SysResponseEnum.SUCCESS.getCode());
            return resultData;
        }
        packingCouponBindMemberParam(param);
        // 判断券规则wid是否为空，如果为空，直接返回
        if (param.getWid() == null){
            log.info("useCouponEntityTowm wid is not found!");
            resultData.setCode(SysResponseEnum.SUCCESS.getCode());
            return resultData;
        }
        try{
            // 2. 封装参数
            CouponBandMemberReq couponBandMemberReq = WmConverFactory.caseToCouponBindingMemberReq(param);
            log.info("couponBindMember,couponBandMemberReq:{}", JSON.toJSONString(couponBandMemberReq));
            // 3. 同步卷模板
            String couponBindResult = wmSystemHttpClientComponent.doPost(WmSystemConstant.MEMBER_GET_COUPON, JSON.toJSONString(couponBandMemberReq));
            log.info("couponBindMember,couponBindResult:{}", couponBindResult);
            // 记录下请求日志
            wmAPiComponent.saveApiRecord(WmTopicConstant.COUPON_BINDING_MEMBER, JSON.toJSONString(couponBandMemberReq), couponBindResult);
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(SysResponseEnum.FAILED.getCode());
            WmResultVo resultVo = JSON.parseObject(couponBindResult, WmResultVo.class);
            if (resultVo != null && WmSystemConstant.SUCCESS_CODE.equals(resultVo.getCode().getErrcode())){
                if (resultVo.getData().getBoolean("result")){
                    // 同步成功
                    resultData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                    resultData.setCode(SysResponseEnum.SUCCESS.getCode());
                }
            }
        }catch (Exception e){
            resultData.setMessage(SysResponseEnum.FAILED.getMessage());
            resultData.setCode(SysResponseEnum.FAILED.getCode());
        }
        log.info("couponBindMember, resultData:{}", JSON.toJSONString(resultData));
        // 如果同步微盟失败，则记录数据
        if (resultData.getCode() != SysResponseEnum.SUCCESS.getCode()){
//            asyncCouponEntityToWmErrorForRecord(param.getCouponCode());
        }
        return resultData;
    }

    /**
     * 封装会员领券入参
     * @param param
     */
    private void packingCouponBindMemberParam(CouponBindMemberParam param){
        // 查找所属会员的wid
        Long wid = this.findWeimengWidBySysMemberCode(param.getMemberCode());
        // 查找券对应的微盟模板id
        Long couponTemplateId = sysCrmWmFieldMappingService.findWmFieldByCrmField(param.getCouponDefinitionCode(), CrmWmFieldMappingTypeEnum.COUPON_CODE.getCode(), Long.class);
        // vid 使用配置默认值
        param.setVid(wmSystemFieldConfig.getVid());
        param.setWid(wid);
        param.setCouponTemplateId(couponTemplateId);
    }

}
