package com.daas.nros.connector.server.service.impl.weimob;

import com.alibaba.fastjson.JSON;
import com.daas.nros.connector.server.mapper.SysCrmWmFieldMappingPOMapper;
import com.daas.nros.connector.client.model.po.SysCrmWmFieldMappingPO;
import com.daas.nros.connector.client.model.po.SysCrmWmFieldMappingPOExample;
import com.daas.nros.connector.server.service.api.weimob.SysCrmWmFieldMappingService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.thymeleaf.util.StringUtils;

import javax.annotation.Resource;
import java.util.List;


/**
 * CRM 与 微盟字段映射关系
 */
@Slf4j
@Service
public class SysCrmWmFieldMappingServiceImpl implements SysCrmWmFieldMappingService {

    @Resource
    private SysCrmWmFieldMappingPOMapper sysCrmWmFieldMappingPOMapper;

    /**
     * 插入CRM 与 微盟字段映射
     * @param entity
     * @return
     */
    @Override
    public Boolean insertSysCrmWmFieldMapping(SysCrmWmFieldMappingPO entity) {
        log.info("insertSysCrmWmFieldMapping,entity:{}", JSON.toJSONString(entity));
        // 校验入参
        if (!checkInsertSysCrmWmFieldMapping(entity)){
            log.info("insertSysCrmWmFieldMapping entity is null, error");
            return false;
        }
        // 判断是否已经存在
        String oldFidld = findWmFieldByCrmField(entity.getCrmField(), entity.getMappingType());
        if (!StringUtils.isEmpty(oldFidld)){
            log.info("insertSysCrmWmFieldMapping entity is exist, error");
            return false;
        }
        entity.setValid(Boolean.TRUE);
        sysCrmWmFieldMappingPOMapper.insertSelective(entity);
        return Boolean.TRUE;
    }


    /**
     * 初始化
     * @param wmField
     * @param crmField
     * @param mappingType
     * @return
     */
    @Override
    public SysCrmWmFieldMappingPO initSysCrmWmFieldMappingPO(String wmField, String crmField, int mappingType){
        SysCrmWmFieldMappingPO mapping = new SysCrmWmFieldMappingPO();
        mapping.setWmField(wmField);
        mapping.setCrmField(crmField);
        mapping.setMappingType(mappingType);
        mapping.setValid(Boolean.TRUE);
        return mapping;
    }

    /**
     * 判断指定类型是否已经存在映射关系
     * @param mappingType
     * @return
     */
    @Override
    public Boolean isExistByMappingType(int mappingType) {
        SysCrmWmFieldMappingPOExample example = new SysCrmWmFieldMappingPOExample();
        SysCrmWmFieldMappingPOExample.Criteria criteria = example.createCriteria();
        criteria.andMappingTypeEqualTo(mappingType).andValidEqualTo(Boolean.TRUE);
        List<SysCrmWmFieldMappingPO> sysCrmWmFieldMappingPOS = sysCrmWmFieldMappingPOMapper.selectByExample(example);
        return CollectionUtils.isNotEmpty(sysCrmWmFieldMappingPOS);
    }

    /**
     * 校验入参
     * @param entity
     * @return
     */
    private boolean checkInsertSysCrmWmFieldMapping(SysCrmWmFieldMappingPO entity){
        if (entity == null || StringUtils.isEmpty(entity.getCrmField())
                || StringUtils.isEmpty(entity.getWmField())
                || null == entity.getMappingType()){
            return false;
        }
        return true;
    }

    /**
     * 根据crm的字段和类型，查找对应的微盟字段
     * @param crmField
     * @return
     */
    @Override
    public String findWmFieldByCrmField(String crmField, int type) {
        return findWmFieldByCrmFieldForStr(crmField, type);
    }

    /**
     * 根据crm的字段和类型，查找对应的微盟字段, 返回指定类型
     * @param crmField
     * @return
     */
    @Override
    public Long findWmFieldByCrmField(String crmField, int type, Class<Long> targetClass) {
        String wmField = findWmFieldByCrmFieldForStr(crmField, type);
        if (StringUtils.isEmpty(wmField)){
            return null;
        }
        return  Long.valueOf(wmField);
    }

    @Override
    public Long findWmFieldByCrmFieldForLong(String crmField, int type) {
        String wmField = findWmFieldByCrmFieldForStr(crmField, type);
        if (StringUtils.isEmpty(wmField)){
            return null;
        }
        return Long.valueOf(wmField);
    }

    private String findWmFieldByCrmFieldForStr(String crmField, int type){
        log.info("findWmFieldByCrmField,crmField:{}, type:{}, targetClass:{}", crmField, type);
        SysCrmWmFieldMappingPOExample example = new SysCrmWmFieldMappingPOExample();
        SysCrmWmFieldMappingPOExample.Criteria criteria = example.createCriteria();
        criteria.andCrmFieldEqualTo(crmField).andMappingTypeEqualTo(type).andValidEqualTo(Boolean.TRUE);
        List<SysCrmWmFieldMappingPO> sysCrmWmFieldMappingPOS = sysCrmWmFieldMappingPOMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(sysCrmWmFieldMappingPOS)){
            log.info("findWmFieldByCrmField, not find wm field");
            return null;
        }
        SysCrmWmFieldMappingPO mappingPO = sysCrmWmFieldMappingPOS.get(0);
        log.info("findWmFieldByCrmField, mappingPO:{}",JSON.toJSONString(mappingPO));
        String wmField = mappingPO.getWmField();
        log.info("findWmFieldByCrmField, result:{}", wmField);
        return wmField;
    }
}
