package com.daas.nros.connector.server.service.impl.burgeon;

import com.alibaba.fastjson.JSONObject;
import com.daas.nros.connector.server.service.api.burgeon.VgMemberService;
import com.daas.nros.connector.client.burgeon.constants.VgIposCouponMethodConstant;
import com.daas.nros.connector.client.burgeon.model.vo.AddVipResponseVO;
import com.daas.nros.connector.client.burgeon.model.vo.VgAddVipRequestVO;
import com.daas.nros.connector.server.config.burgeon.IposConfig;
import com.daas.nros.connector.client.enums.ConnectorResponseEnum;
import com.daas.nros.connector.client.model.result.Result;
import com.daas.nros.connector.client.util.RestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.Map;

@Service("vgMember")
public class VgMemberServiceImpl implements VgMemberService {

    private static Logger logger = LoggerFactory.getLogger(VgMemberServiceImpl.class.getName());

    @Override
    public Result<AddVipResponseVO> addVip(VgAddVipRequestVO requestVO) {
        Map map = IposConfig.signToRequest(VgIposCouponMethodConstant.VG_ADD_VIP_METHOD);
        map.put("param",requestVO);
        Result result = new Result();
        String url = IposConfig.url + VgIposCouponMethodConstant.VG_ADD_VIP;
        logger.info("调用:add_vip---------url:" + url);
        try{
            String resultStr = RestUtils.sendRequestBuff(url, JSONObject.toJSONString(map), "POST");
            result.setCode(ConnectorResponseEnum.SUCCESS.getCode());
            result.setData(resultStr);
        } catch (Exception e) {

        }
        return result;
    }
}
