package com.daas.nros.connector.server.service.impl.burgeon;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;

import com.bizvane.couponfacade.interfaces.CouponDefinitionServiceFeign;
import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.daas.nros.connector.client.api.base.CouponSingleService;
import com.daas.nros.connector.server.service.api.burgeon.VgCouponService;
import com.daas.nros.connector.client.burgeon.constants.VgIposCouponMethodConstant;
import com.daas.nros.connector.client.burgeon.model.vo.*;
import com.daas.nros.connector.server.service.conver.DataConver;
import com.daas.nros.connector.server.config.burgeon.IposConfig;
import com.daas.nros.connector.client.enums.ConnectorResponseEnum;
import com.daas.nros.connector.client.enums.StringBrandCode;
import com.daas.nros.connector.client.model.po.MbrMembersPo;
import com.daas.nros.connector.client.model.result.Result;
import com.daas.nros.connector.client.util.HttpClientUtil;
import com.daas.nros.connector.client.util.RestUtils;
import com.daas.nros.connector.server.service.api.weimob.SysWeimengService;
import com.daas.nros.connector.client.weimob.model.req.param.CouponBindMemberParam;
import com.daas.nros.connector.client.weimob.model.vo.VgAddCouponDefinitionRe;
import com.daas.nros.connector.client.weimob.model.vo.VgAddGiveCouponVoRe;
import com.daas.nros.connector.client.weimob.model.vo.VgCancelCouponVoRe;
import com.daas.nros.connector.client.weimob.model.vo.VgUseCouponVoRe;
import com.daas.nros.connector.client.weimob.rpc.WmConnectServiceFeign;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;

@Service("vgCoupon")
public class VgCouponServiceImpl implements VgCouponService {

    private static Logger logger = LoggerFactory.getLogger(VgCouponServiceImpl.class.getName());

    @Autowired
    private CouponSingleService couponSingleService;

    @Autowired
    private VgCouponService vgCouponService;

    @Autowired
    private CouponDefinitionServiceFeign couponDefinitionServiceFeign;

    @Autowired
    private WmConnectServiceFeign wmConnectServiceFeign;

    @Autowired
    private SysWeimengService sysWeimengService;

    @Override
    public Result<JSONObject> sendCoupon(VgAddCouponCrmVO vgAddCouponCrmVO) {
        Result result = new Result();
        Byte coupStatus = 0;
        try {
            Map map = IposConfig.signToRequest(VgIposCouponMethodConstant.ADD_COUPON_METHOD);
            map.put("param", vgAddCouponCrmVO);
            String resultStr = null;
            String url = IposConfig.url + VgIposCouponMethodConstant.ADD_COUPON;
            String param = JSON.toJSONString(map);
            logger.info("jh_third_interface sendCoupon param : {} , url :{}" , param, url);
            resultStr = RestUtils.sendRequestBuff(url, param, "POST");
            JSONObject resultObject=JSON.parseObject(resultStr);
            if(resultObject.get("code").toString().equals("100")){
                result.setCode(ConnectorResponseEnum.SUCCESS.getCode());
                result.setData(resultObject);
                coupStatus = 1;
                // 同步到微盟
                logger.info("sendCoupon, couponBindingMemberToWm, vo:{}", JSON.toJSONString(vgAddCouponCrmVO));
                Result<Object> wmResult = couponBindingMemberToWm(vgAddCouponCrmVO);
                logger.info("sendCoupon, couponBindingMemberToWm, result:{}", JSON.toJSONString(wmResult));
            } else {
                result.setCode(ConnectorResponseEnum.FAILED.getCode());
                result.setData(resultObject);
            }
        } catch (Exception e) {
            logger.error("jh_third_interface sendCoupon error : {}" , e.getMessage());
            result.setCode(ConnectorResponseEnum.FAILED.getCode());
            result.setMessage(e.getMessage());
        } finally {
            try {
                couponSingleService.callbackSingleCoupon(vgAddCouponCrmVO.getCoupNo(), coupStatus, vgAddCouponCrmVO.getIfSendAgain());
            } catch (Exception e){
                logger.error("jh_third_interface sendCoupon 状态回调失败: {}" , e.getMessage());
            }
        }
        return result;
    }

    @Override
    public Result<JSONObject> sendCouponBatch(JSONObject jsonObject) {
        Map map= IposConfig.signToRequest(VgIposCouponMethodConstant.ADD_COUPON_METHOD);
        map.put("param",jsonObject);
        Result result = new Result();
        String resultStr = null;
        try {
            String url = IposConfig.url + VgIposCouponMethodConstant.ADD_COUPON;
            logger.info("jh_third_interface sendCouponBatch url:" + url);
            resultStr = RestUtils.sendRequestBuff(url, JSON.toJSONString(map), "POST");
            return DataConver.resultObj(result,resultStr);
        } catch (Exception e) {
            logger.error("jh_third_interface sendCouponBatch 发批量券失败 :"+e.getMessage());
            result.setCode(ConnectorResponseEnum.FAILED.getCode());
            result.setMessage(e.getMessage());
        }
        return result;
    }

    @Override
    public Result<JSONObject> addCouponGrp(JSONObject jsonObject,String tag) {
        Map map= IposConfig.signToRequest(VgIposCouponMethodConstant.ADD_COUPON_GRP_METHOD);
        VgAddCouponDefinitionVo vgAddCouponDefinition = JSON.parseObject(JSON.toJSONString(jsonObject), new TypeReference<VgAddCouponDefinitionVo>() {});
        VgAddCouponDefinitionRe vgAddCouponDefinitionRe= DataConver.mqCouponDeToCrmVo(vgAddCouponDefinition,tag);
        vgAddCouponDefinitionRe.setChangeType(VgIposCouponMethodConstant.ADD_COUPON_GRP_CHANGE_TYPE_A);
        map.put("param", vgAddCouponDefinitionRe);
        Result result = new Result();
        String resultStr = null;
        try {
            String url = IposConfig.url + VgIposCouponMethodConstant.ADD_COUPON_GRP;
            String param = JSON.toJSONString(map);
            logger.info("jh_third_interface addCouponGrp---------param :{} ,url :{}" , param , url);
            resultStr = HttpClientUtil.doPost(url, param);
            return DataConver.resultObj(result, resultStr);
        } catch (Exception e) {
            logger.error("jh_third_interface addCouponGrp 发券规则失败 :{} ,data:{}",e.getMessage() , jsonObject);
            result.setCode(ConnectorResponseEnum.FAILED.getCode());
            result.setMessage(e.getMessage());
        }
        return result;
    }

    @Override
    public Result<JSONObject> invalidCouponGrp(JSONObject jsonObject, String tag) {
        Map map= IposConfig.signToRequest(VgIposCouponMethodConstant.INVALID_COUPON_GRP_METHOD);
        VgAddCouponDefinitionVo vgAddCouponDefinition = JSON.parseObject(JSON.toJSONString(jsonObject), new TypeReference<VgAddCouponDefinitionVo>() {});
        VgAddCouponDefinitionRe vgAddCouponDefinitionRe= DataConver.mqCouponDeToCrmVo(vgAddCouponDefinition,tag);
        vgAddCouponDefinitionRe.setChangeType(VgIposCouponMethodConstant.ADD_COUPON_GRP_CHANGE_TYPE_D);
        map.put("param",vgAddCouponDefinitionRe);
        Result result = new Result();
        String resultStr = null;
        try {
            String url = IposConfig.url + VgIposCouponMethodConstant.INVALID_COUPON_GRP;
            String param = JSON.toJSONString(map);
            logger.info("jh_third_interface invalidCouponGrp---------param :{} ,url :{}" , param , url);
            resultStr = RestUtils.sendRequestBuff(url, param, "POST");
            return DataConver.resultObj(result,resultStr);
        } catch (Exception e) {
            logger.error("jh_third_interface invalidCouponGrp 作废发券规则失败 :{} ,data:{}",e.getMessage() , jsonObject);
            result.setCode(ConnectorResponseEnum.FAILED.getCode());
            result.setMessage(e.getMessage());
        }
        return result;
    }

    @Override
    public Result<JSONObject> modifyCouponGrp(JSONObject jsonObject, String tag) {
        Map map= IposConfig.signToRequest(VgIposCouponMethodConstant.MODIFY_COUPON_GRP_METHOD);
        VgAddCouponDefinitionVo vgAddCouponDefinition = JSON.parseObject(JSON.toJSONString(jsonObject), new TypeReference<VgAddCouponDefinitionVo>() {});
        VgAddCouponDefinitionRe vgAddCouponDefinitionRe= DataConver.mqCouponDeToCrmVo(vgAddCouponDefinition,tag);
        vgAddCouponDefinitionRe.setChangeType(VgIposCouponMethodConstant.ADD_COUPON_GRP_CHANGE_TYPE_M);
        map.put("param",vgAddCouponDefinitionRe);
        Result result = new Result();
        String resultStr=null;
        try {
            String url = IposConfig.url + VgIposCouponMethodConstant.MODIFY_COUPON_GRP;
            String param = JSON.toJSONString(map);
            logger.info("jh_third_interface modifyCouponGrp---------param :{} ,url :{}" , param , url);
            resultStr = RestUtils.sendRequestBuff(url, param, "POST");
            return DataConver.resultObj(result,resultStr);
        } catch (Exception e) {
            logger.error("jh_third_interface modifyCouponGrp 修改发券规则商品失败 :{} ,data:{}",e.getMessage() , jsonObject);
            result.setCode(ConnectorResponseEnum.FAILED.getCode());
            result.setMessage(e.getMessage());
        }
        return result;
    }

    @Override
    public Result<JSONObject> giveCoupon(JSONObject jsonObject) {
        VgAddGiveCouponVo vgAddGiveCouponVo = JSON.parseObject(JSON.toJSONString(jsonObject), new TypeReference<VgAddGiveCouponVo>() {});
        VgAddGiveCouponVoRe vgAddGiveCouponVoRe= DataConver.giveCouponToCrm(vgAddGiveCouponVo);
        Map map= IposConfig.signToRequest(VgIposCouponMethodConstant.GIVE_COUPON_METHOD);
        map.put("param",vgAddGiveCouponVoRe);
        Result result = new Result();
        String resultStr=null;
        try {
            String url = IposConfig.url + VgIposCouponMethodConstant.GIVE_COUPON;
            String param=JSON.toJSONString(map);
            logger.info("jh_third_interface giveCoupon---------param :{} ,url :{}" + param,url);
            resultStr = RestUtils.sendRequestBuff(url, param, "POST");
            return DataConver.resultObj(result,resultStr);
        } catch (Exception e) {
            logger.error("jh_third_interface giveCoupon 转赠券失败 :{} , data :{}",e.getMessage(),jsonObject);
            result.setCode(ConnectorResponseEnum.FAILED.getCode());
            result.setMessage(e.getMessage());
        }
        return result;
    }

    @Override
    public Result<JSONObject> cancelCouponBatch(JSONObject jsonObject,String club) {
        VgCancelCouponVo vgCancelCouponVo = JSON.parseObject(JSON.toJSONString(jsonObject), new TypeReference<VgCancelCouponVo>() {});
        VgCancelCouponVoRe vgAddGiveCouponVoRe = DataConver.cancelCouponToCrm(vgCancelCouponVo, vgCancelCouponVo.getBrandCode() );
        JSONArray jsonArray = new JSONArray();
        jsonArray.add(vgAddGiveCouponVoRe);
        Map map= IposConfig.signToRequest(VgIposCouponMethodConstant.CANCEL_COUPON_BATCH_METHOD);
        map.put("param",jsonArray);
        Result result = new Result();
        String resultStr=null;
        try {
            String url = IposConfig.url + VgIposCouponMethodConstant.CANCEL_COUPON_BATCH;
            String param=JSON.toJSONString(map);
            logger.info("jh_third_interface cancelCouponBatch---------param :{}, url :{}" , param , url);
            resultStr = RestUtils.sendRequestBuff(url, param, "POST");
            return DataConver.resultObj(result,resultStr);
        } catch (Exception e) {
            logger.error("jh_third_interface cancelCouponBatch 券作废失败 :{} ,data :{}",e.getMessage(),jsonObject);
            result.setCode(ConnectorResponseEnum.FAILED.getCode());
            result.setMessage(e.getMessage());
        }
        return result;
    }

    @Override
    public Result<JSONObject> useCoupon(JSONObject jsonObject,String tag) {
        VgUseCouponVo vgUseCouponVo = JSON.parseObject(JSON.toJSONString(jsonObject), new TypeReference<VgUseCouponVo>() {});
        VgUseCouponVoRe vgUseCouponVoRe = DataConver.useCouponToCrm(vgUseCouponVo,vgUseCouponVo.getBrandCode());
        Map map= IposConfig.signToRequest(VgIposCouponMethodConstant.USE_COUPON_METHOD);
        map.put("param",vgUseCouponVoRe);
        Result result = new Result();
        String resultStr = null;
        try {
            String url = IposConfig.url + VgIposCouponMethodConstant.USE_COUPON;
            String param = JSON.toJSONString(map);
            logger.info("jh_third_interface useCoupon---------param :{} ,url :{}" , param,url);
            resultStr = RestUtils.sendRequestBuff(url, param, "POST");
            return DataConver.resultObj(result,resultStr);
        } catch (Exception e) {
            logger.error("toJSONString useCoupon 券核销失败 :{}, data :{}" ,e.getMessage(),jsonObject);
            result.setCode(ConnectorResponseEnum.FAILED.getCode());
            result.setMessage(e.getMessage());
        }
        return result;
    }

    /**
     * 会员领券同步到微盟
     */
    private Result<Object> couponBindingMemberToWm(VgAddCouponCrmVO vo) throws ParseException {
        Result<Object> result = new Result<>();
        result.setCode(SysResponseEnum.FAILED.getCode());
        logger.info("couponBindingMemberToWm,vo:{}", JSON.toJSONString(vo));
        // 校验入参
        if (!checkCouponBindingMemberToWm(vo)){
            result.setMessage("参数不完整");
            result.setCode(SysResponseEnum.SUCCESS.getCode());
            return result;
        }

        // 校验当前品牌和券适用品牌是否包含VG
        CouponDefinitionPO definition = findCouponDefinitionByCouponCode(vo.getCoupNo());
        if (!StringBrandCode.vg.getValue().equals(vo.getBrandCode()) && !isExist(definition, StringBrandCode.vg.getValue())){
            logger.info("couponBindingMemberToWm, 当前品牌不是VG,所以不同步到微盟");
            result.setCode(SysResponseEnum.SUCCESS.getCode());
            return  result;
        }
        MbrMembersPo member = sysWeimengService.findMbrMemberBy(vo.getCardNo(), 3, vo.getBrandCode());
        if (member == null){
            logger.info("couponBindingMemberToWm,member is null");
            result.setMessage("找不到对应的会员");
            return result;
        }
        // 根据券定义id，查询券定义实体
        String couponDefinitionCode = findCouponDefinitionCodeByCouponCode(vo.getCoupNo());
        if (StringUtils.isBlank(couponDefinitionCode)){
            logger.info("couponBindingMemberToWm,couponDefinitionCode is null");
            result.setMessage("找不到对应的券模板");
            return result;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        CouponBindMemberParam param = new CouponBindMemberParam();
        // 会员领券时间搓， 取修改时间
        Long acquireTime = sdf.parse(vo.getUpdateTime()).getTime();
        Long startDate = sdf.parse(vo.getDateBegin()).getTime();
        Long endDate = sdf.parse(vo.getDateEnd()).getTime();
        param.setAcquireTime(acquireTime);
        param.setExpireStartTime(startDate);
        param.setExpireEndTime(endDate);
        param.setCouponCode(vo.getCoupNo());
        param.setMemberCode(member.getMemberCode());
        param.setCouponDefinitionCode(couponDefinitionCode);
        logger.info("couponBindingMemberToWm, couponBindMember, param:{}", JSON.toJSONString(param));
        result = sysWeimengService.couponBindMember(param);
        logger.info("couponBindingMemberToWm, couponBindMember, result:{}", JSON.toJSONString(result));
        return result;
    }

    /**
     * 判断适用品牌是否包含指定品牌
     * @param definition
     * @param brandCode
     * @return
     */
    private boolean isExist(CouponDefinitionPO definition, String brandCode){
        if (definition == null){
            return false;
        }
        if (StringUtils.isBlank(definition.getApplicableBrandCodes())){
            return false;
        }
        if (!definition.getApplicableBrandCodes().contains(brandCode)){
            return false;
        }
        return true;
    }

    /**
     * 根据券定义id查询券定义信息
     * @param couponDefId
     * @return
     */
    public CouponDefinitionPO findCouponDefinitionPOByCouponDefId(Long couponDefId){
        logger.info("findCouponDefinitionPOByCouponDefId, couponDefId:{}", couponDefId);
        ResponseData<CouponDefinitionPO> responseData = couponDefinitionServiceFeign.findCouponDefinitionPOByCouponDefId(couponDefId);
        logger.info("findCouponDefinitionPOByCouponDefId, responseData:{}", JSON.toJSONString(responseData));
        if (responseData.getCode() == SysResponseEnum.SUCCESS.getCode()){
            return responseData.getData();
        }
        return null;
    }

    /**
     * 根据券定义id查询券定义信息
     * @param couponCode
     * @return
     */
    public String findCouponDefinitionCodeByCouponCode(String couponCode){
        logger.info("findCouponDefinitionCodeByCouponCode, couponCode:{}", couponCode);
        ResponseData<String> responseData = couponDefinitionServiceFeign.findCouponDefinitionCodeByCouponCode(couponCode);
        logger.info("findCouponDefinitionCodeByCouponCode, responseData:{}", JSON.toJSONString(responseData));
        if (responseData.getCode() == SysResponseEnum.SUCCESS.getCode()){
            return responseData.getData();
        }
        return null;
    }

    /**
     * 根据券定义id查询券定义信息
     * @param couponCode
     * @return
     */
    public CouponDefinitionPO findCouponDefinitionByCouponCode(String couponCode){
        logger.info("findCouponDefinitionByCouponCode, couponCode:{}", couponCode);
        ResponseData<CouponDefinitionPO> responseData = couponDefinitionServiceFeign.findCouponDefinitionByCouponCode(couponCode);
        logger.info("findCouponDefinitionByCouponCode, responseData:{}", JSON.toJSONString(responseData));
        if (responseData.getCode() == SysResponseEnum.SUCCESS.getCode()){
            return responseData.getData();
        }
        return null;
    }

    /**
     * 校验入参
     * @param vo
     * @return
     */
    private boolean checkCouponBindingMemberToWm(VgAddCouponCrmVO vo){
        return Boolean.TRUE;
    }
}
