package com.daas.nros.connector.server.service.impl.burgeon;

import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.daas.nros.connector.server.service.api.burgeon.VGSerialNumberRecordService;
import com.daas.nros.connector.server.service.api.burgeon.VGSerialNumberService;
import com.daas.nros.connector.server.mapper.VGSerialNumberMapper;
import com.daas.nros.connector.client.weimob.model.vo.VGSerialNumberVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;

@Service
@Slf4j
public class VGSerialNumberServiceImpl implements VGSerialNumberService {

    private final String VG_OPENCARD_SERIAL_NUMBER_CONSTANTS = "VG_CARD_";

    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;

    @Resource
    private VGSerialNumberMapper vgSerialNumberMapper;

    @Autowired
    private VGSerialNumberRecordService vgSerialNumberRecordService;

    @Override
    public String getRedisNo(String prefix) {
        String yyHHmm = vgSerialNumberMapper.getDate();
        if(StringUtils.isEmpty(yyHHmm) || yyHHmm.length() != 6){
            throw new RuntimeException("获取db时间失败!");
        }
        String redisKey = VG_OPENCARD_SERIAL_NUMBER_CONSTANTS + yyHHmm;
        Long currentSerialNumber = redisTemplateService.incr(redisKey, 100 * 12 * 30 * 24 * 60 * 60) + 1;
        log.info("当前生成redis流水号为:{}",currentSerialNumber);
        String thisCardNo = prefix + yyHHmm + String.format("%06d", currentSerialNumber);
        return thisCardNo;
    }

    @Override
    public String getRedisNoAndSaveSerialNumberRecord(VGSerialNumberVo vgSerialNumberVo) {
        String prefix = vgSerialNumberVo.getPrefix();
        String redisNo = this.getRedisNo(prefix);
        int rows = vgSerialNumberRecordService.insertRecord(vgSerialNumberVo, redisNo);
        return redisNo;
    }
}
