package com.daas.nros.connector.server.service.impl.burgeon;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import com.bizvane.utils.enumutils.SysResponseEnum;
import com.daas.nros.connector.client.api.ConnectConfigService;
import com.daas.nros.connector.server.service.api.burgeon.MemberService;
import com.daas.nros.connector.client.burgeon.constants.VgMethodConstant;
import com.daas.nros.connector.server.config.burgeon.CrmJointVConfig;
import com.daas.nros.connector.server.config.burgeon.IposConfig;
import com.daas.nros.connector.client.constants.Constant;
import com.daas.nros.connector.server.mapper.MbrLevelDefPoMapper;
import com.daas.nros.connector.server.mapper.MbrMembersPoMapper;
import com.daas.nros.connector.server.mapper.SysBrandPoMapper;
import com.daas.nros.connector.client.model.po.*;
import com.daas.nros.connector.client.model.result.Result;
import com.daas.nros.connector.client.model.vo.*;
import com.daas.nros.connector.client.util.DateUtil;
import com.daas.nros.connector.client.util.RestUtils;
import com.daas.nros.connector.client.weimob.model.vo.OfflineMemberLevelRequestVo;
import com.daas.nros.connector.client.weimob.model.vo.OfflineMemberRequestVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


@Service("member")
public class JHMemberServiceImpl extends BasicServiceImpl implements MemberService {

    private static Logger logger = LoggerFactory.getLogger(JHMemberServiceImpl.class.getName());

    @Autowired
    private ConnectConfigService connectConfigService;

    @Autowired
    private JHMallServiceComponent jhMallServiceComponent;

    @Resource
    private MbrMembersPoMapper mbrMembersPoMapper;

    @Resource
    private SysBrandPoMapper sysBrandPoMapper;

    @Resource
    private MbrLevelDefPoMapper mbrLevelDefPoMapper;

    /**
     * 会员新增
     * @param requestVO
     * @return
     *
     * 1 调用连接器不和POS，商城交互的话，直接type = 3
     * 2 调用连接器，POS返回已经存在，type = 1
     * 3 调用连接器，POS返回不存在， type = 2
     */
    @Override
    public Result<MemberOpenCardResponseVO> loginandopencard(MemberOpenCardRequestVO requestVO){

        Result<MemberOpenCardResponseVO> returnResult = new Result();
        MemberOpenCardResponseVO memberOpenCardResponseVO = new MemberOpenCardResponseVO();
        try{
            // 先判断参数传递的是否正确code
            String offlineBrandCode = requestVO.getOfflineBrandCode() ;
            Long brandId = requestVO.getBrandId();

            ConnectConfig connectConfig = connectConfigService.queryByOnlineBrandId(brandId);
            if( connectConfig==null || StringUtils.isBlank(connectConfig.getOfflineBrandCode()) ){
                logger.error( "jh_third_interface loginAndOpenCard getBrandCode error : {}", JSONObject.toJSONString( requestVO ) );
                returnResult.setCode( SysResponseEnum.MODEL_FAILED_VALIDATION.getCode() );
                returnResult.setMessage( "获取brandCode失败..." );
                returnResult.setData( memberOpenCardResponseVO );
                return returnResult;
            }
            offlineBrandCode = connectConfig.getOfflineBrandCode();
            requestVO.setOfflineBrandCode( offlineBrandCode );

            memberOpenCardResponseVO.setOfflineCardNo( requestVO.getCardNo() );
            memberOpenCardResponseVO.setErpId( requestVO.getCardNo() );
            memberOpenCardResponseVO.setBrandId( brandId );
            memberOpenCardResponseVO.setSessionTokenId( requestVO.getSessionTokenId() );
            memberOpenCardResponseVO.setOfflineBrandCode( offlineBrandCode );

            // 集团卡的不需要同步到线下
            if( isJHBrandRequest( offlineBrandCode )){
                return getMemberOpenCardResponseVOResultMall(requestVO, returnResult, memberOpenCardResponseVO);
            }
            // 卡号为空
            if(StringUtils.isBlank(requestVO.getCardNo())){
                logger.error( "jh_third_interface loginAndOpenCard cardNo empty : {}", JSONObject.toJSONString( requestVO ) );
                returnResult.setCode( SysResponseEnum.MODEL_FAILED_VALIDATION.getCode() );
                returnResult.setMessage( "卡号不能为空" );
                return returnResult;
            }
            // 会员新增，只需要新增TW的，不需要同步TT-TN-TZ的
            if( checkBrandCodeIsTWUnder( requestVO.getOfflineBrandCode() ) ){
                logger.info( "jh_third_interface loginAndOpenCard 会员新增，只需要新增TW的，不需要同步TT-TN-TZ的 : {}", JSONObject.toJSONString( requestVO ) );
                returnResult.setCode( SysResponseEnum.SUCCESS.getCode() );
                returnResult.setMessage( "会员新增，只需要新增TW的，不需要同步TT-TN-TZ的" );
                returnResult.setData( memberOpenCardResponseVO );
                memberOpenCardResponseVO.setType( 3 );
                return returnResult;
            }

            if(isMallBrandRequest(offlineBrandCode)){
                try{
                    Result<MemberOpenCardResponseVO> loginandopencard = jhMallServiceComponent.loginandopencard(requestVO, memberOpenCardResponseVO);
                    logger.info( "jh_third_interface loginAndOpenCard mall会员新增: {}", JSONObject.toJSONString( loginandopencard ) );
                    if(loginandopencard.getCode().equals(SysResponseEnum.SUCCESS.getCode())){
                        return loginandopencard;
                    }
                }catch (Exception e){
                    logger.info("jhMallServiceComponent.loginandopencard error:{}",e);
                }
                return getMemberOpenCardResponseVOResultMall(requestVO, returnResult, memberOpenCardResponseVO);
            }

            Map map = IposConfig.signToRequest( Constant.VIP_ADD_METHOD );
            // 判断当前参数
            if( MapUtils.isEmpty(map) ){
                logger.error( "jh_third_interface loginAndOpenCard sign error : {}", JSONObject.toJSONString( map ) );
                returnResult.setCode( SysResponseEnum.MODEL_FAILED_VALIDATION.getCode() );
                returnResult.setMessage( SysResponseEnum.MODEL_FAILED_VALIDATION.getMessage() );
                return returnResult;
            }
            OfflineMemberRequestVo offlineMemberRequestVo = OfflineMemberRequestVo
                    .builder()
                    .brandCode( requestVO.getOfflineBrandCode() )
                    .cardNo( requestVO.getCardNo() )
                    .levelCode( requestVO.getLevelCode() )
                    .storeCode( requestVO.getOpenStoreCode() )
                    .guideCode( requestVO.getOpenGuideCode() )
                    .serviceStoreCode( requestVO.getServiceStoreCode() )
                    .serviceGuideCode( requestVO.getServiceGuideCode() )
                    .openCardTime(DateUtil.transformDateToStandard( requestVO.getOpenCardTime() ) )
                    .validDate( transformDateToInt( requestVO.getEffectiveTime() ) )
                    .name( requestVO.getName() )
                    .mobile( requestVO.getPhone() )
                    .sex( transformSex( requestVO.getGender() ) )
                    .birthday( transformDateToInt( requestVO.getBirthday() ) )
                    .valid( "Y" )
                    .build();

            map.put( "param",JSON.toJSON( offlineMemberRequestVo ) );

            String mapParams = JSONObject.toJSONString( map );
            logger.info( "jh_third_interface vipAdd start mapParams : {}" , mapParams );
            String httpResult = RestUtils.sendRequestBuff( IposConfig.url + VgMethodConstant.VGCRM_ADD_VIP , mapParams ,"POST" );
            logger.info( "jh_third_interface vipAdd end httpResult : {}" , httpResult );
            JSONObject jsonObjectHttpResult = JSON.parseObject( httpResult );

            Integer returnCode = Integer.valueOf( jsonObjectHttpResult.getOrDefault( "code",SysResponseEnum.FAILED.getCode() ).toString() );
            returnResult.setCode( returnCode==100 ? SysResponseEnum.SUCCESS.getCode() : returnCode );
            returnResult.setMessage( jsonObjectHttpResult.getOrDefault( "message",SysResponseEnum.FAILED.getMessage() ).toString() );
            if( returnCode==100 ){
                // 会员已存在
                if( jsonObjectHttpResult.getJSONObject("data") != null && jsonObjectHttpResult.getJSONObject("data").getOrDefault("subCode","").equals("110") ){
                    memberOpenCardResponseVO.setType( 1 );
                }else{
                    memberOpenCardResponseVO.setType( 2 );
                }
            }

        }catch (Exception e){
            e.printStackTrace();
            logger.error( "jh_third_interface vipAdd error : {}",e.getMessage() );
            returnResult.setCode( SysResponseEnum.SYSTEM_ERROR.getCode() );
            returnResult.setMessage( e.getMessage() );
        }
        returnResult.setData( memberOpenCardResponseVO );
        logger.info( "jh_third_interface loginAndOpenCard 返回结果 : {}", JSONObject.toJSONString( returnResult ) );
        return returnResult;
    }

    private Result<MemberOpenCardResponseVO> getMemberOpenCardResponseVOResultMall(MemberOpenCardRequestVO requestVO, Result<MemberOpenCardResponseVO> returnResult, MemberOpenCardResponseVO memberOpenCardResponseVO) {
        logger.info("jh_third_interface loginAndOpenCard 集团卡不需要同步线下和Mall : {}", JSONObject.toJSONString(requestVO));
        returnResult.setCode(SysResponseEnum.SUCCESS.getCode());
        returnResult.setMessage("集团卡的会员新增不需要同步线下和Mall");
        memberOpenCardResponseVO.setType(3);
        returnResult.setData(memberOpenCardResponseVO);
        return returnResult;
    }


    /**
     * 会员信息修改
     * @param requestVO
     * @return
     */
    @Override
    public Result updateuserinfo(MemberInfoUpdateRequestVO requestVO, String logType){

        Result<String> returnResult = new Result();
        try{

            // 先判断参数传递的是否正确code
            String offlineBrandCode = requestVO.getOfflineBrandCode() ;
            Long brandId = requestVO.getBrandId();
            ConnectConfig connectConfig = connectConfigService.queryByOnlineBrandId(brandId);
            if (connectConfig == null || StringUtils.isBlank(connectConfig.getOfflineBrandCode())) {
                logger.error("jh_third_interface vipModify getBrandCode type:{} , error : {}", logType, JSONObject.toJSONString(requestVO));
                returnResult.setCode(SysResponseEnum.MODEL_FAILED_VALIDATION.getCode());
                returnResult.setMessage("获取brandCode失败...");
                return returnResult;
            }
            offlineBrandCode = connectConfig.getOfflineBrandCode();
            requestVO.setOfflineBrandCode( offlineBrandCode );

            // 卡号为空
            if(StringUtils.isBlank(requestVO.getOfflineCardNo() )){
                logger.error( "jh_third_interface vipModify cardNo type:{} , empty : {}", logType, JSONObject.toJSONString( requestVO ) );
                returnResult.setCode( SysResponseEnum.MODEL_FAILED_VALIDATION.getCode() );
                returnResult.setMessage( "卡号不能为空" );
                return returnResult;
            }

            // 锦集商城的不需要同步到线下
            if(isMallBrandRequest( requestVO.getOfflineBrandCode() ) ){
                logger.warn( "jh_third_interface vipModify type:{} , 集团卡会员信息修改不需要同步线下和Mall : {}", logType , JSONObject.toJSONString( requestVO ) );
                returnResult.setCode( SysResponseEnum.SUCCESS.getCode() );
                returnResult.setMessage( "集团卡的会员信息修改不需要同步到线下和Mall" );
                return returnResult;
            }
            //集团卡时，将其他线下俱乐部都推一次资料变同步
            if( isJHBrandRequest(requestVO.getOfflineBrandCode())){
                logger.info("jh_third_interface#vipModify#syncall");
                SysBrandPoExample sysBrandPoExample = new SysBrandPoExample();
                sysBrandPoExample.createCriteria().andValidEqualTo(Boolean.TRUE)
                        .andSysBrandIdEqualTo(brandId);
                List<SysBrandPo> sysBrandPos = sysBrandPoMapper.selectByExample(sysBrandPoExample);
                SysBrandPo sysBrandPo = sysBrandPos.get(0);

                SysBrandPoExample allBrandExample = new SysBrandPoExample();
                allBrandExample.createCriteria().andValidEqualTo(Boolean.TRUE)
                        .andSysCompanyIdEqualTo(sysBrandPo.getSysCompanyId())
                .andBrandCodeNotEqualTo(Constant.JH_CLUB).andBrandCodeNotEqualTo(Constant.MALL_CLUB);
                List<SysBrandPo> allOfflineBrand = sysBrandPoMapper.selectByExample(allBrandExample);
                for(SysBrandPo offlineBrand : allOfflineBrand){
                    MbrMembersPoExample mbrMembersPoExample = new MbrMembersPoExample();
                    mbrMembersPoExample.createCriteria().andValidEqualTo(Boolean.TRUE)
                            .andPhoneEqualTo(requestVO.getPhone()).andBrandIdEqualTo(offlineBrand.getSysBrandId().intValue());
                    List<MbrMembersPo> mbrMembersPos = mbrMembersPoMapper.selectByExample(mbrMembersPoExample);
                    MbrMembersPo mbrMembersPo = new MbrMembersPo();
                    String gender = "";
                    if(CollectionUtils.isEmpty(mbrMembersPos)){
                        logger.info("jh_third_interface#根据品牌id和手机号未查询到会员信息！");
                    }else {
                        mbrMembersPo = mbrMembersPos.get(0);
                        if (mbrMembersPo != null) {
                            gender = (mbrMembersPo.getGender()!=null?mbrMembersPo.getGender():"");
                        }else{
                            logger.info("jh_third_interface#根据品牌id和手机号未查询到会员信息,mbrMembersPo对象为空，性别未知！");
                        }
                    }
                    //mbrMembersPo对相中gender枚举含义为 女:1 男:2 未知:3
                    //requestVO 中 会员性别 1:男 0:女)
                    if( gender.equals("1") || gender.equals(1) ){
                        gender = "0";
                    }else if( gender.equals("2") || gender.equals(2) ){
                        gender = "1";
                    }else{
                        gender = null;
                    }
                    logger.info("jh_third_interface#会员信息修改接口#根据品牌id和手机号查询会员信息后,gender转换后为:{}",gender);
                    MbrLevelDefPo mbrLevelDefPo = mbrLevelDefPoMapper.selectByPrimaryKey(mbrMembersPo.getLevelId());
                    MemberInfoUpdateRequestVO memberInfoUpdateRequestVO = new MemberInfoUpdateRequestVO();
                    memberInfoUpdateRequestVO.setOfflineBrandCode(offlineBrand.getBrandCode());
                    memberInfoUpdateRequestVO.setOfflineCardNo(mbrMembersPo.getOfflineCardNo());
                    memberInfoUpdateRequestVO.setLevelCode(mbrLevelDefPo.getOfflineLevelCode());
                    memberInfoUpdateRequestVO.setOpenStoreCode(mbrMembersPo.getOpenCardStoreCode());
                    memberInfoUpdateRequestVO.setOpenGuideCode(mbrMembersPo.getOpenCardGuideCode());
                    memberInfoUpdateRequestVO.setServiceStoreCode(mbrMembersPo.getServiceStoreCode());
                    memberInfoUpdateRequestVO.setServiceGuideCode(mbrMembersPo.getServiceGuideCode());
                    memberInfoUpdateRequestVO.setName(mbrMembersPo.getName());
                    memberInfoUpdateRequestVO.setPhone(mbrMembersPo.getPhone());
                    memberInfoUpdateRequestVO.setGender(gender);
                    memberInfoUpdateRequestVO.setBirthday(DateUtil.dateFormatDate(mbrMembersPo.getBirthday()));
                    this.requestVipModify(memberInfoUpdateRequestVO, logType);
                }
                return returnResult;
            }else{
                MbrMembersPoExample mbrMembersPoExample = new MbrMembersPoExample();
                mbrMembersPoExample.createCriteria().andValidEqualTo(Boolean.TRUE)
                        .andPhoneEqualTo(requestVO.getPhone()).andBrandIdEqualTo(requestVO.getBrandId().intValue());
                List<MbrMembersPo> mbrMembersPos = mbrMembersPoMapper.selectByExample(mbrMembersPoExample);
                String gender = "";
                if(CollectionUtils.isEmpty(mbrMembersPos)){
                    logger.info("jh_third_interface#根据品牌id和手机号未查询到会员信息");
                }else {
                    MbrMembersPo mbrMembersPo = mbrMembersPos.get(0);
                    if (mbrMembersPo != null) {
                        gender = (mbrMembersPo.getGender()!=null?mbrMembersPo.getGender():"");
                    }else{
                        logger.info("jh_third_interface#根据品牌id和手机号未查询到会员信息,mbrMembersPo对象为空，性别未知");
                    }
                }
                //mbrMembersPo对相中gender枚举含义为 女:1 男:2 未知:3
                //requestVO 中 会员性别 1:男 0:女)
                if( gender.equals("1") || gender.equals(1) ){
                    gender = "0";
                }else if( gender.equals("2") || gender.equals(2) ){
                    gender = "1";
                }else{
                    gender = null;
                }
                logger.info("jh_third_interface#会员信息修改#根据品牌id和手机号查询会员信息后,gender转换为:{}",gender);
                requestVO.setGender(gender);
            }
            return this.requestVipModify(requestVO, logType);
        }catch (Exception e){
            e.printStackTrace();
            logger.error( "jh_third_interface vipModify type:{} , error : {}",logType,e.getMessage() );
            returnResult.setCode( SysResponseEnum.SYSTEM_ERROR.getCode() );
            returnResult.setMessage( e.getMessage() );
        }
        return returnResult;
    }

    private Result<String> requestVipModify(MemberInfoUpdateRequestVO requestVO, String logType) throws Exception {
        logger.info("jh_third_interface#requestVipModify#requestVO:{},logType:{}",JSON.toJSONString(requestVO),logType);
        Result<String> returnResult = new Result();
        Map map = IposConfig.signToRequest( Constant.VIP_MODIFY_METHOD );
        if( MapUtils.isEmpty( map ) ){
            logger.error( "jh_third_interface vipModify sign type:{} , error : {}",logType, JSONObject.toJSONString( map ) );
            returnResult.setCode( SysResponseEnum.MODEL_FAILED_VALIDATION.getCode() );
            returnResult.setMessage( SysResponseEnum.MODEL_FAILED_VALIDATION.getMessage() );
            return returnResult;
        }
        OfflineMemberRequestVo offlineMemberRequestVo = OfflineMemberRequestVo.builder()
                .brandCode( requestVO.getOfflineBrandCode() )
                .cardNo( requestVO.getOfflineCardNo() )
                .levelCode( requestVO.getLevelCode() )
                .storeCode( requestVO.getOpenStoreCode() )
                .guideCode( requestVO.getOpenGuideCode() )
                .serviceStoreCode( requestVO.getServiceStoreCode() )
                .serviceGuideCode( requestVO.getServiceGuideCode() )
                .openCardTime( "" )
                .validDate( null )
                .name( requestVO.getName() )
                .mobile( requestVO.getPhone() )
                .sex( transformSex( requestVO.getGender() ) )
                .birthday( transformDateToInt( requestVO.getBirthday() ) )
                .valid( "Y" )
                .build();

        String sendToOfflineBrandCode = offlineMemberRequestVo.getBrandCode();
        map.put( "param",JSON.toJSON( offlineMemberRequestVo ) );
        String mapParams = JSONObject.toJSONString(map);
        logger.info( "jh_third_interface vipModify start type:{} , mapParams : {}, sendToOfflineBrandCode :{}" , logType, mapParams,sendToOfflineBrandCode );
        String httpResult = RestUtils.sendRequestBuff( IposConfig.url + VgMethodConstant.VGCRM_VIP_MODIFY , mapParams ,"POST" );
        logger.info( "jh_third_interface vipModify end type:{} , httpResult : {} ,sendToOfflineBrandCode :{}" , logType, httpResult,sendToOfflineBrandCode );
        JSONObject jsonObjectHttpResult = JSON.parseObject( httpResult );

        Integer returnCode = Integer.valueOf( jsonObjectHttpResult.getOrDefault( "code",SysResponseEnum.FAILED.getCode() ).toString() );
        returnResult.setCode( returnCode==100 ? SysResponseEnum.SUCCESS.getCode() : returnCode );
        returnResult.setMessage( jsonObjectHttpResult.getOrDefault( "message",SysResponseEnum.FAILED.getMessage() ).toString() );
        return returnResult;
    }


    /**
     * 等级变更
     * @param requestVO
     * @return
     */
    @Override
    public Result modifymembergrade(MemberModifyGradeRequestVO requestVO){
        Result<String> returnResult = new Result();
        try{
            // 先判断参数传递的是否正确code
            String offlineBrandCode = requestVO.getOfflineBrandCode() ;
            Long brandId = requestVO.getBrandId();

//            if( !checkBrandCodeIsStand(offlineBrandCode) ) {
//                ConnectConfig connectConfig = connectConfigService.queryByOnlineBrandId(brandId);
//                if (connectConfig == null || StringUtils.isBlank(connectConfig.getOfflineBrandCode())) {
//                    logger.error("jh_third_interface levelChange getBrandCode error : {}", JSONObject.toJSONString(requestVO));
//                    returnResult.setCode(SysResponseEnum.MODEL_FAILED_VALIDATION.getCode());
//                    returnResult.setMessage("获取brandCode失败...");
//                    return returnResult;
//                }
//                offlineBrandCode = connectConfig.getOfflineBrandCode();
//            }

            ConnectConfig connectConfig = connectConfigService.queryByOnlineBrandId(brandId);
            if (connectConfig == null || StringUtils.isBlank(connectConfig.getOfflineBrandCode())) {
                logger.error("jh_third_interface levelChange getBrandCode error : {}", JSONObject.toJSONString(requestVO));
                returnResult.setCode(SysResponseEnum.MODEL_FAILED_VALIDATION.getCode());
                returnResult.setMessage("获取brandCode失败...");
                return returnResult;
            }
            offlineBrandCode = connectConfig.getOfflineBrandCode();
            requestVO.setOfflineBrandCode( offlineBrandCode );

            // 商城的等级变更不需要同步到线下POS
            // 集团卡的不需要同步到线下
            if( isJHBrandRequest(requestVO.getOfflineBrandCode()) || isMallBrandRequest( requestVO.getOfflineBrandCode() ) ){
                logger.info( "jh_third_interface levelChange 集团卡等级变更不需要同步线下和Mall : {}", JSONObject.toJSONString( requestVO ) );
                returnResult.setCode( SysResponseEnum.SUCCESS.getCode() );
                returnResult.setMessage( "集团卡的等级变更不需要同步线下和Mall" );
                return returnResult;
            }
            // 卡号为空
            if(StringUtils.isBlank(requestVO.getOfflineCardNo() )){
                logger.error( "jh_third_interface levelChange cardNo empty : {}", JSONObject.toJSONString( requestVO ) );
                returnResult.setCode( SysResponseEnum.MODEL_FAILED_VALIDATION.getCode() );
                returnResult.setMessage( "卡号不能为空" );
                return returnResult;
            }
            Map map = IposConfig.signToRequest( Constant.VIP_LEVEL_CHANGE_METHOD );
            if( MapUtils.isEmpty(map) ){
                logger.error( "jh_third_interface levelChange sign error : {}", JSONObject.toJSONString( map ) );
                returnResult.setCode( SysResponseEnum.MODEL_FAILED_VALIDATION.getCode() );
                returnResult.setMessage( SysResponseEnum.MODEL_FAILED_VALIDATION.getMessage() );
                return returnResult;
            }
            // 不需要发送重复的卡等级变更到线下。
            if( checkBrandCodeIsTWUnder( requestVO.getOfflineBrandCode() ) ){
                logger.info( "jh_third_interface levelChange 不需要发送TW-CLUB以外的卡等级变更到线下POS : {}", JSONObject.toJSONString( requestVO ) );
                returnResult.setCode( SysResponseEnum.SUCCESS.getCode() );
                returnResult.setMessage( "不需要发送TW-CLUB以外的卡等级变更到线下POS" );
                return returnResult;
            }

            OfflineMemberLevelRequestVo offlineMemberLevelRequestVo = OfflineMemberLevelRequestVo.builder()
                    .brandCode( requestVO.getOfflineBrandCode() )
                    .cardNo( requestVO.getOfflineCardNo() )
                    .levelCodeBegin( requestVO.getOldLevelCode() )
                    .levelCodeEnd( requestVO.getNewLevelCode() )
                    .changeTime( DateUtil.transformDateToStandard( requestVO.getModifiedTime() ) )
                    .build();
            map.put( "param",JSON.toJSON( offlineMemberLevelRequestVo ) );
            String mapParams = JSONObject.toJSONString( map );
            logger.info( "jh_third_interface levelChange start postData : {}" , mapParams , mapParams );
            String httpResult = RestUtils.sendRequestBuff( IposConfig.url + VgMethodConstant.VGCRM_LEVEL_CHANGE , mapParams ,"POST" );
            logger.info( "jh_third_interface levelChange end httpResult : {}" , httpResult );
            JSONObject jsonObjectHttpResult = JSON.parseObject( httpResult );
            Integer returnCode = Integer.valueOf( jsonObjectHttpResult.getOrDefault( "code",SysResponseEnum.FAILED.getCode()).toString() );
            returnResult.setCode(returnCode == 100 ? SysResponseEnum.SUCCESS.getCode() : returnCode );
            returnResult.setMessage( jsonObjectHttpResult.getOrDefault( "message",SysResponseEnum.FAILED.getMessage() ).toString() );
        }catch (Exception e){
            e.printStackTrace();
            logger.error( "jh_third_interface levelChange error : {}",e.getMessage() );
            returnResult.setCode( SysResponseEnum.SYSTEM_ERROR.getCode() );
            returnResult.setMessage( e.getMessage() );
        }
        return returnResult;
    }


    /**
     * 会员资料查询
     * @param requestVO
     * @return
     */
    @Override
    public Result<MemberInfoQueryResponseVO> querymemberinfo(MemberInfoQueryRequestVO requestVO) {
        Result<MemberInfoQueryResponseVO> returnResult = new Result();
        returnResult.setCode( SysResponseEnum.SUCCESS.getCode() );
        returnResult.setMessage( SysResponseEnum.SUCCESS.getMessage() );
        MemberInfoQueryResponseVO memberInfoQueryResponseVO = new MemberInfoQueryResponseVO();
        return returnResult;
    }

    /**
     * 修改会员手机号
     * @param requestVO
     * @return
     */
    @Override
    public Result modifymemberphone(MemberPhoneUpdateRequestVO requestVO) {
        Result result = new Result<>();
        try {

            if( requestVO.getNewMobile().equals( requestVO.getOldMobile() ) ){
                result.setCode( SysResponseEnum.FAILED.getCode() );
                result.setMessage( "修改的手机号前后不能一致" );
                return result;
            }

            String erpId = requestVO.getErpId();
            String cardNo = StringUtils.isBlank( requestVO.getCardNo() ) ? erpId : requestVO.getCardNo() ;
            if( StringUtils.isBlank(cardNo) ){
                result.setCode( SysResponseEnum.FAILED.getCode() );
                result.setMessage( "cardNo和erpId不能都为空" );
                return result;
            }
            requestVO.setCardNo( cardNo );

            requestVO.setAppKey(CrmJointVConfig.appKey);
            requestVO.setAppSecret(CrmJointVConfig.appSecret);

            String req = JSONObject.toJSONString(requestVO);

            HashMap<String, String> map = new HashMap<>();
            map.put("Content-type","application/json;charset=utf-8");

            logger.info( "jh_third_interface modifymemberphone start req : {} url :{}",req, CrmJointVConfig.urlPrefix + CrmJointVConfig.memberRights);

            result.setCode(SysResponseEnum.SUCCESS.getCode());
            result.setMessage( SysResponseEnum.SUCCESS.getMessage() );
            result.setData( JSON.toJSONString(requestVO) );
        } catch (Exception e) {
            logger.error( "crm_joint_interface snyMemberRights error : {}",e.getMessage());
            result.setCode(SysResponseEnum.SYSTEM_ERROR.getCode());
            result.setMessage( "修改手机号失败 : " + e.getMessage() );
        }
        return result;
    }

}
