package com.daas.nros.connector.server.service.impl.burgeon;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.daas.nros.connector.client.burgeon.model.req.SyncMemberRegisterReq;
import com.daas.nros.connector.server.config.burgeon.CrmJointVConfig;
import com.daas.nros.connector.client.constants.Constant;
import com.daas.nros.connector.client.model.result.Result;
import com.daas.nros.connector.client.model.vo.MemberOpenCardRequestVO;
import com.daas.nros.connector.client.model.vo.MemberOpenCardResponseVO;
import com.daas.nros.connector.client.util.HttpClientUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import java.util.HashMap;

@Slf4j
@Component("JHMallService")
public class JHMallServiceComponent {

    public Result<MemberOpenCardResponseVO> loginandopencard(MemberOpenCardRequestVO requestVO, MemberOpenCardResponseVO memberOpenCardResponseVO) {
        Result<MemberOpenCardResponseVO> result = new Result<>();
        SyncMemberRegisterReq syncMemberRegisterReq = SyncMemberRegisterReq.builder()
            .mobile(requestVO.getPhone())
            .cardNo( requestVO.getCardNo() )
            .appKey(CrmJointVConfig.appKey)
            .appSecret(CrmJointVConfig.appSecret)
            .build();
        HashMap<String, String> map = new HashMap<>();
        map.put("Content-type","application/json;charset=utf-8");
        try {
            String req = JSONObject.toJSONString(syncMemberRegisterReq);
            log.info("JHMallServiceComponent loginandopencard SyncMemberRegisterReq start req : {} url:{}", req, CrmJointVConfig.urlPrefix + CrmJointVConfig.memberRegister);
            String httpResult = HttpClientUtil.dopost(CrmJointVConfig.urlPrefix + CrmJointVConfig.memberRegister, req, map);
            log.info("JHMallServiceComponent loginandopencard SyncMemberRegisterReq end httpResult : {}", httpResult);
            convertToJsonObjectLoginAndOpenCard(result, httpResult,memberOpenCardResponseVO);
        } catch (Exception e) {
            log.error( "JHMallServiceComponent loginandopencard SyncMemberRegisterReq error : {}",e);
            result.setCode(SysResponseEnum.SYSTEM_ERROR.getCode());
            result.setMessage( SysResponseEnum.SYSTEM_ERROR.getMessage());
        }
        return result;
    }

    /**
     * 返回结果转换
     * @param result
     * @param httpResult
     */
    private void convertToJsonObjectLoginAndOpenCard(Result<MemberOpenCardResponseVO> result, String httpResult,MemberOpenCardResponseVO memberOpenCardResponseVO) {
        JSONObject jsonObject = JSON.parseObject(httpResult);
        if (jsonObject != null) {
            result.setMessage(String.valueOf(JSON.parseObject(String.valueOf(JSON.parseObject(String.valueOf(jsonObject.get(Constant.DATA))).get(Constant.RESULT))).get(Constant.RETURN_MESSAGE)));
            String returnCode = String.valueOf(JSON.parseObject(String.valueOf(JSON.parseObject(String.valueOf(jsonObject.get(Constant.DATA))).get(Constant.RESULT))).get(Constant.RETURN_CODE));
            if (Constant.SUCCESS_CODE.equals(returnCode)) {
                result.setCode(SysResponseEnum.SUCCESS.getCode());
                memberOpenCardResponseVO.setType(2);
            } else if(Constant.SUCCESS_CODE_USER_EXISTS.equals(returnCode)){
                result.setCode(SysResponseEnum.SUCCESS.getCode());
                memberOpenCardResponseVO.setType(1);
            } else {
                result.setCode(SysResponseEnum.FAILED.getCode());
                memberOpenCardResponseVO.setType(3);
            }
        } else {
            result.setCode(SysResponseEnum.FAILED.getCode());
            memberOpenCardResponseVO.setType(3);
        }
        result.setData(memberOpenCardResponseVO);
    }

}
