package com.daas.nros.connector.server.service.impl.burgeon;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.daas.nros.connector.client.burgeon.constants.VgMethodConstant;
import com.daas.nros.connector.server.config.burgeon.IposConfig;
import com.daas.nros.connector.client.constants.Constant;
import com.daas.nros.connector.client.model.result.Result;
import com.daas.nros.connector.client.model.vo.IntegralAdjustRequestVO;
import com.daas.nros.connector.client.model.vo.IntegralAdjustResponseVO;
import com.daas.nros.connector.server.service.api.burgeon.IntegralRecordService;
import com.daas.nros.connector.client.util.DateUtil;
import com.daas.nros.connector.client.util.MD5Util;
import com.daas.nros.connector.client.util.RestUtils;
import com.daas.nros.connector.client.weimob.model.vo.OfflineIntegralRequestVo;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @Author sampson
 * @Date 2021-02-08 12:38
 * @Describe
 */
@Service("integral")
public class JHIntegralRecordServiceImpl extends BasicServiceImpl implements IntegralRecordService {

    private static Logger logger = LoggerFactory.getLogger(JHIntegralRecordServiceImpl.class.getName());

    @Autowired
    private BrandServiceRpc brandServiceRpc;

    /**
     * 保存品牌对应品牌code
     */
    private HashMap<Long,String> brandHashMap = new HashMap<>();

    @Override
    public Result<IntegralAdjustResponseVO> adjustintegral(IntegralAdjustRequestVO requestVO) {
        Result<IntegralAdjustResponseVO> returnResult = new Result();
        try {
            Map map = IposConfig.signToRequest( Constant.VIP_INTEGRAL_CHANGE_METHOD );
            if(MapUtils.isEmpty(map)){
                logger.error( "jh_third_interface integralChange sign error : {}", JSONObject.toJSONString( map ) );
                returnResult.setCode( SysResponseEnum.NULLPOINTEREXCEPTION.getCode() );
                returnResult.setMessage( SysResponseEnum.NULLPOINTEREXCEPTION.getMessage() );
                return returnResult;
            }
            String brandCode = getCompanyBrandCodeByBrandId(requestVO.getBrandId());
            if( StringUtils.isBlank(brandCode) ){
                logger.error( "jh_third_interface integralChange 获取brandCode异常 : {}", JSONObject.toJSONString( requestVO ) );
                returnResult.setCode( SysResponseEnum.OPERATE_FAILED_DATA_NOT_EXISTS.getCode() );
                returnResult.setMessage( "通过brandId查询brandCode失败" );
                return returnResult;
            }

            //返回成功需要的default data
            IntegralAdjustResponseVO defaultIntegralAdjustResponseVO = new IntegralAdjustResponseVO();
            defaultIntegralAdjustResponseVO.setOfflineBrandCode( brandCode );
            defaultIntegralAdjustResponseVO.setIntegralAdjustId( MD5Util.getMd5(requestVO.getSerialNumber()) );
            defaultIntegralAdjustResponseVO.setChangeIntegral( requestVO.getChangeIntegral() );
            defaultIntegralAdjustResponseVO.setDocNo( requestVO.getOrderBillNo() );

            // 集团俱乐部的流水 && 第一次入会的code为空不需要同步线下
            if((isJHBrandRequest( brandCode ) && StringUtils.isBlank( requestVO.getFirstEnterClubCode() ) ) ){
                returnResult.setCode( SysResponseEnum.SUCCESS.getCode() );
                returnResult.setMessage( "集团俱乐部的流水 && 第一次入会的code为空不需要同步线下的不需要" );
                returnResult.setData( defaultIntegralAdjustResponseVO );
                logger.error( "jh_third_interface integralChange 会员未入会且是集团的流水的不需要 requestVO : {} , result: {} ", JSONObject.toJSONString( requestVO ) , JSONObject.toJSONString( returnResult ) );
                return returnResult;
            }

            // 集团俱乐部的流水 && 第一次入会的code为空不需要同步线下
            if((isMallBrandRequest( brandCode ) && StringUtils.isBlank( requestVO.getFirstEnterClubCode() ) ) ){
                returnResult.setCode( SysResponseEnum.SUCCESS.getCode() );
                returnResult.setMessage( "商城俱乐部的流水 && 第一次入会的code为空不需要同步线下的不需要" );
                returnResult.setData( defaultIntegralAdjustResponseVO );
                logger.error( "jh_third_interface integralChange 会员未入会线下俱乐部且是商城的流水的不需要 requestVO : {} , result: {} ", JSONObject.toJSONString( requestVO ) , JSONObject.toJSONString( returnResult ) );
                return returnResult;
            }

            String storeCode = requestVO.getShopCode();
            if(StringUtils.isBlank( storeCode )){
                storeCode = requestVO.getStoreCode();
            }

            OfflineIntegralRequestVo offlineIntegralRequestVo = OfflineIntegralRequestVo.builder()
                .brandCode( brandCode )
                .cardNo( requestVO.getOfflineCardNo() )
                .serialNumber( requestVO.getSerialNumber() )
                .integral( requestVO.getChangeIntegral() )
                .changeTime( DateUtil.transformDateToStandard( requestVO.getAddTime() ) )
                .orderNo( requestVO.getOrderBillNo() )
                .source( StringUtils.isBlank( requestVO.getSource() ) ? "6" : requestVO.getSource() )
                .storeCode( storeCode )
                .changeRemark( requestVO.getBusinessType() )
                .build();

            String sendToOfflineBrandCode = offlineIntegralRequestVo.getBrandCode();
            map.put( "param",JSON.toJSON( offlineIntegralRequestVo ) );
            String mapParams = JSONObject.toJSONString( map );
            logger.info( "jh_third_interface integralChange start mapParams : {} , sendBrandCode :{}" , mapParams , sendToOfflineBrandCode );
            String httpResult = RestUtils.sendRequestBuff( IposConfig.url + VgMethodConstant.VGCRM_INTEGRAL_RECORD , mapParams ,"POST" );
            logger.info( "jh_third_interface integralChange end httpResult : {} , sendBrandCode :{}" , httpResult , sendToOfflineBrandCode );
            JSONObject jsonObjectHttpResult = JSON.parseObject( httpResult );

            Integer returnCode = Integer.valueOf( jsonObjectHttpResult.getOrDefault( "code",SysResponseEnum.FAILED.getCode() ).toString() );
            returnResult.setCode( returnCode==100 ? SysResponseEnum.SUCCESS.getCode() : returnCode );
            returnResult.setMessage( jsonObjectHttpResult.getOrDefault( "message",SysResponseEnum.FAILED.getMessage() ).toString() );
            returnResult.setData( defaultIntegralAdjustResponseVO );
        }catch (Exception e){
            logger.error( "jh_third_interface integralChange error : {}",e.getMessage() );
            returnResult.setCode( SysResponseEnum.SYSTEM_ERROR.getCode() );
            returnResult.setMessage( e.getMessage() );
        }
        logger.info( "jh_third_interface integralChange returnResult : {}" , JSONObject.toJSONString( returnResult ) );
        return returnResult;
    }

    /**
     * 通过brandId获取brandCode
     * @param brandId
     * @return
     */
    private String getCompanyBrandCodeByBrandId(Long brandId){
        try {
            String brandCode = brandHashMap.getOrDefault(brandId,"");
            if( StringUtils.isNotBlank( brandCode ) ){
                return brandCode;
            }
            ResponseData<SysBrandPo> responseData = brandServiceRpc.getBrandByID( brandId );
            if (responseData.getCode() == SysResponseEnum.SUCCESS.getCode() && responseData.getData() != null) {
                brandCode = responseData.getData().getBrandCode();
                brandHashMap.put( brandId,brandCode );
                return brandCode;
            }
        }catch (Exception e){
            logger.info( "jh_third_interface getCompanyBrandCodeByBrandId error : {} , brandId :{}" , e.getMessage() , brandId );
        }
        return null;
    }
    
}
