package com.daas.nros.connector.server.service.impl.burgeon;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.exception.BizException;
import com.daas.nros.connector.server.service.api.burgeon.CrmJointService;
import com.daas.nros.connector.client.burgeon.model.req.*;
import com.daas.nros.connector.client.burgeon.model.vo.VgAddCouponDefinitionVo;
import com.daas.nros.connector.client.burgeon.model.vo.VgAddGiveCouponVo;
import com.daas.nros.connector.client.burgeon.model.vo.VgCancelCouponVo;
import com.daas.nros.connector.server.config.burgeon.CrmJointVConfig;
import com.daas.nros.connector.client.constants.Constant;
import com.daas.nros.connector.server.mapper.ConnectRequestLogPOMapper;
import com.daas.nros.connector.client.enums.ConnectorResponseEnum;
import com.daas.nros.connector.client.model.po.ConnectRequestLogPOWithBLOBs;
import com.daas.nros.connector.client.model.result.Result;
import com.daas.nros.connector.client.util.HttpClientUtil;
import jodd.exception.ExceptionUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.formula.functions.T;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.*;

@Slf4j
@Service
public class CrmJointServiceImpl implements CrmJointService {

    private static ThreadLocal<ConnectRequestLogPOWithBLOBs> logThread = new ThreadLocal<ConnectRequestLogPOWithBLOBs>();

    @Resource
    private ConnectRequestLogPOMapper connectRequestLogPOMapper;

    @Override
    public void init() {
        ConnectRequestLogPOWithBLOBs connectRequestLogPO = new ConnectRequestLogPOWithBLOBs();
        connectRequestLogPO.setTrace(MDC.get("traceId"));
        logThread.set(connectRequestLogPO);
    }

    @Override
    public void remove() {
        ConnectRequestLogPOWithBLOBs connectRequestLogPO = logThread.get();
        if(connectRequestLogPO != null){
            connectRequestLogPO.setThirdEndTime(new Date());
            connectRequestLogPO.setCreateDate(new Date());
            connectRequestLogPOMapper.insertSelective(connectRequestLogPO);
            logThread.remove();
        }
    }

    /**
     * 券定义
     * @param vgAddCouponDefinitionVo
     * @return
     */
    @Override
    public Result<T> snyCouponInfo(VgAddCouponDefinitionVo vgAddCouponDefinitionVo) {
        log.info( "CrmJointServiceImpl#snyCouponInfo#vgAddCouponDefinitionVo: {}", JSON.toJSONString(vgAddCouponDefinitionVo));
        ConnectRequestLogPOWithBLOBs connectRequestLogPOWithBLOBs = logThread.get();
        connectRequestLogPOWithBLOBs.setMethodName("snyCouponInfo");
        connectRequestLogPOWithBLOBs.setBrandCode(vgAddCouponDefinitionVo.getBrandCode());

        Result result = new Result<>();

        List<String> commodityWhiteList = stringToList(vgAddCouponDefinitionVo.getCommodityWhitelist());
        List<String> storeWhiteList = stringToList(vgAddCouponDefinitionVo.getStoreWhitelist());

        if(CollectionUtils.isEmpty(storeWhiteList)){
            log.error("storeWhiteList is empty");
            result.setCode(ConnectorResponseEnum.FAILED.getCode());
            result.setMessage("storeWhiteList 不能为空");
            return result;
        }

        SnyCouponInfoReq couponInfoReq = SnyCouponInfoReq.builder()
                .activityId(vgAddCouponDefinitionVo.getCouponDefinitionCode())
                .activityName(vgAddCouponDefinitionVo.getCouponName())
                .validType(Integer.valueOf(vgAddCouponDefinitionVo.getValidType()))
                .validStartAt(vgAddCouponDefinitionVo.getValidDateStart() != null ? String.valueOf(vgAddCouponDefinitionVo.getValidDateStart().getTime()) : null)
                .validEndAt(vgAddCouponDefinitionVo.getValidDateEnd() != null ? String.valueOf(vgAddCouponDefinitionVo.getValidDateEnd().getTime()) : null)
                .validDay(vgAddCouponDefinitionVo.getValidDay())
                .level(vgAddCouponDefinitionVo.getLevel())
                .condition(vgAddCouponDefinitionVo.getMinConsume().multiply(Constant.BIG_DECIMAL_ONE_HUNDRED).longValue())
                .discountType(Integer.valueOf(vgAddCouponDefinitionVo.getPreferentialType()) == 1 ? 2 : 1)
                .discountTarget(Constant.INT_ONE)
                .quantity(999999999)
                .limitQuantity(999999999)
                .shopId(Constant.MALL_CLUB)
                .status(Constant.INT_ONE)
                .shopCodeList( storeWhiteList )
                .itemCodeList(commodityWhiteList)
                .appKey(CrmJointVConfig.appKey)
                .appSecret(CrmJointVConfig.appSecret)
                .build();

        if (Constant.INT_ONE.equals(couponInfoReq.getDiscountType())){
            couponInfoReq.setDiscountValue(vgAddCouponDefinitionVo.getDiscount().multiply(Constant.BIG_DECIMAL_TEN).longValue());
        } else {
            couponInfoReq.setDiscountValue(vgAddCouponDefinitionVo.getMoney().multiply(Constant.BIG_DECIMAL_ONE_HUNDRED).longValue());
        }
        HashMap<String, String> map = new HashMap<>();
        map.put("Content-type","application/json;charset=utf-8");
        try {
            String req = JSONObject.toJSONString(couponInfoReq);
            log.info( "TOPIC_COUPON_DEFINITION mall-club品牌券定义 snyCouponInfo start req : {} url:{}", req, CrmJointVConfig.urlPrefix + CrmJointVConfig.snyCouponInfo);
            connectRequestLogPOWithBLOBs.setThirdUrl(CrmJointVConfig.urlPrefix + CrmJointVConfig.snyCouponInfo);
            connectRequestLogPOWithBLOBs.setThirdHeader(JSON.toJSONString(map));
            connectRequestLogPOWithBLOBs.setThirdParam(req);
            connectRequestLogPOWithBLOBs.setThirdStartTime(new Date());
            String httpResult = HttpClientUtil.dopost(CrmJointVConfig.urlPrefix + CrmJointVConfig.snyCouponInfo, req, map);
            log.info( "TOPIC_COUPON_DEFINITION mall-club品牌券定义 snyCouponInfo end httpResult : {}", httpResult);
            connectRequestLogPOWithBLOBs.setThirdEndTime(new Date());
            connectRequestLogPOWithBLOBs.setThirdResult(httpResult);
            convertToJsonObject(result, httpResult);
        }catch (BizException e){
            connectRequestLogPOWithBLOBs.setThirdException(jodd.exception.ExceptionUtil.exceptionStackTraceToString(e));
            log.info("BizException:{}",e);
            result.setCode(e.getCode());
            result.setMessage(e.getMessage());
        }catch (Exception e) {
            connectRequestLogPOWithBLOBs.setThirdException(jodd.exception.ExceptionUtil.exceptionStackTraceToString(e));
            log.error( "TOPIC_COUPON_DEFINITION mall-club品牌券定义 snyCouponInfo error : {}",e);
            result.setCode(ConnectorResponseEnum.FAILED.getCode());
            result.setMessage(e.getMessage());
        }
        return result;
    }

    @Override
    public Result<T> modifyCouponInfo(VgAddCouponDefinitionVo vgAddCouponDefinitionVo) {
        ConnectRequestLogPOWithBLOBs connectRequestLogPOWithBLOBs = logThread.get();
        connectRequestLogPOWithBLOBs.setMethodName("modifyCouponInfo");
        connectRequestLogPOWithBLOBs.setBrandCode(vgAddCouponDefinitionVo.getBrandCode());
        log.info( "CrmJointServiceImpl#modifyCouponInfo#vgAddCouponDefinitionVo: {}", JSON.toJSONString(vgAddCouponDefinitionVo));
        Result<T> result = new Result<>();
        List<String> itemCodeList = stringToList(vgAddCouponDefinitionVo.getCommodityWhitelist(),new ArrayList<>());
        SnyCouponInfoReq couponInfoReq = SnyCouponInfoReq.builder()
            .activityId(vgAddCouponDefinitionVo.getCouponDefinitionCode())
            .itemCodeList(itemCodeList)
            .appKey(CrmJointVConfig.appKey)
            .appSecret(CrmJointVConfig.appSecret)
            .build();
        HashMap<String, String> map = new HashMap<>();
        map.put("Content-type","application/json;charset=utf-8");
        try {
            String req = JSONObject.toJSONString(couponInfoReq);
            log.info( "TOPIC_COUPON_DEFINITION mall-club品牌券定义更新 modifyCouponInfo start req : {} url:{}", req, CrmJointVConfig.urlPrefix + CrmJointVConfig.couponUpdate);
            connectRequestLogPOWithBLOBs.setThirdUrl(CrmJointVConfig.urlPrefix + CrmJointVConfig.snyCouponInfo);
            connectRequestLogPOWithBLOBs.setThirdHeader(JSON.toJSONString(map));
            connectRequestLogPOWithBLOBs.setThirdParam(req);
            connectRequestLogPOWithBLOBs.setThirdStartTime(new Date());
            String httpResult = HttpClientUtil.dopost(CrmJointVConfig.urlPrefix + CrmJointVConfig.couponUpdate, req, map);
            connectRequestLogPOWithBLOBs.setThirdEndTime(new Date());
            connectRequestLogPOWithBLOBs.setThirdResult(httpResult);
            log.info( "TOPIC_COUPON_DEFINITION mall-club品牌券定义更新 modifyCouponInfo end httpResult : {}", httpResult);
            convertToJsonObject(result, httpResult);
        }catch (BizException e){
            connectRequestLogPOWithBLOBs.setThirdException(jodd.exception.ExceptionUtil.exceptionStackTraceToString(e));
            log.info("BizException:{}",e);
            result.setCode(e.getCode());
            result.setMessage(e.getMessage());
        } catch (Exception e) {
            connectRequestLogPOWithBLOBs.setThirdException(ExceptionUtil.exceptionStackTraceToString(e));
            log.error( "TOPIC_COUPON_DEFINITION mall-club品牌券定义更新 modifyCouponInfo error : {}",e);
            result.setCode(ConnectorResponseEnum.FAILED.getCode());
            result.setMessage(e.getMessage());
        }
        return result;
    }

    /**
     * 字符串转list
     * @param str
     * @return
     */
    private List<String> stringToList(String str,List<String> defaultValue) {
        if(StringUtils.isBlank(str)){
            return defaultValue;
        }
        return Arrays.asList(str.split(","));
    }

    /**
     * 字符串转list
     * @param str
     * @return
     */
    private List<String> stringToList(String str) {
        return stringToList(str,null);
    }

    public String trimStr(String charStr) {
        int len = charStr.length();
        int st = 0;
        char[] val = charStr.toCharArray();    /* avoid getfield opcode */
        while ((st < len) && (val[st] <= ',')) {
            st++;
        }
        while ((st < len) && (val[len - 1] <= ',')) {
            len--;
        }
        return ((st > 0) || (len < charStr.length() )) ? charStr.substring(st, len) : charStr;
    }

    /**
     * 发券
     * @param couponReqList
     * @return
     */
    @Override
    public Result<T> snyMemberCoupon(List<SnyMemberCouponReq> couponReqList) {
        Result<T> result = new Result<>();
        try {
            VgMemberCouponVo baseReq = VgMemberCouponVo.builder()
                .appKey(CrmJointVConfig.appKey)
                .appSecret(CrmJointVConfig.appSecret)
                .couponList(couponReqList)
                .build();
            // 获取发券的券号
            List<String> couponCodeList = new ArrayList<>();
            for (SnyMemberCouponReq snyMemberCouponReq : couponReqList) {
                couponCodeList.add(snyMemberCouponReq.getCouponId());
            }
            String req = JSONObject.toJSONString(baseReq);
            HashMap<String, String> map = new HashMap<>();
            map.put("Content-type","application/json;charset=utf-8");
            log.info( "TOPIC_COUPON_SEND mall-club品牌发券 snyMemberCoupon start req : {} url:{}",req, CrmJointVConfig.urlPrefix + CrmJointVConfig.snyMemberCoupon);
            String httpResult = HttpClientUtil.dopost(CrmJointVConfig.urlPrefix + CrmJointVConfig.snyMemberCoupon, req, map);
            log.info( "TOPIC_COUPON_SEND mall-club品牌发券 snyMemberCoupon end httpResult : {} couponCodeList :{}",httpResult,couponCodeList);
            convertToJsonObjectCoupon(result, httpResult);
        } catch (Exception e) {
            log.error( "TOPIC_COUPON_SEND mall-club品牌发券 snyMemberCoupon error : {} couponCodeList :{}",e.getMessage(),couponReqList);
            result.setCode(ConnectorResponseEnum.FAILED.getCode());
            result.setMessage(e.getMessage());
        }
        return result;
    }

    /**
     * 优惠券作废
     * @param vgCancelCouponVo
     * @return
     */
    @Override
    public Result<T> snyCouponStatus(VgCancelCouponVo vgCancelCouponVo ) {
        Result<T> result = new Result<>();
        SnyCouponStatusReq statusReq = SnyCouponStatusReq.builder()
            .couponId(vgCancelCouponVo.getCouponCode())
            .status(Constant.INT_MINUS_TWO)
            .updateAt(vgCancelCouponVo.getModifiedDate() != null ? String.valueOf(vgCancelCouponVo.getModifiedDate().getTime()) : null)
            .build();
        return couponStatus(result, statusReq);
    }

    /**
     * 优惠券核销
     * @param vgCancelCouponVo
     * @return
     */
    @Override
    public Result snyCouponCancel(VgCancelCouponVo vgCancelCouponVo ) {
        Result<T> result = new Result<>();
        SnyCouponStatusReq statusReq = SnyCouponStatusReq.builder()
            .couponId(vgCancelCouponVo.getCouponCode())
            .status(Constant.INT_ONE)
            .updateAt(vgCancelCouponVo.getModifiedDate() != null ? String.valueOf(vgCancelCouponVo.getModifiedDate().getTime()) : null)
            .build();
        return couponStatus(result, statusReq);
    }

    /**
     *  调用商城优惠券状态变更接口
     * @param result
     * @param statusReq
     * @return
     */
    private Result couponStatus(Result<T> result, SnyCouponStatusReq statusReq) {
        try {
            statusReq.setAppKey(CrmJointVConfig.appKey);
            statusReq.setAppSecret(CrmJointVConfig.appSecret);
            String req = JSONObject.toJSONString(statusReq);
            HashMap<String, String> map = new HashMap<>();
            map.put("Content-type","application/json;charset=utf-8");
            log.info( "TOPIC_COUPON_VERIFICATION/TOPIC_COUPON_CANCEL snyCouponStatus start req : {} url:{}",req, CrmJointVConfig.urlPrefix + CrmJointVConfig.snyCouponStatus);
            String httpResult = HttpClientUtil.dopost(CrmJointVConfig.urlPrefix + CrmJointVConfig.snyCouponStatus, req, map);
            log.info( "TOPIC_COUPON_VERIFICATION/TOPIC_COUPON_CANCEL snyCouponStatus end httpResult : {}",httpResult);
            convertToJsonObject(result, httpResult);
        } catch (Exception e) {
            log.error( "TOPIC_COUPON_VERIFICATION/TOPIC_COUPON_CANCEL snyCouponStatus error : {}",e.getMessage());
            result.setCode(ConnectorResponseEnum.FAILED.getCode());
            result.setMessage(e.getMessage());
        }
        return result;
    }

    /**
     * 优惠券转赠
     * @param vgAddGiveCouponVo
     * @return
     */
    @Override
    public Result snyCouponTransfer(VgAddGiveCouponVo vgAddGiveCouponVo) {
        Result result = new Result<>();
        try {
            SnyCouponTransferReq build = SnyCouponTransferReq.builder()
                .couponId(vgAddGiveCouponVo.getCouponCode())
                .donorMobile(vgAddGiveCouponVo.getTransferMemberPhone())
                .receiverMobile(vgAddGiveCouponVo.getMemberPhone())
                .appKey(CrmJointVConfig.appKey)
                .appSecret(CrmJointVConfig.appSecret)
                .build();
            HashMap<String, String> map = new HashMap<>();
            map.put("Content-type","application/json;charset=utf-8");
            String req = JSONObject.toJSONString(build);
            log.info( "coupon_to_offline_give_coupon_entity_topic snyCouponTransfer start req : {} url :{} ",req, CrmJointVConfig.urlPrefix + CrmJointVConfig.couponTransfer);
            String httpResult = HttpClientUtil.dopost(CrmJointVConfig.urlPrefix + CrmJointVConfig.couponTransfer, req, map);
            log.info( "coupon_to_offline_give_coupon_entity_topic snyCouponTransfer end httpResult : {}",httpResult);
            convertToJsonObject(result, httpResult);
        } catch (Exception e) {
            log.error( "coupon_to_offline_give_coupon_entity_topic snyCouponTransfer error : {}",e.getMessage());
            result.setCode(ConnectorResponseEnum.FAILED.getCode());
            result.setMessage(e.getMessage());
        }
        return result;
    }

    /**
     * 会员权益
     * @param snyMemberRightsReq
     * @return
     */
    @Override
    public Result snyMemberRights(SnyMemberRightsReq snyMemberRightsReq) {
        Result result = new Result<>();
        try {
            snyMemberRightsReq.setAppKey(CrmJointVConfig.appKey);
            snyMemberRightsReq.setAppSecret(CrmJointVConfig.appSecret);
            String req = JSONObject.toJSONString(snyMemberRightsReq);
            HashMap<String, String> map = new HashMap<>();
            map.put("Content-type","application/json;charset=utf-8");
            log.info( "CrmJointServiceImpl snyMemberRights start req : {} url :{}",req, CrmJointVConfig.urlPrefix + CrmJointVConfig.memberRights);
            String httpResult = HttpClientUtil.dopost(CrmJointVConfig.urlPrefix + CrmJointVConfig.memberRights, req, map);
            log.info( "CrmJointServiceImpl snyMemberRights end httpResult : {}",httpResult);
            convertToJsonObject(result, httpResult);
        } catch (Exception e) {
            log.error( "CrmJointServiceImpl snyMemberRights error : {}",e.getMessage());
            result.setCode(ConnectorResponseEnum.FAILED.getCode());
            result.setMessage(e.getMessage());
        }
        return result;
    }

    /**
     * 返回结果转换
     * @param result
     * @param httpResult
     */
    public void convertToJsonObject(Result<T> result, String httpResult) {
        try {
            JSONObject jsonObject = JSON.parseObject(httpResult);
            if (jsonObject != null) {
                result.setMessage(String.valueOf(JSON.parseObject(String.valueOf(JSON.parseObject(String.valueOf(jsonObject.get(Constant.DATA))).get(Constant.RESULT))).get(Constant.RETURN_MESSAGE)));
                if (Constant.SUCCESS_CODE.equals(String.valueOf(JSON.parseObject(String.valueOf(JSON.parseObject(String.valueOf(jsonObject.get(Constant.DATA))).get(Constant.RESULT))).get(Constant.RETURN_CODE)))) {
                    result.setCode(ConnectorResponseEnum.SUCCESS.getCode());
                } else {
                    result.setCode(ConnectorResponseEnum.FAILED.getCode());
                }
            } else {
                result.setCode(ConnectorResponseEnum.FAILED.getCode());
            }
        } catch (Exception e) {
            log.info("convertToJsonObject:{}",e);
            throw new BizException(SysResponseEnum.SYSTEM_ERROR.getCode(), SysResponseEnum.SYSTEM_ERROR.getMessage());
        }
    }

    /**
     * 返回结果转换
     * @param result
     * @param httpResult
     */
    public void convertToJsonObjectCoupon(Result<T> result, String httpResult) {
        JSONObject jsonObject = JSON.parseObject(httpResult);
        if (jsonObject != null) {
            result.setMessage(String.valueOf(JSON.parseObject(String.valueOf(JSON.parseObject(String.valueOf(jsonObject.get(Constant.DATA))).get(Constant.RESULT))).get(Constant.RETURN_MESSAGE)));
            String resultCode = String.valueOf(JSON.parseObject(String.valueOf(JSON.parseObject(String.valueOf(jsonObject.get(Constant.DATA))).get(Constant.RESULT))).get(Constant.RETURN_CODE));
            if (Constant.SUCCESS_CODE.equals(resultCode)) {
                result.setCode(ConnectorResponseEnum.SUCCESS.getCode());
            } else if(Constant.SUCCESS_CODE_COUPON_EXISTS.equals(resultCode)){
                result.setCode(ConnectorResponseEnum.SUCCESS.getCode());
            } else {
                result.setCode(ConnectorResponseEnum.FAILED.getCode());
            }
        } else {
            result.setCode(ConnectorResponseEnum.FAILED.getCode());
        }
    }
}