package com.daas.nros.connector.server.service.impl.burgeon;

import com.bizvane.couponfacade.interfaces.CouponEntityServiceFeign;
import com.bizvane.utils.responseinfo.ResponseData;
import com.daas.nros.connector.client.api.base.CouponSingleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class CouponServiceImpl implements CouponSingleService {

    private static Logger logger = LoggerFactory.getLogger(CouponServiceImpl.class.getName());

    @Autowired
    private CouponEntityServiceFeign couponEntityServiceFeign;

    @Override
    @Async
    public void callbackSingleCoupon(String couponCode, Byte couponStatus, Integer ifSendAgain) {
        logger.info("jh_third_interface callbackSingleCoupon 回调单张券 couponCode : {} , couponStatus:{} ,ifSendAgain:{}" , couponCode,couponStatus,ifSendAgain );
        ResponseData<Integer> integerResponseData = couponEntityServiceFeign.updateCouponStatus(couponCode,couponStatus,ifSendAgain);
        logger.info("CouponServiceImpl callbackSingleCoupon ,同步券状态:{},couponCode : {}",integerResponseData.getCode(),couponCode);
    }
}
