package com.daas.nros.connector.server.service.impl.burgeon;

import com.daas.nros.connector.client.constants.Constant;
import org.apache.commons.lang3.StringUtils;

/**
 * @Author sampson
 * @Date 2021-03-09 22:06
 * @Describe
 */
public class BasicServiceImpl {
    
    /**
     * 集团卡的会员不需要同步到线下
     * @param brandCode
     * @return
     */
    public boolean isJHBrandRequest(String brandCode){
        try {
            if(brandCode.equals(Constant.JH_CLUB) ){
                return true;
            }
        }catch (Exception e){
            e.printStackTrace();
        }
        return false;
    }

    /**
     * 是否是商城的俱乐部的
     * @param brandCode
     * @return
     */
    public boolean isMallBrandRequest(String brandCode){
        try {
            if( brandCode.equals( Constant.MALL_CLUB ) ){
                return true;
            }
        }catch (Exception e){
            e.printStackTrace();
        }
        return false;
    }

    /**
     * 将有效期时间转换成 19901000 格式
     * @param date
     * @return
     */
    public Integer transformDateToInt(String date){
        try {
            if( date.trim().contains("-") )
                return Integer.valueOf( date.trim().substring(0,10).replaceAll("-","") );
            else
                return Integer.valueOf( date );
        } catch (Exception e){
            return null;
        }
    }

    /**
     * 转换性别
     * @param gender
     * @return
     */
    public String transformSex( Object gender ){
        if( gender==null ){
            return "N";
        }else if( gender.equals("1") || gender.equals(1) ){
            return "M";
        }else if( gender.equals("0") || gender.equals(0) ){
            return "W";
        }
        return "N";
    }

    /**
     * 判断是否是 TT TN TZ
     * @param brandCode
     * @return
     * 322 所有的接口中的俱乐部只有TW，如果传上来的是TT TN TZ 的需要转换，
     * 405 接口中传上来的TT TN TZ 写到对应的俱乐部里面，TW俱乐部的看文档部分需要双写。
     */
    public static boolean checkBrandCodeIsTWUnder(String brandCode){
        if(StringUtils.isBlank(brandCode)){
            throw new IllegalArgumentException("brandCode错误");
        }
        if( brandCode.equals( Constant.TT_CLUB )
                || brandCode.equals( Constant.TN_CLUB )
                || brandCode.equals( Constant.TZ_CLUB )
                || brandCode.equals( Constant.TF_CLUB )){
            return true;
        }
        return false;
    }

    /**
     * 判断code是否是全渠道的code
     * @param brandCode
     * @return
     */
    public boolean checkBrandCodeIsStand( String brandCode ){
        if(StringUtils.isBlank(brandCode)){
            return false;
        }
        if( brandCode.equals( Constant.TT_CLUB )
                || brandCode.equals( Constant.TN_CLUB )
                || brandCode.equals( Constant.TZ_CLUB )
                || brandCode.equals( Constant.TF_CLUB )
                || brandCode.equals( Constant.TW_CLUB )
                || brandCode.equals( Constant.VG_CLUB )
                || brandCode.equals( Constant.YJ_CLUB )
                || brandCode.equals( Constant.MALL_CLUB )
                || brandCode.equals( Constant.JH_CLUB ) ){
            return true;
        }
        return false;
    }

}
