package com.daas.nros.connector.server.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.daas.nros.connector.client.api.ConnectConfigService;
import com.daas.nros.connector.client.burgeon.constants.InterfaceNameConstant;
import com.daas.nros.connector.client.constants.RedisConstant;
import com.daas.nros.connector.client.constants.SystemConstant;
import com.daas.nros.connector.server.mapper.ConnectConfigBeanMapper;
import com.daas.nros.connector.server.mapper.ConnectConfigMapper;
import com.daas.nros.connector.server.mapper.ConnectMethodConfigMapper;
import com.daas.nros.connector.server.mapper.ConnectMethodMapper;
import com.daas.nros.connector.client.enums.ConnectorResponseEnum;
import com.daas.nros.connector.client.model.po.*;
import com.daas.nros.connector.client.model.result.Result;
import com.daas.nros.connector.client.model.vo.ConnectConfigVO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;

/**
 * @author liuying
 * @date 2018/8/9
 * @description
 */
@Service
public class ConnectConfigServiceImpl implements ConnectConfigService {

    private static Logger logger = LoggerFactory.getLogger(ConnectConfigServiceImpl.class.getName());

    private final static String BEAN_NAME = "baseBurgeon";
    private final static String CREATE_USER_NAME = "System";
    private final static Integer CREATE_USER_ID = 999;
    private final static String MODIFIED_USER_NAME = "System";
    private final static Integer MODIFIED_USER_ID = 999;

    @Autowired
    private RedisTemplateServiceImpl<Object , ConnectConfig> connectConfigRedisTemplateService;

    /**
     * 根据appid存储配置项
     */
    private static final HashMap<String, ConnectConfig> CONNECT_CONFIG_HASH_MAP = new HashMap<String, ConnectConfig>();

    public static final HashMap<String, ConnectConfig> getConnectConfigHashMap(){
        return (HashMap<String, ConnectConfig>) CONNECT_CONFIG_HASH_MAP.clone();
    }

    @Autowired
    private ConnectConfigMapper connectConfigMapper;

    @Autowired
    private ConnectConfigBeanMapper connectConfigBeanMapper;

    @Autowired
    private ConnectMethodMapper connectMethodMapper;

    @Autowired
    private ConnectMethodConfigMapper connectMethodConfigMapper;

    private final static String SCRIPT_PREFIX = "wx$";

    @Override
    public void refreshRedisAll() {
        logger.info("execute method refreshRedisAll from Class ConnectConfigServiceImpl");
        ConnectConfigExample connectConfigExample = new ConnectConfigExample();
        connectConfigExample.createCriteria().andValidEqualTo(SystemConstant.VALID);
        List<ConnectConfig> connectConfigList = connectConfigMapper.selectByExample(connectConfigExample);

        CONNECT_CONFIG_HASH_MAP.clear();
        for (ConnectConfig connectConfig : connectConfigList) {
            Long onlineBrandId = connectConfig.getOnlineBrandId();
            String appid = connectConfig.getAppid();
            CONNECT_CONFIG_HASH_MAP.put(appid,connectConfig);

            connectConfigRedisTemplateService.hashPushHashMap(RedisConstant.BRAND ,onlineBrandId,connectConfig);
        }
    }

    @Override
    public ConnectConfig queryByOnlineBrandId(Long onlineBrandId) {
        ConnectConfig connectConfigRedis = connectConfigRedisTemplateService.stringGetStringByKey(RedisConstant.BRAND + onlineBrandId);
        logger.info( "jh_third_interface queryByOnlineBrandId connectConfigRedis data:{} , onlineBrandId:{}" , JSONObject.toJSONString(connectConfigRedis) , onlineBrandId );
        if(connectConfigRedis != null ){
            return connectConfigRedis;
        }

        ConnectConfigExample connectConfigExample = new ConnectConfigExample();
        connectConfigExample.createCriteria().andOnlineBrandIdEqualTo(onlineBrandId)
                .andValidEqualTo(SystemConstant.VALID);
        logger.info( "jh_third_interface queryByOnlineBrandId selectByExample data:{} , onlineBrandId:{}" , JSONObject.toJSONString(connectConfigExample) , onlineBrandId );
        List<ConnectConfig> connectConfigList = connectConfigMapper.selectByExample(connectConfigExample);
        if (CollectionUtils.isEmpty(connectConfigList)) {
            return null;
        }
        ConnectConfig connectConfig = connectConfigList.get(0);
        logger.info( "jh_third_interface queryByOnlineBrandId connectConfig data:{} , onlineBrandId:{}" , JSONObject.toJSONString(connectConfig) , onlineBrandId );
        connectConfigRedisTemplateService.stringSetString(RedisConstant.BRAND + onlineBrandId,connectConfig);
        return connectConfig;
    }

    @Override
    public Result addConnectConfig(ConnectConfigVO requestVO) {
        Result result = new Result();

        Long onlineBrandId = requestVO.getOnlineBrandId();
        ConnectConfig connectConfig = this.queryByOnlineBrandId(onlineBrandId);
        if(connectConfig != null){
            result.setCode(ConnectorResponseEnum.FAILED.getCode());
            result.setMessage("该品牌已存在,无法新增!!!");
            return result;
        }

        //新增t_connect_config表记录
        ConnectConfig connectConfigInsert = insertConnectConfig(requestVO);

        //新增t_connect_config_bean表记录,默认使用伯俊脚本配置
        insertConnectConfigBean(connectConfigInsert);

        //遍历methodList,新增品牌接口配置
        List<ConnectMethod> connectMethodList = selectAllConnectMethod();
        for (int i = 0; CollectionUtils.isNotEmpty(connectMethodList) && i < connectMethodList.size(); i++) {
            ConnectMethod connectMethod = connectMethodList.get(i);

            ConnectMethodConfig connectMethodConfig = new ConnectMethodConfig();
            connectMethodConfig.setConnectConfigId(connectConfigInsert.getConnectConfigId());
            connectMethodConfig.setConnectMethodId(connectMethod.getConnectMethodId());
            connectMethodConfig.setOnlineBrandId(connectConfigInsert.getOnlineBrandId());
            String methodName = connectMethod.getMethodName();
            connectMethodConfig.setMethodName(methodName);
            connectMethodConfig.setMethodUrl(connectMethod.getMethodUrl());
            connectMethodConfig.setOfflineScriptName(SCRIPT_PREFIX +methodName);
            //所有新增的品牌,默认的微商城都是不走Erp
            if(InterfaceNameConstant.REST_ADDORDER.equalsIgnoreCase(methodName)){
                connectMethodConfig.setIsSendErp(Boolean.FALSE);
            }else{
                connectMethodConfig.setIsSendErp(Boolean.TRUE);
            }
            connectMethodConfig.setValid(Boolean.TRUE);
            connectMethodConfig.setCreateUserId(CREATE_USER_ID);
            connectMethodConfig.setCreateUserName(CREATE_USER_NAME);
            connectMethodConfig.setModifiedUserId(MODIFIED_USER_ID);
            connectMethodConfig.setModifiedUserName(MODIFIED_USER_NAME);

            connectMethodConfigMapper.insertSelective(connectMethodConfig);
        }

        result.setCode(ConnectorResponseEnum.SUCCESS.getCode());
        result.setMessage(ConnectorResponseEnum.SUCCESS.getMessage());
        return result;
    }

    @Override
    public Result updateConnectConfig(ConnectConfigVO requestVO) {
        Result result = new Result();
        Long onlineBrandId = requestVO.getOnlineBrandId();
        ConnectConfig connectConfig = this.queryByOnlineBrandId(onlineBrandId);
        if(connectConfig == null){
            result.setCode(ConnectorResponseEnum.FAILED.getCode());
            result.setMessage("该品牌不存在,无法更新!!!");
            return result;
        }
        //获取参数
        Integer connectConfigId = connectConfig.getConnectConfigId();

        //更新参数
        ConnectConfig connectConfigUpdate = new ConnectConfig();
        connectConfigUpdate.setConnectConfigId(connectConfigId);
        connectConfigUpdate.setOnlineBrandId(requestVO.getOnlineBrandId());
        connectConfigUpdate.setOfflineBrandCode(requestVO.getOfflineBrandCode());
        connectConfigUpdate.setBrandName(requestVO.getBrandName());
        connectConfigUpdate.setDomain(requestVO.getDomain());
        connectConfigUpdate.setValidDayNumber(requestVO.getValidDayNumber());
        connectConfigUpdate.setOfflineCompanyCode(requestVO.getOfflineCompanyCode());

        connectConfigMapper.updateByPrimaryKeySelective(connectConfigUpdate);

        result.setCode(ConnectorResponseEnum.SUCCESS.getCode());
        result.setMessage(ConnectorResponseEnum.SUCCESS.getMessage());
        return result;
    }

    @Override
    public List<ConnectConfig> getAllConnectConfigList() {
        ConnectConfigExample connectConfigExample = new ConnectConfigExample();
        connectConfigExample.createCriteria().andValidEqualTo(Boolean.TRUE);
        List<ConnectConfig> connectConfigs = connectConfigMapper.selectByExample(connectConfigExample);
        return connectConfigs;
    }

    /**
     * 根据品牌id删除t_connect_method_config表记录
     * @param connectConfigId
     */
    private void deleteConnectMethodConfigByConnectConfigId(Integer connectConfigId) {
        ConnectMethodConfigExample connectMethodConfigExample = new ConnectMethodConfigExample();
        connectMethodConfigExample.createCriteria().andValidEqualTo(Boolean.TRUE).andConnectConfigIdEqualTo(connectConfigId);
        connectMethodConfigMapper.deleteByExample(connectMethodConfigExample);
    }

    /**
     * 根据品牌id删除t_connect_config_bean表记录
     * @param connectConfigId
     */
    private void deleteConnectConfigBeanByConnectConfigId(Integer connectConfigId) {
        ConnectConfigBeanExample connectConfigBeanExample = new ConnectConfigBeanExample();
        connectConfigBeanExample.createCriteria().andValidEqualTo(Boolean.TRUE).andConnectConfigIdEqualTo(connectConfigId);
        connectConfigBeanMapper.deleteByExample(connectConfigBeanExample);
    }

    /**
     * 查询t_connect_method表所有有效记录
     * @return
     */
    private List<ConnectMethod> selectAllConnectMethod() {
        ConnectMethodExample connectMethodExample = new ConnectMethodExample();
        connectMethodExample.createCriteria().andValidEqualTo(Boolean.TRUE);
        List<ConnectMethod> connectMethodList = connectMethodMapper.selectByExample(connectMethodExample);
        return connectMethodList;
    }


    /**
     * 新增t_connect_config_bean表记录
     * @param connectConfigInsert
     * @return
     */
    private ConnectConfigBean insertConnectConfigBean(ConnectConfig connectConfigInsert) {
        ConnectConfigBean connectConfigBean = new ConnectConfigBean();
        connectConfigBean.setConnectConfigId(connectConfigInsert.getConnectConfigId());
        connectConfigBean.setOnlineBrandId(connectConfigInsert.getOnlineBrandId());
        connectConfigBean.setBeanName(BEAN_NAME);
        connectConfigBean.setValid(Boolean.TRUE);
        connectConfigBean.setCreateUserId(CREATE_USER_ID);
        connectConfigBean.setCreateUserName(CREATE_USER_NAME);
        connectConfigBean.setModifiedUserId(MODIFIED_USER_ID);
        connectConfigBean.setModifiedUserName(MODIFIED_USER_NAME);

        connectConfigBeanMapper.insertSelective(connectConfigBean);
        return connectConfigBean;
    }


    /**
     * 新增t_connect_config表记录
     * @param requestVO
     * @return
     */
    private ConnectConfig insertConnectConfig(ConnectConfigVO requestVO) {
        ConnectConfig connectConfigInsert = new ConnectConfig();

        connectConfigInsert.setOnlineBrandId(requestVO.getOnlineBrandId());
        connectConfigInsert.setOfflineBrandCode(requestVO.getOfflineBrandCode());
        connectConfigInsert.setBrandName(requestVO.getBrandName());
        connectConfigInsert.setDomain(requestVO.getDomain());
        connectConfigInsert.setValidDayNumber(requestVO.getValidDayNumber());
        connectConfigInsert.setOfflineCompanyCode(requestVO.getOfflineCompanyCode());

        connectConfigInsert.setValid(Boolean.TRUE);
        connectConfigInsert.setCreateUserId(CREATE_USER_ID);
        connectConfigInsert.setCreateUserName(CREATE_USER_NAME);
        connectConfigInsert.setModifiedUserId(MODIFIED_USER_ID);
        connectConfigInsert.setModifiedUserName(MODIFIED_USER_NAME);
        connectConfigMapper.insertSelective(connectConfigInsert);
        return connectConfigInsert;
    }

}
