package com.daas.nros.connector.server.service.conver;

import com.bizvane.centerstageservice.models.vo.StaffVo;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.MemberLabelModel;
import com.bizvane.members.facade.models.OrderDetailModel;
import com.bizvane.utils.commonutils.DateUtils;
import com.daas.nros.connector.client.util.DateUtil;
import com.daas.nros.connector.client.weimob.constant.WmSystemConstant;
import com.daas.nros.connector.client.weimob.model.req.*;
import com.daas.nros.connector.client.weimob.model.req.param.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * 微盟对接对象转换攻工具类
 * @anthor shifeng
 * @version 1.0.1
 * 2022-11-30 18:51:38
 */
@Slf4j
public class WmConverFactory {

    /**
     * 会员信息参数转换
     * @anthor shifeng
     * @param
     * @return
     * 2022-12-1 14:13:00
     */
    public static MemberReq getMemberReq(List<MemberInfoModelParam> memberInfoModelParams) {
        MemberReq memberReq = new MemberReq();
        memberReq.setImportType(2);
        List<MemberInfo> userList = new ArrayList<>();
        for (MemberInfoModelParam memberInfoModelParam : memberInfoModelParams) {
            MemberInfo memberInfo = new MemberInfo();
            memberInfo.setPhone(memberInfoModelParam.getPhone());
            memberInfo.setRegionCode("86");
            memberInfo.setUnionId(memberInfoModelParam.getWxUnionId());
            memberInfo.setOpenId(memberInfoModelParam.getWxOpenId());
            memberInfo.setAppId("");
            memberInfo.setAppChannel(5);
            memberInfo.setUserName(memberInfoModelParam.getName());
            memberInfo.setGender(converGender(memberInfoModelParam.getGender()));
            memberInfo.setBirthday(getTimeSecondFromData(memberInfoModelParam.getBirthday()));
            memberInfo.setIdentityCardNum(memberInfoModelParam.getIdCard());
            memberInfo.setEducation(null);
            memberInfo.setIncome(null);
            memberInfo.setIndustry(null);
            memberInfo.setHobby(null);
            memberInfo.setProvince(memberInfoModelParam.getProvince());
            memberInfo.setCity(memberInfoModelParam.getCity());
            memberInfo.setArea(null);
            memberInfo.setAddress(memberInfoModelParam.getAddress());
            memberInfo.setBelongVidName(memberInfoModelParam.getServiceGuiderName());
            memberInfo.setBelongVid(memberInfoModelParam.getServiceStoreId());
            memberInfo.setCustomCardNo(memberInfoModelParam.getCardNo());
            memberInfo.setLevelName(memberInfoModelParam.getLevelName());
            memberInfo.setGrowth(0);
            memberInfo.setBalance(0);
            memberInfo.setTotalBalance(0);
            memberInfo.setTag(memberInfoModelParam.getMemberTags());
            memberInfo.setGuiderPhone(memberInfoModelParam.getServiceGuiderPhone());
            memberInfo.setSourceVid(memberInfoModelParam.getOpenCardStoreId());
            memberInfo.setBecomeMemberTime(getTimeSecondFromData(memberInfoModelParam.getCreateDate()));
            memberInfo.setMembershipCardChannel(1);
            userList.add(memberInfo);
        }
        memberReq.setUserList(userList);
        return memberReq;
    }


    /**
     * 转化性别字段
     * @param gender
     * @return
     */
    public static Integer converGender(String gender) {
        if (StringUtils.isEmpty(gender)) {
            return 0;
        }
        if ("1".equals(gender)) {
            return 2;
        }
        if ("2".equals(gender)) {
            return 1;
        }
        if ("3".equals(gender)) {
             return 0;
        }
        return 0;
    }

    /**
     * 获取时间戳
     * @param date
     * @return
     * 2022-12-1 18:52:22
     */
    public static Long getTimeStampFromData(Date date) {
        // 为空
        if (date == null) {
            return null;
        }
        return date.getTime();
    }

    /**
     * 获取时间戳
     * @param date
     * @return
     * 2022-12-1 18:52:22
     */
    public static Long getTimeSecondFromData(Date date) {
        // 为空
        if (date == null) {
            return null;
        }
        return date.getTime();
    }

    /**
     * 获取时间戳
     * @param dateTims
     * @return
     * 2022-12-1 18:52:22
     */
    private static long getTimeStampFromData(String dateTims) {
        // 为空
        if (StringUtils.isEmpty(dateTims)) {
            return new Date().getTime();
        }
        if (!DateUtil.isValidDate(dateTims)) {
            return new Date().getTime();
        }
        Date date = DateUtils.StringFormatTime(dateTims);
        return date.getTime();
    }

    /**
     * 获取变更会员等级的接口参数
     * @param
     * @return MemberLevelChangeReq
     * 2022-12-1 14:51:53
     */
    public static MemberLevelChangeReq getMemberLevelReq(MemberInfoModelParam memberInfoModelParam) {
        MemberLevelChangeReq memberLevelChangeReq = new MemberLevelChangeReq();
        memberLevelChangeReq.setDelayType(1L);
        memberLevelChangeReq.setUpdateType(3);
        memberLevelChangeReq.setOperatorWId(0L);
        memberLevelChangeReq.setChannelType(971);
        memberLevelChangeReq.setReason("会员等级变更");
        memberLevelChangeReq.setOperatorName("crm");
        memberLevelChangeReq.setNewCustomCardNo(memberInfoModelParam.getCardNo());
        memberLevelChangeReq.setOldCustomCardNo(memberInfoModelParam.getCardNo());
        return memberLevelChangeReq;
    }

    /**
     * 更新会员基本信息参数构建
     * @anthor shifeng
     * @version
     * 2022-12-1 19:12:47
     */
    public static MemberUpdateReq getMemberUpdateReq(MemberInfoModelParam memberInfoModelParam) {
        MemberUpdateReq memberUpdateReq = new MemberUpdateReq();
        memberUpdateReq.setVid(memberInfoModelParam.getServiceStoreCode());
        memberUpdateReq.setName(memberInfoModelParam.getName());
        memberUpdateReq.setGender(converGender(memberInfoModelParam.getGender()));
        memberUpdateReq.setBirthday(getTimeSecondFromData(memberInfoModelParam.getBirthday()));
        if (StringUtils.isEmpty(memberInfoModelParam.getIdCard())) {
            memberUpdateReq.setIdentityCardNum( memberInfoModelParam.getIdCard());
        }
        if (StringUtils.isEmpty(memberInfoModelParam.getEmail())) {
            memberUpdateReq.setEmail(memberInfoModelParam.getEmail());
        }
        memberUpdateReq.setProvince(memberInfoModelParam.getProvince());
        memberUpdateReq.setCity(memberInfoModelParam.getCity());
        memberUpdateReq.setAddress(memberInfoModelParam.getAddress());
        return memberUpdateReq;
    }

    /**
     * 会员 标签参数转换
     * @param
     * @return MemberLabelReq
     * 2022-12-1 11:48:28
     */
    public static MemberLabelReq getMemberLabelReq(List<MemberLabelInfoParam> memberLabelInfoParams) {
        MemberLabelReq memberLabelReq = new MemberLabelReq();
        memberLabelReq.setVidType(1);
        memberLabelReq.setOperationSource(2);
        List<OpenCreateTagRequest> openCreateTagRequestList = new ArrayList<>();
        for (MemberLabelInfoParam memberLabelInfoParam : memberLabelInfoParams){
            OpenCreateTagRequest openCreateTagRequest = new OpenCreateTagRequest();
            openCreateTagRequest.setSource(0);
            openCreateTagRequest.setTagType(1);
            openCreateTagRequest.setIsAddAtt(Boolean.TRUE);
            openCreateTagRequest.setIsCheckQwUpdate(Boolean.FALSE);
            openCreateTagRequest.setCheckTagNameExist(Boolean.TRUE);
            openCreateTagRequest.setTagGroupId(memberLabelInfoParam.getMbrLabelGroupDefId());
            openCreateTagRequest.setTagName(memberLabelInfoParam.getLabelTypeName());
            //获取下面的标签属性 crm 里面的标签
            List<TagAttrRequest> tagAttrRequestList = new ArrayList<>();
            if(!CollectionUtils.isEmpty(memberLabelInfoParam.getMemberLabelModels())) {
                for (MemberLabelModel memberLabelModel : memberLabelInfoParam.getMemberLabelModels()) {
                    if (memberLabelModel == null) {
                        continue;
                    }
                    TagAttrRequest tagAttrRequest = new TagAttrRequest();
                    tagAttrRequest.setAttrId(memberLabelModel.getMbrLabelDefId());
                    tagAttrRequest.setAttrName(memberLabelModel.getLabelName());
                    tagAttrRequestList.add(tagAttrRequest);
                }
            }
            openCreateTagRequest.setTagAttrRequestList(tagAttrRequestList);
            openCreateTagRequestList.add(openCreateTagRequest);
        }
        memberLabelReq.setOpenCreateTagRequestList(openCreateTagRequestList);
        return memberLabelReq;
    }

    /**
     * 获取标签属性
     * @anthor shifenf
     * @param  memberLabelAttrParam
     * @return MemberLabelAttrReq
     * 2022-12-1 16:27:35
     */
    public static MemberLabelAttrReq getMemberLabelAttrReq(MemberLabelAttrParam memberLabelAttrParam) {
        MemberLabelAttrReq memberLabelAttrReq = new MemberLabelAttrReq();
        //标签名称
        memberLabelAttrReq.setAttrName(memberLabelAttrParam.getLabelName());
        //组织架构节点类型
        memberLabelAttrReq.setVidType(1);
        //操作来源
        memberLabelAttrReq.setOperationSource(2);
        return memberLabelAttrReq;
    }

    /**
     * 获取会员新增标签信息
     * @anthor shifeng
     * @param
     * @return MemberLabelAddReq
     * 2022-12-1 16:49:06
     */
    public static MemberLabelAddReq getMemberLabelAddReq() {
        MemberLabelAddReq memberLabelAddReq = new MemberLabelAddReq();
        memberLabelAddReq.setVidType(1);
        memberLabelAddReq.setNeedCheckExist(Boolean.TRUE);
        return memberLabelAddReq;
    }

    /**
     * 获取会员删除标签信息
     * @param  memberInfoModelParam
     * @return MemberLabelRemoveReq
     * 2022-12-2 13:49:50
     */
    public static MemberLabelRemoveReq getMemberLabelRemoveReq(MemberInfoModelParam memberInfoModelParam) {
        MemberLabelRemoveReq memberLabelRemoveReq = new MemberLabelRemoveReq();
        memberLabelRemoveReq.setVidType(1);
        return memberLabelRemoveReq;
    }

    /**
     * 将创建优惠券入参转化为微盟接口入参
     * @return
     */
    public static CouponTemplateReq caseToCouponTemplateReq(CouponDefinitionParam param){
        CouponTemplateReq couponTemplateReq = new CouponTemplateReq();
        // 构建 券模板基础信息
        couponTemplateReq.buildCouponTemplateBaseInfo(param);
        // 构建 券模板优惠规则
        couponTemplateReq.buildCouponTemplateReduceRule(param);
        // 构建 封装卷模板发放规则
        couponTemplateReq.buildCouponTemplateSendRule(param);
        // 构建 封装卷模板使用规则
        couponTemplateReq.buildCouponTemplateUseRule(param);
        // 封装卷模板其他设置
        couponTemplateReq.buildCouponTemplateOtherSetting(param);
        // 封装模板创建信息
        couponTemplateReq.buildCouponTemplateCreateInfo(param);
        return couponTemplateReq;
    }

    /**
     * 将创建优惠券入参转化为微盟接口入参
     * @return
     */
    public static CouponCreateReq caseToCouponCreateReq(CouponDefinitionParam param){
        CouponCreateReq couponCreateReq = new CouponCreateReq();
        // 构建 卷基础信息
        couponCreateReq.buildCouponBaseInfo(param);
        // 构建 优惠卷设置
        couponCreateReq.buildCouponSetting(param);
        // 构建 优惠卷发放规则
        couponCreateReq.buildCouponSendRule(param);
        // 构建 优惠卷使用规则
        couponCreateReq.buildCouponUseRule(param);
        // 构建 优惠卷其他设置
        couponCreateReq.buildCouponOtherSetting(param);
        // 构建 优惠卷创建信息
        couponCreateReq.buildCouponCreateInfo(param);
        return couponCreateReq;
    }

    /**
     * 将会员领取优惠券入参转化为微盟接口入参
     * @return
     */
    public static CouponBandMemberReq caseToCouponBindingMemberReq(CouponBindMemberParam param){
        CouponBandMemberReq couponBandMemberReq = new CouponBandMemberReq();
        // 会员领券时间
        couponBandMemberReq.setAcquireTime(param.getAcquireTime());
        // 优惠券模板 ID
        couponBandMemberReq.setCouponTemplateId(param.getCouponTemplateId());
        // 券号
        couponBandMemberReq.setCode(param.getCouponCode());
        // 优惠券所属会员wid
        couponBandMemberReq.setWid(param.getWid());
        // 优惠券开始时间
        couponBandMemberReq.setExpireStartTime(param.getExpireStartTime());
        // 优惠券结束时间
        couponBandMemberReq.setExpireEndTime(param.getExpireEndTime());
        couponBandMemberReq.setVid(param.getVid());
        return couponBandMemberReq;
    }

    /**
     * 将作废优惠券入参转化为微盟接口入参
     * @return
     */
    public static CouponCancelReq caseToCouponCancelReq(CouponCancelParam param){
        // 组织架构节点类型。类型包括：1-集团；2-品牌；3-区域；4部门；5-商场；6-楼层；10-门店；11-网点；100-自提点。固定值 1
        int vidType = 1;
        // 作废类型：1-售后作废；2-码库作废. 固定值 2
        int type = 2;
        CouponCancelReq couponCancelReq = new CouponCancelReq();
        couponCancelReq.setWid(param.getWid());
        couponCancelReq.setVidType(vidType);
        couponCancelReq.setVid(param.getVid());
        couponCancelReq.setType(type);
        // 构建 优惠券列表
        couponCancelReq.buildCouponOperate(param);
        return couponCancelReq;
    }

    /**
     * 将核销优惠券入参转化为微盟接口入参
     * @return
     */
    public static CouponConsumeReq caseToCouponConsumeReq(CouponUseParam param){
        // 核销操作人 wid, 固定值 0
        Long operator = WmSystemConstant.WM_STSTEM_OPERATOR_ID;
        // 核销方式：1- 线上核销 ；2- 线下核销。 固定值 2
        Integer useResourceType = 2;
        // 核销场景：1-网店订单；7-api核销。固定值 7
        Integer useScene = 7;
        // 组织架构节点类型。类型包括：1-集团；2-品牌；3-区域；4部门；5-商场；6-楼层；10-门店；11-网点；100-自提点。固定值 1
        Integer vidType = 1;
        // 订单总金额，单位：元。 默认固定值 0
        BigDecimal orderAmount = new BigDecimal("0");
        CouponConsumeReq couponConsumeReq = new CouponConsumeReq();
        couponConsumeReq.setOrderAmount(orderAmount);
        couponConsumeReq.setOperator(operator);
        couponConsumeReq.setUseResourceType(useResourceType);
        couponConsumeReq.setUseScene(useScene);
        couponConsumeReq.setWid(param.getWid());
        couponConsumeReq.setVid(param.getVid());
        couponConsumeReq.setVidType(vidType);
        // 封装优惠券列表
        couponConsumeReq.buildCouponUseParam(param);
        return couponConsumeReq;
    }


    /**
     * 获取品牌的VID
     * @param pageNum
     * @param pageSize
     * @return VidReq
     */
    public static VidReq getVidReq(Integer type, Integer pageNum, Integer pageSize) {
        VidReq vidReq = new VidReq();
        vidReq.setVidType(type);
        vidReq.setPageSize(pageSize);
        vidReq.setPageNum(pageNum);
        return vidReq;
    }

    /**
     * 获取会员的wid信息
     * @param phone 手机号码
     * @return MemberWidReq
     * 2022-12-1 15:05:57
     */
    public static MemberWidReq getMemberWidReq(String phone) {
        MemberWidReq memberWidReq = new MemberWidReq();
        memberWidReq.setSource(4);
        memberWidReq.setAppId("");
        memberWidReq.setOriginalId(phone);
        return memberWidReq;
    }

    /**
     * 获取导购wid信息
     * @param phone 手机号码
     * @return MemberWidReq
     * 2022-12-1 15:05:57
     */
    public static GuiderWidReq getGuiderWidReq(String phone) {
        GuiderWidReq guiderWidReq = new GuiderWidReq();
        guiderWidReq.setJobNumber(phone);
        guiderWidReq.setNeedGuiderPicUrl(0);
        guiderWidReq.setGuiderPhone(phone);
        return guiderWidReq;
    }


    /**
     * 构建订单数据对象
     * @param crmMemberOrderParam
     * @return
     */
    public static MemberOrderBaseInfoParam getOrderBaseInfo(CrmMemberOrderParam crmMemberOrderParam) {
        MemberOrderBaseInfoParam orderBaseInfo = new MemberOrderBaseInfoParam();
        //外部订单号/⼩票编号(唯⼀不可重复)
        orderBaseInfo.setOutOrderNo(crmMemberOrderParam.getOrderNo());
        //关联的外部原订单/⼩票编号(唯⼀不可重复)，换货订单必填
        orderBaseInfo.setOutOriginalOrderNo(crmMemberOrderParam.getOrderNo());
        //订单类型：1-普通订单；99-充值订单（暂不⽀持）
        orderBaseInfo.setOrderType(1);
        //订单状态： 8-已完成
        orderBaseInfo.setStatus(8);
        //⽀付类型：1-线上⽀付；2-线下⽀付（含货到付款）
        orderBaseInfo.setPaymentType(crmMemberOrderParam.getOrderNo().contains("O_mall") ? 2 : 1);
        // 订单渠道
        orderBaseInfo.setChannelType(7);
        //下单时间，时间戳
        if (getTimeSecondFromData(crmMemberOrderParam.getPlaceOrderTime()) != null) {
            orderBaseInfo.setOrderTime(Long.toString(getTimeSecondFromData(crmMemberOrderParam.getPlaceOrderTime())));
        }
        //⽀付完成时的时间，时间戳
        if (getTimeSecondFromData(crmMemberOrderParam.getPayTime()) != null) {
            orderBaseInfo.setFinishPaymentTime(Long.toString(getTimeSecondFromData(crmMemberOrderParam.getPayTime())));
        }
        // 修改时间
        orderBaseInfo.setDelete(2);
        // 售卖渠道类型：10001-线上⽹店；10002-线下⻔店（默认）。
        orderBaseInfo.setSaleChannelType(crmMemberOrderParam.getOrderFrom() == 4 ? 10001 : 10002);
        //订单业务来源：1-普通订单；10-换货订单（⽀持订单和商品⾦额及购买件数为负，⾦额和件数为负商品处理为售后项）
        orderBaseInfo.setBizSourceType(1);
        //订单⽀付状态： 2-已⽀付
        orderBaseInfo.setPayStatus(2);
        //订单备注
        orderBaseInfo.setRemark(crmMemberOrderParam.getRemark());
        //订单来源平台： 0-微盟、1-道讯、2-伯俊、3-达摩、4、百胜、5海鼎
        orderBaseInfo.setPlatformType(2);
        return orderBaseInfo;
    }

    /**
     * 获取买家信息对象信息
     * @param memberInfoModel
     * @return MemberOrderUserInfoParam
     * 2022-12-11 11:25:43
     */
    public static MemberOrderUserInfoParam getBuyInfoObj(MemberInfoModel memberInfoModel) {
        // 买家信息
        MemberOrderUserInfoParam buyerInfo = new MemberOrderUserInfoParam();
        //客户昵称
        buyerInfo.setBuyerName(memberInfoModel.getName());
        //客户昵称
        buyerInfo.setBuyerPhone(memberInfoModel.getPhone());
        //客户昵称
        buyerInfo.setOutCardNo(memberInfoModel.getCardNo());
        return buyerInfo;
    }

    /**
     * 获取导购对象信息
     * @param staffVo
     * @return MemberOrderUserInfoParam
     * 2022-12-11 11:25:43
     */
    public static MemberOrderGuiderParam getMemberOrderGuiderParam(StaffVo staffVo) {
        // 买家信息
        MemberOrderGuiderParam memberOrderGuiderParam = new MemberOrderGuiderParam();
        //销售导购名称
        memberOrderGuiderParam.setGuiderName(staffVo.getStaffName());
        //销售导购员⼯编号
        memberOrderGuiderParam.setGuiderNo(staffVo.getStaffCode());
        //外部导购编号
        memberOrderGuiderParam.setOutGuiderNo(staffVo.getStaffCode());
        //销售导购⼿机号（导购⼿机号或导购wid⾄少⼆选⼀必填）
        memberOrderGuiderParam.setGuiderPhone(staffVo.getPhone());
        return memberOrderGuiderParam;
    }

    /**
     * 获取支付对象信息
     * @anthor shifeng
     * @return
     */
    public static MemberOrderPayInfoParam getMemberOrderPayInfoParam(CrmMemberOrderParam crmMemberOrderParam) {
        //支付信息
        MemberOrderPayInfoParam paymentInfo = new MemberOrderPayInfoParam();
        //订单实付
        paymentInfo.setPaymentAmount(crmMemberOrderParam.getPayMoney());
        //订单总⾦额
        paymentInfo.setTotalAmount(crmMemberOrderParam.getPayMoney());
        //订单应付⾦额
        paymentInfo.setShouldPaymentAmount(crmMemberOrderParam.getPayMoney());
        return paymentInfo;
    }

    /**
     * 获取打折信息对象
     * @return
     */
    public static MemberOrderDiscountParam getMemberOrderDiscountParam () {
        MemberOrderDiscountParam memberOrderDiscountParam = new MemberOrderDiscountParam();
        return memberOrderDiscountParam;
    }


    /**
     * 取消会员订单
     * @return
     * 2022-12-11 11:42:02
     */
    public static MemberOrderCancelInfo getMemberOrderCancelInfo () {
        MemberOrderCancelInfo memberOrderCancelInfo = new MemberOrderCancelInfo();
        return memberOrderCancelInfo;
    }

    /**
     *  获取订单商品对象信息
     * @param orderDetailModel
     * @return MemberOrderItemInfoParam
     * 2022-12-11 12:14:09
     */
    public static MemberOrderItemInfoParam getMemberOrderItemInfoParam(OrderDetailModel orderDetailModel) {
        //商品信息
        MemberOrderItemInfoParam memberOrderItemInfoParam = new MemberOrderItemInfoParam();
        //商品类型：1-普通商品；2-虚拟商品
        memberOrderItemInfoParam.setGoodsType(1);
        //商品⼦类型：101-普通商品；201-普通虚拟商品；202-付费券
        memberOrderItemInfoParam.setSubGoodsType(101);
        //外部商品名称，与规格名称必传⼀个
        memberOrderItemInfoParam.setGoodsTitle(orderDetailModel.getProductName());
        //规格属性
        memberOrderItemInfoParam.setSkuAttrInfo(orderDetailModel.getSpecification());
        //图⽚链接
        memberOrderItemInfoParam.setImageUrl(orderDetailModel.getSkuImg());
        //商品售价
        memberOrderItemInfoParam.setSalePrice(orderDetailModel.getTradeAmountDetail());
        //skuID
        memberOrderItemInfoParam.setOutSkuId(orderDetailModel.getSku());
        //sku名称
        memberOrderItemInfoParam.setSkuName(orderDetailModel.getSku());
        //商品吊牌价（原价），直接导⼊外部商品原价（元）
        memberOrderItemInfoParam.setMarketPrice(orderDetailModel.getTagPrice());
        //库存扣减⽅式，1为下单减库存，2为⽀付减库存
        memberOrderItemInfoParam.setDeductStockType(1);
        return memberOrderItemInfoParam;
    }

    /**
     * 获取原订单的订单信息
     * @param crmMemberOrderParam
     * @return OriginOrderParam
     * 2022-12-11 12:30:08
     */
    public static OriginOrderParam getOriginOrderParam(CrmMemberOrderParam crmMemberOrderParam) {
        //原订单信息
        OriginOrderParam originOrder = new OriginOrderParam();
        //外部售后单关联的初始原单号（如多次退/换货）
        if (!StringUtils.isEmpty(crmMemberOrderParam.getOriginalOrderNo())) {
            originOrder.setOutOrderNo(crmMemberOrderParam.getOriginalOrderNo());
            originOrder.setOutOriginalOrderNo(crmMemberOrderParam.getOriginalOrderNo());
        }
        return originOrder;
    }

    /**
     * 获取退单订单的基本信息
     * @param crmMemberOrderParam
     * @return RightsOrderParam
     * 2022-12-11 12:38:42
     */
    public static RightsOrderParam getRightsOrderParam(CrmMemberOrderParam crmMemberOrderParam) {
        //基本信息
        RightsOrderParam rightsOrder = new RightsOrderParam();
        //售后类型 1
        rightsOrder.setRightsType(1);
        //售后单来源渠道
        rightsOrder.setChannelType(7);
        //售后单状态 已退款
        rightsOrder.setRightsStatus(6);
        /**售后触发起源*/
        rightsOrder.setRightsCauseType(1);
        /**退款类型*/
        rightsOrder.setRefundType(crmMemberOrderParam.getOrderFrom() != null && crmMemberOrderParam.getOrderFrom() == 4 ? 2 : 1);
        //外部售后单号
        rightsOrder.setOutRightsNo(crmMemberOrderParam.getOrderNo());
        //售后备注
        rightsOrder.setRemark(crmMemberOrderParam.getRemark());
        //商家⾃定义售后原因
        rightsOrder.setReason(crmMemberOrderParam.getRemark());
        //创建时间
        if (getTimeSecondFromData(crmMemberOrderParam.getPlaceOrderTime()) != null) {
            rightsOrder.setCreateTime(getTimeSecondFromData(crmMemberOrderParam.getPlaceOrderTime()));
        }
        //完成时间
        if (getTimeSecondFromData(crmMemberOrderParam.getPlaceOrderTime()) != null) {
            rightsOrder.setFinishTime(getTimeSecondFromData(crmMemberOrderParam.getPlaceOrderTime()));
        }
        //同意时间
        if (getTimeSecondFromData(crmMemberOrderParam.getPlaceOrderTime()) != null) {
            rightsOrder.setAgreeTime(getTimeSecondFromData(crmMemberOrderParam.getPlaceOrderTime()));
        }
        /**来源平台*/
        rightsOrder.setPlatformType(2);
        /*** 退款⽅式*/
        rightsOrder.setRefundMethod(1);
        return rightsOrder;
    }


    /**
     * 退单商品详情
     * @param orderDetailModel
     * @param crmMemberOrderParam
     * @return
     */
    public static RightsItemsParam getRightsItemsParam(OrderDetailModel orderDetailModel, CrmMemberOrderParam crmMemberOrderParam) {
        RightsItemsParam rightsItemsParam = new RightsItemsParam();
        //外部订单项 ID
        rightsItemsParam.setOutRightsItemId(Long.toString(orderDetailModel.getMbrOrderDetailId()));
        //外部订单项 ID
        //订单项 ID
        rightsItemsParam.setOrderItemId(crmMemberOrderParam.getMbrOrderId());
        //商品名称，可直接导⼊外部商品名称
        rightsItemsParam.setGoodsTitle(orderDetailModel.getProductName());
        //外部商品编码
        rightsItemsParam.setOutGoodsId(orderDetailModel.getProductItemId());
        //skuID
        rightsItemsParam.setOutSkuId(orderDetailModel.getSku());
        //规格名称
        rightsItemsParam.setSkuName(orderDetailModel.getSpecification());
        //售后商品数量，sku 数量
        if (orderDetailModel.getQuantity() != null) {
            rightsItemsParam.setApplyNum(Math.abs(orderDetailModel.getQuantity()));
        }
        //商品吊牌价，直接导⼊外部商品原价（元）
        rightsItemsParam.setMarketPrice(orderDetailModel.getTagPrice());
        if (orderDetailModel.getTradeAmountDetail() != null) {
            //商品售价
            rightsItemsParam.setSalePrice(orderDetailModel.getTradeAmountDetail().intValue() < 0 ? orderDetailModel.getTradeAmountDetail().negate() : orderDetailModel.getTradeAmountDetail());
            //商品实付
            rightsItemsParam.setPayAmount(orderDetailModel.getTradeAmountDetail().intValue() < 0 ? orderDetailModel.getTradeAmountDetail().negate() : orderDetailModel.getTradeAmountDetail());
        }

        List<RightsAssetsParam> rightsAssets = new ArrayList<>();
        RightsAssetsParam rightsAssetsParam = new RightsAssetsParam();
        rightsAssetsParam.setAssetType(1);
        rightsAssetsParam.setAssetsTarget(1);
        if (orderDetailModel.getTradeAmountDetail() != null) {
            RefundDetailParam refundDetail = new RefundDetailParam();
            //申请退款总⾦额，单位元，保留⼩时点后两位，不能为负
            refundDetail.setApplyAmount(orderDetailModel.getTradeAmountDetail().intValue() < 0 ? orderDetailModel.getTradeAmountDetail().negate() : orderDetailModel.getTradeAmountDetail());
            //订单级的实退商品的销售⾦额（货款+运费），单位元，保留⼩时点后
            refundDetail.setRefundAmount(orderDetailModel.getTradeAmountDetail().intValue() < 0 ? orderDetailModel.getTradeAmountDetail().negate() : orderDetailModel.getTradeAmountDetail());
            if (Math.abs(orderDetailModel.getQuantity()) > 1) {
                //申请退款总⾦额，单位元，保留⼩时点后两位，不能为负
                refundDetail.setApplyAmount(orderDetailModel.getTradeAmountDetail().intValue() < 0 ? orderDetailModel.getTradeAmountDetail().negate().multiply(new BigDecimal(Math.abs(orderDetailModel.getQuantity()))) : orderDetailModel.getTradeAmountDetail().multiply(new BigDecimal(Math.abs(orderDetailModel.getQuantity()))));
                //订单级的实退商品的销售⾦额（货款+运费），单位元，保留⼩时点后
                refundDetail.setRefundAmount(orderDetailModel.getTradeAmountDetail().intValue() < 0 ? orderDetailModel.getTradeAmountDetail().negate().multiply(new BigDecimal(Math.abs(orderDetailModel.getQuantity()))) : orderDetailModel.getTradeAmountDetail().multiply(new BigDecimal(Math.abs(orderDetailModel.getQuantity()))));
            }
            rightsItemsParam.setRefundDetail(refundDetail);
            rightsAssetsParam.setAssetAmount(orderDetailModel.getTradeAmountDetail().intValue() < 0 ? orderDetailModel.getTradeAmountDetail().negate() : orderDetailModel.getTradeAmountDetail());
        }
        rightsAssets.add(rightsAssetsParam);
        rightsItemsParam.setRightsAssets(rightsAssets);
        return rightsItemsParam;
    }

    /**
     * wm商品详情
     * @param goodsId
     * @return
     */
    public static WmGoodsBaseInfoParam getWmGoodsBaseInfoParam(String goodsId, Long vid){
        WmGoodsBaseInfoParam wmGoodsBaseInfoParam = new WmGoodsBaseInfoParam();
        wmGoodsBaseInfoParam.setGoodsIdList(Arrays.asList(Long.valueOf(goodsId)));
        WmGoodsBaseInfoParam.BasicInfo basicInfo = new WmGoodsBaseInfoParam.BasicInfo();
        basicInfo.setVid(vid);
        wmGoodsBaseInfoParam.setBasicInfo(basicInfo);
        return wmGoodsBaseInfoParam;
    }

}
