package com.daas.nros.connector.server.service.component;

import com.alibaba.fastjson.JSON;

import com.daas.nros.connector.client.util.HttpClientUtil;
import com.daas.nros.connector.client.weimob.constant.WmSystemConstant;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * 调用微盟系统工具类
 */
@Slf4j
@Component
public class WmSystemHttpClientComponent {

    @Autowired
    private WmSystemTokenUtils tokenUtils;

    /**
     * post 远程调用
     * @param url
     * @param postData
     * @return
     */
    public String doPost(String url, String postData){
        HashMap<String, String> map = new HashMap<>();
        map.put("Content-type","application/json;charset=utf-8");
        return dopost(url,postData,map);
    }

    /**
     * CRM -> 微盟
     * @param url      发送请求的 URL
     * @param postData 需要post的数据
     * @param headers  请求头
     * @return 所代表远程资源的响应结果
     */
    public String dopost(String url, String postData, Map<String, String> headers) {
        // 封装token
        Map<String, String> params  = initWmToken();
        return dopost(url,postData,headers, params);
    }

    private Map<String, String> initWmToken(){
        Map<String, String> params = new HashMap<>();
        String wmSystemToken = tokenUtils.getWmSystemToken();
        log.info("initWmToken,wmSystemToken:{}", wmSystemToken);
        if (StringUtils.isBlank(wmSystemToken)){
            return params;
        }
        params.put(WmSystemConstant.WM_SYSTEM_CALL_TOKEN, wmSystemToken);
        return params;
    }

    /**
     * CRM -> 微盟
     * @param url      发送请求的 URL
     * @param postData 需要post的数据
     * @param headers  请求头
     * @return 所代表远程资源的响应结果
     */
    public String dopost(String url, String postData, Map<String, String> headers, Map<String, String> params) {
        // 封装url,拼接params
        url = packingUrl(url, params);
        log.info("CRM -> WM, origin sync url:{}, postData:{}, headers:{}, params:{}", url, postData, null == headers ? "NULL" : JSON.toJSON(headers), null == params ? "NULL" : JSON.toJSONString(params));
        String result = HttpClientUtil.dopost(url, postData, headers);
        log.info("CRM -> WM, result:{}", result);
        return result;
    }

    /**
     * 将json 转为指定类型对象
     * @param json
     * @param targetClass
     * @return
     */
    public static <T> T jsonCaseObject(String json, Class<T> targetClass){
        T t = JSON.parseObject(json, targetClass);
        return t;
    }


    private String packingUrl(String url, Map<String, String> params){
        url = tokenUtils.packingWmSystemInterface(url);
        if (null == params || params.isEmpty()){
            return url;
        }
        // 拼接请求头
        String[] param = new String[params.size()];
        int index = 0;
        for (Map.Entry<String, String> entity : params.entrySet()) {
            param[index] = entity.getKey() + WmSystemConstant.LINK_EQUAL + entity.getValue();
            index++;
        }
        index = 0;
        for (String s : param) {
            if (index == 0){
                url = url + WmSystemConstant.LINK_QUESTION + s;
            } else  {
                url = url + WmSystemConstant.LINK_AND + s;
            }
        }
        log.info("packingUrl,url:{}", url);
        return url;
    }

}
