package com.daas.nros.connector.server.middleware.mq.producer;

import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.SendResult;
import com.aliyun.openservices.ons.api.exception.ONSClientException;
import com.bizvane.utils.responseinfo.ResponseData;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 发送MQ消息service
 */
@Service
public class RocketMQProducerServiceImpl implements RocketMQProducerService {

    @Autowired
    private RocketMQTemplate rocketMQTemplate;

    private static final Logger logger = LoggerFactory.getLogger(RocketMQProducerServiceImpl.class);

    /**
     * 发送MQ消息service
     *
     * @author 董争光 2018年5月20日下午2:48:19
     */
    @Override
    public ResponseData<String> sendMessage(final Producer producer, final String topic, final String tag, final byte[] messageBody) {
        RocketMQProducerServiceImpl.logger.info("RocketMQProducerServiceImpl.sendMessage:topic:" + topic + ">tag:" + tag);
        if (StringUtils.isBlank(topic) || StringUtils.isBlank(tag)) {
            RocketMQProducerServiceImpl.logger.error("RocketMQProducerServiceImpl.sendMessage:topic、tag不能为空");
        }
        ResponseData<String> result = new ResponseData<>();
        Message message = new Message(topic, tag, messageBody);
        try {
          SendResult sendResult = producer.send(message);
          String messageId = sendResult.getMessageId();
          result.setData(messageId);
          RocketMQProducerServiceImpl.logger.info("RocketMQProducerServiceImpl.sendMessage消息发送完成，msgId：" + messageId);
        } catch (ONSClientException e) {
          RocketMQProducerServiceImpl.logger.info("RocketMQProducerServiceImpl.sendMessage：" + e.getMessage());
          // 出现异常意味着发送失败，为了避免消息丢失，建议缓存该消息然后进行重试。
        }
        return result;
    }


  @Override
  public org.apache.rocketmq.client.producer.SendResult sendMessage(String topic, String tag, Object messageBody, long sysBrandId) {
      logger.info("sendMessage:{},{},{},{}", topic, tag, JSONObject.toJSONString(messageBody), sysBrandId);
      return rocketMQTemplate.send(new Destination(topic, tag, null), messageBody, (mqs, msg, arg) -> {
          int value = arg.hashCode();
          if (value < 0) {
            value = Math.abs(value);
          }
          int i = value % mqs.size();
          return mqs.get(i);
      }, String.valueOf(sysBrandId));
  }

}
