package com.daas.nros.connector.server.middleware.mq.listener;

import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.PropertyKeyConst;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import java.util.Properties;


@Component
public class ApplicationInitListener implements  ApplicationListener<ApplicationReadyEvent> {

    private static Logger logger = LoggerFactory.getLogger(ApplicationInitListener.class.getName());

    private final static String BOOLEAN_TRUE = "true";

    private final static String LOCAL_ONSADDR  = "NAMESRV_ADDR";


    @Value("${rocketmq.onsaddr}")
    private String onsaddr;

    @Value("${rocketmq.accessKey}")
    private String accessKey;

    @Value("${rocketmq.secretKey}")
    private String secretKey;

    @Value("${rocketmq.memberInfoRequestConsumerId}")
    private String memberInfoRequestConsumerId;

    @Value("${rocketmq.topic}")
    public String topic;

    @Value("${rocketmq.memberInfoRequestTag}")
    public String memberInfoRequestTag;

    @Value("${rocketmq.producerId}")
    private String producerId;

    @Value("${rocketmq.isLocal}")
    private String isLocal;

    @Value("${rocketmq.localAddress}")
    private String localAddress;

    private static Producer producer;

    private static Consumer consumer;

    /**
     * mq修改会员信息消费
     */
    private void initMemberInfoMq(){
        logger.info("消费者启动");
        Properties properties = loadMqRequest();
        properties.put(PropertyKeyConst.ConsumerId, memberInfoRequestConsumerId);
        ApplicationInitListener.consumer = ONSFactory.createConsumer(properties);
        consumer.start();
    }

    /**
     * 启动mq生产者
     */
    private void initProducer(){
        logger.info("生产者启动");
        Properties properties = loadMqRequest();
        properties.put(PropertyKeyConst.ProducerId, producerId);
        ApplicationInitListener.producer = ONSFactory.createProducer(properties);
        producer.start();
    }

    /**
     * 初始化mq配置
     * @return
     */
    public Properties loadMqRequest(){
        Properties properties = new Properties();
        properties.put(PropertyKeyConst.AccessKey, accessKey);
        properties.put(PropertyKeyConst.SecretKey, secretKey);
        if(BOOLEAN_TRUE.equalsIgnoreCase(isLocal)){
            logger.info("加载本地roketmq配置:{}",localAddress);
            properties.put(LOCAL_ONSADDR, localAddress);
        }else{
            logger.info("加载aliyun roketmq配置:{}",onsaddr);
            properties.put(PropertyKeyConst.ONSAddr,  onsaddr);
        }
        return properties;
    }

    /**
     * spring启动执行事件
     * @param applicationReadyEvent
     */
    @Override
    public void onApplicationEvent(ApplicationReadyEvent applicationReadyEvent) {
        startMq();
    }

    /**
     * 启动mq
     */
    public void startMq(){
        initMemberInfoMq();
        initProducer();
        logger.info("rabbitMq 启动成功");
    }

    /**
     * 销毁mq
     */
    public void shutdownMq(){
        if(producer != null){
            producer.shutdown();
            logger.info("生产者关闭");
        }
        if(consumer != null){
            consumer.shutdown();
            logger.info("消费者关闭");
        }
        logger.info("rabbitMq 关闭成功");
    }

    public static Producer getProducer() {
        return producer;
    }

    public static Consumer getConsumer() {
        return consumer;
    }

}
