package com.daas.nros.connector.server.middleware.mq.consumer;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
;
import com.daas.nros.connector.server.service.api.burgeon.CrmJointService;
import com.daas.nros.connector.client.burgeon.model.vo.VgCancelCouponVo;
import com.daas.nros.connector.client.model.result.Result;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.factory.annotation.Autowired;

@Slf4j
@RocketMQMessageListener(topic = "TOPIC_COUPON_VERIFICATION",tags = {"MALL_CLUB"})
public class UseCouponBatchShopListener implements RocketMQListener<JSONObject> {

    @Autowired
    private CrmJointService crmJointService;

    /**
     * 券状态变更 - 作废
     * @param consumerMessage
     */
    @Override
    public void onMessage(ConsumerMessage<JSONObject> consumerMessage) {
        log.info("UseCouponBatchShopListener topic:{} on message body : {}","TOPIC_COUPON_VERIFICATION",consumerMessage.getMessage());
        JSONObject body = consumerMessage.getMessage();
        VgCancelCouponVo vgCancelCouponVo = JSON.parseObject(JSON.toJSONString(body), new TypeReference<VgCancelCouponVo>() {});
        Result<T> result = crmJointService.snyCouponStatus(vgCancelCouponVo);
        log.info("TOPIC_COUPON_VERIFICATION返回状态"+ JSON.toJSONString(result));
    }
}