package com.daas.nros.connector.server.middleware.mq.consumer;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;

import com.bizvane.couponfacade.interfaces.CouponDefinitionServiceFeign;
import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.daas.nros.connector.server.service.api.burgeon.VgCouponService;
import com.daas.nros.connector.client.burgeon.model.vo.VgUseCouponVo;
import com.daas.nros.connector.client.enums.StringBrandCode;
import com.daas.nros.connector.client.model.po.MbrMembersPo;
import com.daas.nros.connector.client.model.result.Result;
import com.daas.nros.connector.server.service.api.weimob.SysWeimengService;
import com.daas.nros.connector.client.weimob.model.req.param.CouponUseParam;
import com.daas.nros.connector.client.weimob.rpc.WmConnectServiceFeign;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Arrays;

@Slf4j
@RocketMQMessageListener(topic = "TOPIC_COUPON_VERIFICATION",tags = {"VG_CLUB","YJ_CLUB","TW_CLUB"})
public class UseCouponBatchListerner implements RocketMQListener<JSONObject> {

    @Autowired
    private VgCouponService vgCouponService;

    @Autowired
    private SysWeimengService sysWeimengService;

    @Autowired
    private CouponDefinitionServiceFeign couponDefinitionServiceFeign;

    @Autowired
    private WmConnectServiceFeign wmConnectServiceFeign;

    @Override
    public void onMessage(ConsumerMessage<JSONObject> consumerMessage) {
        log.info("use_couponListerner topic:{} on message body : {}","TOPIC_COUPON_VERIFICATION",consumerMessage.getMessage());
        JSONObject body = consumerMessage.getMessage();
        String tag=consumerMessage.getTags();
        String club=tag.replace("_","-");
        Result<JSONObject> result=vgCouponService.useCoupon(body,club);
        log.info("use_coupon"+ JSON.toJSONString(result));
        log.info("syncCouponConsumerToWM, club:{}, body:{}", club, body);
        Result syncWMResult = syncCouponConsumerToWM(body, club);
        log.info("syncCouponConsumerToWM, syncWMResult:{}", JSON.toJSONString(syncWMResult));
    }

    /**
     * 核销券同步到微盟
     */
    private Result syncCouponConsumerToWM(JSONObject body, String club){
        Result result = new Result();
        VgUseCouponVo vgUseCouponVo = JSON.parseObject(JSON.toJSONString(body), new TypeReference<VgUseCouponVo>() {});
        result.setCode(SysResponseEnum.SUCCESS.getCode());
        log.info("syncCouponConsumerToWM, club:{}, body:{}", club, JSON.toJSONString(body));
        CouponDefinitionPO definition = findCouponDefinitionByCouponCode(vgUseCouponVo.getCouponCode());

        // 判断是否是VG 品牌的核销
        if (!StringBrandCode.vg.getValue().equals(club) && !isExist(definition, StringBrandCode.vg.getValue())){
            log.info("syncCouponConsumerToWM 核销类型不是VG,end.");
            result.setMessage("syncCouponConsumerToWM 核销类型不是VG,end.");
            result.setCode(SysResponseEnum.SUCCESS.getCode());
            return result;
        }

        // 转换入参
        CouponUseParam couponUseParam = convertCouponUseParam(vgUseCouponVo);
        if (null == couponUseParam){
            log.info("syncCouponConsumerToWM convertCouponUseParam 参数转换失败");
            result.setMessage("syncCouponConsumerToWM convertCouponUseParam 参数转换失败");
            return result;
        }
        // 转化入参
        result = sysWeimengService.useCouponEntityTowm(couponUseParam);
        return result;
    }

    /**
     * 根据券定义id查询券定义信息
     * @param couponCode
     * @return
     */
    public CouponDefinitionPO findCouponDefinitionByCouponCode(String couponCode){
        log.info("findCouponDefinitionByCouponCode, couponCode:{}", couponCode);
        ResponseData<CouponDefinitionPO> responseData = couponDefinitionServiceFeign.findCouponDefinitionByCouponCode(couponCode);
        log.info("findCouponDefinitionByCouponCode, responseData:{}", JSON.toJSONString(responseData));
        if (responseData.getCode() == SysResponseEnum.SUCCESS.getCode()){
            return responseData.getData();
        }
        return null;
    }

    /**
     * 判断适用品牌是否包含指定品牌
     * @param definition
     * @param brandCode
     * @return
     */
    private boolean isExist(CouponDefinitionPO definition, String brandCode){
        if (definition == null){
            return false;
        }
        if (StringUtils.isBlank(definition.getApplicableBrandCodes())){
            return false;
        }
        if (!definition.getApplicableBrandCodes().contains(brandCode)){
            return false;
        }
        return true;
    }

    /**
     * 转换入参
     * @param vgUseCouponVo
     * @return
     */
    private CouponUseParam convertCouponUseParam(VgUseCouponVo vgUseCouponVo){
        log.info("convertCouponUseParam, vgUseCouponVo:{}", JSON.toJSONString(vgUseCouponVo));
        CouponUseParam couponUseParam = new CouponUseParam();
        // 获取会员信息
        MbrMembersPo mbrMemberBy = sysWeimengService.findMbrMemberBy(vgUseCouponVo.getUseMemberCardNo(), 3, StringBrandCode.vg.getValue());
        if (mbrMemberBy == null){
            return null;
        }
        // 根据券号获取券定义信息
        String couponDefinitionCode = findCouponDefinitionCodeByCouponCode(vgUseCouponVo.getCouponCode());
        if (StringUtils.isBlank(couponDefinitionCode)){
            return null;
        }
        couponUseParam.setMemberCode(mbrMemberBy.getMemberCode());
        CouponUseParam.OperateCoupon operateCoupon = new CouponUseParam.OperateCoupon();
        operateCoupon.setCode(vgUseCouponVo.getCouponCode());
        operateCoupon.setCouponDefinitionCode(couponDefinitionCode);
        couponUseParam.setOperateCoupons(Arrays.asList(operateCoupon));
        log.info("convertCouponUseParam, result:{}", JSON.toJSONString(couponUseParam));
        return couponUseParam;
    }


    /**
     * 根据券号获取券定义code
     * @param couponCode
     * @return
     */
    private String findCouponDefinitionCodeByCouponCode(String couponCode){
        log.info("findCouponDefinitionCodeByCouponCode, couponCode:{}", couponCode);
        ResponseData<String> responseData = couponDefinitionServiceFeign.findCouponDefinitionCodeByCouponCode(couponCode);
        log.info("findCouponDefinitionCodeByCouponCode, responseData:{}", JSON.toJSONString(responseData));
        if (responseData.getCode() == SysResponseEnum.SUCCESS.getCode()){
            return responseData.getData();
        }
        return "";
    }
}
