package com.daas.nros.connector.server.middleware.mq.consumer;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;

import com.daas.nros.connector.client.api.base.CouponSingleService;
import com.daas.nros.connector.server.service.api.burgeon.VgCouponService;
import com.daas.nros.connector.client.burgeon.constants.VgIposCouponMethodConstant;
import com.daas.nros.connector.client.burgeon.model.vo.VgAddCouponCrmVO;
import com.daas.nros.connector.client.burgeon.model.vo.VgAddCouponVO;
import com.daas.nros.connector.server.service.conver.DataConver;
import com.daas.nros.connector.server.config.burgeon.IposConfig;
import com.daas.nros.connector.client.exception.AnalysysException;
import com.daas.nros.connector.client.model.result.Result;
import com.daas.nros.connector.server.tool.httpbatch.BatchCollecter;
import com.daas.nros.connector.server.tool.httpbatch.HttpSendBatch;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;


@Slf4j
@RocketMQMessageListener(topic = "TOPIC_COUPON_SEND",tags = {"YJ_CLUB"})
public class SendCouponBatchListernerYj implements RocketMQListener<JSONObject> {

    @Autowired
    private CouponSingleService couponSingleService;

    @Autowired
    private VgCouponService vgCouponService;

    final String url = IposConfig.url + VgIposCouponMethodConstant.ADD_COUPON_BATCH;

    private HttpSendBatch analysys = new HttpSendBatch(new BatchCollecter(url,20,60,"TOPIC_COUPON_SEND_YJ"));

    @Override
    public void onMessage(ConsumerMessage<JSONObject> consumerMessage) {
        log.info("SendCouponBatchListernerYj:{} on message body : {}","TOPIC_COUPON_SEND",consumerMessage.getMessage());
        JSONObject body = consumerMessage.getMessage();
        VgAddCouponVO vgAddCouponVO = JSON.parseObject(JSON.toJSONString(body), new TypeReference<VgAddCouponVO>() {});
        VgAddCouponCrmVO vgAddCouponCrmVO= DataConver.mqToCrmVo(vgAddCouponVO,"YJ-CLUB");
        if(1 == vgAddCouponVO.getTopicNumber()){
            Result<JSONObject> result=vgCouponService.sendCoupon(vgAddCouponCrmVO);
            log.info("SendCouponYj状态："+ JSON.toJSONString(result));
        }else {
            try {
                analysys.track(vgAddCouponCrmVO);
            } catch (AnalysysException e) {

            }
        }
    }
}
