package com.daas.nros.connector.server.middleware.mq.consumer;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;

import com.daas.nros.connector.server.service.api.burgeon.VgCouponService;
import com.daas.nros.connector.client.burgeon.constants.VgIposCouponMethodConstant;
import com.daas.nros.connector.client.burgeon.model.vo.VgAddCouponCrmVO;
import com.daas.nros.connector.client.burgeon.model.vo.VgAddCouponVO;
import com.daas.nros.connector.server.service.conver.DataConver;
import com.daas.nros.connector.server.config.burgeon.IposConfig;
import com.daas.nros.connector.client.exception.AnalysysException;
import com.daas.nros.connector.client.model.result.Result;
import com.daas.nros.connector.server.tool.httpbatch.BatchCollecter;
import com.daas.nros.connector.server.tool.httpbatch.HttpSendBatch;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

@Slf4j
@RocketMQMessageListener(topic = "TOPIC_COUPON_SEND",tags = {"TT_CLUB","TN_CLUB","TZ_CLUB","TF_CLUB"})
public class SendCouponBatchListernerEmp implements RocketMQListener<JSONObject> {

    @Autowired
    private VgCouponService vgCouponService;

    final String url = IposConfig.url + VgIposCouponMethodConstant.ADD_COUPON_BATCH;

    private HttpSendBatch analysys = new HttpSendBatch(new BatchCollecter(url,20,60,"TOPIC_COUPON_SEND_EMP"));

    @Override
    public void onMessage(ConsumerMessage<JSONObject> consumerMessage) {
        log.info("SendCouponBatchListernerEmp:{} on message body : {}",consumerMessage.getTags(),consumerMessage.getMessage());
        JSONObject body = consumerMessage.getMessage();
        VgAddCouponVO vgAddCouponVO = JSON.parseObject(JSON.toJSONString(body), new TypeReference<VgAddCouponVO>() {});
        String tag=consumerMessage.getTags();
        String club=tag.replace("_","-");
        VgAddCouponCrmVO vgAddCouponCrmVO= DataConver.mqToCrmVo(vgAddCouponVO,club);
        if(1 == vgAddCouponVO.getTopicNumber()){
            Result<JSONObject> result=vgCouponService.sendCoupon(vgAddCouponCrmVO);
            log.info("SendCouponEmp状态："+ JSON.toJSONString(result));
        }else {
            try {
                analysys.track(vgAddCouponCrmVO);
            } catch (AnalysysException e) {
               
            }
        }
    }
}
