package com.daas.nros.connector.server.middleware.mq.consumer;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;

import com.bizvane.utils.enumutils.SysResponseEnum;
import com.daas.nros.connector.client.burgeon.model.req.SnyMemberCouponReq;
import com.daas.nros.connector.client.burgeon.model.vo.VgAddCouponVO;
import com.daas.nros.connector.server.config.burgeon.CrmJointVConfig;
import com.daas.nros.connector.client.constants.Constant;
import com.daas.nros.connector.client.model.result.Result;
import com.daas.nros.connector.server.service.impl.burgeon.CouponServiceImpl;
import com.daas.nros.connector.server.service.impl.burgeon.CrmJointServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

@Slf4j
@RocketMQMessageListener(topic = "TOPIC_COUPON_SEND_BATCH",tags = {"MALL_CLUB"})
public class SendCouponBatchListenerMallBatch implements RocketMQListener<JSONObject> {

    @Autowired
    private CrmJointServiceImpl crmJointService;

    @Autowired
    private CouponServiceImpl couponService;

    final String url = CrmJointVConfig.urlPrefix + CrmJointVConfig.snyMemberCoupon;

    @Override
    public void onMessage(ConsumerMessage<JSONObject> consumerMessage) {
        log.info("2 SendCouponBatchListenerMallBatch on message body : {}","TOPIC_COUPON_SEND_BATCH",consumerMessage.getMessage());
        JSONObject body = consumerMessage.getMessage();
        VgAddCouponVO vgAddCouponVO = JSON.parseObject(JSON.toJSONString(body), new TypeReference<VgAddCouponVO>() {});
        log.info( "2 TOPIC_COUPON_SEND mall-club品牌发券 : {}", JSONObject.toJSONString(vgAddCouponVO));

        SnyMemberCouponReq snyMemberCouponReq = SnyMemberCouponReq.builder()
                .brandCode(vgAddCouponVO.getBrandCode())
                .ifSendAgain(vgAddCouponVO.getIfSendAgain())
                .couponId(vgAddCouponVO.getCouponCode())
                .mobile(vgAddCouponVO.getMemberPhone())
                .activityId(vgAddCouponVO.getCouponDefinitionCode())
                .memberCardNo(vgAddCouponVO.getMemberCardNo())
                .obtainAt(vgAddCouponVO.getCreateDate() != null ? String.valueOf(vgAddCouponVO.getCreateDate().getTime()) : null)
                .startAt(vgAddCouponVO.getValidDateStart() != null ? String.valueOf(vgAddCouponVO.getValidDateStart().getTime()) : null)
                .expiredAt(vgAddCouponVO.getValidDateEnd() != null ? String.valueOf(vgAddCouponVO.getValidDateEnd().getTime()) : null)
                .status(Constant.INT_ZERO)
                .build();

        Byte coupStatus = 0;
        Result<T> result = null ;
        try{


            List<SnyMemberCouponReq> list = new ArrayList<>();
            list.add( snyMemberCouponReq );
            result = crmJointService.snyMemberCoupon( list );
        } catch (Exception e) {
            coupStatus = 0;
            result = null;
            e.printStackTrace();
        } finally {
            if( result != null && SysResponseEnum.SUCCESS.getCode()==result.getCode() ){
                coupStatus = 1;
                couponService.callbackSingleCoupon( snyMemberCouponReq.getCouponId() , coupStatus , snyMemberCouponReq.getIfSendAgain() );
            }else{
//                couponService.callbackSingleCoupon( snyMemberCouponReq.getCouponId() , coupStatus , snyMemberCouponReq.getIfSendAgain() );
            }
        }
    }
}
