package com.daas.nros.connector.server.middleware.mq.consumer;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import com.alibaba.fastjson.JSONObject;

import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.daas.nros.connector.server.service.api.burgeon.MemberService;
import com.daas.nros.connector.client.model.vo.MemberInfoUpdateRequestVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Slf4j
@RocketMQMessageListener(topic = "public_pro_member_perfect_message",tags = {"memberInfoRequestTag"} )
public class MemberUpdateListener implements RocketMQListener<JSONObject> {

    @Autowired
    @Qualifier("member")
    private MemberService memberService;

    @Override
    public void onMessage(ConsumerMessage<JSONObject> consumerMessage) {
        log.info("jh_third_interface vipModify mq topic:{} on message body : {}","public_pro_member_perfect_message", consumerMessage.getMessage() );
        MemberInfoUpdateRequestVO memberInfoUpdateRequestVO = null;
        JSONObject body = consumerMessage.getMessage();
        try {
            memberInfoUpdateRequestVO = JacksonUtil.json2Obj( body.toJSONString() , MemberInfoUpdateRequestVO.class );
        }catch (Exception e){
            memberInfoUpdateRequestVO = JacksonUtil.json2Obj( body.toString() , MemberInfoUpdateRequestVO.class );
        }
        if( memberInfoUpdateRequestVO==null ){
            log.error( "jh_third_interface vipModify mq error : {}" , body );
            return;
        }
        memberService.updateuserinfo( memberInfoUpdateRequestVO,"mqTopic" );
    }

}
