package com.daas.nros.connector.server.middleware.mq.consumer;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.daas.nros.connector.server.service.api.burgeon.CrmJointService;
import com.daas.nros.connector.server.service.api.burgeon.VgCouponService;
import com.daas.nros.connector.client.burgeon.model.vo.VgAddGiveCouponVo;
import com.daas.nros.connector.client.model.result.Result;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.factory.annotation.Autowired;

@Slf4j
@RocketMQMessageListener(topic = "coupon_to_offline_give_coupon_entity_topic",tags = {"give"})
public class GiveCouponShopListener implements RocketMQListener<JSONObject> {

    @Autowired
    private CrmJointService crmJointService;

    @Autowired
    private VgCouponService vgCouponService;

    //线下券
    private static Byte couponOfflineChannel = 1;

    //全渠道券
    private static Byte couponAllChannel = 2;
    /**
     * 券转增
     * @param consumerMessage
     */
    @Override
    public void onMessage(ConsumerMessage<JSONObject> consumerMessage) {
        log.info("GiveCouponShopListener topic:{} on message body : {}","coupon_to_offline_give_coupon_entity_topic",consumerMessage.getMessage());
        JSONObject body = consumerMessage.getMessage();
        VgAddGiveCouponVo vgCancelCouponVo = JSON.parseObject(JSON.toJSONString(body), new TypeReference<VgAddGiveCouponVo>() {});
        Result<T> offlineResult = null;
        Result<JSONObject> posResult = null;
        if(couponOfflineChannel.equals(vgCancelCouponVo.getUseChannel())){
            posResult = vgCouponService.giveCoupon(body);
        } else if(couponAllChannel.equals(vgCancelCouponVo.getUseChannel())){
            offlineResult = crmJointService.snyCouponTransfer(vgCancelCouponVo);
            posResult = vgCouponService.giveCoupon(body);
        } else {
            log.info("非线下券或全渠道券，不处理");
        }
        log.info("coupon_to_offline_give_coupon_entity_topic,offlineResult:{}",JSON.toJSONString(offlineResult));
        log.info("coupon_to_offline_give_coupon_entity_topic,posResult:{}",JSON.toJSONString(posResult));
    }
}