package com.daas.nros.connector.server.middleware.mq.consumer;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;

import com.daas.nros.connector.server.service.api.burgeon.CrmJointService;
import com.daas.nros.connector.client.burgeon.model.vo.VgAddCouponDefinitionVo;
import com.daas.nros.connector.client.model.result.Result;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.factory.annotation.Autowired;

@Slf4j
@RocketMQMessageListener(topic = "TOPIC_COUPON_DEFINITION",tags = {"MALL_CLUB"})
public class CouponDefinitionShopListener implements RocketMQListener<JSONObject> {

    @Autowired
    private CrmJointService crmJointService;

    /**
     * 新增券定义
     * @param consumerMessage
     */
    @Override
    public void onMessage(ConsumerMessage<JSONObject> consumerMessage) {
        log.info("CouponDefinitionShopListener topic:{} on message body : {} on tag : {}","TOPIC_COUPON_DEFINITION",consumerMessage.getMessage(),consumerMessage.getTags());
        JSONObject body = consumerMessage.getMessage();
        VgAddCouponDefinitionVo vgAddCouponDefinitionVo = JSON.parseObject(JSON.toJSONString(body), new TypeReference<VgAddCouponDefinitionVo>() {});
        Result<T> result = crmJointService.snyCouponInfo(vgAddCouponDefinitionVo);
        log.info("TOPIC_COUPON_DEFINITION返回状态"+ JSON.toJSONString(result));
    }

}