package com.daas.nros.connector.server.middleware.mq.consumer;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import com.daas.nros.connector.server.service.api.burgeon.VgCouponService;
import com.daas.nros.connector.client.model.result.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

@Slf4j
@RocketMQMessageListener(topic = "TOPIC_COUPON_DEFINITION",tags = {"TT_CLUB","TN_CLUB","TZ_CLUB"})
public class CouponDefinitionEmpListerner implements RocketMQListener<JSONObject> {

    @Autowired
    private VgCouponService vgCouponService;

    @Override
    public void onMessage(ConsumerMessage<JSONObject> consumerMessage) {
        log.info("CouponDefinitionEmpListerner topic:{} on message body : {} on tag : {}","TOPIC_COUPON_DEFINITION",consumerMessage.getMessage(),consumerMessage.getTags());
        JSONObject body = consumerMessage.getMessage();
        String tag = consumerMessage.getTags();
        String club = tag.replace("_","-");
        Result<JSONObject> result = vgCouponService.addCouponGrp(body,club);
        log.info("TOPIC_COUPON_DEFINITION返回状态" + JSON.toJSONString(result));
    }
}
