package com.daas.nros.connector.server.config.weimob;


import lombok.Data;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

/**
 * 微盟系统配置
 */
@Data
@Configuration
public class WMSystemConfig {

    // 客户端身份标识
    @Value("${wm.system.clientId:045EB42A0CC77F45A6F14169403A55A8}")
    private String clientId;

    // 客户端密钥
    @Value("${wm.system.clientSecret:94313A700EF345E117760B55E51D53B0}")
    private String clientSecret;

    // OAuth 2.0 的授权类型，自有型应用采用客户端凭证模式，即 client_credentials。
    private String grantType = "client_credentials";

    // 微盟系统域名
    @Value("${wm.system.dns:https://dopen.weimob.com}")
    private String wmSystemDNS;
}
